/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jdbcacsess.sql.DBObject;
import jdbcacsess.sql.DBObjectCatalogs;
import jdbcacsess.sql.DBObjectSchemas;
import jdbcacsess.sql.DBObjects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectProcedures
extends DBObjects {
    static final String[] header = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "REMARKS", "PROCEDURE_TYPE"};
    private ArrayList<DBObject> procedures = new ArrayList();

    public DBObjectProcedures(DBObjectCatalogs.DBObjectCatalog catalog, DBObjectSchemas.DBObjectSchema schema, DatabaseMetaData dmd) throws SQLException {
        ResultSet rs = dmd.getProcedures(catalog.getCatalogName(), schema.getSchemaName(), null);
        DBObjectProcedure prev = new DBObjectProcedure();
        while (rs.next()) {
            DBObjectProcedure procedure = new DBObjectProcedure(rs);
            if (!prev.getKey().equals(procedure.getKey())) {
                this.procedures.add(procedure);
                prev = procedure;
                continue;
            }
            prev.incrementDuplicateCnt();
        }
        rs.close();
    }

    public ArrayList<DBObject> getDBObjects() {
        return this.procedures;
    }

    @Override
    public String toString() {
        return "PROCEDURE";
    }

    public class DBObjectProcedure
    extends DBObject {
        private String procedureCat = "";
        private String procedureSchem = "";
        private String procedureName = "";
        private String remarks = "";
        private short procedureType = 0;
        private int duplicateCnt = 1;

        public DBObjectProcedure() {
        }

        public DBObjectProcedure(ResultSet rs) throws SQLException {
            int colCnt = rs.getMetaData().getColumnCount();
            if (colCnt > 0) {
                this.procedureCat = rs.getString(1);
            }
            if (colCnt > 1) {
                this.procedureSchem = rs.getString(2);
            }
            if (colCnt > 2) {
                this.procedureName = rs.getString(3);
            }
            if (colCnt > 6) {
                this.remarks = rs.getString(7);
            }
            if (colCnt > 7) {
                this.procedureType = rs.getShort(8);
            }
        }

        public String[] getDetail() {
            String[] rtn = new String[]{this.procedureCat, this.procedureSchem, this.procedureName, this.remarks, Short.toString(this.procedureType)};
            return rtn;
        }

        public String toString() {
            return String.valueOf(this.procedureName) + (this.duplicateCnt > 1 ? "  (*" + this.duplicateCnt + ")" : "");
        }

        public String[] getHeader() {
            return header;
        }

        public String getProcedureCat() {
            return this.procedureCat;
        }

        public String getProcedureName() {
            return this.procedureName;
        }

        public String getProcedureSchem() {
            return this.procedureSchem;
        }

        public short getProcedureType() {
            return this.procedureType;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public int getDuplicateCnt() {
            return this.duplicateCnt;
        }

        public void setDuplicateCnt(int duplicateCnt) {
            this.duplicateCnt = duplicateCnt;
        }

        public void incrementDuplicateCnt() {
            ++this.duplicateCnt;
        }

        public String getKey() {
            return String.valueOf(this.procedureCat) + this.procedureSchem + this.procedureName;
        }
    }
}

