/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui.common;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.tree.TreePath;

public class PopupKeybordAndMouse {
    PopupComponent pc;
    JPopupMenu jpm;

    public PopupKeybordAndMouse(JTree jtree, JPopupMenu jpopupMenu) {
        this.pc = new PopupComponentJTree(jtree);
        this.jpm = jpopupMenu;
        this.init();
    }

    public PopupKeybordAndMouse(JTable jtable, JPopupMenu jpopupMenu) {
        this.pc = new PopupComponentJTable(jtable);
        this.jpm = jpopupMenu;
        this.init();
    }

    private void init() {
        JComponent component = this.pc.getJComponent();
        component.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PopupKeybordAndMouse.this.pc.cellSelect(e);
                    PopupKeybordAndMouse.this.jpm.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PopupKeybordAndMouse.this.pc.cellSelect(e);
                    PopupKeybordAndMouse.this.jpm.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        component.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                JComponent component = PopupKeybordAndMouse.this.pc.getJComponent();
                InputMap im = component.getRootPane().getInputMap(1);
                InputMap myim = component.getInputMap(1);
                KeyStroke[] keyStrokeArray = im.allKeys();
                int n = 0;
                int n2 = keyStrokeArray.length;
                while (n < n2) {
                    KeyStroke keyStroke = keyStrokeArray[n];
                    myim.put(keyStroke, im.get(keyStroke));
                    ++n;
                }
                component.getActionMap().put("postPopup", new AbstractAction(){
                    private static final long serialVersionUID = 8315610383335629222L;

                    public void actionPerformed(ActionEvent e) {
                        if (e.getSource() == null) {
                            return;
                        }
                        Rectangle r = (this).PopupKeybordAndMouse.this.pc.getPopupLocation();
                        (this).PopupKeybordAndMouse.this.jpm.show((Component)e.getSource(), r.x + r.width, r.y + r.height);
                    }
                });
            }

            public void ancestorMoved(AncestorEvent event) {
            }

            public void ancestorRemoved(AncestorEvent event) {
            }
        });
    }

    private static interface PopupComponent {
        public JComponent getJComponent();

        public void cellSelect(MouseEvent var1);

        public Rectangle getPopupLocation();
    }

    private class PopupComponentJTree
    implements PopupComponent {
        JTree tree;

        public PopupComponentJTree(JTree component) {
            this.tree = component;
        }

        public JTree getJComponent() {
            return this.tree;
        }

        public void cellSelect(MouseEvent e) {
            TreePath mouseTreePath = this.tree.getPathForLocation(e.getX(), e.getY());
            if (mouseTreePath == null) {
                return;
            }
            TreePath[] selectTreePaths = this.tree.getSelectionPaths();
            if (selectTreePaths == null) {
                this.tree.setSelectionPath(mouseTreePath);
                return;
            }
            boolean hitFlg = false;
            TreePath[] treePathArray = selectTreePaths;
            int n = 0;
            int n2 = treePathArray.length;
            while (n < n2) {
                TreePath path = treePathArray[n];
                if (path == mouseTreePath) {
                    hitFlg = true;
                    break;
                }
                ++n;
            }
            if (!hitFlg) {
                this.tree.setSelectionPath(mouseTreePath);
            }
        }

        public Rectangle getPopupLocation() {
            return this.tree.getPathBounds(this.tree.getSelectionPath());
        }
    }

    private class PopupComponentJTable
    implements PopupComponent {
        JTable table;

        public PopupComponentJTable(JTable table) {
            this.table = table;
        }

        public JComponent getJComponent() {
            return this.table;
        }

        public void cellSelect(MouseEvent e) {
            int row = this.table.rowAtPoint(e.getPoint());
            int col = this.table.columnAtPoint(e.getPoint());
            if (row < 0 || col < 0) {
                return;
            }
            if (!this.table.isCellSelected(row, col)) {
                this.table.setRowSelectionInterval(row, row);
                this.table.setColumnSelectionInterval(col, col);
            }
        }

        public Rectangle getPopupLocation() {
            return this.table.getCellRect(this.table.getSelectedRow(), this.table.getSelectedColumn(), false);
        }
    }
}

