/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jdbcacsess.PrefixStringBuffer;
import jdbcacsess.createdata.JFrameCreateDataSetting;
import jdbcacsess.gui.CellRendererDataBaseObject;
import jdbcacsess.gui.JFrameCreateSqlFromTree;
import jdbcacsess.gui.JTextPaneSqlStatement;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.gui.common.JPopupMenuCnageUI;
import jdbcacsess.gui.common.PopupKeybordAndMouse;
import jdbcacsess.sql.ColumnInfoParameter;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.DBObject;
import jdbcacsess.sql.DBObjectCatalogs;
import jdbcacsess.sql.DBObjectProcedures;
import jdbcacsess.sql.DBObjectSchemas;
import jdbcacsess.sql.DBObjectTableTypes;
import jdbcacsess.sql.DBObjectTables;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlExec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeDataBaseObjects
extends JTree
implements Observer {
    private static final long serialVersionUID = -294660305476207747L;
    private DefaultMutableTreeNode rootTreeNode;
    private JTextPaneSqlStatement sqlStatement;
    private JPopupMenuCnageUI jPopupMenuTable = null;
    private JMenuItem jMenuItemOrderPrimeKey = null;
    private JMenuItem jMenuItemNoOrder = null;
    private JMenuItem jMenuItemStored = null;
    private JMenuItem jMenuItemTreeUpdate = null;
    private DefaultTreeModel treeModel;
    private JMenuItem jMenuItemCreateData = null;
    private JMenuItem jMenuItemName = null;
    private JMenuItem jMenuItemEditSql = null;
    private JFrameCreateSqlFromTree csft = null;

    @Override
    public void update(Observable o, Object sqlStatement) {
        this.sqlStatement = (JTextPaneSqlStatement)sqlStatement;
        if (this.csft != null) {
            this.csft.setSqlStatement(this.sqlStatement);
        }
    }

    public JTreeDataBaseObjects() {
        this.initialize();
    }

    private void initialize() {
        this.setRowHeight(this.getFontMetrics(CellRendererDataBaseObject.treeFontPrim).getHeight());
        this.setModel(null);
        this.setToggleClickCount(2);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent e) {
                JTreeDataBaseObjects.this.expandColumnName(e.getPath());
            }

            public void treeCollapsed(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 2) {
                    JTreeDataBaseObjects.this.transColumnName(JTreeDataBaseObjects.this.getSelectionPaths());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
            }
        });
        this.setCellRenderer(new CellRendererDataBaseObject());
        new PopupKeybordAndMouse(this, (JPopupMenu)this.getJPopupMenuTable());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.jPopupMenuTable.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                this.setAllMenuItemEnabled(true);
                boolean tblFlg = false;
                boolean colFlg = false;
                boolean prcFlg = false;
                TreePath[] tps = JTreeDataBaseObjects.this.getSelectionPaths();
                if (tps == null) {
                    this.setAllMenuItemEnabled(false);
                    return;
                }
                TreePath[] treePathArray = JTreeDataBaseObjects.this.getSelectionPaths();
                int n = 0;
                int n2 = treePathArray.length;
                while (n < n2) {
                    TreePath treePath = treePathArray[n];
                    if (JTreeDataBaseObjects.this.isDBObject(treePath, DBObjectTables.DBObjectTable.class)) {
                        tblFlg = true;
                    } else if (JTreeDataBaseObjects.this.isDBObject(treePath, ColumnInfoTable.class)) {
                        colFlg = true;
                    } else if (JTreeDataBaseObjects.this.isDBObject(treePath, DBObjectProcedures.DBObjectProcedure.class)) {
                        prcFlg = true;
                    } else {
                        this.setAllMenuItemEnabled(false);
                        return;
                    }
                    ++n;
                }
                if (tblFlg & colFlg & prcFlg || !tblFlg & !colFlg & !prcFlg) {
                    this.setAllMenuItemEnabled(false);
                    return;
                }
                if (!(tblFlg | colFlg) | prcFlg) {
                    JTreeDataBaseObjects.this.jMenuItemOrderPrimeKey.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemNoOrder.setEnabled(false);
                    JTreeDataBaseObjects.this.jMenuItemEditSql.setEnabled(false);
                }
                if (tblFlg | colFlg | !prcFlg) {
                    JTreeDataBaseObjects.this.jMenuItemStored.setEnabled(false);
                } else if (prcFlg && JTreeDataBaseObjects.this.getSelectionCount() != 1) {
                    JTreeDataBaseObjects.this.jMenuItemStored.setEnabled(false);
                }
                if (!tblFlg | colFlg | prcFlg) {
                    JTreeDataBaseObjects.this.jMenuItemCreateData.setEnabled(false);
                }
            }

            private void setAllMenuItemEnabled(boolean enable) {
                JTreeDataBaseObjects.this.jMenuItemOrderPrimeKey.setEnabled(enable);
                JTreeDataBaseObjects.this.jMenuItemNoOrder.setEnabled(enable);
                JTreeDataBaseObjects.this.jMenuItemStored.setEnabled(enable);
                JTreeDataBaseObjects.this.jMenuItemEditSql.setEnabled(enable);
                JTreeDataBaseObjects.this.jMenuItemCreateData.setEnabled(enable);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }
        });
    }

    protected void transColumnName(TreePath[] treePaths) {
        if (treePaths == null) {
            return;
        }
        PrefixStringBuffer psb = new PrefixStringBuffer(" ", ", ");
        TreePath[] treePathArray = treePaths;
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            TreePath treePath = treePathArray[n];
            String selectItem = this.getLastPathUserObject(treePath).toString();
            psb.appendItem(selectItem);
            ++n;
        }
        this.sqlStatement.insertCurrentPosition(psb.getString());
    }

    private Object getLastPathUserObject(TreePath treePath) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return treeNode.getUserObject();
    }

    private boolean isDBObject(TreePath treePath, Class cls) {
        DefaultMutableTreeNode symbol = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return symbol.getUserObject().getClass() == cls;
    }

    private void expandColumnName(TreePath treePath) {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        if (this.isDBObject(treePath, DBObjectTables.DBObjectTable.class) || this.isDBObject(treePath, DBObjectProcedures.DBObjectProcedure.class)) {
            DefaultMutableTreeNode symbol = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode dummyChild = (DefaultMutableTreeNode)symbol.getFirstChild();
            if (dummyChild.getUserObject() != null) {
                return;
            }
            DBObjectSchemas.DBObjectSchema dbObjectSchema = (DBObjectSchemas.DBObjectSchema)this.getDBObject(treePath, DBObjectSchemas.DBObjectSchema.class);
            try {
                if (this.isDBObject(treePath, DBObjectTables.DBObjectTable.class)) {
                    DBObjectTables.DBObjectTable dbObjectTable = (DBObjectTables.DBObjectTable)symbol.getUserObject();
                    for (ColumnInfoTable col : SqlExec.getColumnMames(new SchemaTableName(dbObjectSchema.getSchemaName(), dbObjectTable.getTableName()))) {
                        symbol.add(new DefaultMutableTreeNode(col));
                    }
                }
                if (this.isDBObject(treePath, DBObjectProcedures.DBObjectProcedure.class)) {
                    DBObjectProcedures.DBObjectProcedure dBObjectProcedure = (DBObjectProcedures.DBObjectProcedure)symbol.getUserObject();
                    List<ColumnInfoParameter> list = SqlExec.getProcedureColumns(dBObjectProcedure);
                    for (ColumnInfoParameter cip : list) {
                        symbol.add(new DefaultMutableTreeNode(cip));
                    }
                }
            }
            catch (SQLException e1) {
                JDialogMessage.sqlErrorDialog(e1, "\u30c4\u30ea\u30fc\u8868\u793a\u306e\u60c5\u5831\u53d6\u5f97");
            }
            symbol.remove(dummyChild);
            this.treeModel.reload(symbol);
        }
    }

    public void setTree() {
        DBObjectTableTypes tableTypes;
        DatabaseMetaData dmd;
        final ArrayList<DefaultMutableTreeNode> schemaNodeList = new ArrayList<DefaultMutableTreeNode>();
        DefaultMutableTreeNode selfschemaNode = null;
        try {
            this.rootTreeNode = new DefaultMutableTreeNode(SqlExec.getDatabaseProductName());
            dmd = SqlExec.getDatabaseMetaData();
            tableTypes = new DBObjectTableTypes(dmd);
            DBObjectCatalogs catalogs = new DBObjectCatalogs(dmd);
            for (DBObject catalog : catalogs.getDBObjects()) {
                DefaultMutableTreeNode catalogNode = new DefaultMutableTreeNode(catalog);
                this.rootTreeNode.add(catalogNode);
                DBObjectSchemas schemas = new DBObjectSchemas((DBObjectCatalogs.DBObjectCatalog)catalog, dmd);
                for (DBObject schema : schemas.getDBObjects()) {
                    DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode(schema);
                    catalogNode.add(schemaNode);
                    String userName = dmd.getUserName();
                    if (userName != null && dmd.getUserName().equals(((DBObjectSchemas.DBObjectSchema)schema).getSchemaName())) {
                        this.displayTree(schemaNode, tableTypes, dmd);
                        selfschemaNode = schemaNode;
                        continue;
                    }
                    schemaNodeList.add(schemaNode);
                }
            }
        }
        catch (SQLException e) {
            JDialogMessage.sqlErrorDialog(e, "\u30c4\u30ea\u30fc\u8868\u793a\u306e\u60c5\u5831\u53d6\u5f97");
            return;
        }
        this.treeModel = new DefaultTreeModel(this.rootTreeNode);
        this.setModel(this.treeModel);
        if (selfschemaNode != null) {
            this.expandPath(new TreePath(selfschemaNode.getPath()));
        }
        new Thread(){

            public void run() {
                try {
                    final ArrayList<DefaultMutableTreeNode> childNonSchemaNodeList = new ArrayList<DefaultMutableTreeNode>();
                    for (DefaultMutableTreeNode schemaNode : schemaNodeList) {
                        if (!JTreeDataBaseObjects.this.displayTree(schemaNode, tableTypes, dmd)) continue;
                        childNonSchemaNodeList.add(schemaNode);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            for (DefaultMutableTreeNode node : childNonSchemaNodeList) {
                                JTreeDataBaseObjects.this.treeModel.removeNodeFromParent(node);
                            }
                        }
                    });
                }
                catch (SQLException e) {
                    JDialogMessage.sqlErrorDialog(e, "\u30c4\u30ea\u30fc\u8868\u793a\u306e\u60c5\u5831\u53d6\u5f97");
                }
                System.out.println("\u5b9a\u7fa9\u60c5\u5831\u53d6\u5f97\u30b9\u30ec\u30c3\u30c9\u7d42\u4e86");
            }
        }.start();
    }

    private boolean displayTree(final DefaultMutableTreeNode schemaNode, DBObjectTableTypes tableTypes, DatabaseMetaData dmd) throws SQLException {
        final ArrayList<DefaultMutableTreeNode> schemaChildList = new ArrayList<DefaultMutableTreeNode>();
        DBObjectSchemas.DBObjectSchema schema = (DBObjectSchemas.DBObjectSchema)schemaNode.getUserObject();
        for (DBObject tableType : tableTypes.getDBObjects()) {
            DBObjectTables tables = new DBObjectTables(schema.getDBObjectCatalog(), schema, (DBObjectTableTypes.DBObjectTableType)tableType, dmd);
            if (tables.getDBObjects().size() == 0) continue;
            DefaultMutableTreeNode tableTypeNode = new DefaultMutableTreeNode(tableType);
            for (DBObject table : tables.getDBObjects()) {
                DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table);
                tableNode.add(new DefaultMutableTreeNode(null));
                tableTypeNode.add(tableNode);
            }
            schemaChildList.add(tableTypeNode);
        }
        DBObjectProcedures procedurs = new DBObjectProcedures(schema.getDBObjectCatalog(), schema, dmd);
        if (procedurs.getDBObjects().size() != 0) {
            DefaultMutableTreeNode procedureHeadNode = new DefaultMutableTreeNode("PROCEDURE");
            for (DBObject procedure : procedurs.getDBObjects()) {
                DefaultMutableTreeNode procedureNode = new DefaultMutableTreeNode(procedure);
                procedureNode.add(new DefaultMutableTreeNode(null));
                procedureHeadNode.add(procedureNode);
            }
            schemaChildList.add(procedureHeadNode);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (DefaultMutableTreeNode node : schemaChildList) {
                    schemaNode.add(node);
                    int[] i = new int[]{schemaNode.getChildCount() - 1};
                    JTreeDataBaseObjects.this.treeModel.nodesWereInserted(schemaNode, i);
                }
            }
        });
        return schemaChildList.size() == 0;
    }

    public void clearTree() {
        if (this.rootTreeNode != null) {
            this.rootTreeNode.removeAllChildren();
            this.treeModel.reload();
        }
    }

    private Object getDBObject(TreePath treePath, Class cls) {
        DefaultMutableTreeNode symbol = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object[] obj = symbol.getUserObjectPath();
        if (obj.length - 2 < 0) {
            return null;
        }
        int i = obj.length - 2;
        while (i >= 0) {
            if (obj[i].getClass() == cls) {
                return obj[i];
            }
            --i;
        }
        return null;
    }

    private SchemaTableName getSchemaTable(TreePath tableTreePath) {
        DBObjectSchemas.DBObjectSchema schema = (DBObjectSchemas.DBObjectSchema)this.getDBObject(tableTreePath, DBObjectSchemas.DBObjectSchema.class);
        DBObjectTables.DBObjectTable table = (DBObjectTables.DBObjectTable)this.getLastPathUserObject(tableTreePath);
        SchemaTableName stn = new SchemaTableName(schema.getSchemaName(), table.getTableName());
        return stn;
    }

    private ArrayList<SchemaTableName> getSelectSchemaTables() {
        ArrayList<SchemaTableName> list = new ArrayList<SchemaTableName>();
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            ColumnInfoTable ci;
            SchemaTableName stn;
            TreePath treePath = treePathArray[n];
            if (this.isDBObject(treePath, ColumnInfoTable.class) && list.indexOf(stn = (ci = (ColumnInfoTable)this.getLastPathUserObject(treePath)).getSchemaTableName()) == -1) {
                list.add(stn);
            }
            if (this.isDBObject(treePath, DBObjectTables.DBObjectTable.class) && list.indexOf(stn = this.getSchemaTable(treePath)) == -1) {
                list.add(stn);
            }
            ++n;
        }
        int i = 0;
        for (SchemaTableName name : list) {
            name.setAliasName("T" + ++i);
        }
        return list;
    }

    private StringBuffer getSelColumsListPhrase(ArrayList<SchemaTableName> list) {
        ArrayList<String> columns = new ArrayList<String>();
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            TreePath tp = treePathArray[n];
            if (this.isDBObject(tp, ColumnInfoTable.class)) {
                ColumnInfoTable cit = (ColumnInfoTable)this.getLastPathUserObject(tp);
                DBObjectSchemas.DBObjectSchema schema = (DBObjectSchemas.DBObjectSchema)this.getDBObject(tp, DBObjectSchemas.DBObjectSchema.class);
                DBObjectTables.DBObjectTable table = (DBObjectTables.DBObjectTable)this.getDBObject(tp, DBObjectTables.DBObjectTable.class);
                int index = list.indexOf(new SchemaTableName(schema.getSchemaName(), table.getTableName()));
                if (index > -1) {
                    columns.add(String.valueOf(list.get(index).getAliasName()) + "." + cit.getColumnName());
                } else {
                    columns.add("???." + cit.getColumnName());
                }
            }
            ++n;
        }
        StringBuffer str = new StringBuffer("");
        if (columns.size() == 0) {
            str.append("*");
            return str;
        }
        PrefixStringBuffer psb = new PrefixStringBuffer("", ", ");
        for (String column : columns) {
            psb.appendItem(column);
        }
        return psb.getStringBuffer();
    }

    private StringBuffer getFromPhrase(ArrayList<SchemaTableName> list) {
        if (list.size() > 2) {
            JOptionPane.showMessageDialog(null, "2\u3064\u4ee5\u4e0a\u306e\u30c6\u30fc\u30d6\u30eb\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f\u3002\nJOIN\u6761\u4ef6\u4f5c\u6210\u3067\u306f\u6700\u521d\u306e2\u30c6\u30fc\u30d6\u30eb\u304c\u6709\u52b9\u3067\u3059");
        }
        PrefixStringBuffer psb = new PrefixStringBuffer("\nFROM ", ", ");
        for (SchemaTableName stn : list) {
            psb.appendItem(String.valueOf(stn.getCompleteTableName()) + " " + stn.getAliasName());
        }
        return psb.getStringBuffer();
    }

    private String getWherePhrase(ArrayList<SchemaTableName> list) {
        if (list.size() < 2) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        ArrayList<String> editKey = new ArrayList<String>();
        this.createPrimaryAndColumn(editKey, str, list.get(0), list.get(1));
        this.createPrimaryAndColumn(editKey, str, list.get(1), list.get(0));
        if (editKey.size() == 0) {
            return "";
        }
        return "\nWHERE " + str.substring(5);
    }

    private void createPrimaryAndColumn(ArrayList<String> editKey, StringBuffer str, SchemaTableName primStn, SchemaTableName colStn) {
        ArrayList<String> primList = null;
        ArrayList<ColumnInfoTable> colList = null;
        try {
            primList = SqlExec.getPrimaryKeys(primStn.getSchemaName(), primStn.getTableName());
            colList = SqlExec.getColumnMames(colStn);
        }
        catch (SQLException e) {
            JDialogMessage.sqlErrorDialog(e, "\u30ab\u30e9\u30e0\u60c5\u5831\u53d6\u5f97\u3067\u5931\u6557");
            return;
        }
        for (ColumnInfoTable col : colList) {
            for (String prim : primList) {
                if (!col.getColumnName().equals(prim) || editKey.contains(col.getColumnName())) continue;
                str.append(" AND " + primStn.getAliasName() + "." + prim + " = " + colStn.getAliasName() + "." + col.getColumnName());
                editKey.add(col.getColumnName());
            }
        }
    }

    private StringBuffer getOrdeByPhrase(ArrayList<SchemaTableName> list) {
        PrefixStringBuffer psb = new PrefixStringBuffer("\nORDER BY ", ", ");
        for (SchemaTableName stn : list) {
            try {
                for (String key : SqlExec.getPrimaryKeys(stn.getSchemaName(), stn.getTableName())) {
                    psb.appendItem(String.valueOf(stn.getAliasName()) + "." + key);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return psb.getStringBuffer();
    }

    private void actionPerformedSelect(boolean isOrderBy) {
        if (this.sqlStatement == null) {
            return;
        }
        ArrayList<SchemaTableName> schemaTables = this.getSelectSchemaTables();
        StringBuffer text = new StringBuffer("SELECT ");
        text.append(this.getSelColumsListPhrase(schemaTables));
        text.append(this.getFromPhrase(schemaTables));
        text.append(this.getWherePhrase(schemaTables));
        if (isOrderBy) {
            text.append(this.getOrdeByPhrase(schemaTables));
        }
        text.append("\n");
        this.sqlStatement.setText(text.toString());
        this.sqlStatement.requestFocus();
    }

    private void actionPerformedStored() {
        if (this.sqlStatement == null) {
            return;
        }
        TreePath treePath = this.getSelectionPath();
        DBObjectProcedures.DBObjectProcedure p = (DBObjectProcedures.DBObjectProcedure)this.getLastPathUserObject(treePath);
        DBObjectSchemas.DBObjectSchema s = (DBObjectSchemas.DBObjectSchema)this.getDBObject(treePath, DBObjectSchemas.DBObjectSchema.class);
        StringBuffer text = new StringBuffer("call " + new SchemaTableName(s.getSchemaName(), p.getProcedureName()).getCompleteTableName() + "(");
        PrefixStringBuffer psb = new PrefixStringBuffer("", ",");
        try {
            List<ColumnInfoParameter> list = SqlExec.getProcedureColumns(p);
            int i = 0;
            while (i < list.size()) {
                ColumnInfoParameter cip = list.get(i);
                if (i == 0 && cip.isModeReturn()) {
                    text.insert(0, "?=");
                } else {
                    if (cip.isModeReturn()) break;
                    psb.appendItem("?");
                }
                ++i;
            }
            text.append(psb.getStringBuffer());
            text.append(")\n");
            this.sqlStatement.setText(text.toString());
            this.sqlStatement.requestFocus();
            if (p.getDuplicateCnt() > 1) {
                JDialogMessage.infoDialog("\u30aa\u30fc\u30d0\u30ed\u30fc\u30c9\u3055\u308c\u3066\u3044\u308b\u306e\u3067\u3001\u5f15\u6570\u306e\u6570\u3092\u6b63\u3057\u304f\u5224\u65ad\u51fa\u6765\u307e\u305b\u3093\u3002\n\u3088\u3063\u3066\u5f15\u6570\u306e ? \u306f\u3001\u6050\u3089\u304f\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002\u7de8\u96c6\u3057\u76f4\u3057\u3066\u4e0b\u3055\u3044\u3002", "\u5f15\u6570\u304c\u8aa4\u3063\u3066\u3044\u308b\u306e\u3067\u4fee\u6b63\u304c\u5fc5\u8981\u3067\u3059");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private JPopupMenuCnageUI getJPopupMenuTable() {
        if (this.jPopupMenuTable == null) {
            this.jPopupMenuTable = new JPopupMenuCnageUI();
            this.jPopupMenuTable.add(this.getJMenuItemOrderPrimeKey());
            this.jPopupMenuTable.add(this.getJMenuItemNoOrder());
            this.jPopupMenuTable.add(this.getJMenuItemStored());
            this.jPopupMenuTable.add(this.getJMenuItemEditSql());
            this.jPopupMenuTable.add(this.getJMenuItemName());
            this.jPopupMenuTable.addSeparator();
            this.jPopupMenuTable.add(this.getJMenuItemCreateData());
            this.jPopupMenuTable.addSeparator();
            this.jPopupMenuTable.add(this.getJMenuItemTreeUpdate());
        }
        return this.jPopupMenuTable;
    }

    private JMenuItem getJMenuItemOrderPrimeKey() {
        if (this.jMenuItemOrderPrimeKey == null) {
            this.jMenuItemOrderPrimeKey = new JMenuItem();
            this.jMenuItemOrderPrimeKey.setText("\u5168\u4ef6\u691c\u7d22\u6587\uff08\u4e3b\u30ad\u30fc\u9806\uff09");
            this.jMenuItemOrderPrimeKey.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedSelect(true);
                }
            });
        }
        return this.jMenuItemOrderPrimeKey;
    }

    private JMenuItem getJMenuItemNoOrder() {
        if (this.jMenuItemNoOrder == null) {
            this.jMenuItemNoOrder = new JMenuItem();
            this.jMenuItemNoOrder.setText("\u5168\u4ef6\u691c\u7d22\u6587\uff08\u7121\u6307\u5b9a\u9806\uff09");
            this.jMenuItemNoOrder.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedSelect(false);
                }
            });
        }
        return this.jMenuItemNoOrder;
    }

    private JMenuItem getJMenuItemStored() {
        if (this.jMenuItemStored == null) {
            this.jMenuItemStored = new JMenuItem();
            this.jMenuItemStored.setText("\u30b9\u30c8\u30a2\u30c9\u547c\u51fa\u6587");
            this.jMenuItemStored.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedStored();
                }
            });
        }
        return this.jMenuItemStored;
    }

    private JMenuItem getJMenuItemTreeUpdate() {
        if (this.jMenuItemTreeUpdate == null) {
            this.jMenuItemTreeUpdate = new JMenuItem();
            this.jMenuItemTreeUpdate.setText("\u5b9a\u7fa9\u518d\u53d6\u8fbc");
            this.jMenuItemTreeUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.setTree();
                }
            });
        }
        return this.jMenuItemTreeUpdate;
    }

    private JMenuItem getJMenuItemCreateData() {
        if (this.jMenuItemCreateData == null) {
            this.jMenuItemCreateData = new JMenuItem();
            this.jMenuItemCreateData.setText("\u30c7\u30fc\u30bf\u751f\u6210\u2026");
            this.jMenuItemCreateData.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedCreateData(e);
                }
            });
        }
        return this.jMenuItemCreateData;
    }

    private void actionPerformedCreateData(ActionEvent e) {
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        int n2 = treePathArray.length;
        while (n < n2) {
            TreePath treePath = treePathArray[n];
            if (this.isDBObject(treePath, DBObjectTables.DBObjectTable.class)) {
                JFrameCreateDataSetting dlg = new JFrameCreateDataSetting(this.getSchemaTable(treePath));
                dlg.setVisible(true);
            }
            ++n;
        }
    }

    private JMenuItem getJMenuItemName() {
        if (this.jMenuItemName == null) {
            this.jMenuItemName = new JMenuItem();
            this.jMenuItemName.setText("\u5b9a\u7fa9\u540d\u3000\u3000\u3000\u3000\u3000\u4e2d\u30dc\u30bf\u30f3");
            this.jMenuItemName.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.transColumnName(JTreeDataBaseObjects.this.getSelectionPaths());
                }
            });
        }
        return this.jMenuItemName;
    }

    private JMenuItem getJMenuItemEditSql() {
        if (this.jMenuItemEditSql == null) {
            this.jMenuItemEditSql = new JMenuItem();
            this.jMenuItemEditSql.setText("\u691c\u7d22\u6587\u751f\u6210\u2026");
            this.jMenuItemEditSql.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTreeDataBaseObjects.this.actionPerformedEditSql();
                }
            });
        }
        return this.jMenuItemEditSql;
    }

    protected void actionPerformedEditSql() {
        if (this.csft == null) {
            this.csft = new JFrameCreateSqlFromTree();
            this.csft.setSqlStatement(this.sqlStatement);
        }
        TreePath[] tps = this.getSelectionPaths();
        TreeMap<SchemaTableName, ArrayList<ColumnInfoTable>> map = new TreeMap<SchemaTableName, ArrayList<ColumnInfoTable>>();
        int i = 0;
        while (i < tps.length) {
            SchemaTableName stn;
            if (this.isDBObject(tps[i], DBObjectTables.DBObjectTable.class)) {
                stn = this.getSchemaTable(tps[i]);
                if (map.get(stn) == null) {
                    map.put(stn, new ArrayList());
                }
            } else if (this.isDBObject(tps[i], ColumnInfoTable.class)) {
                ColumnInfoTable cit = (ColumnInfoTable)this.getLastPathUserObject(tps[i]);
                stn = cit.getSchemaTableName();
                ArrayList<ColumnInfoTable> list = map.get(stn);
                if (list == null) {
                    list = new ArrayList();
                    map.put(stn, list);
                }
                list.add(cit);
            }
            ++i;
        }
        this.csft.setTablemap(map);
        this.csft.setVisible(true);
    }
}

