/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.gui.common.JPopupMenuEdit;

public class JTextPaneSqlStatement
extends JTextPane {
    private static final long serialVersionUID = -287689674208777989L;
    private SimpleAttributeSet set;
    static Pattern pattern;
    private SimpleAttributeSet sqlHigh;
    private StyledDocument doc = this.getStyledDocument();
    private JPopupMenuEdit jPopupMenuEdit;
    private UndoManager undoManagerPopupMenu;
    private CompoundEdit compoundEdit;

    static {
        String[] SQLPHASE = new String[]{"ABSOLUTE", "ACTION", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHAR_LENGTH", "CHARACTER_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"};
        StringBuffer sb = new StringBuffer("\\b(");
        int i = 0;
        while (i < SQLPHASE.length) {
            if (i != 0) {
                sb.append("|");
            }
            sb.append(SQLPHASE[i]);
            ++i;
        }
        sb.append(")\\b");
        pattern = Pattern.compile(sb.toString());
    }

    public JTextPaneSqlStatement() {
        this.doc.addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                this.addEventEdit(e);
            }

            public void insertUpdate(DocumentEvent e) {
                this.addEventEdit(e);
            }

            public void changedUpdate(DocumentEvent e) {
            }

            private void addEventEdit(DocumentEvent e) {
                if (UndoableEdit.class.isAssignableFrom(e.getClass())) {
                    UndoableEdit anEdit = (UndoableEdit)((Object)e);
                    if (JTextPaneSqlStatement.this.compoundEdit != null) {
                        Logger.global.fine("   compoundEdit.addEdit=>" + anEdit);
                        JTextPaneSqlStatement.this.compoundEdit.addEdit(anEdit);
                    } else {
                        Logger.global.fine("   undoManagerPopupMenu.addEdit=>" + anEdit);
                        JTextPaneSqlStatement.this.undoManagerPopupMenu.addEdit(anEdit);
                    }
                }
                JTextPaneSqlStatement.this.setAttr(pattern, JTextPaneSqlStatement.this.sqlHigh);
            }
        });
        this.jPopupMenuEdit = new JPopupMenuEdit(this);
        this.undoManagerPopupMenu = this.jPopupMenuEdit.getUndoManager();
        this.doc.removeUndoableEditListener(this.undoManagerPopupMenu);
        this.set = new SimpleAttributeSet();
        Font font = new Font(JFrameMain.fontFamilyName, 0, 12);
        StyleConstants.setFontSize(this.set, font.getSize());
        StyleConstants.setLeftIndent(this.set, 0.5f);
        StyleConstants.setForeground(this.set, Color.BLACK);
        StyleConstants.setBackground(this.set, Color.WHITE);
        StyleConstants.setFontFamily(this.set, font.getFamily());
        StyleConstants.setLineSpacing(this.set, -0.15f);
        int tabLength = this.getFontMetrics(font).charWidth('M') * 4;
        TabStop[] tabs = new TabStop[100];
        int j = 0;
        while (j < tabs.length) {
            tabs[j] = new TabStop((j + 1) * tabLength);
            ++j;
        }
        StyleConstants.setTabSet(this.set, new TabSet(tabs));
        this.setParagraphAttributes(this.set, true);
        this.sqlHigh = new SimpleAttributeSet();
        StyleConstants.setForeground(this.sqlHigh, Color.BLUE);
    }

    public void insertMenuItem(Component menuItem, int index) {
        this.jPopupMenuEdit.insert(menuItem, index);
    }

    private void setAttr(final Pattern pattern, final SimpleAttributeSet sqlHigh) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    JTextPaneSqlStatement.this.doc.setCharacterAttributes(0, JTextPaneSqlStatement.this.doc.getLength(), JTextPaneSqlStatement.this.set, false);
                    Matcher m = pattern.matcher(JTextPaneSqlStatement.this.doc.getText(0, JTextPaneSqlStatement.this.doc.getLength()).toUpperCase());
                    m.reset();
                    while (m.find()) {
                        int i = 0;
                        while (i <= m.groupCount()) {
                            JTextPaneSqlStatement.this.doc.setCharacterAttributes(m.start(i), m.end(i) - m.start(i), sqlHigh, false);
                            ++i;
                        }
                    }
                }
                catch (BadLocationException e) {
                    JDialogMessage.errorDialog(e);
                }
            }
        });
    }

    public void insertCurrentPosition(String str) {
        try {
            this.doc.insertString(this.getCaretPosition(), str, this.set);
        }
        catch (BadLocationException e) {
            JDialogMessage.errorDialog(e);
        }
        this.requestFocusInWindow();
    }

    public void setText(String str) {
        this.compoundEdit = new CompoundEdit();
        super.setText(str);
        this.compoundEdit.end();
        this.requestFocusInWindow();
        this.undoManagerPopupMenu.addEdit(this.compoundEdit);
        this.compoundEdit = null;
    }

    public void undoDiscard() {
        this.undoManagerPopupMenu.discardAllEdits();
    }
}

