/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import jdbcacsess.InfoListSetting;
import jdbcacsess.gui.common.ConstColumnDelimiter;
import jdbcacsess.gui.common.ConstCommitCnt;
import jdbcacsess.gui.common.ConstDupliKeyAction;
import jdbcacsess.gui.common.ConstEncoding;
import jdbcacsess.gui.common.ConstItemHeader;
import jdbcacsess.gui.common.ConstLineSeparator;
import jdbcacsess.sql.SchemaTableName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvInfo
extends InfoListSetting<CsvInfo> {
    private String fileName = new String("");
    private SchemaTableName tableName = new SchemaTableName("");
    private ConstColumnDelimiter columnDelimiter;
    private ConstLineSeparator lineSeparator;
    private ConstItemHeader itemHeader;
    private ConstDupliKeyAction duplicateKeyAction;
    private ConstCommitCnt commitCnt;
    private ConstEncoding encoding;
    private String lastModified;
    private String lastImportExecuted = new String("");
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public String toString() {
        return "[CsvInfo]fileName=" + this.fileName + "tableName=" + this.tableName + "columnDelimiter=" + (Object)((Object)this.columnDelimiter) + "lineSeparator=" + (Object)((Object)this.lineSeparator) + "encoding=" + this.encoding + "hasItemHeader=" + (Object)((Object)this.itemHeader) + "duplicateKeyAction=" + (Object)((Object)this.duplicateKeyAction) + "commitCnt=" + (Object)((Object)this.commitCnt);
    }

    @Override
    public String getKeyValue() {
        return this.getFileName();
    }

    @Override
    public void setKeyValue(String key) {
        this.setFileName(key);
    }

    @Override
    public String getBaseTagName() {
        return "csvinfo";
    }

    @Override
    public CsvInfo getInstance() {
        return new CsvInfo();
    }

    @Override
    public void setFromElement(Element cvsInfoNode) {
        this.setPropTableName(new SchemaTableName(cvsInfoNode.getAttribute("TableName")));
        this.setColumnDelimiter(cvsInfoNode.getAttribute("ColumnDelimiter"));
        this.setLineSeparator(cvsInfoNode.getAttribute("LineSeparator"));
        this.setEncoding(cvsInfoNode.getAttribute("Encoding"));
        this.setItemHeader(cvsInfoNode.getAttribute("ItemHeader"));
        this.setDuplicateKeyAction(cvsInfoNode.getAttribute("DuplicateKeyAction"));
        this.setCommitCnt(cvsInfoNode.getAttribute("CommitCnt"));
        File file = new File(this.getFileName());
        this.lastModified = file.exists() ? this.sdf.format(new Date(file.lastModified())) : "not found";
        this.lastImportExecuted = cvsInfoNode.getAttribute("LastImportExecuted");
    }

    @Override
    public void addToElement(Element cvsInfoNode) {
        cvsInfoNode.setAttribute("TableName", this.getPropTableName().getCompleteTableName());
        cvsInfoNode.setAttribute("ColumnDelimiter", this.getColumnDelimiter().toString());
        cvsInfoNode.setAttribute("LineSeparator", this.getLineSeparator().toString());
        cvsInfoNode.setAttribute("Encoding", this.getEncoding().toString());
        cvsInfoNode.setAttribute("ItemHeader", this.getItemHeader().toString());
        cvsInfoNode.setAttribute("DuplicateKeyAction", this.getDuplicateKeyAction().toString());
        cvsInfoNode.setAttribute("CommitCnt", this.getCommitCnt().toString());
        cvsInfoNode.setAttribute("LastImportExecuted", this.lastImportExecuted);
    }

    public Vector<String> getHeader() {
        Vector<String> list = new Vector<String>();
        list.add("\u30d5\u30a1\u30a4\u30eb\u540d");
        list.add("\u30d5\u30a1\u30a4\u30eb\u66f4\u65b0\u65e5\u6642");
        list.add("\u30c6\u30fc\u30d6\u30eb\u540d");
        list.add(ConstColumnDelimiter.getEnumName());
        list.add(ConstLineSeparator.getEnumName());
        list.add(ConstEncoding.getEnumName());
        list.add(ConstItemHeader.getEnumName());
        list.add(ConstDupliKeyAction.getEnumName());
        list.add(ConstCommitCnt.getEnumName());
        list.add("Import\u5b9f\u884c\u65e5\u6642");
        return list;
    }

    public String getData(int index) {
        String rtn = "";
        switch (index) {
            case 0: {
                rtn = this.getFileName();
                break;
            }
            case 1: {
                rtn = this.lastModified;
                break;
            }
            case 2: {
                rtn = this.getPropTableName().getCompleteTableName();
                break;
            }
            case 3: {
                rtn = this.getColumnDelimiter().toString();
                break;
            }
            case 4: {
                rtn = this.getLineSeparator().toString();
                break;
            }
            case 5: {
                rtn = this.getEncoding().toString();
                break;
            }
            case 6: {
                rtn = this.getItemHeader().toString();
                break;
            }
            case 7: {
                rtn = this.getDuplicateKeyAction().toString();
                break;
            }
            case 8: {
                rtn = this.getCommitCnt().toString();
                break;
            }
            case 9: {
                if (this.lastImportExecuted.equals("")) {
                    rtn = " ";
                    break;
                }
                rtn = this.lastImportExecuted;
                break;
            }
        }
        return rtn;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setPropTableName(SchemaTableName stn) {
        this.tableName = stn;
    }

    public SchemaTableName getPropTableName() {
        return this.tableName;
    }

    public void setColumnDelimiter(String propColumndelimiter) {
        this.columnDelimiter = ConstColumnDelimiter.searchName(propColumndelimiter);
    }

    public void setColumnDelimiter(ConstColumnDelimiter columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
    }

    public ConstColumnDelimiter getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public void setLineSeparator(String propLineSeparator) {
        this.lineSeparator = ConstLineSeparator.searchName(propLineSeparator);
    }

    public void setLineSeparator(ConstLineSeparator lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public ConstLineSeparator getLineSeparator() {
        return this.lineSeparator;
    }

    public void setDuplicateKeyAction(String propDuplicateKeyAction) {
        this.duplicateKeyAction = ConstDupliKeyAction.searchName(propDuplicateKeyAction);
    }

    public void setDuplicateKeyAction(ConstDupliKeyAction duplicateKeyAction) {
        this.duplicateKeyAction = duplicateKeyAction;
    }

    public ConstDupliKeyAction getDuplicateKeyAction() {
        return this.duplicateKeyAction;
    }

    public void setEncoding(String encoding) {
        this.encoding = ConstEncoding.searchName(encoding);
    }

    public void setEncoding(ConstEncoding encoding) {
        this.encoding = encoding;
    }

    public ConstEncoding getEncoding() {
        return this.encoding;
    }

    public void setItemHeader(String propItemheader) {
        this.itemHeader = ConstItemHeader.searchName(propItemheader);
    }

    public void setItemHeader(ConstItemHeader propItemHeader) {
        this.itemHeader = propItemHeader;
    }

    public ConstItemHeader getItemHeader() {
        return this.itemHeader;
    }

    public void setCommitCnt(String propCommitCnt) {
        this.commitCnt = ConstCommitCnt.searchName(propCommitCnt);
    }

    public void setCommitCnt(ConstCommitCnt propCommitCnt) {
        this.commitCnt = propCommitCnt;
    }

    public ConstCommitCnt getCommitCnt() {
        return this.commitCnt;
    }

    public void setCurrentImportExecuted() {
        this.lastImportExecuted = this.sdf.format(new Date(System.currentTimeMillis()));
    }

    public void clearImportExecuted() {
        this.lastImportExecuted = "";
    }
}

