/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JOptionPane;
import jdbcacsess.csv.CSVTokenizer;
import jdbcacsess.csv.CsvImportSqlExecute;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.DupliKeyActionMode;
import jdbcacsess.gui.JDialogError;
import jdbcacsess.sql.PrepareExecUpdate;
import jdbcacsess.sql.SqlExec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvImport {
    private CsvInfo csvInfo;
    private BufferedReader in;
    private int inputCnt = 0;
    private int resultCntUpdate = 0;
    private int resultCntInsert = 0;
    private int resultCntDelete = 0;
    private Connection con;

    public CsvImport(CsvInfo info) {
        this.csvInfo = info;
        try {
            this.openInputFile();
        }
        catch (FileNotFoundException e2) {
            JDialogError.errorDialog(e2);
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            JDialogError.errorDialog(e2);
            return;
        }
        this.con = null;
        try {
            this.con = SqlExec.getNewConnection();
            if (this.csvInfo.getCommitCnt() == 0) {
                this.con.setAutoCommit(true);
            } else {
                this.con.setAutoCommit(false);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            JDialogError.sqlErrorDialog(ex, "DB\u63a5\u7d9a\u3067\u30a8\u30e9\u30fc\u3002\u66f4\u65b0\u7cfb\u30b3\u30de\u30f3\u30c9(CSV\u5165\u529b)\u5b9f\u884c");
            SqlExec.disconnect(this.con);
            return;
        }
        if (this.csvInfo.getDuplicateKeyAction() == DupliKeyActionMode.ALLDELETE) {
            PrepareExecUpdate peu = new PrepareExecUpdate();
            peu.addStm("DELETE FROM " + this.csvInfo.getPropTableName().getCompleteTableName());
            try {
                this.resultCntDelete = peu.prepareExecute(this.con);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                JDialogError.sqlErrorDialog(ex, "\u5168\u4ef6\u524a\u9664\u3067\u30a8\u30e9\u30fc\u3001RollBack\u3057\u307e\u3059\u3002\u66f4\u65b0\u7cfb\u30b3\u30de\u30f3\u30c9(CSV\u5165\u529b)\u5b9f\u884c" + peu.getStm());
                try {
                    this.con.rollback();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                return;
            }
        }
        try {
            try {
                Vector<String> header = new Vector();
                if (this.csvInfo.hasItemHeader() && (header = this.readFile()) == null) {
                    throw new Exception("\u898b\u51fa\u3057\u6709\u308a\u306a\u306e\u306b\u3001\u7a7a\u30d5\u30a1\u30a4\u30eb\u3067\u3059");
                }
                CsvImportSqlExecute cise = new CsvImportSqlExecute(this.con, this.csvInfo.getPropTableName(), header);
                if (this.csvInfo.hasItemHeader()) {
                    this.checkColumn(cise);
                }
                int commitCnt = 1;
                Vector<String> items = this.readFile();
                while (items != null) {
                    this.executeUpdateRow(cise, items);
                    if (this.csvInfo.getCommitCnt() == 100 && ++commitCnt > 100) {
                        this.con.commit();
                        commitCnt = 1;
                    }
                    items = this.readFile();
                }
                if (this.csvInfo.getCommitCnt() != 0) {
                    this.con.commit();
                }
                JOptionPane.showMessageDialog(null, String.valueOf(this.csvInfo.getPropTableName().getCompleteTableName()) + "\u3092\u66f4\u65b0\u3057\u307e\u3057\u305f\u3002" + "\n  INFILE: " + this.inputCnt + " \u30ec\u30b3\u30fc\u30c9" + "\n  UPDATE: " + this.resultCntUpdate + " \u884c" + "\n  INSERT: " + this.resultCntInsert + " \u884c" + "\n  DELETE: " + this.resultCntDelete + " \u884c", "Import\u7d42\u4e86", 1);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                JDialogError.sqlErrorDialog(ex, "INFILE\u306e " + this.inputCnt + "\u30ec\u30b3\u30fc\u30c9\u76ee\u3067 RollBack\u307e\u3059\u3002\u66f4\u65b0\u7cfb\u30b3\u30de\u30f3\u30c9(CSV\u5165\u529b)\u5b9f\u884c" + "\n  UPDATE: " + this.resultCntUpdate + " \u884c" + "\n  INSERT: " + this.resultCntInsert + " \u884c" + "\n  DELETE: " + this.resultCntDelete + " \u884c");
                try {
                    this.con.rollback();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JDialogError.errorDialog(ex);
            }
        }
        finally {
            try {
                this.closeInputFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            SqlExec.disconnect(this.con);
        }
    }

    private void executeUpdateRow(CsvImportSqlExecute editSql, Vector<String> rowData) throws SQLException {
        if (this.csvInfo.getDuplicateKeyAction() == DupliKeyActionMode.UPDATE) {
            int updateCnt = editSql.getUpdate(rowData);
            if (updateCnt == 0) {
                this.resultCntInsert += editSql.getInsertColumnAndValue(rowData);
            } else {
                this.resultCntUpdate += updateCnt;
            }
        } else {
            this.resultCntInsert = this.csvInfo.hasItemHeader() ? (this.resultCntInsert += editSql.getInsertColumnAndValue(rowData)) : (this.resultCntInsert += editSql.getInsertOnlyValuePhrase(rowData));
        }
    }

    private void checkColumn(CsvImportSqlExecute editSql) throws Exception {
        String str = editSql.hasAllColumn();
        if (!str.equals("")) {
            throw new Exception("CSV\u306e\u898b\u51fa\u3057\u30ab\u30e9\u30e0\u304c\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u306b\u7121\u3044\n" + str);
        }
        if (this.csvInfo.getDuplicateKeyAction() == DupliKeyActionMode.UPDATE && !(str = editSql.hasPrimeKey()).equals("")) {
            throw new Exception("\u4e3b\u30ad\u30fc\u5b9a\u7fa9\u30ab\u30e9\u30e0\u304cCSV\u306e\u898b\u51fa\u3057\u306b\u7121\u3044\n" + str);
        }
    }

    private void openInputFile() throws FileNotFoundException, IOException {
        try {
            FileInputStream fos = new FileInputStream(this.csvInfo.getFileName());
            this.in = new BufferedReader(new InputStreamReader((InputStream)fos, this.csvInfo.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void closeInputFile() throws IOException {
        this.in.close();
    }

    private Vector<String> readFile() throws IOException {
        Vector<String> v = new Vector<String>();
        String rec = this.in.readLine();
        if (rec == null) {
            return null;
        }
        ++this.inputCnt;
        CSVTokenizer csvt = new CSVTokenizer(rec);
        csvt.setToken(this.csvInfo.getColumnDelimiter());
        while (csvt.hasMoreTokens()) {
            v.add(this.enquoteJdbc(csvt.nextToken()));
        }
        return v;
    }

    private String enquoteJdbc(String str) {
        boolean prevEscapChar = false;
        StringBuffer rtnBuff = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\'') {
                prevEscapChar = !prevEscapChar;
            } else if (prevEscapChar) {
                rtnBuff.append('\'');
                prevEscapChar = false;
            }
            rtnBuff.append(c);
            ++i;
        }
        return rtnBuff.toString();
    }
}

