﻿Option Explicit On
Option Strict On
Option Infer Off

''' <summary>
''' Shared functions
''' </summary>
''' <remarks></remarks>
Public Class SharedFunctions
    Shared Function DecToBCD(ByVal UInt16Value As UInt16, ByRef RetValue As UInt16) As Integer
        Dim UInt16Array() As UInt16 = New UInt16(3) {0, 0, 0, 0}
        Dim TempValue As UInt16

        For count As Integer = 3 To 1 Step -1
            TempValue = CUShort(10 ^ count)
            If UInt16Value >= TempValue Then
                UInt16Array(count) = CUShort(UInt16Value \ TempValue)
                UInt16Value = UInt16Value Mod TempValue
            End If
        Next
        RetValue = CUShort(UInt16Array(3) * 4096 + UInt16Array(2) * 256 + UInt16Array(1) * 16 + UInt16Value)
        Return 0
    End Function

    Shared Function BCDToDec(ByVal UInt16Value As UInt16, ByRef RetValue As UInt16) As Integer
        Dim UInt16Array() As UInt16 = New UInt16(3) {0, 0, 0, 0}
        Dim TempValue As UInt16

        For count As Integer = 3 To 1 Step -1
            TempValue = CUShort(16 ^ count)
            If UInt16Value >= TempValue Then
                UInt16Array(count) = CUShort(UInt16Value \ TempValue)
                UInt16Value = UInt16Value Mod TempValue
            End If
        Next
        RetValue = CUShort(UInt16Array(3) * 1000 + UInt16Array(2) * 100 + UInt16Array(1) * 10 + UInt16Value)
        Return 0
    End Function

    Shared Function CheckValue(Of T)(ByVal ValueName As String, ByVal ObjValue As Object, ByVal MinValue As Double, ByVal MaxValue As Double, ByRef CheckedValue As T) As Integer
        Dim DblValue As Double

        Try
            DblValue = CType(ObjValue, Double)

            If DblValue >= MinValue And DblValue <= MaxValue Then
                CheckedValue = CType(ObjValue, T)
                Return 0
            Else
                MessageBox.Show("Over range: Please set within " + MinValue.ToString() + " <= " + ValueName + " <= " + MaxValue.ToString())
                Return -1
            End If
        Catch ex As InvalidCastException
            MessageBox.Show(" Illeagal value: Please set within " + MinValue.ToString() + " < " + ValueName + " < " + MaxValue.ToString(), "[CheckValue] InvalidCastException")
            Return -1
        Catch ex As OverflowException
            MessageBox.Show("Illeagal value: Please set within " + MinValue.ToString() + " < " + ValueName + " < " + MaxValue.ToString(), "[CheckValue] OverflowException")
            Return -1
        End Try
    End Function

    Shared Function CheckValueEx(Of T)(ByVal ValueName As String, ByVal ObjValue As Object, ByVal MinValue As Double, ByVal MaxValue As Double, ByRef CheckedValue As T) As Integer
        Dim DblValue As Double

        Try
            DblValue = CType(ObjValue, Double)

            If DblValue > MinValue And DblValue < MaxValue Then
                CheckedValue = CType(ObjValue, T)
                Return 0
            Else
                MessageBox.Show("Over range: Please set within " + MinValue.ToString() + " < " + ValueName + " < " + MaxValue.ToString())
                Return -1
            End If
        Catch ex As InvalidCastException
            MessageBox.Show(" Illeagal value: Please set within " + MinValue.ToString() + " < " + ValueName + " < " + MaxValue.ToString(), "[CheckValueEx] InvalidCastException")
            Return -1
        Catch ex As OverflowException
            MessageBox.Show("Illeagal value: Please set within " + MinValue.ToString() + " < " + ValueName + " < " + MaxValue.ToString(), "[CheckValueEx] OverflowException")
            Return -1
        End Try
    End Function
End Class
