﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Net

''' <summary>
''' OMRON PLC, FinsTCP protocol, Binary, TCP socket communication
''' </summary>
''' <remarks></remarks>
Public Class StandardBinaryProtocol
    Inherits Protocol

    Private TcpClientSync As TcpClientSync
    Private ServerIp As IPAddress
    Private ServerPort As Integer

    Private HeaderBytes As Integer = 2
    Private CountNumberStart As Integer = 1
    Private CountNumberBytes As Integer = 2
    Private CountStart As Integer = 1
    Private CountOrder As Integer = 0

    ''' <summary>
    ''' Constructor
    ''' </summary>
    ''' <param name="Q_Protocol"></param>
    ''' <remarks></remarks>
    Public Sub New(ByVal Q_Protocol As IEnumerable(Of XElement))
        If Q_Protocol.<ServerIp>.Value Is Nothing Then
            MessageBox.Show("[ClockDividerProtocol] ServerIp in <DeviceArray><Device><Protocol>.<ServerIp> not found!")
            End
        ElseIf Q_Protocol.<ServerPort>.Value Is Nothing Then
            MessageBox.Show("ClockDividerProtocol] ServerPort in <DeviceArray><Device><Protocol>.<ServerPort> not found!")
            End
        End If

        ServerIp = IPAddress.Parse(Q_Protocol.<ServerIp>.Value)
        ServerPort = CInt(Q_Protocol.<ServerPort>.Value)

        TcpClientSync = New TcpClientSync()
    End Sub

    ''' <summary>
    ''' Connect to ClockDivider
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function Connect() As Integer
        Dim result As Integer = TcpClientSync.Connect(ServerIp, ServerPort)  ' Connect
        If result = -1 Then
            err = "Connection failed"
        End If

        Connect = result
    End Function

    ''' <summary>
    ''' Disconnect from ClockDivider
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function Disconnect() As Integer
        Dim result As Integer = TcpClientSync.Close()
        Return result
    End Function

    ' ''' <summary>
    ' ''' Read bit data from PLC 
    ' ''' </summary>
    ' ''' <param name="DeviceName"></param>
    ' ''' <param name="StartDevice"></param>
    ' ''' <param name="StartBitNo"></param>
    ' ''' <param name="DeviceCount"></param>
    ' ''' <param name="RecvDataRet"></param>
    ' ''' <returns></returns>
    ' ''' <remarks></remarks>
    'Public Function ReadBits(ByVal DeviceName As String, ByVal StartDevice As Integer, ByVal StartBitNo As Integer, ByVal DeviceCount As Integer, ByRef RecvDataRet As UInt16()) As Integer
    'End Function

    ''' <summary>
    ''' Send word data to PLC
    ''' </summary>
    ''' <param name="StartDevice"></param>
    ''' <param name="DeviceCount"></param>
    ''' <param name="RecvDataRet"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ReadWords(ByVal StartDevice As UInteger, ByVal DeviceCount As Integer, ByRef RecvDataRet As UInt16()) As Integer
        Try
            Dim MsgLen As Integer = 2 + 11
            Dim SendData() As Byte = New Byte(MsgLen - 1) {}
            Dim strValue As String
            Dim result As Integer

            ReDim RecvDataRet(DeviceCount)

            strValue = "0000" + Hex(MsgLen)
            SendData(0) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))
            SendData(1) = CByte("&h" + Strings.Right(strValue, 2))

            SendData(2) = &H0     ' Command code 1/2
            SendData(3) = &H10     ' Command code 2/2

            SendData(4) = &H0     ' Command kind: request
            SendData(5) = &H2                     'Data kind: word

            strValue = "00000000" + Hex(StartDevice)
            SendData(6) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 7, 2))                                  ' Start address 1/4
            SendData(7) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 5, 2))                                  ' Start address 2/4
            SendData(8) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))                                  ' Start address 1/4
            SendData(9) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 1, 2))                                  ' Start address 2/4

            SendData(10) = &H0                     'Start bit: &h00

            strValue = "0000" + Hex(DeviceCount)
            SendData(11) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))  ' Data count 1/2
            SendData(12) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 1, 2))  ' Data count 2/2

            TcpClientSync.Send(SendData)

            Dim RecvLengthWish As Integer = 2 + 5 + DeviceCount * 2
            Dim RecvDataByte() As Byte = New Byte() {}
            'result = TcpClientSync.RecvBinary(RecvDataByte, 0, 2, 0)
            result = TcpClientSync.RecvBinary(RecvDataByte, HeaderBytes, CountNumberStart, CountNumberBytes, CountStart, CountOrder)

            If result <> 0 Then
                err = TcpClientSync.GetError()
                Return -1
            Else
                If RecvDataByte.GetLength(0) <> RecvLengthWish Then ' Check data length
                    err = "RecvLengthError"
                    Return -1
                Else
                    If RecvDataByte(5) = 0 And RecvDataByte(6) = 0 Then
                        For count As Integer = 0 To DeviceCount - 1
                            For count2 As Integer = 0 To 1
                                RecvDataRet(count) = Convert.ToUInt16(RecvDataRet(count) + RecvDataByte(7 + count * 2 + count2) * 256 ^ (2 - 1 - count2))
                            Next
                        Next

                        Return 0
                    Else
                        err = "ResultCodeError"
                        Return -1
                    End If
                End If
            End If
        Catch ex As Exception
            err = ex.Message
            Return -1
        End Try
    End Function

    ''' <summary>
    ''' Send word data to PLC
    ''' </summary>
    ''' <param name="VariableAddress"></param>
    ''' <param name="StartValue"></param>
    ''' <param name="EndValue"></param>
    ''' <param name="ReadAddress"></param>
    ''' <param name="RecvDataRet"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function SequencialReadWords(VariableAddress As UInteger, StartValue As Integer, EndValue As Integer, ByVal ReadAddress As UInteger, ByRef RecvDataRet As UInt16()) As Integer
        Try
            Dim MsgLen As Integer = 2 + 14
            Dim SendData() As Byte = New Byte(MsgLen - 1) {}
            Dim strValue As String
            Dim result As Integer

            ReDim RecvDataRet(EndValue - StartValue)

            strValue = "0000" + Hex(MsgLen)
            SendData(0) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))
            SendData(1) = CByte("&h" + Strings.Right(strValue, 2))

            SendData(2) = &H0     ' Command code 1/2
            SendData(3) = &H20     ' Command code 2/24

            SendData(4) = &H0     ' Command kind: request

            strValue = "00000000" + Hex(VariableAddress)
            SendData(5) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 7, 2))                                  ' Variable Address 1/4
            SendData(6) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 5, 2))                                  ' Variable Address 2/4
            SendData(7) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))                                  ' Variable Address 3/4
            SendData(8) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 1, 2))                                  ' Variable Address 4/4

            SendData(9) = CByte(StartValue)                   'StartValue
            SendData(10) = CByte(EndValue)                    'EndValue

            SendData(11) = &H2                     'DataType: word

            strValue = "00000000" + Hex(ReadAddress)
            SendData(12) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 7, 2))                                  ' Read Address 1/4
            SendData(13) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 5, 2))                                  ' Read Address 2/4
            SendData(14) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))                                  ' Read Address 3/4
            SendData(15) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 1, 2))                                  ' Read Address 4/4

            TcpClientSync.Send(SendData)

            Dim RecvLengthWish As Integer = 2 + 5 + (EndValue - StartValue + 1) * 2
            Dim RecvDataByte() As Byte = New Byte() {}
            'result = TcpClientSync.RecvBinary(RecvDataByte, 0, 2, 0)
            result = TcpClientSync.RecvBinary(RecvDataByte, HeaderBytes, CountNumberStart, CountNumberBytes, CountStart, CountOrder)

            If result <> 0 Then
                err = TcpClientSync.GetError()
                Return -1
            Else
                If RecvDataByte.GetLength(0) <> RecvLengthWish Then ' Check data length
                    err = "RecvLengthError"
                    Return -1
                Else
                    If RecvDataByte(5) = 0 And RecvDataByte(6) = 0 Then
                        For count As Integer = 0 To (EndValue - StartValue + 1) - 1
                            For count2 As Integer = 0 To 1
                                RecvDataRet(count) = Convert.ToUInt16(RecvDataRet(count) + RecvDataByte(7 + count * 2 + count2) * 256 ^ (2 - 1 - count2))
                            Next
                        Next

                        Return 0
                    Else
                        err = "ResultCodeError"
                        Return -1
                    End If
                End If
            End If
        Catch ex As Exception
            err = ex.Message
            Return -1
        End Try
    End Function

    ''' <summary>
    ''' Write bit data to PLC
    ''' </summary>
    ''' <param name="DeviceName"></param>
    ''' <param name="StartDevice"></param>
    ''' <param name="StartBitNo"></param>
    ''' <param name="intData"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function WriteBits(ByVal DeviceName As String, ByVal StartDevice As UInteger, ByVal StartBitNo As Integer, ByVal intData As Integer) As Integer
        Try
            Dim MsgLen As Integer = 2 + 12 + 1
            Dim SendData() As Byte = New Byte(MsgLen - 1) {}
            Dim strValue As String
            Dim result As Integer

            strValue = "0000" + Hex(MsgLen)
            SendData(0) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))
            SendData(1) = CByte("&h" + Strings.Right(strValue, 2))

            SendData(2) = &H0     ' Command code 1/2
            SendData(3) = &H30     ' Command code 2/2

            SendData(4) = &H0     ' Command kind: request
            SendData(5) = &H0     ' Action kind: normal
            SendData(6) = &H0     ' Data kind: bit

            strValue = "00000000" + Hex(StartDevice)
            SendData(7) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 7, 2))                                  ' Start address 1/4
            SendData(8) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 5, 2))                                  ' Start address 2/4
            SendData(9) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))                                  ' Start address 1/4
            SendData(10) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 1, 2))                                  ' Start address 2/4

            strValue = "00" + Hex(StartBitNo)
            SendData(11) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 1, 2))                                  ' StartBitNo

            SendData(12) = &H0                                                                                          ' Data count 1/2
            SendData(13) = &H1                                                                                          ' Data count 2/2
            SendData(14) = CByte(intData)                                                                               ' Write data

            TcpClientSync.Send(SendData)


            Dim RecvLengthWish As Integer = 7
            Dim RecvDataByte() As Byte = New Byte() {}
            'result = TcpClientSync.RecvBinary(RecvDataByte, 0, 2, 0)
            result = TcpClientSync.RecvBinary(RecvDataByte, HeaderBytes, CountNumberStart, CountNumberBytes, CountStart, CountOrder)

            If result <> 0 Then
                err = TcpClientSync.GetError()
                Return -1
            Else
                If RecvDataByte.GetLength(0) <> RecvLengthWish Then ' Check data length
                    err = "RecvLengthError"
                    Return -1
                Else
                    If RecvDataByte(5) = &H0 And RecvDataByte(6) = &H0 Then
                        Return 0
                    Else
                        err = "ResultCodeError"
                        Return -1
                    End If
                End If
            End If
        Catch ex As Exception
            err = ex.Message
            Return -1
        End Try
    End Function

    ''' <summary>
    ''' Write multiple word data to PLC
    ''' </summary>
    ''' <param name="DeviceName"></param>
    ''' <param name="StartDevice"></param>
    ''' <param name="DeviceCount"></param>
    ''' <param name="UInt16Data"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function WriteWords(ByVal DeviceName As String, ByVal StartDevice As UInteger, ByVal DeviceCount As Integer, ByVal UInt16Data() As UInt16) As Integer
        Try
            Dim MsgLen As Integer = 2 + 12 + UInt16Data.Count * 2
            Dim SendData() As Byte = New Byte(MsgLen - 1) {}
            Dim strValue As String
            Dim result As Integer

            strValue = "0000" + Hex(MsgLen)
            SendData(0) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))
            SendData(1) = CByte("&h" + Strings.Right(strValue, 2))

            SendData(2) = &H0     ' Command code 1/2
            SendData(3) = &H30     ' Command code 2/2

            SendData(4) = &H0     ' Command kind: request
            SendData(5) = &H0     ' Action kind: normal
            SendData(6) = &H2     ' Data kind: word

            strValue = "00000000" + Hex(StartDevice)
            SendData(7) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 7, 2))                                  ' Start address 1/4
            SendData(8) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 5, 2))                                  ' Start address 2/4
            SendData(9) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))                                  ' Start address 1/4
            SendData(10) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 1, 2))                                  ' Start address 2/4

            SendData(11) = &H0                                                                                          ' StartBitNo

            strValue = "0000" + Hex(DeviceCount)
            SendData(12) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))                                  ' Start address 1/2
            SendData(13) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 1, 2))                                  ' Start address 2/2

            For count As Integer = 0 To UInt16Data.Count - 1
                SendData(14 + count * 2) = Convert.ToByte(UInt16Data(count) \ 256)
                SendData(14 + count * 2 + 1) = Convert.ToByte(UInt16Data(count) Mod 256)
            Next

            TcpClientSync.Send(SendData)

            Dim RecvLengthWish As Integer = 7
            Dim RecvDataByte() As Byte = New Byte() {}
            'result = TcpClientSync.RecvBinary(RecvDataByte, 0, 2, 0)
            result = TcpClientSync.RecvBinary(RecvDataByte, HeaderBytes, CountNumberStart, CountNumberBytes, CountStart, CountOrder)

            If result <> 0 Then
                err = TcpClientSync.GetError()
                Return -1
            Else
                If RecvDataByte.GetLength(0) <> RecvLengthWish Then ' Check data length
                    err = "RecvLengthError"
                    Return -1
                Else
                    If RecvDataByte(5) = &H0 And RecvDataByte(6) = &H0 Then
                        Return 0
                    Else
                        err = "ResultCodeError"
                        Return -1
                    End If
                End If
            End If
        Catch ex As Exception
            err = ex.Message
            Return -1
        End Try
    End Function

    ''' <summary>
    ''' Send word data to PLC
    ''' </summary>
    ''' <param name="VariableAddress"></param>
    ''' <param name="StartValue"></param>
    ''' <param name="EndValue"></param>
    ''' <param name="WriteAddress"></param>
    ''' <param name="UInt16Data"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function SequencialWriteWords(VariableAddress As UInteger, StartValue As Integer, EndValue As Integer, ByVal WriteAddress As UInteger, ByVal UInt16Data() As UInt16) As Integer
        Try
            Dim MsgLen As Integer = 2 + 14 + (EndValue - StartValue + 1) * 2
            Dim SendData() As Byte = New Byte(MsgLen - 1) {}
            Dim strValue As String
            Dim result As Integer

            strValue = "0000" + Hex(MsgLen)
            SendData(0) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))
            SendData(1) = CByte("&h" + Strings.Right(strValue, 2))

            SendData(2) = &H0     ' Command code 1/2
            SendData(3) = &H40     ' Command code 2/24

            SendData(4) = &H0     ' Command kind: request

            strValue = "00000000" + Hex(VariableAddress)
            SendData(5) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 7, 2))                                  ' Variable Address 1/4
            SendData(6) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 5, 2))                                  ' Variable Address 2/4
            SendData(7) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))                                  ' Variable Address 3/4
            SendData(8) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 1, 2))                                  ' Variable Address 4/4

            SendData(9) = CByte(StartValue)                   'StartValue
            SendData(10) = CByte(EndValue)                    'EndValue

            SendData(11) = &H2                     'DataType: word

            strValue = "00000000" + Hex(WriteAddress)
            SendData(12) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 7, 2))                                  ' Read Address 1/4
            SendData(13) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 5, 2))                                  ' Read Address 2/4
            SendData(14) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 3, 2))                                  ' Read Address 3/4
            SendData(15) = CByte("&h" + Strings.Mid(strValue, strValue.Length - 1, 2))                                  ' Read Address 4/4

            For count As Integer = 0 To UInt16Data.Count - 1
                SendData(16 + count * 2) = Convert.ToByte(UInt16Data(count) \ 256)
                SendData(16 + count * 2 + 1) = Convert.ToByte(UInt16Data(count) Mod 256)
            Next

            TcpClientSync.Send(SendData)

            Dim RecvLengthWish As Integer = 2 + 5
            Dim RecvDataByte() As Byte = New Byte() {}
            'result = TcpClientSync.RecvBinary(RecvDataByte, 0, 2, 0)
            result = TcpClientSync.RecvBinary(RecvDataByte, HeaderBytes, CountNumberStart, CountNumberBytes, CountStart, CountOrder)

            If result <> 0 Then
                err = TcpClientSync.GetError()
                Return -1
            Else
                If RecvDataByte.GetLength(0) <> RecvLengthWish Then ' Check data length
                    err = "RecvLengthError"
                    Return -1
                Else
                    If RecvDataByte(5) = 0 And RecvDataByte(6) = 0 Then
                        Return 0
                    Else
                        err = "ResultCodeError"
                        Return -1
                    End If
                End If
            End If
        Catch ex As Exception
            err = ex.Message
            Return -1
        End Try
    End Function

End Class
