﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Net

Public Class BinaryTcpClientIn
    'Inherits PlcProtocol

    Dim TcpClientSync As TcpClientSync
    Dim err As String = ""
    Dim Header As String = ""

    Dim ServerIp As IPAddress
    Dim ServerPort As Integer

    Private HeaderBytes As Integer = 2
    Private CountNumberStart As Integer = 1
    Private CountNumberBytes As Integer = 2
    Private CountStart As Integer = 1
    Private CountOrder As Integer = 0

    Public Sub New(ByVal Q_Protocol As IEnumerable(Of XElement))
        If Q_Protocol.<ServerIp>.Value Is Nothing Then
            MessageBox.Show("[FinsTcp] ServerIp in <DeviceArray><Device><Protocol>.<ServerIp> not found!")
            End
        ElseIf Q_Protocol.<ServerPort>.Value Is Nothing Then
            MessageBox.Show("FinsTcp] ServerPort in <DeviceArray><Device><Protocol>.<ServerPort> not found!")
            End
        End If

        ServerIp = IPAddress.Parse(Q_Protocol.<ServerIp>.Value)
        ServerPort = CInt(Q_Protocol.<ServerPort>.Value)

        TcpClientSync = New TcpClientSync()
    End Sub

    Public Function GetError() As String
        GetError = err
    End Function

    Public Function Connect() As Integer
        Dim result As Integer = TcpClientSync.Connect(ServerIp, ServerPort)
        If result = -1 Then
            err = "Connection to BinaryTcpServer failed"
        End If
        Connect = result
    End Function

    Public Function Disconnect() As Integer
        Dim result As Integer = TcpClientSync.Close()
        Return result
    End Function

    ' get word data
    Public Function GetData(ByRef WordGetArrayRet() As WordGet, ByRef SixteenBitsGetArrayRet() As SixteenBitsGet) As Integer
        'Try
        Dim SendData() As Byte = New Byte(3 - 1) {}
        Dim result As Integer
        Dim RecvLengthHeader As Integer
        Dim Int32Value As Int32

        SendData(0) = &H0     ' message length 1/1
        SendData(1) = &H3     ' message length 1/2
        SendData(2) = &H1     ' command code
        TcpClientSync.Send(SendData)

        'Dim RecvLengthWish As Integer = 162
        Dim RecvLengthWish As Integer = 156
        Dim RecvDataByte() As Byte = New Byte() {}
        'result = TcpClientSync.RecvBinary(RecvDataByte, 0, 2, 0)
        result = TcpClientSync.RecvBinary(RecvDataByte, HeaderBytes, CountNumberStart, CountNumberBytes, CountStart, CountOrder)

        If result <> 0 Then  ' receive result
            err = TcpClientSync.GetError()
            Return -1
        Else
            If RecvDataByte.GetLength(0) <> RecvLengthWish Then             ' data length error
                err = "RecvLengthError"
                Return -1
            Else
                ' メッセージ内データ長
                RecvLengthHeader = RecvDataByte(0) * 256 + RecvDataByte(1)
                If RecvLengthHeader <> RecvLengthWish Then                  ' data length in message incorrect
                    err = "RecvLengthError(Message)"
                    Return -1
                Else
                    If RecvDataByte(2) <> &H1 Then                          ' check command
                        err = "RecvCommandError"
                        Return -1
                    Else
                        If RecvDataByte(3) = &H1 Then                       ' check result code (FormatError)
                            err = "FormatError"
                            Return -1
                        ElseIf RecvDataByte(3) = &H2 Then                   ' check result code (LowerConnectionError)
                            err = "LowerConnectionError"
                            Return -1
                        ElseIf RecvDataByte(3) = &H0 Then                   ' check result code (OK)
                            ' Analog data
                            For count As Integer = 0 To WordGetArrayRet.GetLength(0) - 1
                                Int32Value = RecvDataByte(4 + 2 * count) * 256 + RecvDataByte(4 + 2 * count + 1)
                                'If Int32Value >= 32768 Then
                                '    Int32Value = Int32Value - 65536
                                'End If
                                If Int32Value >= 32768 Then
                                    Int32Value = 0
                                End If

                                WordGetArrayRet(count).Value = Int32Value
                            Next


                            For count As Integer = 0 To SixteenBitsGetArrayRet.GetLength(0) - 1
                                Int32Value = RecvDataByte(4 + 2 * WordGetArrayRet.GetLength(0) + 2 * count) * 256 + RecvDataByte(4 + 2 * WordGetArrayRet.GetLength(0) + 2 * count + 1)
                                'If Int32Value >= 32768 Then
                                '    Int32Value = Int32Value - 65536
                                'End If
                                'If Int32Value >= 32768 Then
                                '    Int32Value = 0
                                'End If

                                For count2 As Integer = 0 To 15
                                    If (Int32Value And CType(2 ^ count2, Long)) = 0 Then
                                        SixteenBitsGetArrayRet(count).ValueArray(count2) = 0
                                    Else
                                        SixteenBitsGetArrayRet(count).ValueArray(count2) = 1
                                    End If
                                Next

                                For count2 As Integer = 0 To SixteenBitsGetArrayRet(count).BitGetArray.GetLength(0) - 1
                                    SixteenBitsGetArrayRet(count).BitGetArray(count2).Value = SixteenBitsGetArrayRet(count).ValueArray(SixteenBitsGetArrayRet(count).BitGetArray(count2).BitNum)
                                Next
                            Next

                            Return 0
                        Else
                            err = "ResultCodeError"
                            Return -1
                        End If
                    End If
                End If
            End If
        End If
        'Catch ex As Exception
        '    err = ex.Message
        '    Return -1
        'End Try
    End Function
End Class
