﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System
Imports Microsoft.VisualBasic
Imports System.IO.Ports

''' <summary>
''' Mitsubishi Melsec PLC, 3CType4, ASCII, Serial communication
''' </summary>
''' <remarks></remarks>
Public Class Melsec3Ctype4AsciiSerial
    Inherits PlcProtocol

    Private Serial As SerialSync

    Private Const ENQ As String = Chr(&H5)                    ' ENC
    Private Const FrameNo As String = "F9"                    ' Frame identification number
    Private Const NodeNo As String = "00"                     ' Station number
    Private Const NetworkNo As String = "00"                  ' Network number
    Private Const PcNo As String = "FF"                       ' PC number
    Private Const MyNodeNo As String = "00"                   ' My node number
    Private Const Header As String = FrameNo + NodeNo + NetworkNo + PcNo + MyNodeNo ' Message header

    Private Const CommandReadBits As String = "04010001"      ' Command code for read bit data
    Private Const CommandReadWords As String = "04010000"     ' Command code for read word data
    Private Const CommandWriteBits As String = "14010001"     ' Command code for write bit data
    Private Const CommandWriteWords As String = "14010000"    ' Command code for write word data

    ''' <summary>
    ''' Constructor
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()
        Serial = New SerialSync("COM1", 9600, Parity.Odd, 8, StopBits.One, vbCrLf, , , 5000, True, True)
    End Sub

    ''' <summary>
    ''' Connect to PLC
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function Connect() As Integer
        Dim result As Integer = Serial.Open()               ' open serial data transmission
        Connect = result
    End Function

    ''' <summary>
    ''' Disconnect from PLC
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function Disconnect() As Integer
        Dim result As Integer = Serial.Close()              ' close serial data transmission
        Return result
    End Function

    ''' <summary>
    ''' Calculate check sum
    ''' </summary>
    ''' <param name="Data"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function CalcCheckSum(ByVal Data As String) As String
        Dim Enc As New System.Text.ASCIIEncoding
        Dim ByteDataArray() As Byte = Enc.GetBytes(Data)
        Dim i As Integer
        Dim CheckSumInt As Integer = 0

        For i = 0 To ByteDataArray.GetLength(0) - 1
            CheckSumInt += Convert.ToInt16(ByteDataArray(i))
        Next

        CalcCheckSum = (CheckSumInt Mod 256).ToString("00")
    End Function

    ''' <summary>
    ''' Read bit data from PLC 
    ''' </summary>
    ''' <param name="DeviceName"></param>
    ''' <param name="StartDevice"></param>
    ''' <param name="DeviceCount"></param>
    ''' <param name="RecvDataRet"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overloads Function ReadBits(ByVal DeviceName As String, ByVal StartDevice As UInteger, ByVal DeviceCount As Integer, ByRef RecvDataRet As UInt16()) As Integer
        Dim SendData As String = ""
        Dim i As Integer

        Dim StrValue As String

        Dim RecvData As String = ""

        SendData += Header                                      ' Header
        SendData += CommandReadBits                             ' Command code (8byte)
        SendData += DeviceName                                  ' I/O type (2byte)

        StrValue = "000000" + (StartDevice.ToString("X"))
        SendData += StrValue.Substring(StrValue.Length - 6, 6)  ' Start address (6byte)

        StrValue = "0000" + (DeviceCount.ToString("X"))
        SendData += StrValue.Substring(StrValue.Length - 4, 4)  ' Data count (4byte)
        'SendData += CalcCheckSum(SendData)                     ' Check sum
        SendData = ENQ + SendData

        Serial.Send(SendData)
        RecvData += Serial.Recv()

        If RecvData = "TIMEOUT" Then
            err = "TIMEOUT"
            Return Nothing
        Else
            If AscW(RecvData.Substring(0, 1)) = &H2 Then        ' Check result code
                If RecvData.Length <> 14 + DeviceCount Then     ' Check data length
                    For i = 0 To DeviceCount - 1
                        RecvDataRet(i) = Convert.ToUInt16(RecvData.Substring(11 + i, 1))
                    Next
                    Return 0
                Else
                    err = "DataLengthError"
                    Return -1
                End If
            Else
                err = "ReadBitsFailed"
                Return -1
            End If
        End If
    End Function

    ''' <summary>
    ''' Read word data from PLC
    ''' </summary>
    ''' <param name="DeviceName"></param>
    ''' <param name="StartDevice"></param>
    ''' <param name="DeviceCount"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function ReadWords(ByVal DeviceName As String, ByVal StartDevice As UInteger, ByVal DeviceCount As Integer, ByRef RecvDataRet As UInt16()) As Integer
        Dim SendData As String = ""
        Dim i As Integer
        Dim StrValue As String
        Dim RecvData As String = ""

        SendData += Header                                      ' Header
        SendData += CommandReadWords                            ' Command code (8byte)
        SendData += DeviceName                                  ' I/O type (2byte)

        StrValue = "000000" + (StartDevice.ToString("X"))
        SendData += StrValue.Substring(StrValue.Length - 6, 6)  ' Start address (6byte)

        StrValue = "0000" + (DeviceCount.ToString("X"))
        SendData += StrValue.Substring(StrValue.Length - 4, 4)  ' Data count (4byte)

        'SendData += CalcCheckSum(SendData)                     ' Check sum
        SendData = ENQ + SendData

        Serial.Send(SendData)
        RecvData += Serial.Recv()

        If RecvData = "TIMEOUT" Then
            err = "TIMEOUT"
            Return Nothing
        Else
            If AscW(RecvData.Substring(0, 1)) = &H2 Then        ' Check result code: OK?
                If RecvData.Length <> 14 + DeviceCount * 4 Then ' Check data length
                    For i = 0 To DeviceCount - 1
                        '' Need to debug
                        RecvDataRet(i) = Convert.ToUInt16(RecvData.Substring(11 + i * 4, 4), 16)
                    Next
                    Return 0
                Else
                    err = "DataLengthError"
                    Return -1
                End If
            Else
                err = "ReadWordsFailed"
                Return -1
            End If
        End If
    End Function

    ' write bit data
    Public Overloads Function WriteBits(ByVal DeviceName As String, ByVal StartDevice As Integer, ByVal DeviceCount As Integer, ByVal DataIntArray As Integer()) As Integer
        ' Public Overrides Function WriteBits(ByVal DeviceName As String, ByVal StartDevice As UInteger, ByVal StartBitNo As Integer, ByVal intData As Integer) As Integer
        Dim i As Integer
        Dim SendData As String = ""
        Dim DataStr As String = ""

        Dim StrValue As String

        Dim RecvData As String = ""

        SendData += Header                                      ' Header
        SendData += CommandWriteBits                            ' Command code for write bit(8byte)
        SendData += DeviceName                                  ' I/O type (2byte)

        StrValue = "000000" + (StartDevice.ToString("X"))
        SendData += StrValue.Substring(StrValue.Length - 6, 6)  ' Start address (6byte)

        StrValue = "0000" + (DeviceCount.ToString("X"))
        SendData += StrValue.Substring(StrValue.Length - 4, 4)  ' Data count (2byte)

        For i = 0 To DataIntArray.GetLength(0) - 1
            If DataIntArray(i) = 0 Or DataIntArray(i) = 1 Then
                DataStr += DataIntArray(i).ToString()
            Else
                err = "DataError"
                WriteBits = Nothing
            End If
        Next

        SendData += DataStr
        'SendData += CalcCheckSum(SendData)                     ' Check sum
        SendData = ENQ + SendData

        'MainForm.MsgLogSave("[Melsec.WriteBits]: SEND: DeviceName(" + DeviceNameString + ") " _
        '  + "StartDevice(" + StartDeviceString + ") " + "DeviceCount(" + DeviceCountString + ") " _
        '  + "SetDataArray(" + SetDataArrayString + ")", True)

        Serial.Send(SendData)
        RecvData += Serial.Recv()

        If RecvData = "TIMEOUT" Then
            err = "TIMEOUT"
            Return Nothing
        Else
            If AscW(RecvData.Substring(0, 1)) = &H6 Then        ' Check result code: OK?
                If RecvData.Length = 11 Then                    ' Check data length
                    WriteBits = 0
                Else
                    err = "DataLengthError"
                    Return -1
                End If
            Else
                err = "WriteBitsFailed"
                Return Convert.ToInt16(RecvData.Substring(11, 4))
            End If
        End If
    End Function

    ''' <summary>
    ''' Write word data
    ''' </summary>
    ''' <param name="DeviceName"></param>
    ''' <param name="StartDevice"></param>
    ''' <param name="DeviceCount"></param>
    ''' <param name="DataIntArray"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function WriteWords(ByVal DeviceName As String, ByVal StartDevice As UInteger, ByVal DeviceCount As Integer, ByVal DataIntArray() As UInt16) As Integer
        Dim i As Integer
        Dim SendData As String = ""
        Dim DataStr As String = ""
        Dim StrValue As String
        Dim RecvData As String = ""

        SendData += Header                                      ' Header
        SendData += CommandWriteWords                           ' Command code for write word (8byte)
        SendData += DeviceName                                  ' I/O type (2byte)

        StrValue = "000000" + (DeviceCount.ToString("X"))
        SendData += StrValue.Substring(StrValue.Length - 6, 6)  ' Start address (6byte)

        StrValue = "0000" + (DeviceCount.ToString("X"))
        SendData += StrValue.Substring(StrValue.Length - 4, 4)  ' Data count (2byte)

        For i = 0 To DataIntArray.GetLength(0) - 1
            If DataIntArray(i) >= -32768 And DataIntArray(i) <= 32767 Then
                StrValue = "0000" + DataIntArray(i).ToString("X")
                DataStr += StrValue.Substring(StrValue.Length - 4, 4)
            Else
                err = "DataError"
                WriteWords = Nothing
            End If
        Next

        SendData += DataStr
        'SendData += CalcCheckSum(SendData)                     ' Check sum
        SendData = ENQ + SendData

        Serial.Send(SendData)
        'MainForm.MsgLogSave("[Melsec.WriteBits]: SEND: DeviceName(" + DeviceNameString + ") " _
        '  + "StartDevice(" + StartDeviceString + ") " + "DeviceCount(" + DeviceCountString + ") " _
        '  + "SetDataArray(" + SetDataArrayString + ")", True)

        RecvData += Serial.Recv()

        If RecvData = "TIMEOUT" Then
            err = "TIMEOUT"
            Return Nothing
        Else
            'MainForm.MsgLogSave("[Melsec.WriteBits]: TcpClientBlock.SendData OK", True)

            If AscW(RecvData.Substring(0, 1)) = &H6 Then        ' Check result code: OK?
                If RecvData.Length = 11 Then                    ' Check data length
                    WriteWords = 0
                Else
                    'MainForm.MsgLogSave("Melsec.WriteBits: TcpClientBlock.SendData illeagal message length", True)
                    err = "DataLengthError"
                    WriteWords = -1
                End If
            Else
                err = "SendRecvError"
                WriteWords = Convert.ToInt16(RecvData.Substring(11, 4))
            End If
        End If
    End Function
End Class