﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System
Imports Microsoft.VisualBasic

''' <summary>
''' Hitachi PLC, EH150, ASCII, Serial communication
''' </summary>
''' <remarks></remarks>
Public Class EH150AsciiSerial
    Inherits PlcProtocol

    Private Serial As SerialSync
    Private count As Integer = 0

    Private Const STX As String = Chr(&H2)    'STX &h02
    Private Const TM As String = "2"          'Reply TM &h32



    'Public Function Open() As Integer
    '    Try
    '        port = New SerialPort("COM1", 19200, Parity.Even, 7, StopBits.One)
    '        port.NewLine = Microsoft.VisualBasic.vbCr
    '        port.ReceivedBytesThreshold = 7
    '        port.ReadBufferSize = 1024
    '        port.ReadTimeout = 10000
    '        port.DtrEnable = True
    '        port.RtsEnable = False
    '        port.Open()

    '        Open = 0
    '    Catch ex As Exception
    '        Open = -1
    '    End Try
    'End Function


    ''' <summary>
    ''' Constructor
    ''' </summary>
    ''' <param name="Q_Protocol"></param>
    ''' <remarks></remarks>
    Sub New(ByVal Q_Protocol As IEnumerable(Of XElement))
        Serial = New SerialSync("COM1", 19200, IO.Ports.Parity.Even, 7, IO.Ports.StopBits.One, vbCrLf, 7, 1024, 10000, True, False)
    End Sub

    ''' <summary>
    ''' Open serial communication
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function Connect() As Integer
        Dim result As Integer = Serial.Open()  ' Serial communication open
        Connect = result
    End Function

    ''' <summary>
    ''' Calculate check sum
    ''' </summary>
    ''' <param name="Data"></param>
    ''' <param name="CheckSum"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function CalcCheckSum(ByVal Data As String, ByRef CheckSum As String) As Integer
        Dim CheckSumInt As Integer = 0
        Dim CheckSumHexString As String

        For count As Integer = 0 To Data.Length - 1
            CheckSumInt += Asc(Data(count))
        Next

        CheckSumHexString = Hex(CheckSumInt)
        CheckSum = CheckSumHexString(CheckSumHexString.Length - 2) + CheckSumHexString(CheckSumHexString.Length - 1)

        Return 0
    End Function

    ''' <summary>
    ''' Read bit data from PLC
    ''' </summary>
    ''' <param name="DeviceName"></param>
    ''' <param name="StartDevice"></param>
    ''' <param name="StartBitNo"></param>
    ''' <param name="DeviceCount"></param>
    ''' <param name="RecvDataRet"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Overrides Function ReadBits(ByVal DeviceName As String, ByVal StartDevice As UInteger, ByVal StartBitNo As Integer, ByVal DeviceCount As Integer, ByRef RecvDataRet As UInt16()) As Integer
        Dim SendData As String = ""
        Dim i As Integer, j As Integer
        Dim IntArray(DeviceCount - 1) As Int16
        Dim StrValue As String = "000000" + (StartDevice.ToString("X"))
        Dim StartDeviceString As String = StrValue.Substring(StrValue.Length - 6, 6)

        StrValue = "00" + (DeviceCount.ToString("X"))
        Dim DeviceCountString As String = StrValue.Substring(StrValue.Length - 2, 2)
        Dim RecvData As String = ""
        Dim CheckSum As String = ""

        SendData += TM                      ' header(10byte)
        SendData += "A0"                    ' task code(2byte)
        SendData += DeviceName              ' WL=0B device type(2byte)
        SendData += StartDeviceString       ' "0000" device number(4byte)
        SendData += DeviceCountString       ' device count(2byte)
        CalcCheckSum(SendData, CheckSum)
        SendData += CheckSum                ' checksum(2byte)
        SendData = STX + SendData + vbCr

        Serial.Send(SendData)               ' send message

        RecvData += Serial.Recv()           ' receive message

        If RecvData = "TIMEOUT" Then
            err = "TIMEOUT"
            Return Nothing
        Else
            If AscW(RecvData.Substring(1, 2)) = &H0 Then            ' OK
                If RecvData.Length <> 8 + DeviceCount * 4 Then      ' data length OK
                    If AscW(RecvData.Substring(3, 2)) = &HA Then    ' check task  code
                        Dim quotient As Integer = DeviceCount \ 8
                        Dim remainder As Integer = DeviceCount Mod 8
                        Dim UInt16Data As UInt16

                        For i = 0 To quotient - 2
                            UInt16Data = Convert.ToUInt16(RecvData.Substring(5 + i, 1))
                            For j = 0 To 7
                                Dim UIntValue As UInt16 = UInt16Data \ CType(2 ^ (7 - j), UInt16)

                                RecvDataRet(i * 8 + j) = UIntValue
                                UInt16Data = UInt16Data - UIntValue
                            Next
                        Next

                        UInt16Data = Convert.ToUInt16(RecvData.Substring(5 + quotient - 1, 1))
                        For j = 0 To remainder - 1
                            Dim UIntValue As UInt16 = UInt16Data \ CType(2 ^ (7 - j), UInt16)

                            RecvDataRet(quotient - 1 * 8 + j) = UIntValue
                            UInt16Data = UInt16Data - UIntValue
                        Next

                        Return 0
                    Else
                        err = "TaskCodeError"   ' task code error
                    End If
                Else
                    err = "DataLengthError"     ' data length error
                    Return -1
                End If
            Else
                err = "ReadBitsFailed"
                Return -1
            End If
        End If

        Return -1
    End Function

    ''' <summary>
    ''' Write word data to PLC
    ''' </summary>
    ''' <param name="DeviceName"></param>
    ''' <param name="StartDevice"></param>
    ''' <param name="DeviceCount"></param>
    ''' <param name="RecvDataRet"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function ReadWords(ByVal DeviceName As String, ByVal StartDevice As UInteger, ByVal DeviceCount As Integer, ByRef RecvDataRet() As UInt16) As Integer
        Dim SendData As String = ""
        Dim i As Integer
        Dim IntArray(DeviceCount - 1) As Int16
        Dim StrValue As String = "000000" + (StartDevice.ToString("X"))
        Dim StartDeviceString As String = StrValue.Substring(StrValue.Length - 6, 6)
        ReDim RecvDataRet(DeviceCount - 1)
        Dim RecvDataTemp As String = ""

        StrValue = "00" + (DeviceCount.ToString("X"))
        Dim DeviceCountString As String = StrValue.Substring(StrValue.Length - 2, 2)
        Dim RecvData As String = ""
        Dim CheckSum As String = ""
        Dim WishRecvLength As Integer = 7 + DeviceCount * 4

        count += 1

        SendData += TM                              ' Header (10byte)
        SendData += "A0"                            ' Task code (2byte)
        SendData += DeviceName                      ' Device type (2byte)
        SendData += StartDeviceString               ' Device number (4byte)
        SendData += DeviceCountString               ' Device count (2byte)
        CalcCheckSum(SendData, CheckSum)
        SendData += CheckSum                        ' Check sum (2byte)
        SendData = STX + SendData + vbCr

        System.Threading.Thread.Sleep(1000)
        Serial.Send(SendData)                       ' Send message

        While True
            If RecvData.Length > WishRecvLength Then
                err = "RecvLengthError"
                Return -1
            ElseIf RecvData.Length < WishRecvLength Then
                RecvDataTemp = Serial.Recv()        ' Receive message
                If Asc(RecvDataTemp.Substring(0, 1)) = &H15 Then
                    err = "NackReceived"
                    Return -1
                Else
                    If RecvDataTemp = "TIMEOUT" Then
                        err = "TIMEOUT"
                        Return -1
                    ElseIf RecvDataTemp = "PORT_CLOSED" Then
                        err = "PORT_CLOSED"
                        Return -1
                    Else
                        RecvData += RecvDataTemp
                    End If
                End If
            Else
                Exit While
            End If
        End While

        If RecvData.Substring(1, 2).Equals("00") Then               ' Result: Done successfully
            If RecvData.Substring(3, 2).Equals("A0") Then           ' Task code
                For i = 0 To DeviceCount - 1
                    RecvDataRet(i) = Convert.ToUInt16(RecvData.Substring(5 + i * 4, 4), 16)
                Next
                Return 0
            Else
                err = "TaskCodeError"
            End If
        Else
            err = count.ToString + ":ReadWordsFailed"               ' Result: Failed
            Return -1
        End If

        Return -1
    End Function

    ''' <summary>
    ''' Write bit data to PLC
    ''' </summary>
    ''' <param name="DeviceName"></param>
    ''' <param name="StartDevice"></param>
    ''' <param name="StartBitNo"></param>
    ''' <param name="intData"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overloads Overrides Function WriteBits(DeviceName As String, StartDevice As UInteger, StartBitNo As Integer, intData As Integer) As Integer
        Return 0
    End Function

    ''' <summary>
    ''' Write word data to PLC
    ''' </summary>
    ''' <param name="DeviceName"></param>
    ''' <param name="StartDevice"></param>
    ''' <param name="DeviceCount"></param>
    ''' <param name="UInt16Data"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overloads Overrides Function WriteWords(DeviceName As String, StartDevice As UInteger, DeviceCount As Integer, UInt16Data() As UInt16) As Integer
        Return 0
    End Function

    ''' <summary>
    ''' Close serial communication
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function Disconnect() As Integer
        Dim result As Integer = Serial.Close()
        Return result
    End Function
End Class