﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Windows.Interop
Imports System.Runtime.InteropServices

Public Class MailSettingWindow
    Dim Kernel As Kernel

    'Dim WindowTagArray() As String

    Dim OriginalWidth As Double
    Dim OriginalHeight As Double

    Private Const MF_BYCOMMAND As Integer = &H0&
    Private Const SC_CLOSE As Integer = &HF060&

    Public ToListArray As New ArrayList

    Public CaptureWindowListArray As New ArrayList

    Public CheckBoxArray() As CheckBox

    <DllImport("User32")> _
    Public Shared Function RemoveMenu(ByVal hMenu As IntPtr, ByVal uPosition As UInteger, ByVal uFlags As UInteger) As Boolean
    End Function

    <DllImport("User32")> _
    Public Shared Function GetSystemMenu(ByVal hWnd As IntPtr, ByVal bRevert As Boolean) As IntPtr
    End Function

    <DllImport("User32")> _
    Public Shared Function DrawMenuBar(ByVal hWnd As IntPtr) As Long
    End Function

    Sub New(ByVal Kernel As Kernel)
        MyBase.New()

        Me.Kernel = Kernel

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()
        Init()
    End Sub

    Sub New()
        MyBase.New()

        InitializeComponent()
        Init()
    End Sub

    Sub CheckBoxArray_Clicked(sender As Object, e As System.Windows.RoutedEventArgs)
        ReturnToOrigin.IsEnabled = True
        SaveData.IsEnabled = True
    End Sub

    Private Sub Init()
        OriginalWidth = Me.Width
        OriginalHeight = Me.Height

        Me.MinWidth = OriginalWidth / 2
        Me.MinHeight = OriginalHeight / 2

        For count As Integer = 0 To Kernel.MailDestinationArray(0).ToArray.Count - 1
            ToList.Items.Add(Kernel.MailDestinationArray(0).ToArray(count).Address)
            ToListArray.Add(Kernel.MailDestinationArray(0).ToArray(count).Address)
        Next

        CheckBoxArray = New CheckBox(Kernel.WindowInfoArray.GetLength(0)) {}
        For i As Integer = 0 To Kernel.WindowInfoArray.GetLength(0) - 1
            CheckBoxArray(i) = New CheckBox
            CaptureWindowList.Items.Add(CheckBoxArray(i))
            AddHandler CheckBoxArray(i).Click, AddressOf CheckBoxArray_Clicked


            CType(CaptureWindowList.Items.Item(i), CheckBox).Content = Kernel.WindowInfoArray(i).Tag
            'WindowTagArray(i) = Kernel.WindowInfoArray(i).Tag
        Next

        BackToOrigin()
    End Sub

    Private Sub HideWindow_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles HideWindow.Click
        BackToOrigin()
        Me.Hide()
    End Sub

    Sub BackToOrigin()
        If Kernel.MailDestinationArray(0).CaptureAttached = 1 Then
            CaptureAttachedUI.IsChecked = True
        Else
            CaptureAttachedUI.IsChecked = False
        End If

        If Kernel.MailDestinationArray(0).ReminderEnabled = 1 Then
            ReminderEnabledUI.IsChecked = True
        Else
            ReminderEnabledUI.IsChecked = False
        End If

        For i As Integer = 0 To CaptureWindowList.Items.Count - 1
            If Kernel.WindowInfoArray(i).CaptureAttached = 1 Then
                DirectCast(CaptureWindowList.Items(i), CheckBox).IsChecked = True
            Else
                DirectCast(CaptureWindowList.Items(i), CheckBox).IsChecked = False
            End If
        Next

        ReminderIntervalSecUI.Text = CStr(Kernel.MailDestinationArray(0).ReminderIntervalSec)

        ReturnToOrigin.IsEnabled = False
        SaveData.IsEnabled = False
    End Sub

    Private Sub Add_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles Add.Click
        If ToListArray.IndexOf(MailAddressInput.Text) = -1 Then
            ToList.Items.Add(MailAddressInput.Text)
            ToListArray.Add(MailAddressInput.Text)
            SaveToArray()
        End If
    End Sub

    Private Sub Delete_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles Delete.Click
        Dim RemoveIndex As Integer = ToList.SelectedIndex
        ToListArray.RemoveAt(RemoveIndex)
        ToList.Items.RemoveAt(RemoveIndex)
        SaveToArray()
    End Sub

    Sub SaveToArray()
        Dim doc As XDocument = XDocument.Load("System.xml")
        Dim Q_ToArray As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<ParameterArray>.<MailSetting>.<MailDestination>.<ToArray> Select i
        Dim Q_MailAddress As IEnumerable(Of XElement) = From i In Q_ToArray.<MailAddress> Select i
        Dim NewData As XElement

        For count As Integer = Q_MailAddress.Count - 1 To 0 Step -1
            Q_MailAddress(count).Remove()
        Next
        ReDim Kernel.MailDestinationArray(0).ToArray(ToList.Items.Count - 1)

        For count As Integer = 0 To ToList.Items.Count - 1
            NewData = New XElement("MailAddress", New XAttribute("Address", ToList.Items.Item(count).ToString))
            Q_ToArray(0).Add(NewData)
            Kernel.MailDestinationArray(0).ToArray(count) = New MailAddress("", ToList.Items.Item(count).ToString)
        Next

        doc.Save("..\\..\\System.xml")
        doc.Save("System.xml")
    End Sub

    Private Sub MailSettingWindow_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        'TODO: ここにイベント ハンドラーのコードを追加します。
        Dim windowHandle As IntPtr = (New WindowInteropHelper(Me)).Handle

        Call RemoveMenu(GetSystemMenu(windowHandle, False), SC_CLOSE, MF_BYCOMMAND)
        Call DrawMenuBar(windowHandle)
    End Sub

    Private Sub MailSettingWindow_SizeChanged(ByVal sender As Object, ByVal e As System.Windows.SizeChangedEventArgs)
        'TODO: ここにイベント ハンドラーのコードを追加します。
        Dim AdjustScale As System.Windows.Media.ScaleTransform = New System.Windows.Media.ScaleTransform()

        AdjustScale.ScaleX = (Me.Width - 20) / (OriginalWidth - 20)
        AdjustScale.ScaleY = (Me.Height - 40) / (OriginalHeight - 40)

        Me.Height = AdjustScale.ScaleX * OriginalHeight

        CV.RenderTransform = AdjustScale
    End Sub

    Private Sub SaveData_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles SaveData.Click
        Dim doc As XDocument = XDocument.Load("System.xml")
        Dim Q_MailDestination As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<ParameterArray>.<MailSetting>.<MailDestination> Select i
        Dim Q_WindowArray As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<ParameterArray>.<WindowArray>.<Window> Select i

        ' <ParameterArray><MailSetting>.<MailDestination>.@CaptureAttached
        If CaptureAttachedUI.IsChecked Then
            Q_MailDestination(0).@CaptureAttached = "1"
            Kernel.MailDestinationArray(0).CaptureAttached = 1
        Else
            Q_MailDestination(0).@CaptureAttached = "0"
            Kernel.MailDestinationArray(0).CaptureAttached = 0
        End If

        ' <ParameterArray><MailSetting>.<MailDestination>.@ReminderEnabled
        If ReminderEnabledUI.IsChecked Then
            Q_MailDestination(0).@ReminderEnabled = "1"
            Kernel.MailDestinationArray(0).ReminderEnabled = 1
        Else
            Q_MailDestination(0).@ReminderEnabled = "0"
            Kernel.MailDestinationArray(0).ReminderEnabled = 0
        End If

        ' <ParameterArray><MailSetting>.<MailDestination>.@ReminderInterval
        Q_MailDestination(0).@ReminderIntervalSec = ReminderIntervalSecUI.Text
        Kernel.MailDestinationArray(0).ReminderIntervalSec = CInt(ReminderIntervalSecUI.Text)
        Kernel.em.MailReminderEventCount = Convert.ToInt32(Kernel.MailDestinationArray(0).ReminderIntervalSec * 1000 / Kernel.TicksMilliSecond)

        ' <ParameterArray>WindowArray><Window>.CaptureAttached 
        For count As Integer = 0 To CaptureWindowList.Items.Count - 1
            If DirectCast(CaptureWindowList.Items(count), CheckBox).IsChecked Then
                Q_WindowArray(count).@CaptureAttached = "1"
                Kernel.WindowInfoArray(count).CaptureAttached = 1
            Else
                Q_WindowArray(count).@CaptureAttached = "0"
                Kernel.WindowInfoArray(count).CaptureAttached = 0
            End If
        Next

        doc.Save("..\\..\\System.xml")
        doc.Save("System.xml")
    End Sub

    Private Sub ReminderEnabledUI_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles ReminderEnabledUI.Click
        ReturnToOrigin.IsEnabled = True
        SaveData.IsEnabled = True
    End Sub

    Private Sub CaptureAttachedUI_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles CaptureAttachedUI.Click
        ReturnToOrigin.IsEnabled = True
        SaveData.IsEnabled = True
    End Sub

    Private Sub ReminderIntervalSecUI_TextChanged(sender As System.Object, e As System.Windows.Controls.TextChangedEventArgs) Handles ReminderIntervalSecUI.TextChanged
        Dim ReminderIntervalChecked As Integer

        If ReminderIntervalSecUI.Text <> CStr(Kernel.MailDestinationArray(0).ReminderIntervalSec) Then
            If SharedFunctions.CheckValue(Of Integer)("Reminder wait time", ReminderIntervalSecUI.Text, 1, 86400, ReminderIntervalChecked) = 0 Then
                ReturnToOrigin.IsEnabled = True
                SaveData.IsEnabled = True
            Else
                ReminderIntervalSecUI.Text = CStr(Kernel.MailDestinationArray(0).ReminderIntervalSec)
            End If
        End If
    End Sub

    Private Sub ReturnToOrigin_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles ReturnToOrigin.Click
        BackToOrigin()
    End Sub
End Class