﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Windows.Interop
Imports System.Runtime.InteropServices

Public Class AlarmAnalog
    Dim Kernel As Kernel

    Dim OriginalWidth As Double
    Dim OriginalHeight As Double

    Dim dsAlarmAnalog As shmit.dsAlarmAnalog
    Dim DataTable As System.Data.DataTable

    Private Const MF_BYCOMMAND As Integer = &H0&
    Private Const SC_CLOSE As Integer = &HF060&

    <DllImport("User32")> _
    Public Shared Function RemoveMenu(ByVal hMenu As IntPtr, ByVal uPosition As UInteger, ByVal uFlags As UInteger) As Boolean
    End Function

    <DllImport("User32")> _
    Public Shared Function GetSystemMenu(ByVal hWnd As IntPtr, ByVal bRevert As Boolean) As IntPtr
    End Function

    <DllImport("User32")> _
    Public Shared Function DrawMenuBar(ByVal hWnd As IntPtr) As Long
    End Function

    Private Sub AddMsg(ByVal msg As String, ByVal flag As Boolean)
        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + msg, True)
    End Sub

    Public Sub New(ByVal kernel As Kernel)
        MyBase.New()

        InitializeComponent()
        Init()

        Me.Kernel = kernel
    End Sub

    Public Sub New()
        MyBase.New()

        InitializeComponent()
        Init()
    End Sub

    Private Sub Init()
        OriginalWidth = Me.Width
        OriginalHeight = Me.Height

        Me.MinWidth = OriginalWidth / 2
        Me.MinHeight = OriginalHeight / 2
    End Sub

    Private Sub AlarmAnalog_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        Dim windowHandle As IntPtr = (New WindowInteropHelper(Me)).Handle

        Call RemoveMenu(GetSystemMenu(windowHandle, False), SC_CLOSE, MF_BYCOMMAND)
        Call DrawMenuBar(windowHandle)

    End Sub

    Private Sub Window_SizeChanged(ByVal sender As System.Object, ByVal e As System.Windows.SizeChangedEventArgs) Handles AlarmAnalog.SizeChanged
        Dim AdjustScale As System.Windows.Media.ScaleTransform = New System.Windows.Media.ScaleTransform()

        AdjustScale.ScaleX = (Me.Width - 20) / (OriginalWidth - 20)
        AdjustScale.ScaleY = (Me.Height - 40) / (OriginalHeight - 40)

        Me.Height = AdjustScale.ScaleX * OriginalHeight

        CV.RenderTransform = AdjustScale
    End Sub

    Private Sub HideWindow_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles HideWindow.Click
        Me.Hide()
    End Sub

    Public Sub InitDataSet()
        DataTable.Clear()

        For count As Integer = 0 To Kernel.RealDataArray.Count - 1
            Try
                DataTable.Rows.Add()
                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("NameSet")) = Kernel.RealDataArray(count).Name

                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHSet")) = Kernel.RealDataArray(count).UpperLimitItemArray(0).LimitValue
                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHInput")) = Kernel.RealDataArray(count).UpperLimitItemArray(0).LimitValue
                If Kernel.RealDataArray(count).UpperLimitItemArray(0).MailFlag = 1 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHMailSet")) = True
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHMailInput")) = True
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHMailSet")) = False
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHMailInput")) = False
                End If

                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHSet")) = Kernel.RealDataArray(count).UpperLimitItemArray(1).LimitValue
                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHInput")) = Kernel.RealDataArray(count).UpperLimitItemArray(1).LimitValue
                If Kernel.RealDataArray(count).UpperLimitItemArray(1).MailFlag = 1 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHMailSet")) = True
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHMailInput")) = True
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHMailSet")) = False
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHMailInput")) = False
                End If


                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLSet")) = Kernel.RealDataArray(count).LowerLimitItemArray(0).LimitValue
                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLInput")) = Kernel.RealDataArray(count).LowerLimitItemArray(0).LimitValue
                If Kernel.RealDataArray(count).LowerLimitItemArray(0).MailFlag = 1 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLMailSet")) = True
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLMailInput")) = True
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLMailSet")) = False
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLMailInput")) = False
                End If

                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLSet")) = Kernel.RealDataArray(count).LowerLimitItemArray(1).LimitValue
                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLInput")) = Kernel.RealDataArray(count).LowerLimitItemArray(1).LimitValue
                If Kernel.RealDataArray(count).LowerLimitItemArray(1).MailFlag = 1 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLMailSet")) = True
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLMailInput")) = True
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLMailSet")) = False
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLMailInput")) = False
                End If

            Catch ex As ResourceReferenceKeyNotFoundException
                MessageBox.Show("[InternalError] DataSetName = dsAlarmAnalog not found!")
                End
            End Try
        Next
    End Sub

    Public Sub UpdateDataSet()
        For count As Integer = 0 To Kernel.RealDataArray.Count - 1
            Try
                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHSet")) = Kernel.RealDataArray(count).UpperLimitItemArray(0).LimitValue
                If Kernel.RealDataArray(count).UpperLimitItemArray(0).MailFlag = 1 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHMailSet")) = True
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHMailSet")) = False
                End If

                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHSet")) = Kernel.RealDataArray(count).UpperLimitItemArray(1).LimitValue
                If Kernel.RealDataArray(count).UpperLimitItemArray(1).MailFlag = 1 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHMailSet")) = True
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHMailSet")) = False
                End If

                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLSet")) = Kernel.RealDataArray(count).LowerLimitItemArray(0).LimitValue
                If Kernel.RealDataArray(count).LowerLimitItemArray(0).MailFlag = 1 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLMailSet")) = True
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLMailSet")) = False
                End If

                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLSet")) = Kernel.RealDataArray(count).LowerLimitItemArray(1).LimitValue
                If Kernel.RealDataArray(count).LowerLimitItemArray(1).MailFlag = 1 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLMailSet")) = True
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLMailSet")) = False
                End If

            Catch ex As ResourceReferenceKeyNotFoundException
                MessageBox.Show("[InternalError] DataSetName = dsAlarmAnalog not found!")
                End
            End Try
        Next
    End Sub

    Private Sub AlarmAnalog_Initialized(ByVal sender As Object, ByVal e As System.EventArgs)
        'TODO: ここにイベント ハンドラーのコードを追加します。
        dsAlarmAnalog = CType(Me.FindResource("dsAlarmAnalog"), shmit.dsAlarmAnalog)
        DataTable = CType(dsAlarmAnalog.Tables("DataTable1"), System.Data.DataTable)
    End Sub

    Private Sub SetData_Click(ByVal sender as Object, ByVal e as System.Windows.RoutedEventArgs)
    	'TODO: ここにイベント ハンドラーのコードを追加します。
        Dim doc As XDocument = XDocument.Load("System.xml")
        Dim Q_RealData As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<RealDataArray>.<RealData> Select i
        For count As Integer = 0 To Q_RealData.Count - 1
            Dim Q_UpperLimitItem As IEnumerable(Of XElement) = From i In Q_RealData(count).<AlarmItem>.<UpperLimitArray>.<LimitItem> Select i
            Q_UpperLimitItem(0).@LimitValue = CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("HHInput")).ToString         ' HH
            Q_UpperLimitItem(0).@RecoveryValue = CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("HHInput")).ToString
            Kernel.RealDataArray(count).UpperLimitItemArray(0).LimitValue = CDbl(CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("HHInput")))
            Kernel.RealDataArray(count).UpperLimitItemArray(0).RecoveryValue = CDbl(CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("HHInput")))
            If CBool(CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("HHMailInput"))) = True Then
                Q_UpperLimitItem(0).@MailFlag = "1"
            Else
                Q_UpperLimitItem(0).@MailFlag = "0"
            End If
            Kernel.RealDataArray(count).UpperLimitItemArray(0).MailFlag = CInt(Q_UpperLimitItem(0).@MailFlag)

            Q_UpperLimitItem(1).@LimitValue = CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("PHInput")).ToString         ' PH
            Q_UpperLimitItem(1).@RecoveryValue = CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("PHInput")).ToString
            Kernel.RealDataArray(count).UpperLimitItemArray(1).LimitValue = CDbl(CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("PHInput")))
            Kernel.RealDataArray(count).UpperLimitItemArray(1).RecoveryValue = CDbl(CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("PHInput")))
            If CBool(CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("PHMailInput"))) = True Then
                Q_UpperLimitItem(1).@MailFlag = "1"
            Else
                Q_UpperLimitItem(1).@MailFlag = "0"
            End If
            Kernel.RealDataArray(count).UpperLimitItemArray(1).MailFlag = CInt(Q_UpperLimitItem(1).@MailFlag)



            Dim Q_LowerLimitItem As IEnumerable(Of XElement) = From i In Q_RealData(count).<AlarmItem>.<LowerLimitArray>.<LimitItem> Select i
            Q_LowerLimitItem(0).@LimitValue = CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("PLInput")).ToString         ' HH
            Q_LowerLimitItem(0).@RecoveryValue = CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("PLInput")).ToString
            Kernel.RealDataArray(count).LowerLimitItemArray(0).LimitValue = CDbl(CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("PLInput")))
            Kernel.RealDataArray(count).LowerLimitItemArray(0).RecoveryValue = CDbl(CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("PLInput")))
            If CBool(CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("PLMailInput"))) = True Then
                Q_LowerLimitItem(0).@MailFlag = "1"
            Else
                Q_LowerLimitItem(0).@MailFlag = "0"
            End If
            Kernel.RealDataArray(count).LowerLimitItemArray(0).MailFlag = CInt(Q_LowerLimitItem(0).@MailFlag)

            Q_LowerLimitItem(1).@LimitValue = CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("LLInput")).ToString        ' PH
            Q_LowerLimitItem(1).@RecoveryValue = CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("LLInput")).ToString
            Kernel.RealDataArray(count).LowerLimitItemArray(1).LimitValue = CDbl(CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("LLInput")))
            Kernel.RealDataArray(count).LowerLimitItemArray(1).RecoveryValue = CDbl(CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("LLInput")))
            If CBool(CType(DataTable1ListView1.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("LLMailInput"))) = True Then
                Q_LowerLimitItem(1).@MailFlag = "1"
            Else
                Q_LowerLimitItem(1).@MailFlag = "0"
            End If
            Kernel.RealDataArray(count).LowerLimitItemArray(1).MailFlag = CInt(Q_LowerLimitItem(1).@MailFlag)

        Next

        'doc.Save("..\\..\\System.xml")
        doc.Save("System.xml")

        UpdateDataSet()
    End Sub
End Class