﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System
Imports System.Windows
Imports System.Threading
Imports System.IO
Imports System.Text

Public Class DataAcquisitionAsync
    Inherits DataAcquisition
    Dim ErrFlagPre() As Integer
    Private Kernel As Kernel
    Public ConnectStatus As Integer = -1
    Public ConnectStatusPre As Integer = -1
    Dim LogicalItemPreStatusArray() As Integer
    Public DataReceivedFlag As Boolean = False
    Public TimeoutFlag As Boolean = False           ' True: No Data Received Within 20 sec

    Dim MailToArray() As String
    Dim ErrorMessageTotal As String = ""

    Sub New(ByVal em As EventManager, ByVal Kernel As Kernel)
        Me.Kernel = Kernel
        ReDim ErrFlagPre(Kernel.DeviceArray.GetLength(0) - 1)

        If Kernel.MailDestinationArray IsNot Nothing And Kernel.MailSendFlag = 1 Then
            MailToArray = New String(Kernel.MailDestinationArray(0).ToArray.Count - 1) {}
            For count As Integer = 0 To MailToArray.Count - 1
                MailToArray(count) = Kernel.MailDestinationArray(0).ToArray(count).Address
            Next
        End If

        AddHandler em.evtDataAcquisition, AddressOf DataAcquisition
        AddHandler em.evtMailReminder, AddressOf MailReminder ' register MailReminder event handler

        For count As Integer = 0 To Kernel.DeviceArray.GetLength(0) - 1
            ErrFlagPre(count) = -1
        Next

        LogicalItemPreStatusArray = New Integer(Kernel.LogicalItemArray.Count - 1) {}
        For count As Integer = 0 To Kernel.DeviceArray.GetLength(0) - 1
            ErrFlagPre(count) = -1
        Next

        For count As Integer = 0 To LogicalItemPreStatusArray.Count - 1
            LogicalItemPreStatusArray(count) = Kernel.LogicalItemArray(count).StateArray.Count - 1
        Next
    End Sub

    Sub DataAcquisition()
        ' In case of 15sec elapsed
        If Kernel.DeviceArray(0).LastAcquisitionTime.AddSeconds(20) < System.DateTime.Now Then
            If DataReceivedFlag Then
                DataReceivedFlag = False
                TimeoutFlag = False
                ConnectStatus = 1
            Else
                If Kernel.DeviceArray(0).Protocol.AsciiDataGetArray IsNot Nothing Then
                    For count As Integer = 0 To Kernel.DeviceArray(0).Protocol.AsciiDataGetArray.GetLength(0) - 1
                        Kernel.DeviceArray(0).Protocol.AsciiDataGetArray(count).Value = &HFFFF
                    Next
                End If

                TimeoutFlag = True
                ConnectStatus = 0
                End If
        End If

        If ConnectStatus <> ConnectStatusPre Then
            If ConnectStatus = 1 Then
                Kernel.ChangeStyle(Kernel.GetWindow(Of MainWindow)("MainWindow").ComStatus, "LabelWithContent2.0_Green")
                Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Connection OK.", True)
            Else
                Kernel.ChangeStyle(Kernel.GetWindow(Of MainWindow)("MainWindow").ComStatus, "LabelWithContent2.0_Red_Blink")
                Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Connection NG.", True)
            End If
            ConnectStatusPre = ConnectStatus
        End If

        DataCheck()

        ' In case of BinaryTcpSync(PlantTerminal)
        'Dim j As Integer
        'Dim EventCount As Integer = 1
        'Dim ErrFlag(Kernel.DeviceArray.GetLength(0) - 1) As Integer

        'For count As Integer = 0 To Kernel.DeviceArray.GetLength(0) - 1
        '    If Kernel.DeviceArray(count).ActiveFlag = 1 Then
        '        ErrFlag(count) = -1
        '        j = 0

        '        ' データ収集
        '        If Kernel.DeviceArray(count).CommunicationStatus = True Then
        '            ErrFlag(count) = Kernel.DeviceArray(count).DoQuery()
        '        Else
        '            ErrFlag(count) = 1
        '            If DirectCast(Kernel.DeviceArray(count), BinaryTcpSync).BinaryTcpClientIn.Connect = 0 Then
        '                DirectCast(Kernel.DeviceArray(count), BinaryTcpSync).CommunicationStatus = True
        '                ErrFlag(count) = Kernel.DeviceArray(count).DoQuery()
        '            End If
        '        End If

        '        If ErrFlag(count) <> ErrFlagPre(count) Then
        '            If ErrFlag(count) = 1 Then
        '                Dim ErrorKind As String = Kernel.DeviceArray(count).GetError()

        '                If ErrorKind <> "LowerConnectionError" Then
        '                    Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Data acquisition failed. re-connect to " + Kernel.DeviceArray(count).DeviceName + " at intervals of " + Kernel.AcquisitionCycleMilliSecond.ToString + "msec...", True)
        '                    'Kernel.ChangeStyle(Kernel.GetWindow(Of MainWindow)("MainWindow").ShowLog, "ButtonRoundWithContentRed")

        '                    If Kernel.ComStatus IsNot Nothing Then
        '                        If Kernel.ComStatus(count) IsNot Nothing Then
        '                            Kernel.ChangeStyle(Kernel.ComStatus(count), "LabelWithContent2.0_Red_Blink")
        '                        End If
        '                    End If


        '                    DirectCast(Kernel.DeviceArray(count), BinaryTcpSync).BinaryTcpClientIn.Disconnect()
        '                    DirectCast(Kernel.DeviceArray(count), BinaryTcpSync).CommunicationStatus = False
        '                Else
        '                    Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Data acquisition failed. LowerConnectionError at " + Kernel.DeviceArray(count).DeviceName, True)
        '                    If Kernel.ComStatus IsNot Nothing Then
        '                        If Kernel.ComStatus(count) IsNot Nothing Then
        '                            Kernel.ChangeStyle(Kernel.ComStatus(count), "LabelWithContent2.0_Yellow")
        '                        End If
        '                    End If
        '                End If
        '            Else
        '                Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Connection recovered. Data acquisition OK. (" + Kernel.DeviceArray(count).DeviceName + ")", True)

        '                If Kernel.ComStatus IsNot Nothing Then
        '                    If Kernel.ComStatus(count) IsNot Nothing Then
        '                        Kernel.ChangeStyle(Kernel.ComStatus(count), "LabelWithContent2.0_Green")
        '                    End If
        '                End If
        '            End If

        '            ErrFlagPre(count) = ErrFlag(count)
        '        End If
        '    End If
        'Next

        '' calculate and display digital data
        'For count3 As Integer = 0 To Kernel.LogicalItemArray.GetLength(0) - 1
        '    Dim UnknownFlag As Integer = -1

        '    For count2 As Integer = 0 To Kernel.LogicalItemArray(count3).BitItemArray.GetLength(0) - 1
        '        If ErrFlag(Kernel.LogicalItemArray(count3).BitItemArray(count2).BitArrayId.DeviceId) = 1 Then
        '            UnknownFlag = 1
        '            Exit For
        '        Else
        '            Kernel.LogicalItemArray(count3).BitItemArray(count2).Value = Kernel.DeviceArray(Kernel.LogicalItemArray(count3).BitItemArray(count2).BitArrayId.DeviceId).SixteenBitsGetArray(Kernel.LogicalItemArray(count3).BitItemArray(count2).BitArrayId.SixteenBitsGetID).BitGetArray(Kernel.LogicalItemArray(count3).BitItemArray(count2).BitArrayId.BitGetID).Value
        '        End If
        '    Next

        '    If UnknownFlag = 1 Then
        '        For count4 As Integer = 0 To Kernel.LogicalItemArray(count3).BitItemArray.GetLength(0) - 1
        '            Kernel.LogicalItemArray(count3).BitItemArray(count4).Value = -1
        '        Next
        '    End If

        '    Kernel.LogicalItemArray(count3).Show()
        'Next

        '' calculate and display analog data
        'For count3 As Integer = 0 To Kernel.RealDataArray.GetLength(0) - 1
        '    Dim ItemProfileArray() As Double = New Double(Kernel.RealDataArray(count3).Calculation.ItemProfileArray.GetLength(0) - 1) {}
        '    Dim UnknownFlag As Integer = -1

        '    For count2 As Integer = 0 To ArgumentArray.GetLength(0) - 1
        '        If Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).Type = "WordGet" Then
        '            If ErrFlag(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).DeviceId) = 1 Then
        '                UnknownFlag = 1
        '                Exit For
        '            Else
        '                ItemProfileArray(count2) = Kernel.DeviceArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).DeviceId).WordGetArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).Id).Value
        '            End If
        '        ElseIf Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).Type = "RealData" Then
        '            ItemProfileArray(count2) = Kernel.RealDataArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).Id).CalData
        '        Else
        '            MessageBox.Show("Illeagal Value or RealDataArray(" + "count3" + ").Calculation.Argument(" + "count2" + ").Type: " + Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).Type)
        '        End If
        '    Next

        '    If UnknownFlag = 1 Then
        '        Kernel.RealDataArray(count3).CalData = Kernel.RealDataArray(count3).CalDataUnknown
        '    Else
        '        Kernel.RealDataArray(count3).Calc(ItemProfileArray)
        '    End If

        '    Kernel.RealDataArray(count3).Show()
        'Next
    End Sub

    ' check data consistency and data range
    Public Function DataCheck() As Integer
        Dim ErrorMessage As String = ""

        Dim RecoveryMessageTotal As String = ""
        Dim RecoveryMessage As String = ""

        Dim PreAlarmStatus As Integer

        Dim NewErrorOccured As Integer = 0
        Dim NewRecoveryOccured As Integer = 0

        ' Check if value is more than upper limit.
        For count As Integer = 0 To Kernel.RealDataArray.Count - 1
            For count2 As Integer = 0 To Kernel.RealDataArray(count).UpperLimitItemArray.Count - 1
                PreAlarmStatus = Kernel.RealDataArray(count).UpperLimitItemArray(count2).Status

                If (PreAlarmStatus = 0 Or PreAlarmStatus = -1) And Kernel.RealDataArray(count).CalData > Kernel.RealDataArray(count).UpperLimitItemArray(count2).LimitValue Then
                    NewErrorOccured = 1
                    If Kernel.RealDataArray(count).UpperLimitItemArray(count2).AlarmFlag = 1 Then
                        ErrorMessage = "Range over: " + Kernel.RealDataArray(count).Name + " " + Kernel.RealDataArray(count).UpperLimitItemArray(count2).Name
                        DirectCast(Kernel.WindowHashTable("LOGMSG"), LOGMSG).AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[DataAcquisitionAsync.DataCheck] " + ErrorMessage, True)
                    End If

                    If Kernel.MailSendFlag = 1 And Kernel.RealDataArray(count).UpperLimitItemArray(count2).MailFlag = 1 Then
                        ErrorMessage = "Range over: " + Kernel.RealDataArray(count).Name + " " + Kernel.RealDataArray(count).UpperLimitItemArray(count2).Name
                        ErrorMessageTotal = ErrorMessageTotal + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss ") + ErrorMessage + vbCrLf
                    End If

                    Kernel.RealDataArray(count).UpperLimitItemArray(count2).Status = 1
                ElseIf PreAlarmStatus = 1 And Kernel.RealDataArray(count).CalData < Kernel.RealDataArray(count).UpperLimitItemArray(count2).RecoveryValue Then
                    NewRecoveryOccured = 1
                    If Kernel.RealDataArray(count).UpperLimitItemArray(count2).AlarmFlag = 1 Then
                        RecoveryMessage = "Range recovery: " + Kernel.RealDataArray(count).Name + " " + Kernel.RealDataArray(count).UpperLimitItemArray(count2).Name
                        DirectCast(Kernel.WindowHashTable("LOGMSG"), LOGMSG).AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[DataAcquisitionAsync.DataCheck] " + RecoveryMessage, True)
                    End If

                    If Kernel.MailSendFlag = 1 And Kernel.RealDataArray(count).UpperLimitItemArray(count2).MailFlag = 1 Then
                        RecoveryMessage = "Range recovery: " + Kernel.RealDataArray(count).Name + " " + Kernel.RealDataArray(count).UpperLimitItemArray(count2).Name
                        RecoveryMessageTotal = RecoveryMessageTotal + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss ") + RecoveryMessage + vbCrLf
                    End If

                    Kernel.RealDataArray(count).UpperLimitItemArray(count2).Status = 0
                ElseIf PreAlarmStatus = -1 And Kernel.RealDataArray(count).CalData <= Kernel.RealDataArray(count).UpperLimitItemArray(count2).RecoveryValue Then
                    Kernel.RealDataArray(count).UpperLimitItemArray(count2).Status = 0
                End If
            Next

            ' Check if value is lesser than lower limit.
            For count2 As Integer = 0 To Kernel.RealDataArray(count).LowerLimitItemArray.Count - 1
                PreAlarmStatus = Kernel.RealDataArray(count).LowerLimitItemArray(count2).Status

                If (PreAlarmStatus = 0 Or PreAlarmStatus = -1) And Kernel.RealDataArray(count).CalData < Kernel.RealDataArray(count).LowerLimitItemArray(count2).LimitValue Then
                    NewErrorOccured = 1
                    If Kernel.RealDataArray(count).LowerLimitItemArray(count2).AlarmFlag = 1 Then
                        ErrorMessage = "Range over: " + Kernel.RealDataArray(count).Name + " " + Kernel.RealDataArray(count).LowerLimitItemArray(count2).Name
                        DirectCast(Kernel.WindowHashTable("LOGMSG"), LOGMSG).AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[DataAcquisitionAsync.DataCheck] " + ErrorMessage, True)
                    End If

                    If Kernel.MailSendFlag = 1 And Kernel.RealDataArray(count).LowerLimitItemArray(count2).MailFlag = 1 Then
                        ErrorMessage = "Range over: " + Kernel.RealDataArray(count).Name + " " + Kernel.RealDataArray(count).LowerLimitItemArray(count2).Name
                        ErrorMessageTotal = ErrorMessageTotal + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss ") + ErrorMessage + vbCrLf
                    End If

                    Kernel.RealDataArray(count).LowerLimitItemArray(count2).Status = 1
                ElseIf PreAlarmStatus = 1 And Kernel.RealDataArray(count).CalData >= Kernel.RealDataArray(count).LowerLimitItemArray(count2).RecoveryValue Then
                    NewRecoveryOccured = 1
                    If Kernel.RealDataArray(count).LowerLimitItemArray(count2).AlarmFlag = 1 Then
                        RecoveryMessage = "Range recovery: " + Kernel.RealDataArray(count).Name + " " + Kernel.RealDataArray(count).LowerLimitItemArray(count2).Name
                        DirectCast(Kernel.WindowHashTable("LOGMSG"), LOGMSG).AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[DataAcquisitionAsync.DataCheck] " + RecoveryMessage, True)
                    End If

                    If Kernel.MailSendFlag = 1 And Kernel.RealDataArray(count).LowerLimitItemArray(count2).MailFlag = 1 Then
                        RecoveryMessage = "Range recovery: " + Kernel.RealDataArray(count).Name + " " + Kernel.RealDataArray(count).LowerLimitItemArray(count2).Name
                        RecoveryMessageTotal = RecoveryMessageTotal + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss ") + RecoveryMessage + vbCrLf
                    End If

                    'Kernel.RealDataArray(count).LowerLimitItemArray(count2).Status = 0
                ElseIf PreAlarmStatus = -1 And Kernel.RealDataArray(count).CalData > Kernel.RealDataArray(count).LowerLimitItemArray(count2).RecoveryValue Then
                    Kernel.RealDataArray(count).LowerLimitItemArray(count2).Status = 0
                End If
            Next
        Next

        For count As Integer = 0 To Kernel.LogicalItemArray.Count - 1
            If Kernel.LogicalItemArray(count).CurrentStatusId <> LogicalItemPreStatusArray(count) Then
                NewErrorOccured = 1
                If Kernel.LogicalItemArray(count).StateArray(Kernel.LogicalItemArray(count).CurrentStatusId).AlarmFlag = 1 Then
                    ErrorMessage = "Status error: " + Kernel.LogicalItemArray(count).Name + " " + Kernel.LogicalItemArray(count).StateArray(Kernel.LogicalItemArray(count).CurrentStatusId).Name
                    DirectCast(Kernel.WindowHashTable("LOGMSG"), LOGMSG).AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[DataAcquisitionAsync.DataCheck] " + ErrorMessage, True)
                End If

                If Kernel.MailSendFlag = 1 And Kernel.LogicalItemArray(count).StateArray(Kernel.LogicalItemArray(count).CurrentStatusId).MailFlag = 1 Then
                    ErrorMessage = "Status error: " + Kernel.LogicalItemArray(count).Name + " " + Kernel.LogicalItemArray(count).StateArray(Kernel.LogicalItemArray(count).CurrentStatusId).Name
                    ErrorMessageTotal = ErrorMessageTotal + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss ") + ErrorMessage + vbCrLf
                End If
                LogicalItemPreStatusArray(count) = Kernel.LogicalItemArray(count).CurrentStatusId
            End If
        Next

        If Kernel.MailSendFlag = 1 And NewErrorOccured = 1 And Not ErrorMessageTotal.Equals("") Then
            Kernel.SMTPmail.SendMail("hidekilg@gmail.com", MailToArray, Nothing, Nothing, "Error occured", ErrorMessageTotal)
            If Kernel.MailDestinationArray(0).ReminderEnabled = 1 Then
                Kernel.em.MailReminderCurrentCount = Kernel.em.MailReminderEventCount
            Else
                ErrorMessageTotal = ""
            End If
        End If

        If Kernel.MailSendFlag = 1 And NewRecoveryOccured = 1 And Not RecoveryMessageTotal.Equals("") Then
            Kernel.SMTPmail.SendMail("hidekilg@gmail.com", MailToArray, Nothing, Nothing, "Error recovered", RecoveryMessageTotal)
        End If
        Return 0
    End Function

    Sub MailReminder()
        Kernel.SMTPmail.SendMail("hidekilg@gmail.com", MailToArray, Nothing, Nothing, "Error occured (reminder)", ErrorMessageTotal)
        ErrorMessageTotal = ""
    End Sub
End Class
