﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Threading
Imports System.Net

Public Class PlantInterface
    Inherits Device

    Public BinaryTcpServerIn As BinaryTcpServerIn
    Dim Kernel As Kernel
    Dim err As String = ""

    Dim Portno As Integer
    Dim MaxClientNo As Integer

    Public Overrides Function GetError() As String
        GetError = err
    End Function


    Sub New(ByVal Kernel As Kernel, ByVal Q_Device As System.Xml.Linq.XElement)
        Me.Kernel = Kernel
        Resource = New Object

        DeviceName = Q_Device.@Name
        DeviceType = Q_Device.@Type

        ActiveFlag = CInt(Q_Device.@ActiveFlag)

        Portno = CInt(Q_Device.<Protocol>.<Portno>.Value)
        MaxClientNo = CInt(Q_Device.<Protocol>.<MaxClientNo>.Value)

        BinaryTcpServerIn = New BinaryTcpServerIn(Kernel, Portno, MaxClientNo)

        AddHandler BinaryTcpServerIn.Connected, AddressOf OnConnected               ' register Connected event
        AddHandler BinaryTcpServerIn.BinaryReceived, AddressOf OnBinaryReceived     ' register BinaryReceived event
        AddHandler BinaryTcpServerIn.Disconnected, AddressOf OnDisconnected         ' register Disconnected event

        '' WordGet list
        '<WordGetArray>
        Dim Q_WordGet As IEnumerable(Of XElement) = From i In Q_Device.<WordGetArray>.<WordGet> Select i
        WordGetArray = New WordGet(Q_WordGet.Count - 1) {}

        For count2 As Integer = 0 To Q_WordGet.Count - 1
            Dim Type As String = Q_WordGet(count2).@Type
            Dim Address As UInt32 = CUInt(Q_WordGet(count2).@Address)
            Dim Name As String = Q_WordGet(count2).@Name
            Dim Tag As String = Q_WordGet(count2).@Tag
            WordGetArray(count2) = New WordGet(Name, Tag, Type, Address)

            Try
                WordGetArrayHt.Add(Tag, count2)
            Catch ArgumentException As Exception
                MessageBox.Show("[PlantInterface.New] Tag= " + Tag + " is duplicated in <WordGetArray>!")
                End
            End Try
        Next

        '' 16BitGet list
        '<SixteenBitsGetArray>
        Dim Q_SixteenBitsGet As IEnumerable(Of XElement) = From i In Q_Device.<SixteenBitsGetArray>.<SixteenBitsGet> Select i
        SixteenBitsGetArray = New SixteenBitsGet(Q_SixteenBitsGet.Count - 1) {}

        For count2 As Integer = 0 To Q_SixteenBitsGet.Count - 1
            Dim Type As String = Q_SixteenBitsGet(count2).@Type
            Dim Address As UInt32 = CUInt(Q_SixteenBitsGet(count2).@Address)

            Dim Q_BitGet As IEnumerable(Of XElement) = From i In Q_SixteenBitsGet(count2).<BitGet> Select i
            Dim BitGetArray() As BitGet = New BitGet(Q_BitGet.Count - 1) {}

            For count3 As Integer = 0 To Q_BitGet.Count - 1
                Dim BitNum As Integer = CInt(Q_BitGet(count3).@BitNum)
                Dim Name As String = Q_BitGet(count3).@Name
                Dim Tag As String = Q_BitGet(count3).@Tag
                BitGetArray(count3) = New BitGet(BitNum, Name, Tag)

                Try
                    SixteenBitsGetArrayHt.Add(Tag, count2)
                Catch ArgumentException As Exception
                    MessageBox.Show("[PlantInterface.New] Tag= " + Tag + " is duplicated in <SixteenBitsGetArray>!")
                    End
                End Try

                Try
                    BitGetArrayHt.Add(Tag, count3)
                Catch ArgumentException As Exception
                    MessageBox.Show("[PlantInterface.New] Tag= " + Tag + " is duplicated in <BitGetArray>!")
                    End
                End Try
            Next

            SixteenBitsGetArray(count2) = New SixteenBitsGet(Type, Address, BitGetArray)
        Next

        'If ActiveFlag = 1 Then
        '    If Conn.Connect() = 0 Then
        '        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + "[BinaryTcpSync.New] Connected! (" + DeviceName + ")", True)
        '    Else
        '        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + "[BinaryTcpSync.New] Connection failed... (" + DeviceName + ")", True)
        '    End If
        'End If
    End Sub


    Public Overrides Function DoQuery() As Integer
        Return 0
    End Function

    'event handler for BinaryReceived event
    Private Sub OnBinaryReceived(ByVal sender As TcpServerAsync, ByVal ConnId As Integer, ByVal data() As Byte, ByVal BytesReceived As Integer)
        Dim RecvLengthHeader As Integer
        Dim Int32Value As Int32

        'Dim RecvLengthWish As Integer = 162
        Dim RecvLengthWish As Integer = 156

        'AddText("Recv: " + ConnId.ToString + ": " + MakeDispData(data, BytesReceived))

        Try
            If BytesReceived <> RecvLengthWish Then         ' received data length error
                Kernel.AddMsg("[PlantInterface.OnBinaryReceived] RecvLengthError! " + ConnId.ToString(), True)
            Else
                RecvLengthHeader = data(0) * 256 + data(1)  ' data length in message
                If RecvLengthHeader <> RecvLengthWish Then
                    Kernel.AddMsg("[PlantInterface.OnBinaryReceived] RecvLengthError(Message)! " + ConnId.ToString(), True)
                Else
                    If data(2) <> &H1 Then                  ' check command
                        Kernel.AddMsg("[PlantInterface.OnBinaryReceived] RecvCommandError! " + ConnId.ToString(), True)
                    Else
                        If data(3) <> &H0 Then              ' check result code
                            Kernel.AddMsg("[PlantInterface.OnBinaryReceived] ResultCodeError! " + ConnId.ToString(), True)
                        Else
                            LastAcquisitionTime = System.DateTime.Now   ' save data acquisition time 

                            ' analog data
                            For count As Integer = 0 To WordGetArray.GetLength(0) - 1
                                Int32Value = data(4 + 2 * count) * 256 + data(4 + 2 * count + 1)
                                'If Int32Value >= 32768 Then
                                '    Int32Value = Int32Value - 65536
                                'End If
                                If Int32Value >= 32768 Then
                                    Int32Value = 0
                                End If

                                WordGetArray(count).Value = Int32Value
                            Next

                            For count As Integer = 0 To SixteenBitsGetArray.GetLength(0) - 1
                                Int32Value = data(4 + 2 * WordGetArray.GetLength(0) + 2 * count) * 256 + data(4 + 2 * WordGetArray.GetLength(0) + 2 * count + 1)
                                'If Int32Value >= 32768 Then
                                '    Int32Value = Int32Value - 65536
                                'End If
                                'If Int32Value >= 32768 Then
                                '    Int32Value = 0
                                'End If

                                SixteenBitsGetArray(count).Value = Int32Value

                                For count2 As Integer = 0 To 15
                                    If (Int32Value And CType(2 ^ count2, Long)) = 0 Then
                                        SixteenBitsGetArray(count).ValueArray(count2) = 0
                                    Else
                                        SixteenBitsGetArray(count).ValueArray(count2) = 1
                                    End If
                                Next

                                For count2 As Integer = 0 To SixteenBitsGetArray(count).BitGetArray.GetLength(0) - 1
                                    SixteenBitsGetArray(count).BitGetArray(count2).Value = SixteenBitsGetArray(count).ValueArray(SixteenBitsGetArray(count).BitGetArray(count2).BitNum)
                                Next
                            Next

                            Dim trd1 As Thread = New Thread(AddressOf Kernel.em.Archive)
                            trd1.IsBackground = True
                            trd1.Start()
                        End If
                    End If
                End If
            End If
        Catch ex As Exception
            err = ex.Message
            Kernel.AddMsg("[PlantInterface.OnBinaryReceived] ResultCodeError! " + ConnId.ToString(), True)
        End Try
    End Sub

    ' event hundler for Connected event
    Private Sub OnConnected(ByVal sender As TcpServerAsync, ByVal ConnId As Integer)
        'Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + "[PlantInterface.OnConnected] Connected! (" + ConnId.ToString() + ")", True)
    End Sub

    ' event handler for Disconnected event
    Private Sub OnDisconnected(ByVal sender As TcpServerAsync, ByVal ConnId As Integer)
        'Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + "[PlantInterface.OnDisconnected] Disconnected! (" + ConnId.ToString() + ")", True)
    End Sub

End Class

