﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Net
Imports System.Net.Sockets
Imports System.Text
Imports System

''' <summary>
''' Udp peer for sync communication
''' </summary>
''' <remarks></remarks>
Public Class UdpTermSync
    Private err As String = ""

    Private Session As UdpClient
    Private SessionThread As Threading.Thread

    Private ReceivePort As Integer      ' Receive port
    Private SendIPAddress As IPAddress  ' Destination IP address
    Private SendPort As Integer         ' Send port
    Private IPEP As IPEndPoint

    ''' <summary>
    ''' Constructor
    ''' </summary>
    ''' <param name="SendIPAddress"></param>
    ''' <param name="SendPort"></param>
    ''' <param name="ReceivePort"></param>
    ''' <remarks></remarks>
    Sub New(ByVal SendIPAddress As IPAddress, ByVal SendPort As Integer, ByVal ReceivePort As Integer)
        Me.ReceivePort = ReceivePort
        IPEP = New IPEndPoint(SendIPAddress, SendPort)  ' Create UDP session
    End Sub

    ''' <summary>
    ''' Get error details
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetError() As String
        Dim ret As String = err
        err = ""
        GetError = ret
    End Function

    ''' <summary>
    ''' Fix the remote host
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Connect() As Integer
        Try
            Session = New UdpClient(ReceivePort)
            Session.Client.ReceiveTimeout = 5000
            Session.Connect(IPEP)  ' Fix the remote host

            Connect = 0
        Catch ex As Exception
            Connect = -1
        End Try
    End Function

    ''' <summary>
    ''' Send ASCII data
    ''' </summary>
    ''' <param name="SendData"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Send(ByVal SendData As String) As Integer
        Try
            Dim sendBytes As Byte() = Encoding.ASCII.GetBytes(SendData)   ' Send data
            Session.Send(sendBytes, sendBytes.Length)

            Send = 0
        Catch ex As System.IO.IOException
            err = "IOException"
            Send = -1
        Catch ex As Exception
            err = "Exception"
            Send = -1
        End Try
    End Function

    ''' <summary>
    ''' Send binary data
    ''' </summary>
    ''' <param name="SendData"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Send(ByVal SendData() As Byte) As Integer
        Try
            Session.Send(SendData, SendData.GetLength(0))

            Send = 0
        Catch ex As System.IO.IOException
            err = "IOException"
            Send = -1
        Catch ex As Exception
            err = "Exception"
            Send = -1
        End Try
    End Function

    ''' <summary>
    ''' Receive ASCII data
    ''' </summary>
    ''' <param name="RecvData"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function RecvAscii(ByRef RecvData As String) As Integer
        Try
            Dim RecvDataByt As Byte() = Session.Receive(IPEP)
            RecvData = Encoding.ASCII.GetString(RecvDataByt)

            Return 0
        Catch ex As TimeoutException
            err = "TIMEOUT"
            Return -1
        Catch ex As Exception
            err = "RecvErr"
            Return -1
        End Try
    End Function

    ''' <summary>
    '''  Receive Binary data
    ''' </summary>
    ''' <param name="RecvDataRet"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function RecvBinary(ByRef RecvDataRet() As Byte) As Integer
        Dim RecvLength As Integer = 0

        Try
            Dim RecvData As Byte() = Session.Receive(IPEP)

            ReDim RecvDataRet(RecvData.GetLength(0) - 1)
            System.Array.Copy(RecvData, RecvDataRet, RecvDataRet.GetLength(0))

            Return 0
        Catch ex As TimeoutException
            err = "TIMEOUT"
            Return -1
        Catch ex As Exception
            err = "RecvErr"
            Return -1
        End Try
    End Function

    ''' <summary>
    ''' Finish UDP communication with fixed remote host
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function CloseSocket() As Integer
        Try
            Session.Close()

            CloseSocket = 0
        Catch ex As Exception
            CloseSocket = -1
        End Try
    End Function
End Class
