﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Net.Mail

''' <summary>
'''  SMTPmail
''' </summary>
''' <remarks></remarks>
Public Class SMTPmail
    Private err As String
    Private sc As New System.Net.Mail.SmtpClient()
    Private Kernel As Kernel

    ''' <summary>
    ''' Get error details
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetError() As String
        GetError = err
    End Function

    ''' <summary>
    ''' Constructor
    ''' </summary>
    ''' <param name="Kernel"></param>
    ''' <param name="ServerName"></param>
    ''' <remarks></remarks>
    Sub New(Kernel As Kernel, ByVal ServerName As String)
        Me.Kernel = Kernel
        sc.Host = ServerName            ' Mail server name
        sc.ServicePoint.MaxIdleTime = 1
    End Sub

    ''' <summary>
    ''' Send mail
    ''' </summary>
    ''' <param name="SendFrom"></param>
    ''' <param name="SendTo"></param>
    ''' <param name="SendCC"></param>
    ''' <param name="SendBCC"></param>
    ''' <param name="Subject"></param>
    ''' <param name="Body"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function SendMail(ByVal SendFrom As String, ByVal SendTo As String(), ByVal SendCC As String(), ByVal SendBCC As String(), ByVal Subject As String, ByVal Body As String) As Integer
        Dim CaptureWindowArray As New ArrayList

        Dim msg As New System.Net.Mail.MailMessage()

        For count As Integer = 0 To Kernel.WindowInfoArray.GetLength(0) - 1
            If Kernel.WindowInfoArray(count).CaptureAttached = 1 Then
                CaptureWindowArray.Add(Kernel.WindowInfoArray(count).Tag)
            End If
        Next

        Dim AttachedFileNameArray() As String = New String(CaptureWindowArray.Count) {}

        msg.From = New System.Net.Mail.MailAddress(SendFrom)            ' From mail address

        For i As Integer = 0 To SendTo.GetLength(0) - 1
            msg.To.Add(New System.Net.Mail.MailAddress(SendTo(i)))      ' To mail address
        Next

        If Not IsNothing(SendCC) Then
            For i As Integer = 0 To SendCC.GetLength(0) - 1
                msg.CC.Add(New System.Net.Mail.MailAddress(SendCC(i)))   ' CC mail address
            Next
        End If

        If Not IsNothing(SendBCC) Then
            For i As Integer = 0 To SendBCC.GetLength(0) - 1
                msg.Bcc.Add(New System.Net.Mail.MailAddress(SendBCC(i))) ' BCC mail address
            Next
        End If

        msg.Subject = Subject                                           ' subject
        msg.Body = Body                                                 ' body

        ' attached file
        If Kernel.MailDestinationArray(0).CaptureAttached = 1 Then
            For count As Integer = 0 To CaptureWindowArray.Count - 1
                AttachedFileNameArray(count) = CStr(CaptureWindowArray.Item(count)) + "_" + System.DateTime.Now.ToString("yyyyMMddHHmmss") + ".png"
                Kernel.CaptureWindow(CStr(CaptureWindowArray.Item(count)), AttachedFileNameArray(count))
                msg.Attachments.Add(New System.Net.Mail.Attachment(".\\Capture\\" + AttachedFileNameArray(count)))
            Next
        End If

        Try
            sc.Send(msg)            ' send email
        Catch ex As SmtpException
            DirectCast(Kernel.WindowHashTable("LOGMSG"), LOGMSG).AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[SMTPmail.SendMain] Sending mail failed.", True)
        End Try

        msg.Dispose()

        ' delete temporary file
        'For count As Integer = 0 To AttachedFileNameArray.GetLength(0) - 1
        'System.IO.File.Delete(AttachedFileNameArray(count))
        'Next

        Return 0
    End Function
End Class
