﻿Option Strict On

Imports System.Net.Sockets
Imports System.Text

Public Class BinaryTcpServerOut
    Private err As String = ""

    Const portno As Integer = 12001           ' listen port
    Dim server As TcpServerAsync
    Private max_client_number As Integer = 10
    Dim kernel As Kernel

    Public Event Connected(ByVal sender As TcpServerAsync, ByVal ConnId As Integer)                             ' Connected event
    Public Event BinaryReceived(ByVal sender As TcpServerAsync, ByVal ConnId As Integer, ByVal Data() As Byte, ByVal BytesRead As Integer) ' BinaryReceived event
    Public Event Disconnected(ByVal sender As TcpServerAsync, ByVal ConnId As Integer)                          ' Disconnected event
    Public Event DataSent(ByVal sender As TcpServerAsync, ByVal ConnId As Integer, ByVal Data() As Byte)        ' DataSent event
    Public Event ErrorOccurred(ByVal sender As BinaryTcpServerOut, Content As String)                           ' ErrorOccured event
    ' TotalMessage = Header + Data
    Dim HeaderBytes As Integer = 2
    Dim CountNumberStart As Integer = 1 ' Start from 1
    Dim CountNumberBytes As Integer = 2
    Dim CountStart As Integer = 1  ' Start from 1, Start position of count number, there can be a charactors after count number.
    Dim CountOrder As Integer = 0

    Sub New(kernel As Kernel)
        Me.kernel = kernel
        server = New TcpServerAsync(portno, max_client_number, HeaderBytes, CountNumberStart, CountNumberBytes, CountStart, CountOrder)

        AddHandler server.Connected, AddressOf OnConnected              ' register server.Connected event handler
        AddHandler server.BinaryReceived, AddressOf OnBinaryReceived    ' register server.BinaryReceived event handler
        AddHandler server.Disconnected, AddressOf OnDisconnected        ' register server.Disconnected event handler
    End Sub

    ' event handler for Connected event
    Private Sub OnConnected(ByVal sender As TcpServerAsync, ByVal ConnId As Integer)
        kernel.AddMsg("[BinaryTcpServerOut.OnConnected] Connected: " + ConnId.ToString(), True)
        RaiseEvent Connected(sender, ConnId) ' Establish Connected event
    End Sub


    ' event handler for BinaryReceived event
    Private Sub OnBinaryReceived(ByVal sender As TcpServerAsync, ByVal ConnId As Integer, ByVal data() As Byte, ByVal BytesReceived As Integer)
        Dim ReplyData() As Byte
        Dim ConnectStatus As Integer
        'Dim UInt16Value As UInt16

        'AddText("Recv: " + ConnId.ToString + ": " + MakeDispData(data, BytesReceived))
        RaiseEvent BinaryReceived(sender, ConnId, data, BytesReceived)                         ' establish BinaryReceived event

        ' reply
        'ChangeText(ToBinary, ConnId.ToString())
        'ChangeText(txtSendBinary, MakeDispData(data, BytesReceived))
        'btnSendBinary_Click(sender, New System.EventArgs)

        ' Test for CocoNumber
        'data(33) = &H1
        'data(34) = &H1
        'data(35) = &H1
        'data(36) = &HA

        'For count As Integer = 0 To 3
        '    data(count + HeaderBytes) = Convert.ToByte(GetText(txtSendBinary).Substring(3 * count, 2), 16)
        'Next


        ' check received byte count(it should be 3bytes)
        If BytesReceived = 3 Then
            ' check command
            If data(2) = &H1 Then   ' data request from connected terminal
                Dim MsgLen As Integer = 4 + 2 * kernel.DeviceArray(0).WordGetArray.GetLength(0) + 2 * (kernel.DeviceArray(0).SixteenBitsGetArray.GetLength(0))
                ReDim ReplyData(MsgLen - 1)

                ReplyData(0) = CByte(MsgLen \ 256)
                ReplyData(1) = CByte(MsgLen Mod 256)
                ReplyData(2) = &H1      ' command

                If kernel.AcquisitionAsyncFlag Then
                    ConnectStatus = DirectCast(kernel.em.DataAcquisitionInst, DataAcquisitionAsync).ConnectStatus
                Else
                    ConnectStatus = DirectCast(kernel.em.DataAcquisitionInst, DataAcquisitionSync).ConnectStatus
                End If

                If ConnectStatus = 1 Then
                    ReplyData(3) = &H0   ' result code
                Else
                    ReplyData(3) = &H2   ' result code
                End If

                ' analog value (2bytex50points)
                For count As Integer = 0 To kernel.DeviceArray(0).WordGetArray.GetLength(0) - 1
                    'UInt16Value = CUShort(kernel.DeviceArray(0).WordGetArray(count).Value)
                    ReplyData(4 + 2 * count) = CByte(kernel.DeviceArray(0).WordGetArray(count).Value \ 256)
                    ReplyData(4 + 2 * count + 1) = CByte(kernel.DeviceArray(0).WordGetArray(count).Value Mod 256)
                Next

                ' digital value (8bit/bytesx60bytes)
                For count As Integer = 0 To kernel.DeviceArray(0).SixteenBitsGetArray.GetLength(0) - 1
                    'UInt16Value = CUShort(kernel.DeviceArray(0).SixteenBitsGetArray(count).Value)
                    ReplyData(4 + 2 * kernel.DeviceArray(0).WordGetArray.GetLength(0) + 2 * count) = CByte(kernel.DeviceArray(0).SixteenBitsGetArray(count).Value \ 256)
                    ReplyData(4 + 2 * kernel.DeviceArray(0).WordGetArray.GetLength(0) + 2 * count + 1) = CByte(kernel.DeviceArray(0).SixteenBitsGetArray(count).Value Mod 256)
                Next

                'ReDim ReplyData(162)
                'ReplyData(0) = CByte(162 \ 256)
                'ReplyData(1) = CByte(162 Mod 256)
                'ReplyData(2) = &H0   ' result code 1/2
                'ReplyData(3) = &H0   ' result code 2/2

                '' analog value (2bytex50points)
                'For count As Integer = 0 To 49
                '    Int16Value = CShort(kernel.DeviceArray(0).WordGetArray(count).Value)
                '    ReplyData(4 + 2 * count) = CByte(kernel.DeviceArray(0).WordGetArray(count).Value \ 256)
                '    ReplyData(4 + 2 * count + 1) = CByte(kernel.DeviceArray(0).WordGetArray(count).Value Mod 256)
                'Next

                '' digital value (8bit/bytesx60bytes)
                'For count As Integer = 0 To 29
                '    Int16Value = CShort(kernel.DeviceArray(0).SixteenBitsGetArray(count).Value)
                '    ReplyData(104 + 2 * count) = CByte(kernel.DeviceArray(0).SixteenBitsGetArray(count).Value \ 256)
                '    ReplyData(104 + 2 * count + 1) = CByte(kernel.DeviceArray(0).SixteenBitsGetArray(count).Value Mod 256)
                'Next

                server.SendDataBINARY(ConnId, ReplyData)
                RaiseEvent DataSent(sender, ConnId, ReplyData)         ' establish DataSent event
            ElseIf data(2) = &H2 Then   ' data request from other control system
                'ReplyData(2) = &H0     ' result code 1/2 
                'ReplyData(3) = &H0     ' result code 2/2
                '' analog value (2bytex50points)
                '' digital value (8bit/bytesx60bytes)
            Else
                RaiseEvent ErrorOccurred(Me, "[BinaryTcpServerOut.OnBinaryReceived] command error")
            End If
        Else
            RaiseEvent ErrorOccurred(Me, "[BinaryTcpServerOut.OnBinaryReceived] recv length error")
        End If
    End Sub

    ' event handler for Disconnected event
    Private Sub OnDisconnected(ByVal sender As TcpServerAsync, ByVal ConnId As Integer)
        kernel.AddMsg("[BinaryTcpServerOut.OnConnected] Disconnected: " + ConnId.ToString(), True)
        RaiseEvent Disconnected(sender, ConnId) ' establish Disconnected event
    End Sub

    Private Function SendData(ConnId As Integer, message() As Byte) As Integer
        Try
            Dim DataCount As Integer = message.GetLength(0) - (CountStart - 1)
            If CountOrder = 0 Then
                For count As Integer = 0 To CountNumberBytes - 2
                    message(CountNumberStart - 1 + count) = Convert.ToByte(DataCount \ CType(256 ^ (CountNumberBytes - count - 1), Long))
                    DataCount = Convert.ToByte(DataCount Mod CType(256 ^ (CountNumberBytes - count - 1), Long))
                Next
                message(CountNumberStart - 1 + CountNumberBytes - 1) = Convert.ToByte(DataCount)
            Else
                For count As Integer = CountNumberBytes - 1 To 1 Step -1
                    message(CountNumberStart - 1 + count) = Convert.ToByte(DataCount \ CType(256 ^ count, Long))
                    DataCount = Convert.ToByte(DataCount Mod CType(256 ^ count, Long))
                Next
                message(CountNumberStart - 1) = Convert.ToByte(DataCount)
            End If

            For count As Integer = 0 To message.GetLength(0) - 1 - 1
                message(count + HeaderBytes) = message(count)
            Next

            server.SendDataBINARY(ConnId, message)

            'AddText("Send: " + ToBinary.Text + ": " + MakeDispData(message, message.GetLength(0)))
        Catch ex As Exception
            'AddText("btnSendBinary_Click: " & ex.Message)
        End Try

        Return -1
    End Function

    Public Function GetError() As String
        Dim ret As String = err
        Err = ""
        GetError = ret
    End Function

    Private Function MakeDispData(ByVal Data As Byte(), ByVal DataLength As Integer) As String
        Dim DispData As String = ""

        For count As Integer = 0 To DataLength - 2
            DispData = DispData + Strings.Right("00" + Hex(Data(count)), 2) + " "
        Next
        DispData = DispData + Strings.Right("00" + Hex(Data(DataLength - 1)), 2)

        Return DispData
    End Function


    'Exitボタン押下
    Public Sub Disconnect()
        server.Close()
    End Sub

End Class
