﻿Option Strict On

Imports System.Net.Sockets
Imports System.Text

Public Class BinaryTcpServerIn
    Private err As String = ""
    Dim server As TcpServerAsync

    Dim Portno As Integer
    Dim MaxClientNo As Integer

    Dim kernel As Kernel

    Public Event Connected(ByVal sender As TcpServerAsync, ByVal ConnId As Integer)                         ' Connected event
    Public Event BinaryReceived(ByVal sender As TcpServerAsync, ByVal ConnId As Integer, ByVal Data() As Byte, ByVal BytesRead As Integer) ' BinaryReceived event
    Public Event Disconnected(ByVal sender As TcpServerAsync, ByVal ConnId As Integer)                      ' Disconnected event
    Public Event ErrorOccurred(ByVal sender As BinaryTcpServerIn, Content As String)                        ' ErrorOccured event

    ' TotalMessage = Header + Data
    Dim HeaderBytes As Integer = 2
    Dim CountNumberStart As Integer = 1 ' Start from 1
    Dim CountNumberBytes As Integer = 2
    Dim CountStart As Integer = 1  ' Start from 1, Start position of count number, there can be a charactors after count number.
    Dim CountOrder As Integer = 0

    Sub New(ByVal Kernel As Kernel, ByVal Portno As Integer, MaxClientNo As Integer)
        Me.kernel = Kernel

        Me.Portno = portno
        Me.MaxClientNo = MaxClientNo

        server = New TcpServerAsync(portno, MaxClientNo, HeaderBytes, CountNumberStart, CountNumberBytes, CountStart, CountOrder)

        AddHandler server.Connected, AddressOf OnConnected              ' add event handler for Connected event
        AddHandler server.BinaryReceived, AddressOf OnBinaryReceived    ' add event handler for BinaryReceived event
        AddHandler server.Disconnected, AddressOf OnDisconnected        ' add event handler for Disconnected event
    End Sub

    ' event handler for Connected event
    Private Sub OnConnected(ByVal sender As TcpServerAsync, ByVal ConnId As Integer)
        RaiseEvent Connected(sender, ConnId)                            ' establish connected event
    End Sub


    ' event handler for BinaryReceived event
    Private Sub OnBinaryReceived(ByVal sender As TcpServerAsync, ByVal ConnId As Integer, ByVal data() As Byte, ByVal BytesReceived As Integer)
        RaiseEvent BinaryReceived(sender, ConnId, data, BytesReceived)  ' establish BinaryReceived event
    End Sub


    ' event handler for Disconnected event
    Private Sub OnDisconnected(ByVal sender As TcpServerAsync, ByVal ConnId As Integer)
        RaiseEvent Disconnected(sender, ConnId)                         ' establish Disconnected event
    End Sub

    Private Function SendData(ConnId As Integer, message() As Byte) As Integer
        Try
            Dim DataCount As Integer = message.GetLength(0) - (CountStart - 1)
            If CountOrder = 0 Then
                For count As Integer = 0 To CountNumberBytes - 2
                    message(CountNumberStart - 1 + count) = Convert.ToByte(DataCount \ CType(256 ^ (CountNumberBytes - count - 1), Long))
                    DataCount = Convert.ToByte(DataCount Mod CType(256 ^ (CountNumberBytes - count - 1), Long))
                Next
                message(CountNumberStart - 1 + CountNumberBytes - 1) = Convert.ToByte(DataCount)
            Else
                For count As Integer = CountNumberBytes - 1 To 1 Step -1
                    message(CountNumberStart - 1 + count) = Convert.ToByte(DataCount \ CType(256 ^ count, Long))
                    DataCount = Convert.ToByte(DataCount Mod CType(256 ^ count, Long))
                Next
                message(CountNumberStart - 1) = Convert.ToByte(DataCount)
            End If

            For count As Integer = 0 To message.GetLength(0) - 1 - 1
                message(count + HeaderBytes) = message(count)
            Next

            server.SendDataBINARY(ConnId, message)

            'AddText("Send: " + ToBinary.Text + ": " + MakeDispData(message, message.GetLength(0)))
        Catch ex As Exception
            'AddText("btnSendBinary_Click: " & ex.Message)
        End Try

        Return -1
    End Function

    Public Function GetError() As String
        Dim ret As String = err
        err = ""
        GetError = ret
    End Function

    Private Function MakeDispData(ByVal Data As Byte(), ByVal DataLength As Integer) As String
        Dim DispData As String = ""

        For count As Integer = 0 To DataLength - 2
            DispData = DispData + Strings.Right("00" + Hex(Data(count)), 2) + " "
        Next
        DispData = DispData + Strings.Right("00" + Hex(Data(DataLength - 1)), 2)

        Return DispData
    End Function


    'Exitボタン押下
    Public Sub Disconnect()
        server.Close()
    End Sub

End Class
