﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System
Imports ZedGraph
Imports System.Drawing
Imports System.Windows.Controls
Imports System.IO
Imports System.Windows.Forms

Public Class TrendGraph
    Dim LogByGroup As Boolean
    Dim DataItemIndexArray(,) As Integer
    Dim CheckedItemCountArray() As Integer

    Dim ItemNameArray() As String
    Dim TagNameArray() As String
    Dim CurveCount As Integer
    Dim ColorArray() As Color
    Dim list() As PointPairList
    Dim myPane As GraphPane
    Dim cyclemsec As Integer = 1000
    Dim DataLifemsec As Integer
    Dim count As Integer = 0    ' テストデータ生成用
    Dim SetGraph2 As SetGraph
    Dim Kernel As Kernel
    Dim myCurve() As LineItem
    Dim Ymax As Double
    Dim Ymin As Double

    Dim PointAddFlg() As Boolean = {True, True, True, True, True, True, True, True, True, True}
    Dim PointValue() As Double = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    Dim YdiffThreshold As Double
    Dim RefreshRatemsec As Integer
    Dim position As Integer
    Dim LogScaleFlag As Boolean

    Private RefreshWaitCount As Integer = 0

    Dim LabelControlArray() As System.Windows.Forms.Label

    Dim monitor() As System.Windows.Forms.Screen = System.Windows.Forms.Screen.AllScreens()


    Sub New(ByVal position As Integer, ByVal Title As String, ByRef Kernel As Kernel, ByVal DataItemIndexArray(,) As Integer, ByVal CheckedItemCountArray() As Integer, ByVal ColorArray() As Color, ByVal LogScaleFlag As Boolean, ByVal Ymin As Double, ByVal Ymax As Double, ByVal DataLifemsec As Integer, ByVal YdiffThreshold As Double, ByVal RefreshRatemsec As Integer)
        ' この呼び出しは、Windows フォーム デザイナで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        Me.position = position
        Me.LogScaleFlag = LogScaleFlag

        LogByGroup = True

        Me.Text = Title
        LabelControlArray = New System.Windows.Forms.Label() {Label1, Label2, Label3, Label4, Label5, Label6, Label7, Label8, Label9, Label10}

        Me.Kernel = Kernel

        ReDim Me.DataItemIndexArray(DataItemIndexArray.GetLength(0) - 1, DataItemIndexArray.GetLength(1) - 1)
        For count As Integer = 0 To DataItemIndexArray.GetLength(0) - 1
            For count2 As Integer = 0 To DataItemIndexArray.GetLength(1) - 1
                Me.DataItemIndexArray(count, count2) = DataItemIndexArray(count, count2)
            Next

            CurveCount += CheckedItemCountArray(count)
        Next

        ReDim Me.CheckedItemCountArray(CheckedItemCountArray.GetLength(0) - 1)
        System.Array.Copy(CheckedItemCountArray, Me.CheckedItemCountArray, CheckedItemCountArray.GetLength(0))

        ReDim Me.ColorArray(ColorArray.GetLength(0) - 1)
        System.Array.Copy(ColorArray, Me.ColorArray, ColorArray.GetLength(0))

        ReDim list(CurveCount - 1)
        For count As Integer = 0 To CurveCount - 1
            list(count) = New PointPairList
        Next

        ReDim myCurve(CurveCount - 1)

        Me.YdiffThreshold = YdiffThreshold
        Me.RefreshRatemsec = RefreshRatemsec

        Me.DataLifemsec = DataLifemsec
        Me.Ymax = Ymax
        Me.Ymin = Ymin
    End Sub



    Sub New(ByVal position As Integer, ByVal Title As String, ByRef Kernel As Kernel, ByVal ItemNameArray() As String, ByVal TagNameArray() As String, ByVal ColorArray() As Color, ByVal LogScaleFlag As Boolean, ByVal Ymin As Double, ByVal Ymax As Double, ByVal DataLifemsec As Integer, ByVal YdiffThreshold As Double, ByVal RefreshRatemsec As Integer)
        ' この呼び出しは、Windows フォーム デザイナで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        Me.position = position
        Me.LogScaleFlag = LogScaleFlag

        LogByGroup = False

        Me.Text = Title
        LabelControlArray = New System.Windows.Forms.Label() {Label1, Label2, Label3, Label4, Label5, Label6, Label7, Label8, Label9, Label10}

        For count As Integer = 0 To CurveCount - 1
            list(count) = New PointPairList()
        Next

        Me.Kernel = Kernel

        ReDim Me.ItemNameArray(ItemNameArray.GetLength(0) - 1)
        System.Array.Copy(ItemNameArray, Me.ItemNameArray, ItemNameArray.GetLength(0))

        ReDim Me.TagNameArray(TagNameArray.GetLength(0) - 1)
        System.Array.Copy(TagNameArray, Me.TagNameArray, TagNameArray.GetLength(0))
        CurveCount = TagNameArray.GetLength(0)

        ReDim Me.ColorArray(ColorArray.GetLength(0) - 1)
        System.Array.Copy(ColorArray, Me.ColorArray, ColorArray.GetLength(0))

        ReDim list(CurveCount - 1)
        For count As Integer = 0 To CurveCount - 1
            list(count) = New PointPairList
        Next

        ReDim myCurve(CurveCount - 1)

        Me.YdiffThreshold = YdiffThreshold
        Me.RefreshRatemsec = RefreshRatemsec

        Me.DataLifemsec = DataLifemsec
        Me.Ymax = Ymax
        Me.Ymin = Ymin
    End Sub

    Public Sub CreateChart()
        myPane = zg1.GraphPane
        myPane.Title.IsVisible = False       ' タイトル設定

        'Dim myRect As System.Drawing.RectangleF = myPane.Rect
        'myRect.Height = myRect.Height - 20
        'myPane.Rect = myRect
        'zg1.Height = Me.ClientRectangle.Height - 10
        'zg1.Height = Me.ClientRectangle.Height * (1 - 25 / Me.ClientRectangle.Height)

        myPane.Border.IsVisible = False
        myPane.Chart.Border.Color = Color.White
        'myPane.Fill = New Fill(Color.FromArgb(20, 5, 30))
        'myPane.Chart.Fill = New Fill(Color.FromArgb(20, 5, 30))

        myPane.Fill = New Fill(Me.BackColor)
        myPane.Chart.Fill = New Fill(Me.BackColor)
        '#FFAAAAEE

        myPane.XAxis.Title.IsVisible = False
        myPane.XAxis.Scale.Format = "HH:mm:ss"
        myPane.XAxis.Type = AxisType.Date          ' X軸をDate形式に設定
        myPane.XAxis.Scale.Min = New XDate(DateTime.Now.AddMilliseconds(-DataLifemsec))                    ' レンジの設定(最小)
        myPane.XAxis.Scale.Max = New XDate(DateTime.Now)                          ' レンジの設定(最大)
        myPane.XAxis.Scale.FontSpec.FontColor = Color.White
        myPane.XAxis.Color = Color.White
        myPane.XAxis.MajorGrid.IsVisible = True    ' X軸グリッド表示
        myPane.XAxis.MajorGrid.Color = Color.White
        myPane.XAxis.MinorGrid.Color = Color.White
        myPane.XAxis.Scale.FontSpec.Size = 20

        myPane.YAxis.Title.IsVisible = False             ' Y軸ラベル設定
        myPane.YAxis.Scale.FontSpec.FontColor = Color.White
        myPane.YAxis.Color = Color.White
        myPane.YAxis.MajorGrid.IsVisible = True   ' Y軸グリッド表示
        myPane.YAxis.MajorGrid.Color = Color.White
        myPane.YAxis.MinorGrid.Color = Color.White
        myPane.YAxis.Scale.FontSpec.Size = 20

        myPane.YAxis.Scale.Min = Ymin
        myPane.YAxis.Scale.Max = Ymax

        If Ymin = Ymax Then
            myPane.YAxis.Scale.MinAuto = True
            myPane.YAxis.Scale.MaxAuto = True
        Else
            myPane.YAxis.Scale.MinAuto = False
            myPane.YAxis.Scale.MaxAuto = False
        End If

        myPane.Legend.Fill = New Fill(Color.FromArgb(45, 30, 30))
        myPane.Legend.FontSpec.Size = 14
        myPane.Legend.FontSpec.FontColor = Color.White

        For count As Integer = 0 To list.GetLength(0) - 1
            list(count).Clear()
        Next
    End Sub

    Private Sub TrendGraph_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
        'ControlObject.GRAPHITEMLIST.WinExistFlag(position) = 0
    End Sub

    Private Sub TrendGraph_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim num As Integer = 0

        Dim TypeIndex As Integer

        If monitor.Length = 1 Then
            Me.Left = monitor(0).WorkingArea.X + (position \ 3) * 640
            Me.Top = (position Mod 3) * 330
        ElseIf monitor.Length = 2 Then
            Me.Left = monitor(1).WorkingArea.X + (position \ 3) * 640
            Me.Top = (position Mod 3) * 330
        End If

        CreateChart()
        'SetGraph2 = New SetGraph2(5, -7, Ymax, Ymin, 300000, 0.05, 1)
        SetGraph2 = New SetGraph(Ymax, Ymin, DataLifemsec, YdiffThreshold, RefreshRatemsec)

        ReadHistory()

        If LogByGroup = True Then
            For count As Integer = 0 To DataItemIndexArray.GetLength(0) - 1
                If CheckedItemCountArray(count) > 0 Then
                    For count2 As Integer = 0 To CheckedItemCountArray(count) - 1
                        TypeIndex = Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, count2)).TypeIndex
                        If TypeIndex = 0 Then   'WordGet
                            myCurve(num) = myPane.AddCurve(Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, count2)).DeviceIndex).WordGetArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, count2)).TagIndex).Name, list(num), ColorArray(num), SymbolType.None)
                        ElseIf TypeIndex = 1 Then   'BitGet
                            myCurve(num) = myPane.AddCurve(Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, count2)).DeviceIndex).SixteenBitsGetArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, count2)).TagIndex).BitGetArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, count2)).TagIndex2).Name, list(num), ColorArray(num), SymbolType.None)
                        ElseIf TypeIndex = 2 Then   'RealData
                            myCurve(num) = myPane.AddCurve(Kernel.RealDataArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, count2)).TagIndex).Name, list(num), ColorArray(num), SymbolType.None)
                        ElseIf TypeIndex = 3 Then   'LogicalItem
                            myCurve(num) = myPane.AddCurve(Kernel.LogicalItemArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, count2)).TagIndex).Name, list(num), ColorArray(num), SymbolType.None)
                        End If

                        num += 1
                    Next
                End If
            Next
        Else
            For count As Integer = 0 To CurveCount - 1
                myCurve(0) = myPane.AddCurve(ItemNameArray(count), list(count), ColorArray(count), SymbolType.None)
				myCurve(0).Line.Width = 1
                ''myCurve(0) = myPane.AddCurve(TagNameArray(i), list(i), ColorArray(i), SymbolType.None)
            Next
        End If

        zg1.AxisChange()                      ' 軸スケール計算
        zg1.Invalidate()                    ' グラフの再描画完了を認識

        Timer1.Interval = cyclemsec
        Timer1.Enabled = True
    End Sub

    Private Sub ReadHistory()
        ' テストデータ作成
        Dim i As Integer = -DataLifemsec
        Dim j As Integer
        Dim x As Double
        Dim WordArray(Kernel.RealDataArray.GetLength(0) - 1) As String
        Dim y(CurveCount - 1) As Double
        Dim num As Integer = 0

        Dim strLine As String
        Dim FileName As String
        Dim fs As FileStream

        Dim ReadCount As Integer = 0
        Dim SkipCount As Integer = Convert.ToInt16((DataLifemsec - 1) / 43200000)

        If Kernel.LogSettingType = 2 Then
            For count As Integer = 0 To DataItemIndexArray.GetLength(0) - 1
                If CheckedItemCountArray(count) > 0 Then
                    ' Read historical data(read from 1 day previous data)
                    For i = -1 * (Convert.ToInt16((DataLifemsec - 1) / 86400000)) To 0
                        FileName = System.IO.Path.Combine(Kernel.DataLogFolderArray(0), Kernel.DataGroupArray(count).Name + "_PlantTerm_" + System.DateTime.Now.AddMilliseconds(86400000 * i).ToString("yyyyMMdd") + ".csv")

                        If System.IO.File.Exists(FileName) Then ' Check wheather the file exists or not
                            fs = New FileStream(FileName, FileMode.Open)
                            Dim sr As StreamReader = New StreamReader(fs)

                            sr.ReadLine()   ' Skip title

                            While True
                                Try
                                    strLine = sr.ReadLine() 'Read data from file
                                    If strLine = Nothing Then
                                        Exit While
                                    Else
                                        ReadCount = ReadCount + 1
                                        If ReadCount > SkipCount Then
                                            ReadCount = 0

                                            Dim strSplit() As String = strLine.Split(","c)  'データを配列に入れる
                                            x = New XDate(DateTime.ParseExact(strSplit(0), "yyyy/MM/dd HH:mm:ss", Nothing)) '時刻値をxに入れる

                                            If (x >= myPane.XAxis.Scale.Min) Then   '時間値がデータライフ以内の時
                                                For j = 0 To CheckedItemCountArray(count) - 1
                                                    If LogScaleFlag Then
                                                        y(num + j) = Math.Log10(Convert.ToDouble(strSplit(DataItemIndexArray(count, j) + 1))) 'タグ名からインデックスを検索し対応する値を取得
                                                    Else
                                                        y(num + j) = Convert.ToDouble(strSplit(DataItemIndexArray(count, j) + 1)) 'タグ名からインデックスを検索し対応する値を取得
                                                    End If

                                                    If Math.Abs(y(num + j) - PointValue(num + j)) < SetGraph2.Ydiffthreshold Then   ' データ変化なし
                                                        If PointAddFlg(num + j) = True Or list(num + j).Count <= 1 Then              ' 前回データ変化して新規プロットした
                                                            list(num + j).Add(x, y(num + j))                                        ' 現在記憶している値(現在値ではない)をプロット
                                                            PointAddFlg(num + j) = False                                      ' 新規プロットフラグOFF
                                                        Else                                                            ' 前回データ変化せず新規プロットせず
                                                            list(num + j).Item(list(num + j).Count - 1).X = x                       ' 最後のポイントのX座標を現在のX座標に変更
                                                            PointAddFlg(num + j) = False                                      ' 新規プロットフラグOFF
                                                        End If
                                                    Else                                                                ' データ変化あり
                                                        list(num + j).Add(x, y(num + j))                                            ' 現在記憶している値(現在値ではない)をプロット
                                                        PointValue(num + j) = y(num + j)                                            ' 現在記憶している値を更新
                                                        PointAddFlg(num + j) = True                                           ' 新規プロットフラグON
                                                    End If
                                                Next
                                            End If
                                        End If
                                    End If
                                Catch ex As FormatException
                                    Continue While
                                End Try
                            End While
                            fs.Close()
                        End If
                    Next
                    num = num + j
                End If
            Next
        Else
            Dim IndexArray(CurveCount - 1) As Integer
            For i = 0 To CurveCount - 1
                IndexArray(i) = SearchRealData(TagNameArray(i))
            Next

            ' Read historical data(read from 1 day previous data)
            For i = -1 * (Convert.ToInt16((DataLifemsec - 1) / 86400000)) To 0
                FileName = System.IO.Path.Combine(Kernel.DataLogFolderArray(0), "LOG" + System.DateTime.Now.AddMilliseconds(86400000 * i).ToString("yyyyMMdd") + ".csv")

                If System.IO.File.Exists(FileName) Then ' Check wheather the file exists or not
                    fs = New FileStream(FileName, FileMode.Open)
                    Dim sr As StreamReader = New StreamReader(fs)

                    sr.ReadLine()   ' Skip title

                    While True
                        Try
                            strLine = sr.ReadLine() 'Read data from file
                            If strLine = Nothing Then
                                Exit While
                            Else
                                ReadCount = ReadCount + 1
                                If ReadCount > SkipCount Then
                                    ReadCount = 0

                                    Dim strSplit() As String = strLine.Split(","c)  'データを配列に入れる
                                    x = New XDate(DateTime.ParseExact(strSplit(0), "yyyy/MM/dd HH:mm:ss", Nothing)) '時刻値をxに入れる

                                    If (x >= myPane.XAxis.Scale.Min) Then   '時間値がデータライフ以内の時
                                        For j = 0 To CurveCount - 1
                                            If LogScaleFlag Then
                                                y(j) = Math.Log10(Convert.ToDouble(strSplit(IndexArray(j) + 1))) 'タグ名からインデックスを検索し対応する値を取得
                                            Else
                                                y(j) = Convert.ToDouble(strSplit(IndexArray(j) + 1)) 'タグ名からインデックスを検索し対応する値を取得
                                            End If

                                            If Math.Abs(y(j) - PointValue(j)) < SetGraph2.Ydiffthreshold Then   ' データ変化なし
                                                If PointAddFlg(j) = True Or list(j).Count <= 1 Then              ' 前回データ変化して新規プロットした
                                                    list(j).Add(x, y(j))                                        ' 現在記憶している値(現在値ではない)をプロット
                                                    PointAddFlg(j) = False                                      ' 新規プロットフラグOFF
                                                Else                                                            ' 前回データ変化せず新規プロットせず
                                                    list(j).Item(list(j).Count - 1).X = x                       ' 最後のポイントのX座標を現在のX座標に変更
                                                    PointAddFlg(j) = False                                      ' 新規プロットフラグOFF
                                                End If
                                            Else                                                                ' データ変化あり
                                                list(j).Add(x, y(j))                                            ' 現在記憶している値(現在値ではない)をプロット
                                                PointValue(j) = y(j)                                            ' 現在記憶している値を更新
                                                PointAddFlg(j) = True                                           ' 新規プロットフラグON
                                            End If
                                        Next
                                    End If
                                End If
                            End If
                        Catch ex As FormatException
                            Continue While
                        End Try
                    End While
                    fs.Close()
                End If
            Next
        End If

        'デバッグ用
        For i = 0 To CurveCount - 1
            LabelControlArray(i).Text = list(i).Count.ToString()
        Next

        zg1.AxisChange()   ' グラフに軸レンジの計算を通知
        zg1.Invalidate()   ' グラフの再描画完了を認識
    End Sub

    Private Sub UpdateChart()
        Dim x As Double = New XDate(DateTime.Now)
        Dim y(CurveCount - 1) As Double
        Dim TypeIndex As Integer
        Dim value As Double
        Dim j As Integer
        Dim num As Integer = 0

        ' X軸の最大・最小を再計算
        myPane.XAxis.Scale.Min = New XDate(DateTime.Now.AddMilliseconds(-DataLifemsec))
        myPane.XAxis.Scale.Max = New XDate(DateTime.Now)

        Try
            ' 現在のデータを生成
            If LogByGroup = True Then
                For count As Integer = 0 To DataItemIndexArray.GetLength(0) - 1
                    If CheckedItemCountArray(count) > 0 Then
                        For j = 0 To CheckedItemCountArray(count) - 1
                            TypeIndex = Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, j)).TypeIndex
                            If TypeIndex = 0 Then   'WordGet
                                value = CDbl(Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, j)).DeviceIndex).WordGetArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, j)).TagIndex).Value)
                            ElseIf TypeIndex = 1 Then   'BitGet
                                value = CDbl(Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, j)).DeviceIndex).SixteenBitsGetArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, j)).TagIndex).BitGetArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, j)).TagIndex2).Value)
                            ElseIf TypeIndex = 2 Then   'RealData
                                value = CDbl(Kernel.RealDataArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, j)).TagIndex).CalData)
                            ElseIf TypeIndex = 3 Then   'LogicalItem
                                value = CDbl(Kernel.LogicalItemArray(Kernel.DataGroupArray(count).DataItemArray(DataItemIndexArray(count, j)).TagIndex).GetStatus())
                            End If

                            If LogScaleFlag Then
                                y(num + j) = Math.Log10(value)
                            Else
                                y(num + j) = value
                            End If

                            If Math.Abs(y(num + j) - PointValue(num + j)) < SetGraph2.Ydiffthreshold Then        ' データ変化なし
                                If PointAddFlg(num + j) = True Then      ' 前回データ変化して新規プロットした
                                    list(num + j).Add(x, y(num + j))        ' 現在記憶している値(現在値ではない)をプロット
                                    PointAddFlg(num + j) = False         ' 新規プロットフラグOFF
                                Else                            ' 前回データ変化せず新規プロットせず
                                    If list(num + j).Count >= 1 Then
                                        list(num + j).Item(list(num + j).Count - 1).X = x ' 最後のポイントを削除
                                    End If
                                    PointAddFlg(num + j) = False         ' 新規プロットフラグOFF
                                End If
                            Else                                ' データ変化あり
                                list(num + j).Add(x, y(num + j))        ' 現在記憶している値(現在値ではない)をプロット

                                PointValue(num + j) = y(num + j)            ' 現在記憶している値を更新
                                PointAddFlg(num + j) = True              ' 新規プロットフラグON
                            End If

                            If list(num + j).Count = 1 Then
                                list(num + j).Insert(list(num + j).Count - 1, myPane.XAxis.Scale.Min, y(num + j))
                            End If
                        Next
                        num = num + j
                    End If
                Next
            Else
                For count As Integer = 0 To CurveCount - 1
                    If LogScaleFlag Then
                        y(count) = Math.Log10(Convert.ToDouble(Kernel.RealDataArray(SearchRealData(TagNameArray(count))).CalData))
                    Else
                        y(count) = Convert.ToDouble(Kernel.RealDataArray(SearchRealData(TagNameArray(count))).CalData)
                    End If

                    If Math.Abs(y(count) - PointValue(count)) < SetGraph2.Ydiffthreshold Then        ' データ変化なし
                        If PointAddFlg(count) = True Then      ' 前回データ変化して新規プロットした
                            list(count).Add(x, y(count))        ' 現在記憶している値(現在値ではない)をプロット
                            PointAddFlg(count) = False         ' 新規プロットフラグOFF
                        Else                            ' 前回データ変化せず新規プロットせず
                            If list(count).Count >= 1 Then
                                list(count).Item(list(count).Count - 1).X = x ' 最後のポイントを削除
                            End If
                            PointAddFlg(count) = False         ' 新規プロットフラグOFF
                        End If
                    Else                                ' データ変化あり
                        list(count).Add(x, y(count))        ' 現在記憶している値(現在値ではない)をプロット

                        PointValue(count) = y(count)            ' 現在記憶している値を更新
                        PointAddFlg(count) = True              ' 新規プロットフラグON
                    End If

                    If list(count).Count = 1 Then
                        list(count).Insert(list(count).Count - 1, myPane.XAxis.Scale.Min, y(count))
                    End If
                Next
            End If

            'デバッグ用
            For count As Integer = 0 To CurveCount - 1
                LabelControlArray(count).Text = list(count).Count.ToString()
            Next

            zg1.AxisChange()   ' グラフに軸レンジの計算を通知
            zg1.Invalidate()   ' グラフの再描画完了を認識
        Catch ex As FormatException
        End Try
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        If RefreshWaitCount >= SetGraph2.RefreshRateSec Then
            UpdateChart()
            RefreshWaitCount = 0
        Else
            RefreshWaitCount = RefreshWaitCount + 1
        End If
    End Sub

    Private Function SearchRealData(ByVal Tag As String) As Integer
        SearchRealData = -1

        For count As Integer = 0 To Kernel.RealDataArray.GetLength(0) - 1
            If Kernel.RealDataArray(count).Tag = Tag Then
                SearchRealData = count
                Exit For
            End If
        Next
    End Function

    ' ZedChart時間軸変更
    Public Sub ChangeAxis()
        Dim datalifeBefore As Integer = DataLifemsec
        Dim YmaxBefore As Double = SetGraph2.Ymax
        Dim YminBefore As Double = SetGraph2.Ymin

        DataLifemsec = SetGraph2.datalifemsec
        Ymax = SetGraph2.Ymax
        Ymin = SetGraph2.Ymin

        If DataLifemsec <> SetGraph2.datalifemsec Or myPane.YAxis.Scale.Max <> SetGraph2.Ymax Or myPane.YAxis.Scale.Max <> SetGraph2.Ymin Then
            CreateChart()
            ReadHistory()
        End If
    End Sub

    Private Sub btnSet_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSet.Click
        Dim result As DialogResult = SetGraph2.ShowDialog()

        If result = DialogResult.OK Then
            ChangeAxis()
        End If
    End Sub

    Private Sub btnClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClose.Click
        Me.Close()
    End Sub

    Private Sub TrendGraph_SizeChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.SizeChanged
        Dim MonitorWidth As Long

        If monitor.Length = 1 Then
            MonitorWidth = monitor(0).WorkingArea.Width
        ElseIf monitor.Length = 2 Then
            MonitorWidth = monitor(1).WorkingArea.Width
        End If

        zg1.Height = CInt((1 + 0.055 * Me.ClientRectangle.Width / MonitorWidth) * (Me.ClientRectangle.Height * (1 - 25 / Me.ClientRectangle.Height)))
    End Sub
End Class