﻿Imports System
Imports System.Text
Imports System.Windows
Imports System.Windows.Forms

Public Class SetGraph
    Public datalifemsec As Integer
    Public Ymin As Double
    Public Ymax As Double

    Public Ydiffthreshold As Double
    Public RefreshRateSec As Integer

    Sub New(ByVal Ymax As Double, ByVal Ymin As Double, ByVal datalifemsec As Long, ByVal Ydiffthreshold As Double, ByVal RefreshRateSec As Integer)
        Me.datalifemsec = Convert.ToInt32(datalifemsec)
        Me.Ymax = Ymax
        Me.Ymin = Ymin
        Me.Ydiffthreshold = Ydiffthreshold
        Me.RefreshRateSec = RefreshRateSec

        ' この呼び出しは、Windows フォーム デザイナで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
    End Sub

    Private Sub btnClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClose.Click
        Me.DialogResult = DialogResult.Abort
        Me.Hide()
    End Sub

    Private Sub btnApply_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnApply.Click
        Dim intTempValue As Integer
        Dim dblTempValue As Double
        Dim YmaxTemp As Single
        Dim YminTemp As Single

        Try
            intTempValue = Convert.ToInt16(txtXrange.Text) * 60 * 1000

            If intTempValue > 0 And intTempValue <= 4320 * 60 * 1000 Then
                datalifemsec = intTempValue
            Else
                System.Windows.MessageBox.Show("X range　範囲エラー")
                Me.DialogResult = DialogResult.Abort
                Me.Hide()
            End If

            YminTemp = Convert.ToSingle(txtYmin.Text)
            Ymin = YminTemp

            YmaxTemp = Convert.ToSingle(txtYmax.Text)

            If Ymin <= Ymax Then
                Ymax = YmaxTemp
            Else
                System.Windows.MessageBox.Show("入力値エラー（Ymin > Ymax）")
                Me.DialogResult = DialogResult.Abort
                Me.Hide()
            End If


            dblTempValue = Convert.ToDouble(txtYdiffThreshold.Text)
            If dblTempValue >= 0 Then
                Ydiffthreshold = dblTempValue
            Else
                System.Windows.MessageBox.Show("Y diff threshold　範囲エラー 0<=value")
                Me.DialogResult = DialogResult.Abort
                Me.Hide()
            End If

            intTempValue = Convert.ToInt16(txtRefreshrate.Text)
            If intTempValue > 0 And intTempValue <= 10 Then
                RefreshRateSec = intTempValue
            Else
                System.Windows.MessageBox.Show("Refresh rate　範囲エラー 0<value<=10")
                Me.DialogResult = DialogResult.Abort
                Me.Hide()
            End If

        Catch ex As Exception
            System.Windows.MessageBox.Show("値エラー")
            Me.DialogResult = DialogResult.Abort
            Me.Hide()
        End Try

        Me.DialogResult = DialogResult.OK
        Me.Hide()
    End Sub

    Private Sub SetGraph2_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        txtXrange.Text = (datalifemsec / 60 / 1000).ToString("####0")
        txtYmax.Text = Ymax.ToString()
        txtYmin.Text = Ymin.ToString()
        txtYdiffThreshold.Text = Ydiffthreshold.ToString("0.000000")
        txtRefreshrate.Text = refreshratesec.ToString()
    End Sub

    Private Sub txtXrange_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtXrange.TextChanged

    End Sub
End Class