﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Windows.Interop
Imports System.Runtime.InteropServices
Imports System.Data
Imports System.IO
Imports System.Text

Public Class DataView
    Dim OriginalWidth As Double
    Dim OriginalHeight As Double

    Dim DataSet As shmit.dsDataView
    Dim DataTable As System.Data.DataTable

    Private Const MF_BYCOMMAND As Integer = &H0&
    Private Const SC_CLOSE As Integer = &HF060&

    Dim Kernel As Kernel
    Dim FromDate As Date
    Dim FromSec As Long
    Dim ToDate As Date
    Dim ToSec As Long
    Dim IntervalSec As Long
    Dim GroupId As Integer
    Dim SelectedIndexArray As New ArrayList
    Dim FileNameArray() As String

    <DllImport("User32")> _
    Public Shared Function RemoveMenu(ByVal hMenu As IntPtr, ByVal uPosition As UInteger, ByVal uFlags As UInteger) As Boolean
    End Function

    <DllImport("User32")> _
    Public Shared Function GetSystemMenu(ByVal hWnd As IntPtr, ByVal bRevert As Boolean) As IntPtr
    End Function

    <DllImport("User32")> _
    Public Shared Function DrawMenuBar(ByVal hWnd As IntPtr) As Long
    End Function

    Private Sub AddMsg(ByVal msg As String, ByVal flag As Boolean)
        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + msg, True)
    End Sub

    Public Sub New(ByVal Kernel As Kernel, ByVal FromDate As Date, ByVal ToDate As Date, ByVal IntervalSec As Long, ByVal GroupId As Integer, ByVal SelectedIndexArray As ArrayList, ByVal FileNameArray() As String)
        MyBase.New()

        InitializeComponent()

        Me.Kernel = Kernel
        Me.FromDate = FromDate
        FromSec = CType(FromDate.Ticks / 10000000, Long)
        Me.ToDate = ToDate
        ToSec = CType(ToDate.Ticks / 10000000, Long)
        Me.IntervalSec = IntervalSec
        Me.GroupId = GroupId
        Me.SelectedIndexArray = SelectedIndexArray
        Me.FileNameArray = FileNameArray

        Init()
        InitDataSet()
    End Sub

    Public Sub New(ByVal Kernel As Kernel)
        MyBase.New()

        InitializeComponent()

        Me.Kernel = Kernel
        Init()
    End Sub

    Public Sub New()
        MyBase.New()

        InitializeComponent()
        Init()
    End Sub

    Private Sub Init()
        OriginalWidth = Me.Width
        OriginalHeight = Me.Height

        Me.MinWidth = OriginalWidth / 2
        Me.MinHeight = OriginalHeight / 2
    End Sub

    Private Sub HideWindow_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles HideWindow.Click
        Me.Hide()
    End Sub

    Private Sub DataView_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        'TODO: ここにイベント ハンドラーのコードを追加します。
        Dim windowHandle As IntPtr = (New WindowInteropHelper(Me)).Handle

        Call RemoveMenu(GetSystemMenu(windowHandle, False), SC_CLOSE, MF_BYCOMMAND)
        Call DrawMenuBar(windowHandle)
    End Sub

    Private Sub DataView_SizeChanged(ByVal sender As Object, ByVal e As System.Windows.SizeChangedEventArgs)
        'TODO: ここにイベント ハンドラーのコードを追加します。
        Dim AdjustScale As System.Windows.Media.ScaleTransform = New System.Windows.Media.ScaleTransform()

        AdjustScale.ScaleX = (Me.Width - 20) / (OriginalWidth - 20)
        AdjustScale.ScaleY = (Me.Height - 40) / (OriginalHeight - 40)

        Me.Height = AdjustScale.ScaleX * OriginalHeight

        CV.RenderTransform = AdjustScale
    End Sub

    Private Sub DataView_Initialized(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Initialized
        DataSet = CType(Me.FindResource("dsDataView"), shmit.dsDataView)
        DataTable = CType(DataSet.Tables("DataTable1"), System.Data.DataTable)
    End Sub


    Public Sub InitDataSet()
        Dim strLine As String
        Dim fs As FileStream = Nothing
        Dim ValueArray() As String
        Dim BaseSec As Long = FromSec

        Dim NetworkDrive As NetworkDrive = New NetworkDrive()
        Dim WorkFileNameArray() As String = New String(FileNameArray.Count - 1) {}
        Dim ColumnName As String

        '' network drive
        NetworkDrive.Dispose("Z:")
        Dim ret As Integer = NetworkDrive.Create("\\RemoteHostname\Log", "Username", "Password", "Z:")
        If ret <> 0 Then
            MessageBox.Show("Can not connect to network drive")
            Exit Sub
        End If

        For count As Integer = 0 To FileNameArray.Count - 1
            WorkFileNameArray(count) = "tmp_" + FileNameArray(count)

            'file copy, set true at the 3rd parameter to enable update
            System.IO.File.Copy("Z:\" + FileNameArray(count), WorkFileNameArray(count), True)
        Next

        DataTable.Clear()
        DataTable1DataGrid.AutoGenerateColumns = True

        DataTable.Columns.Add("Time")

        For count As Integer = 0 To SelectedIndexArray.Count - 1
            If Kernel.DataGroupArray(GroupId).DataItemArray(CType(SelectedIndexArray(count), Integer)).Type.Equals("RealData") Then
                ColumnName = Kernel.RealDataArray(Kernel.DataGroupArray(GroupId).DataItemArray(CType(SelectedIndexArray(count), Integer)).TagIndex).Name
                DataTable.Columns.Add(ColumnName.Replace("."c, ChrW(&H2024)).Replace("/"c, ChrW(&H2044)))
            ElseIf Kernel.DataGroupArray(GroupId).DataItemArray(CType(SelectedIndexArray(count), Integer)).Type.Equals("BitGet") Then
                ColumnName = Kernel.DeviceArray(Kernel.DataGroupArray(GroupId).DataItemArray(CType(SelectedIndexArray(count), Integer)).DeviceIndex) _
                                      .SixteenBitsGetArray(Kernel.DataGroupArray(GroupId).DataItemArray(CType(SelectedIndexArray(count), Integer)).TagIndex) _
                                      .BitGetArray(Kernel.DataGroupArray(GroupId).DataItemArray(CType(SelectedIndexArray(count), Integer)).TagIndex2).Name
                DataTable.Columns.Add(ColumnName.Replace("."c, ChrW(&H2024)).Replace("/"c, ChrW(&H2044)))
            End If
        Next

        Dim FileCount As Integer = 0

        While True
            If FileCount <= WorkFileNameArray.Count - 1 Then
                If File.Exists(WorkFileNameArray(FileCount)) Then ' check if the file exists
                    If fs IsNot Nothing Then
                        fs.Close()
                    End If
                    fs = New FileStream(WorkFileNameArray(FileCount), FileMode.Open, IO.FileAccess.Read, FileShare.Write)
                    Dim sr As StreamReader = New StreamReader(fs, Encoding.GetEncoding("Shift_JIS"))

                    strLine = sr.ReadLine() ' skip title
                    While True
                        Try
                            strLine = sr.ReadLine() ' read data from file
                            If strLine = Nothing Then
                                Exit While
                            Else
                                ' add data (strLine)
                                ValueArray = strLine.Split(","c)

                                Dim DataSec As Long = CType(Date.Parse(ValueArray(0)).Ticks / 10000000, Long)
                                If DataSec >= BaseSec Then
                                    If DataSec <= ToSec Then
                                        If DataSec >= BaseSec + IntervalSec Then
                                            BaseSec = BaseSec + ((DataSec - BaseSec) \ IntervalSec) * IntervalSec
                                        End If

                                        DataTable.Rows.Add()
                                        DataTable.Rows(DataTable.Rows.Count - 1).Item(DataTable.Columns.IndexOf("Time")) = ValueArray(0)
                                        For count2 As Integer = 0 To SelectedIndexArray.Count - 1
                                            If Kernel.DataGroupArray(GroupId).DataItemArray(CType(SelectedIndexArray(count2), Integer)).Type.Equals("RealData") Then
                                                DataTable.Rows(DataTable.Rows.Count - 1).Item(DataTable.Columns.IndexOf(Kernel.RealDataArray(Kernel.DataGroupArray(GroupId).DataItemArray(CType(SelectedIndexArray(count2), Integer)).TagIndex).Name)) = ValueArray(CType(SelectedIndexArray(count2), Integer) + 1)
                                            ElseIf Kernel.DataGroupArray(GroupId).DataItemArray(CType(SelectedIndexArray(count2), Integer)).Type.Equals("BitGet") Then
                                                DataTable.Rows(DataTable.Rows.Count - 1).Item( _
                                                    Kernel.DeviceArray(Kernel.DataGroupArray(GroupId).DataItemArray(CType(SelectedIndexArray(count2), Integer)).DeviceIndex) _
                                      .SixteenBitsGetArray(Kernel.DataGroupArray(GroupId).DataItemArray(CType(SelectedIndexArray(count2), Integer)).TagIndex) _
                                      .BitGetArray(Kernel.DataGroupArray(GroupId).DataItemArray(CType(SelectedIndexArray(count2), Integer)).TagIndex2).Name) = ValueArray(CType(SelectedIndexArray(count2), Integer) + 1)
                                            End If
                                        Next

                                        BaseSec += IntervalSec
                                    Else
                                        ' exit loop in case DataSec > ToSe
                                        Exit While
                                    End If
                                Else
                                    ' skip to next dat in case DataSec<BaseSec
                                End If
                            End If
                        Catch ex As FormatException
                            Continue While
                        End Try
                    End While
                    fs.Close()
                End If
            Else
                Exit While
            End If

            FileCount += 1
        End While

        For count As Integer = 0 To WorkFileNameArray.Count - 1
            System.IO.File.Delete(WorkFileNameArray(count))
        Next

        NetworkDrive.Dispose("Z:")


        'For count As Integer = 0 To Kernel.RealDataArray.Count - 1
        '    Try
        '        DataTable.Rows.Add()
        '        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("NameSet")) = Kernel.RealDataArray(count).Name

        '        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHSet")) = Kernel.RealDataArray(count).UpperLimitItemArray(0).LimitValue
        '        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHInput")) = Kernel.RealDataArray(count).UpperLimitItemArray(0).LimitValue
        '        If Kernel.RealDataArray(count).UpperLimitItemArray(0).MailFlag = 1 Then
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHMailSet")) = True
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHMailInput")) = True
        '        Else
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHMailSet")) = False
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("HHMailInput")) = False
        '        End If

        '        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHSet")) = Kernel.RealDataArray(count).UpperLimitItemArray(1).LimitValue
        '        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHInput")) = Kernel.RealDataArray(count).UpperLimitItemArray(1).LimitValue
        '        If Kernel.RealDataArray(count).UpperLimitItemArray(1).MailFlag = 1 Then
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHMailSet")) = True
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHMailInput")) = True
        '        Else
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHMailSet")) = False
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PHMailInput")) = False
        '        End If


        '        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLSet")) = Kernel.RealDataArray(count).LowerLimitItemArray(0).LimitValue
        '        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLInput")) = Kernel.RealDataArray(count).LowerLimitItemArray(0).LimitValue
        '        If Kernel.RealDataArray(count).LowerLimitItemArray(0).MailFlag = 1 Then
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLMailSet")) = True
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLMailInput")) = True
        '        Else
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLMailSet")) = False
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("PLMailInput")) = False
        '        End If

        '        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLSet")) = Kernel.RealDataArray(count).LowerLimitItemArray(1).LimitValue
        '        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLInput")) = Kernel.RealDataArray(count).LowerLimitItemArray(1).LimitValue
        '        If Kernel.RealDataArray(count).LowerLimitItemArray(1).MailFlag = 1 Then
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLMailSet")) = True
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLMailInput")) = True
        '        Else
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLMailSet")) = False
        '            DataTable.Rows(count).Item(DataTable.Columns.IndexOf("LLMailInput")) = False
        '        End If

        '    Catch ex As ResourceReferenceKeyNotFoundException
        '        MessageBox.Show("[InternalError] DataSetName = dsAlarmAnalog not found!")
        '        End
        '    End Try
        'Next
    End Sub

    Private Sub FileSave_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles FileSave.Click
        'Dim DirName As String = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments) + "\Data\"
        Dim DirName As String = ".\Data\"

        If System.IO.Directory.Exists(DirName) Then
            Dim FileName As String = DirName + "Data_" + FromDate.ToString("yyyyMMddHHmmss") + "_" + ToDate.ToString("yyyyMMddHHmmss") + "_" + Now.ToString("yyyyMMddHHmmss") + ".csv"
            Dim fs As New FileStream(FileName, FileMode.Create, IO.FileAccess.Write, FileShare.Read)
            Dim sw As New StreamWriter(fs, Encoding.GetEncoding("Shift_JIS"))
            Dim strLine As String

            strLine = DataTable.Columns(0).ColumnName
            For count As Integer = 1 To DataTable.Columns.Count - 1
                strLine += "," + DataTable.Columns(count).ColumnName
            Next
            sw.WriteLine(strLine)

            For count As Integer = 0 To DataTable.Rows.Count - 1
                strLine = DataTable.Rows(count).ItemArray(0).ToString
                For count2 As Integer = 1 To DataTable.Columns.Count - 1
                    strLine += "," + DataTable.Rows(count).ItemArray(count2).ToString       '' ???
                Next
                sw.WriteLine(strLine)
            Next

            sw.Flush()
            fs.Close()

            FileSave.IsEnabled = False
        Else
            MessageBox.Show("日報・月報データを保存するディレクトリが存在しません(" + DirName + ")")
        End If
    End Sub
End Class