﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Net

''' <summary>
''' PLC - Programmable Logic Controller
''' </summary>
''' <remarks></remarks>
Public Class PLC
    Inherits Device

    Private Kernel As Kernel
    Private err As String = ""

    ''' <summary>
    ''' Get error details
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function GetError() As String
        GetError = err
    End Function

    ''' <summary>
    ''' Construction
    ''' </summary>
    ''' <param name="Kernel"></param>
    ''' <param name="Q_Device"></param>
    ''' <remarks></remarks>
    Sub New(ByVal Kernel As Kernel, ByVal Q_Device As System.Xml.Linq.XElement)
        Me.Kernel = Kernel
        Resource = New Object

        DeviceName = Q_Device.@Name
        DeviceType = Q_Device.@Type
        ActiveFlag = CInt(Q_Device.@ActiveFlag)

        Dim Q_Protocol As IEnumerable(Of XElement) = Q_Device.<Protocol>

        Try
            Protocol = CType(System.Activator.CreateInstance(Type.GetType(Me.GetType.Namespace.ToString() + "." + Q_Protocol.@Name), New Object() {Q_Protocol}), PlcProtocol)
        Catch ex As Exception
            MessageBox.Show("[BinaryTcpSync.New] CreateInstance (" + Me.GetType.Namespace.ToString() + "." + Q_Protocol.@Name + ") failed.")
        End Try

        '<WordGetArray>
        Dim Q_WordGet As IEnumerable(Of XElement) = From i In Q_Device.<WordGetArray>.<WordGet> Select i
        WordGetArray = New WordGet(Q_WordGet.Count - 1) {}

        For count2 As Integer = 0 To Q_WordGet.Count - 1
            Dim Type As String = Q_WordGet(count2).@Type
            Dim Address As UInt32 = CUInt(Q_WordGet(count2).@Address)
            Dim Name As String = Q_WordGet(count2).@Name
            Dim Tag As String = Q_WordGet(count2).@Tag
            WordGetArray(count2) = New WordGet(Name, Tag, Type, Address)

            Try
                WordGetArrayHt.Add(Tag, count2)
            Catch ArgumentException As Exception
                MessageBox.Show("[PLC.New] Tag= " + Tag + " is duplicated in <WordGetArray>!")
                End
            End Try
        Next

        '<WordGetQueryArray>
        Dim Q_WordGetQuery As IEnumerable(Of XElement) = From i In Q_Device.<WordGetQueryArray>.<WordGetQuery> Select i
        WordGetQueryArray = New GetQuery(Q_WordGetQuery.Count - 1) {}

        For count2 As Integer = 0 To Q_WordGetQuery.Count - 1
            Dim Type As String = Q_WordGetQuery(count2).@Type
            Dim StartAddress As UInt32 = CUInt(Q_WordGetQuery(count2).@StartAddress)
            Dim GetCount As Int32 = CInt(Q_WordGetQuery(count2).@Count)

            Dim Q_GetItem As IEnumerable(Of XElement) = From i In Q_WordGetQuery(count2).<GetItem> Select i
            Dim GetItemArray() As Integer = New Integer(Q_GetItem.Count - 1) {} ' data sequence for each WordGet query

            For count3 As Integer = 0 To Q_GetItem.Count - 1
                GetItemArray(count3) = CInt(Q_GetItem(count3).@Num)
            Next

            WordGetQueryArray(count2) = New GetQuery(Type, StartAddress, GetCount, GetItemArray)
        Next

        '<WordSetArray>
        Dim Q_WordSet As IEnumerable(Of XElement) = From i In Q_Device.<WordSetArray>.<WordSet> Select i
        WordSetArray = New WordSet(Q_WordSet.Count - 1) {}

        For count2 As Integer = 0 To Q_WordSet.Count - 1
            Dim Name As String = Q_WordSet(count2).@Name
            Dim Tag As String = Q_WordSet(count2).@Tag
            Dim Type As String = Q_WordSet(count2).@Type
            Dim Address As UInteger = CUInt(Q_WordSet(count2).@Address)
            Dim Format As String = Q_WordSet(count2).@Format
            Dim Unit As String = Q_WordSet(count2).@Unit

            WordSetArray(count2) = New WordSet(Name, Tag, Type, Address, Format, Unit)
        Next

        '<SixteenBitsGetArray>
        Dim Q_SixteenBitsGet As IEnumerable(Of XElement) = From i In Q_Device.<SixteenBitsGetArray>.<SixteenBitsGet> Select i
        SixteenBitsGetArray = New SixteenBitsGet(Q_SixteenBitsGet.Count - 1) {}

        For count2 As Integer = 0 To Q_SixteenBitsGet.Count - 1
            Dim Type As String = Q_SixteenBitsGet(count2).@Type
            Dim Address As UInt32
            Try
                Address = CUInt(Q_SixteenBitsGet(count2).@Address)
            Catch ex As InvalidCastException
                MessageBox.Show("[PLC.New] InvalidCastException at <SixteenBitsGetArray>[" + count2.ToString + "]!")
                End
            End Try


            Dim Q_BitGet As IEnumerable(Of XElement) = From i In Q_SixteenBitsGet(count2).<BitGet> Select i
            Dim BitGetArray() As BitGet = New BitGet(Q_BitGet.Count - 1) {}

            For count3 As Integer = 0 To Q_BitGet.Count - 1
                Dim BitNum As Integer = CInt(Q_BitGet(count3).@BitNum)
                Dim Name As String = Q_BitGet(count3).@Name
                Dim Tag As String = Q_BitGet(count3).@Tag
                BitGetArray(count3) = New BitGet(BitNum, Name, Tag)

                Try
                    SixteenBitsGetArrayHt.Add(Tag, count2)
                Catch ArgumentException As Exception
                    MessageBox.Show("[PLC.New] Tag= " + Tag + " is duplicated in <SixteenBitsGetArray>!")
                    End
                End Try

                Try
                    BitGetArrayHt.Add(Tag, count3)
                Catch ArgumentException As Exception
                    MessageBox.Show("[PLC.New] Tag= " + Tag + " is duplicated in <BitGetArray>!")
                    End
                End Try
            Next

            SixteenBitsGetArray(count2) = New SixteenBitsGet(Type, Address, BitGetArray)
        Next

        '<SixteenBitsGetQueryArray>
        Dim Q_SixteenBitsGetQuery As IEnumerable(Of XElement) = From i In Q_Device.<SixteenBitsGetQueryArray>.<SixteenBitsGetQuery> Select i
        SixteenBitsGetQueryArray = New GetQuery(Q_SixteenBitsGetQuery.Count - 1) {}

        For count2 As Integer = 0 To Q_SixteenBitsGetQuery.Count - 1
            Dim Type As String = Q_SixteenBitsGetQuery(count2).@Type
            Dim StartAddress As UInt32 = CUInt(Q_SixteenBitsGetQuery(count2).@StartAddress)
            Dim GetCount As Int32 = CInt(Q_SixteenBitsGetQuery(count2).@Count)

            Dim Q_GetItem As IEnumerable(Of XElement) = From i In Q_SixteenBitsGetQuery(count2).<GetItem> Select i
            Dim GetItemArray() As Integer = New Integer(Q_GetItem.Count - 1) {} '' Data sequence in query

            For count3 As Integer = 0 To Q_GetItem.Count - 1
                GetItemArray(count3) = CInt(Q_GetItem(count3).@Num)
            Next

            SixteenBitsGetQueryArray(count2) = New GetQuery(Type, StartAddress, GetCount, GetItemArray)
        Next

        '<BitSetArray>
        Dim Q_BitSet As IEnumerable(Of XElement) = From i In Q_Device.<BitSetArray>.<BitSet> Select i
        BitSetArray = New BitSet(Q_BitSet.Count - 1) {}

        For count2 As Integer = 0 To Q_BitSet.Count - 1
            Dim Name As String = Q_BitSet(count2).@Name
            Dim Tag As String = Q_BitSet(count2).@Tag
            Dim Type As String = Q_BitSet(count2).@Type
            Dim Address As UInteger = CUInt(Q_BitSet(count2).@Address)
            Dim BitNum As Integer = CInt(Q_BitSet(count2).@BitNum)

            BitSetArray(count2) = New BitSet(Name, Tag, Type, Address, BitNum)
        Next


        If ActiveFlag = 1 Then
            If Protocol.Connect() = 0 Then
                CommunicationStatus = True
                Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[PLC.New] Connected! (" + DeviceName + ")", True)
            Else
                Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[PLC.New] Connection failed... (" + DeviceName + ")", True)
            End If
        End If
    End Sub

    ''' <summary>
    ''' Acquire digital and analog data
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function DoQuery() As Integer
        Dim UInt16Array() As UInt16 = New UInt16() {}
        Dim ErrFlag As Integer = 0
        Dim Result As Integer
        Dim i As Integer, j As Integer, k As Integer, l As Integer
        Dim TempValue As UInt16

        If CommunicationStatus = False Then
            If Protocol.Connect = 0 Then
                CommunicationStatus = True
            Else
                Dim ErrMsg As String = Protocol.GetError()
                'If ErrMsg.Equals("TIMEOUT") Or ErrMsg.Equals("RecvErr") Or ErrMsg.Equals("RecvLengthError") Or ErrMsg.Equals("PORT_CLOSED") Then
                ErrFlag = 1
                Return ErrFlag
                'End If
            End If
        End If

        ' Acquire digital data
        j = 0
        For i = 0 To SixteenBitsGetQueryArray.GetLength(0) - 1
            SyncLock Resource
                Result = DirectCast(Protocol, PlcProtocol).ReadWords(SixteenBitsGetQueryArray(i).Type, SixteenBitsGetQueryArray(i).StartAddress, SixteenBitsGetQueryArray(i).Count, UInt16Array)
            End SyncLock

            If Result <> 0 Then
                Dim ErrMsg As String = Protocol.GetError()
                If ErrMsg.Equals("TIMEOUT") Or ErrMsg.Equals("RecvErr") Or ErrMsg.Equals("RecvLengthError") Or ErrMsg.Equals("PORT_CLOSED") Then
                    ErrFlag = 1
                    Exit For
                Else
                    ErrFlag = 1
                    Continue For
                End If
            Else
                For k = 0 To SixteenBitsGetQueryArray(i).GetItemArray.GetLength(0) - 1
                    TempValue = UInt16Array(SixteenBitsGetQueryArray(i).GetItemArray(k))
                    SixteenBitsGetArray(j).Value = TempValue
                    For l = 0 To 15
                        If (TempValue And CType(2 ^ l, Long)) = 0 Then
                            SixteenBitsGetArray(j).ValueArray(l) = 0
                        Else
                            SixteenBitsGetArray(j).ValueArray(l) = 1
                        End If
                    Next

                    j = j + 1
                Next

                ' Separate into bit data
                For k = 0 To SixteenBitsGetArray.GetLength(0) - 1
                    For l = 0 To SixteenBitsGetArray(k).BitGetArray.GetLength(0) - 1
                        SixteenBitsGetArray(k).BitGetArray(l).Value = SixteenBitsGetArray(k).ValueArray(SixteenBitsGetArray(k).BitGetArray(l).BitNum)
                    Next
                Next
            End If
        Next

        ' Acquire analog data
        j = 0
        For i = 0 To WordGetQueryArray.GetLength(0) - 1
            SyncLock Resource
                Result = DirectCast(Protocol, PlcProtocol).ReadWords(WordGetQueryArray(i).Type, WordGetQueryArray(i).StartAddress, WordGetQueryArray(i).Count, UInt16Array)
            End SyncLock
            If Result <> 0 Then
                Dim ErrMsg As String = Protocol.GetError()
                If ErrMsg.Equals("TIMEOUT") Or ErrMsg.Equals("RecvErr") Or ErrMsg.Equals("RecvLengthError") Then
                    ErrFlag = 1
                    Exit For
                Else
                    ErrFlag = 1
                    Continue For
                End If
            Else
                Try
                    For k = 0 To WordGetQueryArray(i).GetItemArray.GetLength(0) - 1
                        Dim Int32Value As Int32
                        Int32Value = UInt16Array(WordGetQueryArray(i).GetItemArray(k))
                        'If Int32Value >= 32768 Then
                        '    Int32Value = Int32Value - 65536
                        'End If
                        If Int32Value >= 32768 Then
                            Int32Value = 0
                        End If

                        WordGetArray(j).Value = Int32Value
                        j = j + 1

                    Next
                Catch IndexOutOfRangeException As IndexOutOfRangeException
                    MessageBox.Show("[PLC.DoQuery] IndexOutOfRangeException. PleaseCheck <WordGetQueryArray>.")
                    End
                End Try
            End If
        Next

        Return ErrFlag
    End Function

    ''' <summary>
    ''' Set word data to PLC
    ''' </summary>
    ''' <param name="Tag"></param>
    ''' <param name="value"></param>
    ''' <param name="LogFlag"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function SetWord(ByVal Tag As String, ByVal value As UInt16, ByVal LogFlag As Boolean) As Integer
        Dim result As Integer
        Dim FindFlag As Integer = -1
        Dim ShowFormat As String = Nothing

        For i As Integer = 0 To WordSetArray.GetLength(0) - 1
            If WordSetArray(i).Tag = Tag Then
                FindFlag = 0

                SyncLock Resource
                    result = DirectCast(Protocol, PlcProtocol).WriteWords(WordSetArray(i).Type, WordSetArray(i).Address, 1, New UInt16() {value})
                End SyncLock

                If result <> 0 Then
                    MessageBox.Show("[Kernel.SetWord] Error: " + Protocol.GetError + ":" + result.ToString("X"))
                End If

                ShowFormat = WordSetArray(i).Format
                Exit For
            End If
        Next

        If FindFlag = -1 Then
            MessageBox.Show("[PLC.SetWord] Error: Tag not found.(" + Tag + ")")
            Kernel.AddMsg("[PLC.SetWord] Error: TagName not found.(" + Tag + ")", LogFlag)
            Return -1
        ElseIf result <> 0 Then
            MessageBox.Show("[PLC.SetWord] Error: Set failed.(" + Tag + ")")
            Kernel.AddMsg("[PLC.SetWord] Error: Set Failed.(" + Tag + ")", LogFlag)
            Return -1
        Else
            Kernel.AddMsg("[PLC.SetWord] " + Tag + "=" + value.ToString(ShowFormat), LogFlag)
            Return 0
        End If
    End Function

    ''' <summary>
    ''' Set multiple word data to PLC
    ''' </summary>
    ''' <param name="Tag"></param>
    ''' <param name="value"></param>
    ''' <param name="LogFlag"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function SetWords(ByVal Tag() As String, ByVal value() As UInt16, ByVal LogFlag As Boolean) As Integer
        Dim result As Integer
        Dim FindFlag As Boolean = False
        Dim ShowFormat As String = Nothing
        Dim MatchFlag As Boolean = True

        For i As Integer = 0 To WordSetArray.GetLength(0) - 1
            If WordSetArray(i).Tag = Tag(0) Then
                FindFlag = True
                For count2 As Integer = 1 To Tag.GetLength(0) - 1
                    If WordSetArray(i + count2).Tag <> Tag(count2) _
                        Or WordSetArray(i).Type <> WordSetArray(i + count2).Type _
                        Or WordSetArray(i).Address + count2 <> WordSetArray(i + count2).Address Then
                        MatchFlag = False
                        Exit For
                    End If

                Next

                If FindFlag = True And MatchFlag = True Then
                    SyncLock Resource
                        result = DirectCast(Protocol, PlcProtocol).WriteWords(WordSetArray(i).Type, WordSetArray(i).Address, Tag.GetLength(0), value)
                    End SyncLock

                    If result <> 0 Then
                        MessageBox.Show("[PLC.SetWord] Error: " + Protocol.GetError + ":" + result.ToString("X"))
                    End If
                End If

                Exit For
            End If
        Next

        If FindFlag = False Then
            MessageBox.Show("[PLC.SetWords] Error: Tag not found.(" + Tag(0) + ")")
            Kernel.AddMsg("[PLC.SetWords] Error: TagName not found.(" + Tag(0) + ")", LogFlag)
            Return -1
        ElseIf MatchFlag = False Then
            MessageBox.Show("[PLC.SetWords] Error: Tag not match.(" + Tag(0) + "and the other" + (Tag.GetLength(0) - 1).ToString() + ")")
            Kernel.AddMsg("[PLC.SetWords] Error: TagName not match.(" + Tag(0) + "and the other" + (Tag.GetLength(0) - 1).ToString() + ")", LogFlag)
            Return -1
        ElseIf result <> 0 Then
            MessageBox.Show("[PLC.SetWords] Error: Set failed.(" + Tag(0) + "and the other" + (Tag.GetLength(0) - 1).ToString() + ")")
            Kernel.AddMsg("[PLC.SetWords] Error: Set Failed.(" + Tag(0) + "and the other " + (Tag.GetLength(0) - 1).ToString() + "items)", LogFlag)
            Return -1
        Else
            Kernel.AddMsg("[PLC.SetWord] " + Tag(0) + "and the other " + (Tag.GetLength(0) - 1).ToString() + "items", LogFlag)
            Return 0
        End If
    End Function


    ''' <summary>
    ''' Set multiple word data to PLC
    ''' </summary>
    ''' <param name="Tag"></param>
    ''' <param name="value"></param>
    ''' <param name="LogFlag"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function SetWords(ByVal Tag As String, ByVal value() As UInt16, ByVal LogFlag As Boolean) As Integer
        Dim result As Integer
        Dim FindFlag As Boolean = False
        Dim ShowFormat As String = Nothing
        Dim MatchFlag As Boolean = True

        For i As Integer = 0 To WordSetArray.GetLength(0) - 1
            If WordSetArray(i).Tag = Tag Then
                FindFlag = True
                For count2 As Integer = 1 To value.GetLength(0) - 1
                    If WordSetArray(i).Type <> WordSetArray(i + count2).Type _
                        Or WordSetArray(i).Address + count2 <> WordSetArray(i + count2).Address Then
                        MatchFlag = False
                        Exit For
                    End If

                Next

                If FindFlag = True And MatchFlag = True Then
                    SyncLock Resource
                        result = DirectCast(Protocol, PlcProtocol).WriteWords(WordSetArray(i).Type, WordSetArray(i).Address, value.GetLength(0), value)
                    End SyncLock

                    If result <> 0 Then
                        MessageBox.Show("[PLC.SetWord] Error: " + Protocol.GetError + ":" + result.ToString("X"))
                    End If
                End If

                Exit For
            End If
        Next

        If FindFlag = False Then
            MessageBox.Show("[PLC.SetWords] Error: Tag not found.(" + Tag + ")")
            Kernel.AddMsg("[PLC.SetWords] Error: TagName not found.(" + Tag + ")", LogFlag)
            Return -1
        ElseIf MatchFlag = False Then
            MessageBox.Show("[PLC.SetWords] Error: Tag not match.(" + Tag + "and the other" + (value.GetLength(0) - 1).ToString() + ")")
            Kernel.AddMsg("[PLC.SetWords] Error: TagName not match.(" + Tag + "and the other" + (value.GetLength(0) - 1).ToString() + ")", LogFlag)
            Return -1
        ElseIf result <> 0 Then
            MessageBox.Show("[PLC.SetWords] Error: Set failed.(" + Tag + "and the other" + (value.GetLength(0) - 1).ToString() + ")")
            Kernel.AddMsg("[PLC.SetWords] Error: Set Failed.(" + Tag(0) + "and the other " + (value.GetLength(0) - 1).ToString() + "items)", LogFlag)
            Return -1
        Else
            Kernel.AddMsg("[PLC.SetWord] " + Tag + "and the other " + (value.GetLength(0) - 1).ToString() + "items", LogFlag)
            Return 0
        End If
    End Function

    ''' <summary>
    ''' Set bit data to PLC
    ''' </summary>
    ''' <param name="TargetArray"></param>
    ''' <param name="value"></param>
    ''' <param name="LogFlag"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function SetBit(ByVal TargetArray() As String, ByVal value As UInt16, ByVal LogFlag As Boolean) As Integer
        Dim result As Integer
        Dim FindFlag As Integer

        For TargetArrayCount As Integer = 0 To TargetArray.GetLength(0) - 1
            FindFlag = -1

            For BitSetArrayCount As Integer = 0 To BitSetArray.GetLength(0) - 1
                If TargetArray(TargetArrayCount) = BitSetArray(BitSetArrayCount).Tag Then
                    FindFlag = 0

                    Dim Address As UInteger = BitSetArray(BitSetArrayCount).Address

                    SyncLock Resource
                        result = DirectCast(Protocol, PlcProtocol).WriteBits(BitSetArray(BitSetArrayCount).Type, Address, BitSetArray(BitSetArrayCount).BitNum, value)
                    End SyncLock

                    If result <> 0 Then
                        MessageBox.Show("[PLC.SetBit] Error: " + Protocol.GetError + ":" + result.ToString("X"))
                    End If
                    Exit For
                End If
            Next

            If FindFlag = -1 Then
                MessageBox.Show("[PLC.SetBit] Error: TagName not found.(" + TargetArray(TargetArrayCount) + ")")
                Kernel.AddMsg("[PLC.SetBit] Error: TagName not found.(" + TargetArray(TargetArrayCount) + ")", LogFlag)
                Return -1
            ElseIf result <> 0 Then
                MessageBox.Show("[PLC.SetBit] Error: Set Bit Failed.(" + TargetArray(TargetArrayCount) + ")")
                Kernel.AddMsg("[PLC.SetBit] Error: Set Bit Failed.(" + TargetArray(TargetArrayCount) + ")", LogFlag)
                Return -1
            Else
                Kernel.AddMsg("[PLC.SetBit] " + TargetArray(TargetArrayCount) + "=" + value.ToString(), LogFlag)
                Return 0
            End If
        Next

        Return -1
    End Function
End Class

