﻿Option Explicit On
Option Strict On
Option Infer Off

Public MustInherit Class Device
    Public DeviceId As Integer
    Public DeviceName As String
    Public DeviceType As String
    Public ActiveFlag As Integer

    Public Protocol As Protocol

    Public WordGetArray() As WordGet
    Public WordGetQueryArray() As GetQuery
    Public WordSetArray() As WordSet
    Public WordItemArray() As WordItem

    Public SixteenBitsGetArray() As SixteenBitsGet
    Public SixteenBitsGetQueryArray() As GetQuery
    Public BitSetArray() As BitSet

    Public SixteenBitsGetArrayHt As Hashtable = New Hashtable
    Public BitGetArrayHt As Hashtable = New Hashtable
    Public WordGetArrayHt As Hashtable = New Hashtable
    Public WordGetArrayHt2 As Hashtable = New Hashtable

    Public WordSetArrayHt As Hashtable = New Hashtable
    Public WordSetArrayHt2 As Hashtable = New Hashtable

    Public CommunicationStatus As Boolean = False

    Public LastAcquisitionTime As DateTime = System.DateTime.Now ' for asynchronous data acquisition

    MustOverride Function GetError() As String

    Public Shared Resource As New Object

    Public Overridable Function SetWord(ByVal Tag As String, ByVal value As UInt16, ByVal LogFlag As Boolean) As Integer
        Return -1
    End Function

    Public Overridable Function SetWords(ByVal Tag() As String, ByVal value() As UInt16, ByVal LogFlag As Boolean) As Integer
        Return -1
    End Function

    Public Overridable Function SetWords(ByVal Tag As String, ByVal value() As UInt16, ByVal LogFlag As Boolean) As Integer
        Return -1
    End Function

    Public Overridable Function SetBit(ByVal TargetArray() As String, ByVal value As UInt16, ByVal LogFlag As Boolean) As Integer
        Return -1
    End Function

    Overridable Function DoQuery() As Integer
        Return Nothing
    End Function

    Public Overridable Function SearchWordGetArrayHt(DataItemTag As String, ByRef ht As Integer, ByRef ht2 As Integer) As Integer
        Dim ret As Object

        ret = WordGetArrayHt(DataItemTag)

        If ret IsNot Nothing Then
            ht = CInt(ret)

            If WordGetArray(ht).IsArrayFlag Then
                ret = WordGetArrayHt2(DataItemTag)
                If ret IsNot Nothing Then
                    ht2 = CInt(ret)
                    Return 1
                Else
                    ht2 = -1
                    Return -1
                End If
            Else
                Return 0
            End If
        Else
            ht = -1
            Return -1
        End If
    End Function

    Public Overridable Function SearchWordSetArrayHt(DataItemTag As String, ByRef ht As Integer, ByRef ht2 As Integer) As Integer
        Dim ret As Object

        ret = WordSetArrayHt(DataItemTag)

        If ret IsNot Nothing Then
            ht = CInt(ret)

            If WordSetArray(ht).IsArrayFlag Then
                ret = WordSetArrayHt2(DataItemTag)
                If ret IsNot Nothing Then
                    ht2 = CInt(ret)
                    Return 1
                Else
                    ht2 = -1
                    Return -1
                End If
            Else
                Return 0
            End If
        Else
            ht = -1
            Return -1
        End If
    End Function

    Public Overridable Function SearchBitGetArrayHt(DataItemTag As String, ByRef chno As Integer, ByRef bitno As Integer) As Integer
        Dim ret As Object

        ret = SixteenBitsGetArrayHt(DataItemTag)
        If ret IsNot Nothing Then
            chno = CInt(ret)
            ret = BitGetArrayHt(DataItemTag)
            If ret IsNot Nothing Then
                bitno = CInt(ret)
                Return 0
            Else
                Return -1
            End If
        Else
            Return -1
        End If
    End Function
End Class
