﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Net

Public Class BinaryTcpSync
    Inherits Device

    Dim Kernel As Kernel
    Dim err As String = ""
    Dim shotno As Integer
    Public BinaryTcpClientIn As BinaryTcpClientIn

    Public Overrides Function GetError() As String
        GetError = err
    End Function

    Sub New(ByVal Kernel As Kernel, ByVal Q_Device As System.Xml.Linq.XElement)
        Me.Kernel = Kernel
        Resource = New Object

        DeviceName = Q_Device.@Name
        DeviceType = Q_Device.@Type
        ActiveFlag = CInt(Q_Device.@ActiveFlag)

        Dim Q_Protocol As IEnumerable(Of XElement) = Q_Device.<Protocol>
        Try
            BinaryTcpClientIn = CType(System.Activator.CreateInstance(Type.GetType(Me.GetType.Namespace.ToString() + "." + Q_Protocol.@Name), New Object() {Q_Protocol}), BinaryTcpClientIn)
        Catch ex As Exception
            MessageBox.Show("[BinaryTcpSync.New] CreateInstance (" + Me.GetType.Namespace.ToString() + "." + Q_Protocol.@Name + ") failed.")
        End Try

        '' WordGet list
        '<WordGetArray>
        Dim Q_WordGet As IEnumerable(Of XElement) = From i In Q_Device.<WordGetArray>.<WordGet> Select i
        WordGetArray = New WordGet(Q_WordGet.Count - 1) {}

        For count2 As Integer = 0 To Q_WordGet.Count - 1
            Dim Type As String = Q_WordGet(count2).@Type
            Dim Address As UInt32 = CUInt(Q_WordGet(count2).@Address)
            Dim Name As String = Q_WordGet(count2).@Name
            Dim Tag As String = Q_WordGet(count2).@Tag
            WordGetArray(count2) = New WordGet(Name, Tag, Type, Address)

            Try
                WordGetArrayHt.Add(Tag, count2)
            Catch ArgumentException As Exception
                MessageBox.Show("[BinaryTcpSync.New] Tag= " + Tag + " is duplicated in <WordGetArray>!")
                End
            End Try
        Next

        '' 16BitGet list
        '<SixteenBitsGetArray>
        Dim Q_SixteenBitsGet As IEnumerable(Of XElement) = From i In Q_Device.<SixteenBitsGetArray>.<SixteenBitsGet> Select i
        SixteenBitsGetArray = New SixteenBitsGet(Q_SixteenBitsGet.Count - 1) {}

        For count2 As Integer = 0 To Q_SixteenBitsGet.Count - 1
            Dim Type As String = Q_SixteenBitsGet(count2).@Type
            Dim Address As UInt32 = CUInt(Q_SixteenBitsGet(count2).@Address)

            Dim Q_BitGet As IEnumerable(Of XElement) = From i In Q_SixteenBitsGet(count2).<BitGet> Select i
            Dim BitGetArray() As BitGet = New BitGet(Q_BitGet.Count - 1) {}

            For count3 As Integer = 0 To Q_BitGet.Count - 1
                Dim BitNum As Integer = CInt(Q_BitGet(count3).@BitNum)
                Dim Name As String = Q_BitGet(count3).@Name
                Dim Tag As String = Q_BitGet(count3).@Tag
                BitGetArray(count3) = New BitGet(BitNum, Name, Tag)

                Try
                    SixteenBitsGetArrayHt.Add(Tag, count2)
                Catch ArgumentException As Exception
                    MessageBox.Show("[BinaryTcpSync.New] Tag= " + Tag + " is duplicated in <SixteenBitsGetArray>!")
                    End
                End Try

                Try
                    BitGetArrayHt.Add(Tag, count3)
                Catch ArgumentException As Exception
                    MessageBox.Show("[BinaryTcpSync.New] Tag= " + Tag + " is duplicated in <BitGetArray>!")
                    End
                End Try
            Next

            SixteenBitsGetArray(count2) = New SixteenBitsGet(Type, Address, BitGetArray)
        Next

        If ActiveFlag = 1 Then
            If BinaryTcpClientIn.Connect() = 0 Then
                CommunicationStatus = True
                Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + "[BinaryTcpSync.New] Connected! (" + DeviceName + ")", True)
            Else
                Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + "[BinaryTcpSync.New] Connection failed... (" + DeviceName + ")", True)
            End If
        End If
    End Sub

    Public Overrides Function DoQuery() As Integer
        Dim ErrFlag As Integer = 0
        Dim Result As Integer

        SyncLock Resource
            Result = CType(BinaryTcpClientIn, BinaryTcpClientIn).GetData(WordGetArray, SixteenBitsGetArray)
        End SyncLock

        If Result <> 0 Then
            Dim ErrMsg As String = BinaryTcpClientIn.GetError()
            If ErrMsg.Equals("TIMEOUT") Or ErrMsg.Equals("RecvErr") Or ErrMsg.Equals("RecvLengthError") Then
                err = ErrMsg
                ErrFlag = 1
            Else
                err = ErrMsg
                ErrFlag = 1
            End If
        End If

        Return ErrFlag
    End Function
End Class

