Option Strict On

Imports System.Net
Imports System.Net.Sockets
Imports System.Threading

' TCP server
Public Class TcpServerAsync
    Private err As String = ""

    Private listener As TcpListener             ' listener

    Public Event Connected(ByVal sender As TcpServerAsync, ByVal ConnId As Integer)                          ' Connected event
    Public Event BinaryReceived(ByVal sender As TcpServerAsync, ByVal ConnId As Integer, ByVal Data() As Byte, ByVal BytesRead As Integer) ' binary data received event
    Public Event Disconnected(ByVal sender As TcpServerAsync, ByVal ConnId As Integer)                       ' Disconnect event

    Private client() As TcpClient
    Private ns() As System.Net.Sockets.NetworkStream
    Private max_client_number As Integer

    Dim portno As Integer

    Private HeaderBytes As Integer
    Private CountNumberStart As Integer
    Private CountNumberBytes As Integer
    Private CountStart As Integer
    Private CountOrder As Integer
    Private FixCount As Integer

    ' Constructor
    Public Sub New(ByVal portno As Integer, ByVal max_client_number As Integer, ByVal HeaderBytes As Integer, ByVal CountNumberStart As Integer, ByVal CountNumberBytes As Integer, ByVal CountStart As Integer, ByVal CountOrder As Integer, Optional FixCount As Integer = 0)
        Me.portno = portno
        Me.HeaderBytes = HeaderBytes
        Me.CountNumberStart = CountNumberStart
        Me.CountNumberBytes = CountNumberBytes
        Me.CountStart = CountStart
        Me.CountOrder = CountOrder
        Me.FixCount = FixCount

        Me.max_client_number = max_client_number

        client = New TcpClient(max_client_number - 1) {}
        For i As Integer = 0 To max_client_number - 1
            client(i) = New TcpClient()
        Next

        ns = New System.Net.Sockets.NetworkStream(max_client_number - 1) {}

        Dim listenerThread As Thread = New System.Threading.Thread(AddressOf DoListen)  ' Thread for listener
        listenerThread.Start()                                                          ' start listener thread
    End Sub

    Public Function GetError() As String
        Dim ret As String = err
        err = ""
        GetError = ret
    End Function

    ' send binary data
    Public Sub SendDataBINARY(ByVal ConnId As Integer, ByVal Data() As Byte)
        SyncLock ns(ConnId)  ' lock network stream from other thread.
            ns(ConnId).Write(Data, 0, Data.GetLength(0))
            ns(ConnId).Flush()
        End SyncLock
    End Sub

    ' wait for new connection
    Private Sub DoListen()
        Dim ConnId As Integer = -1
        Dim ClientTemp As TcpClient

        Try
            listener = New TcpListener(IPAddress.Any, portno)               ' create listener instance
            listener.Start()                                                ' start listener
            While True
                ConnId = -1
                ClientTemp = listener.AcceptTcpClient

                ' check connection number
                For i As Integer = 0 To max_client_number - 1
                    If client(i) Is Nothing Or (client(i) IsNot Nothing And client(i).Connected = False) Then
                        ConnId = i
                        client(i) = ClientTemp
                        ns(i) = client(i).GetStream
                        RaiseEvent Connected(Me, ConnId) ' establish Connected event
                        Exit For
                    End If
                Next

                If ConnId = -1 Then
                    ' In case over the limit of connection number
                    MessageBox.Show("Connection number over!")
                Else
                    ' start the asynchronous thread to receive data
                    Dim t As Thread = New Thread(New ParameterizedThreadStart(AddressOf RecvBinary))

                    t.Start(New ParamClass(ConnId))
                End If
            End While
        Catch ex As Exception
            listener.Stop()
        End Try
    End Sub

    ' receive binary data
    Public Sub RecvBinary(ByVal param As Object)
        Dim RecvData(HeaderBytes - 1) As Byte
        Dim MsgLen As Integer = 0
        Dim RecvDataRet() As Byte
        Dim ReceivedBytes As Integer = 0
        Dim count1 As Integer
        Dim count2 As Integer
        Dim ret As Integer = 0

        Try
            While True
                ReceivedBytes = 0
                MsgLen = 0

                Do Until ReceivedBytes = HeaderBytes
                    ret = ns(CType(param, ParamClass).ConnId).Read(RecvData, 0, HeaderBytes - ReceivedBytes)
                    If ret > 0 Then
                        ReceivedBytes = ReceivedBytes + ret
                    Else
                        err = "Recv zero byte"
                        RaiseEvent Disconnected(Me, CType(param, ParamClass).ConnId) ' establish Disconnected event
                        client(CType(param, ParamClass).ConnId).Close()
                        Exit While
                    End If
                Loop

                For count1 = 0 To CountNumberBytes - 1
                    If CountOrder = 1 Then  'Index=CountStartIndex+CountBytes-1 is higer digit
                        MsgLen += RecvData(count1 + CountNumberStart - 1) * CType(256 ^ count1, Integer)
                    Else                    'Index=0 is higer digit
                        MsgLen += RecvData(count1 + CountNumberStart - 1) * CType(256 ^ ((CountNumberBytes - 1) - count1), Integer)
                    End If
                Next

                If FixCount = 0 Then   ' variable length message
                    ReDim RecvDataRet(CountStart - 1 + MsgLen - 1)

                    For count2 = 0 To HeaderBytes - 1
                        RecvDataRet(count2) = RecvData(count2)
                    Next

                    ReceivedBytes = 0

                    Do Until ReceivedBytes = CountStart - 1 + MsgLen - HeaderBytes
                        ret = ns(CType(param, ParamClass).ConnId).Read(RecvDataRet, HeaderBytes, CountStart - 1 + MsgLen - HeaderBytes - ReceivedBytes)
                        If ret > 0 Then
                            ReceivedBytes = ReceivedBytes + ret
                        Else
                            err = "Recv zero byte"
                            RaiseEvent Disconnected(Me, CType(param, ParamClass).ConnId) ' establish Disconnected event
                            client(CType(param, ParamClass).ConnId).Close()
                            Exit While
                        End If
                    Loop
                    RaiseEvent BinaryReceived(Me, CType(param, ParamClass).ConnId, RecvDataRet, CountStart - 1 + ReceivedBytes)                         ' establish BinaryReceived event
                Else                ' fixed length message
                    ReDim RecvDataRet(FixCount - 1)

                    For count2 = 0 To HeaderBytes - 1
                        RecvDataRet(count2) = RecvData(count2)
                    Next

                    ReceivedBytes = 0

                    Do Until ReceivedBytes = FixCount - HeaderBytes
                        ret = ns(CType(param, ParamClass).ConnId).Read(RecvDataRet, HeaderBytes, FixCount - HeaderBytes - ReceivedBytes)
                        If ret > 0 Then
                            ReceivedBytes = ReceivedBytes + ret
                        Else
                            err = "Recv zero byte"
                            RaiseEvent Disconnected(Me, CType(param, ParamClass).ConnId) ' Establish Disconnected event
                            client(CType(param, ParamClass).ConnId).Close()
                            Exit While
                        End If
                    Loop
                    RaiseEvent BinaryReceived(Me, CType(param, ParamClass).ConnId, RecvDataRet, FixCount)                         ' Established BinaryReceived event
                End If
            End While
        Catch ex As TimeoutException
            err = "TIMEOUT"
        Catch ex As System.IO.IOException
            err = "IOException"
            RaiseEvent Disconnected(Me, CType(param, ParamClass).ConnId) ' establish Disconnected event
            client(CType(param, ParamClass).ConnId).Close()
        Catch ex As Exception
            err = ex.Message
        End Try
    End Sub

    Public Sub Close()
        listener.Stop()
        For i As Integer = 0 To max_client_number - 1
            If client(i).Connected Then
                client(i).Close()
            End If
        Next
    End Sub
End Class

Public Class ParamClass
    Public ConnId As Integer

    Sub New(ByVal ConnId As Integer)
        Me.ConnId = ConnId
    End Sub
End Class