﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System
Imports System.IO.Ports
Imports System.Threading

''' <summary>
''' Serial connection
''' </summary>
''' <remarks></remarks>
Public Class SerialAsync
    Private port As SerialPort              ' Communication port
    Private err As String = ""              ' Error message
    Private Shared Resource1 As New Object  ' For exclusive access control

    Public Event AsciiDataReceived(ByVal sender As SerialAsync, ByVal Data As String)
    Public Event ErrorOccured(ByVal sender As SerialAsync, ByVal Content As String)         ' Error occured event

    Dim t As Thread

    Dim PortName As String
    Dim BaudRate As Integer
    Dim Parity As Parity
    Dim DataBits As Integer
    Dim StopBits As StopBits
    Dim NewLine As String
    Dim ReceivedBytesThreshold As Integer
    Dim ReadBufferSize As Integer
    Dim ReadTimeout As Integer
    Dim DtrEnable As Boolean
    Dim RtsEnable As Boolean = False

    Dim NewLineHt As Hashtable = New Hashtable()

    ''' <summary>
    ''' Constructor
    ''' </summary>
    ''' <param name="PortName">PortName</param>
    ''' <param name="BaudRate">BaudRate</param>
    ''' <param name="Parity">Parity</param>
    ''' <param name="DataBits">DataBits</param>
    ''' <param name="StopBits">StopBits</param>
    ''' <param name="NewLine">NewLine</param>
    ''' <param name="ReceivedBytesThreshold">ReceivedBytesThreshold</param>
    ''' <param name="ReadBufferSize">ReadBufferSize</param>
    ''' <param name="ReadTimeout">ReadTimeout</param>
    ''' <param name="DtrEnable">DtrEnable</param>
    ''' <param name="RtsEnable">RtsEnable</param>
    ''' <remarks></remarks>
    Sub New(ByVal PortName As String, ByVal BaudRate As Integer, _
            Optional ByVal Parity As Parity = IO.Ports.Parity.None, Optional ByVal DataBits As Integer = 8, Optional ByVal StopBits As StopBits = IO.Ports.StopBits.One, _
            Optional ByVal NewLine As String = "CrLf", Optional ByVal ReceivedBytesThreshold As Integer = 1, _
            Optional ByVal ReadBufferSize As Integer = 4096, Optional ByVal ReadTimeout As Integer = SerialPort.InfiniteTimeout, _
            Optional ByVal DtrEnable As Boolean = False, Optional ByVal RtsEnable As Boolean = False)
        NewLineHt.Add("Cr", vbCr)
        NewLineHt.Add("Lf", vbLf)
        NewLineHt.Add("CrLf", vbCrLf)

        Me.PortName = PortName
        Me.BaudRate = BaudRate
        Me.Parity = Parity
        Me.DataBits = DataBits
        Me.StopBits = StopBits
        Me.NewLine = NewLineHt(NewLine).ToString
        Me.ReceivedBytesThreshold = ReceivedBytesThreshold
        Me.ReadBufferSize = ReadBufferSize
        Me.ReadTimeout = ReadTimeout
        Me.DtrEnable = DtrEnable
        Me.RtsEnable = RtsEnable
    End Sub

    ''' <summary>
    ''' Get error details
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetError() As String
        GetError = err
    End Function


    ''' <summary>
    ''' Open serial communication
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Open() As Integer
        Try
            port = New SerialPort(PortName, BaudRate, Parity, DataBits, StopBits)

            port.ReceivedBytesThreshold = ReceivedBytesThreshold
            port.ReadBufferSize = ReadBufferSize
            port.ReadTimeout = ReadTimeout
            port.DtrEnable = DtrEnable
            port.RtsEnable = RtsEnable
            port.NewLine = NewLine

            port.Open()

            ' Start asynch receive thread
            t = New Thread(New ThreadStart(AddressOf RecvData))
            t.Start()

            Open = 0
        Catch ex As Exception
            RaiseEvent ErrorOccured(Me, "SerialAsync.Open.Exception")                    ' Exception
            Open = -1
        End Try
    End Function

    ''' <summary>
    ''' Send data through serial connection
    ''' </summary>
    ''' <param name="SendData"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Send(ByVal SendData As String) As Integer
        Try
            port.WriteLine(SendData)
            Send = 0
        Catch ex As InvalidOperationException
            RaiseEvent ErrorOccured(Me, "SerialAsync.Send.InvalidOperationException")                    ' InvalidOperationException
            Send = -1
        End Try
    End Function

    ''' <summary>
    ''' Receive ascii data
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub RecvData()
        Dim RecvData As String

        Try
            While True
                RecvData = port.ReadLine()
                RaiseEvent AsciiDataReceived(Me, RecvData)    ' Data received event
            End While
        Catch ex As TimeoutException
            RaiseEvent ErrorOccured(Me, "SerialAsync.RecvData.TimeoutException")    ' Error occured event
            port.Close()
            port.Open()
        Catch ex As InvalidOperationException
            RaiseEvent ErrorOccured(Me, "SerialAsync.RecvData.InvalidOperationException")    ' Error occured event
            port.Close()
            port.Open()
        Catch ex As Exception
            RaiseEvent ErrorOccured(Me, "SerialAsync.RecvData.Exception")    ' Error occured event
            port.Close()
            port.Open()
        End Try
    End Sub


    ''' <summary>
    ''' Close serial port
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Close() As Integer
        Try
            port.Close()
            Close = 0
        Catch ex As Exception
            Close = -1
        End Try
    End Function
End Class
