// ShitarabianDllImp.cpp: CShitarabianDllImp NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
#include "ShitarabianDllImp.h"
#include "SettingDlg.h"
#include "DocumentIF.h"
#include "Common.h"
#include <process.h>
#include "xDib.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

BOOL	SaveBitmap(
	CBitmap*	pBitmap,
	CString		strDstFilePath
);

const int	iROIMode = 3;
const int	iNormalMode = 0;

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CShitarabianDllImp::CShitarabianDllImp()
: m_strPaintExe( "mspaint.exe" )
, m_bEmphasis( FALSE )
, m_bEnable( FALSE )
{
}

CShitarabianDllImp::~CShitarabianDllImp()
{
}

void	CShitarabianDllImp::OnLoad(CDocumentIF*	pDocIF)
{
	Load( pDocIF );

	// c[o[̏
	if ( m_bEnable )
	{
		pDocIF->EntryToolBar( IDR_DLLTOOLBAR );
		pDocIF->ShowToolBar( TRUE );
	}
	else
	{
		pDocIF->ShowToolBar( FALSE );
	}
}

void	CShitarabianDllImp::OnSave(CDocumentIF*	pDocIF)
{
	Save( pDocIF );
}


const char* CShitarabianDllImp::GetPlugInName()
{
	return( "vgXN[ ver1.1" );
}



void CShitarabianDllImp::OnSetting(
	CDocumentIF*	pDocIF
)
{
	CSettingDlg		dlg;
	dlg.m_bEmphasis = m_bEmphasis;
	dlg.m_strExePath = m_strPaintExe;
	dlg.m_bEnable = m_bEnable;
	if ( dlg.DoModal() == IDOK )
	{
		m_bEmphasis = dlg.m_bEmphasis;
		m_strPaintExe = dlg.m_strExePath;
		m_bEnable = dlg.m_bEnable;

		if ( m_bEnable )
		{
			pDocIF->EntryToolBar( IDR_DLLTOOLBAR );
			pDocIF->ShowToolBar( TRUE );
		}
		else
		{
			pDocIF->ShowToolBar( FALSE );
			// ROI[h
			pDocIF->SetSelectMode( iNormalMode );
			pDocIF->SetAllUpdate();
			pDocIF->ReDraw();
		}
	}
}



void CShitarabianDllImp::OnToolButton(
	CDocumentIF*	pDocIF,
	int				idxButton
)
{
	switch( idxButton )
	{
	case 0:		// 荞݊Jn
		{
			int		iMode = iROIMode;
			pDocIF->GetSelectMode( &iMode );

			if ( iMode != iROIMode )
			{
				pDocIF->SetSelectMode( iROIMode );
				pDocIF->SetAllUpdate();
				pDocIF->ReDraw();
			}
			else
			{
				pDocIF->SetSelectMode( iNormalMode );
				pDocIF->SetAllUpdate();
				pDocIF->ReDraw();
			}
		}
		break;

	case 1:		// 荞ݏ
		{
			CBitmap		bmpMem;
			GetBitmap(
				pDocIF,
				&bmpMem
			);

			// xtempɕۑA
			CString	strDstShortFileName;
			CString	strDstLongFileName;
			{
				const	iBuffSize = 1024;
				char	pPath[ iBuffSize ];
				::GetTempPath( iBuffSize, pPath );

				CString		str( pPath );
				strDstShortFileName = str;
				strDstShortFileName += _T("printscreen.bmp");
				::GetLongPathName( str, pPath, iBuffSize );
				strDstLongFileName = pPath;
				strDstLongFileName += _T("printscreen.bmp");
			}
			ToDIB	bmpSave;
			bmpSave = (HBITMAP)bmpMem;
			bmpSave.SaveToFile( strDstLongFileName );

			// yCg𗧂グĕҏW
			_spawnlp(
				_P_NOWAIT,
				m_strPaintExe,
				m_strPaintExe,
				strDstShortFileName,
				NULL
			);
		}
		break;

	case 2:		// 荞ݏ
		{
			::OpenClipboard( NULL );
			::EmptyClipboard();
			::CloseClipboard();

			CBitmap		bmpMem;
			GetBitmap(
				pDocIF,
				&bmpMem
			);

			OpenClipboard(NULL);
			HANDLE handle = ::SetClipboardData(
				CF_BITMAP,
				(HBITMAP)bmpMem
			);
			PrintLastErr();
			CloseClipboard();
		}
		break;

	case 4:		// ݒ_CAO\
		OnSetting( pDocIF );
		break;

	default:
		ASSERT( FALSE );
		break;
	}
}




void CShitarabianDllImp::OnToolButtonUI(
	CDocumentIF*	pDocIF,
	int				idxButton,
	CCmdUI*			pCmdUI
)
{
	switch( idxButton )
	{
	case 0:		// 荞݊Jn
		{
			int		iMode = iROIMode;
			pDocIF->GetSelectMode( &iMode );
			pCmdUI->SetCheck( iMode == iROIMode );
		}
		break;

	case 1:		// ROI荞
	case 2:		// ROI荞
		{
			int		iMode = iROIMode;
			pDocIF->GetSelectMode( &iMode );
			pCmdUI->Enable( iMode == iROIMode );
		}
		break;

	case 3:		// ݒ_CAO
		{
			pCmdUI->Enable( TRUE );
		}
		break;

	default:
		return;
		break;
	}
}





void CShitarabianDllImp::Save(
	CDocumentIF*	pDocIF
)
{
	try
	{
		CString	strIniFolderPath = pDocIF->GetIniPath();
		CString	strIniFilePath = strIniFolderPath + "printscreen.ini";

		CStdioFile	File( strIniFilePath, CFile::modeCreate|CFile::modeWrite );
		File.WriteString( ::BoolToString( m_bEnable )+"\n" );
		File.WriteString( ::BoolToString( m_bEmphasis )+"\n" );
		File.WriteString( ::QuoteString( m_strPaintExe )+"\n" );
	}
	catch( CFileException* e )
	{
		e->Delete();
	}
}

void CShitarabianDllImp::Load(
	CDocumentIF*	pDocIF
)
{
	try
	{
		CString	strIniFolderPath = pDocIF->GetIniPath();
		CString	strIniFilePath = strIniFolderPath + "printscreen.ini";

		CStdioFile	File( strIniFilePath, CFile::modeRead | CFile::shareDenyNone );

		CString		str;
		File.ReadString( str );
		m_bEnable = ::StringToBool( str );
		File.ReadString( str );
		m_bEmphasis = ::StringToBool( str );
		File.ReadString( str );
		m_strPaintExe = ::DeQuoteString( str );
	}
	catch( CFileException* e )
	{
		e->Delete();
	}
}



void CShitarabianDllImp::GetBitmap(
	CDocumentIF*	pDocIF,
	CBitmap*		pbmpMem
)
{
	BOOL	bEmphasis = pDocIF->GetEmphasisEnable();
	pDocIF->SetEmphasisEnable( m_bEmphasis );

	// ROI擾
	CRect		rcROI;
	BOOL		bROIExists = pDocIF->GetROI( &rcROI );
	if ( bROIExists )
	{
		// 傫̂тƂ܂Ղ
		CDC			dcMem;
//		CBitmap		bmpMem;
		CBitmap*	pOldBMP;
		{
			HDC	hdc = ::GetDC( NULL );
			dcMem.CreateCompatibleDC( CDC::FromHandle( hdc ) );
			pbmpMem->CreateCompatibleBitmap(
				CDC::FromHandle( hdc ),
				rcROI.Width(),
				rcROI.Height()
			);
			::ReleaseDC( NULL, hdc );
			pOldBMP = dcMem.SelectObject( pbmpMem );
		}

		// ֕`
		pDocIF->Draw(
			&dcMem,
			0,0,
			rcROI
		);

		dcMem.SelectObject( pOldBMP );
	}

	pDocIF->SetEmphasisEnable( bEmphasis );
}