// ScanLogicPuzzle.h: ScanLogicPuzzle NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCANLOGICPUZZLE_H__9B8ECA80_F8AF_11D6_B6AE_0090997F65F0__INCLUDED_)
#define AFX_SCANLOGICPUZZLE_H__9B8ECA80_F8AF_11D6_B6AE_0090997F65F0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef unsigned char uchar;

class ScanLogicPuzzle  
{
private:
	CStringArray	aDivLogic;
	CStringArray	aScanNumX;
	CStringArray	aScanNumY;
	int				iSetSizeX;
	int				iSetSizeY;
	BOOL			bEnable;
	CString			strScanLog;
	CString			strQuestion;
	CString			strWhiteBlock;

	void	MakeLogic	( uchar* pucLogic );
	void	ScanX		( uchar* pucLogic );
	void	ScanY		( uchar* pucLogic );
	void	FixSize		( CStringArray* paScaned , int iFixSize );
	void	Divide		( CStringArray* pstrArray , uchar* pucLogic );
	void	SetScaned	( CString* pstrSet );
	uchar*	FixNum		( int iNum , uchar* ucpNum );
	int		GetLongLine	( uchar* pucLogic );

public:
	ScanLogicPuzzle();
	virtual ~ScanLogicPuzzle();
	
	BOOL	Scan ( uchar* pucLogic );
	CString GetScaned();
	CString GetQuestion();
};

#endif // !defined(AFX_SCANLOGICPUZZLE_H__9B8ECA80_F8AF_11D6_B6AE_0090997F65F0__INCLUDED_)