/*-----------------------------------------------------------------------------
[]	CategoryTreeView.cpp
[Tv]	JeSc[r[̎
[l]	Ȃ
[]	2003-03-18	NC		VK쐬(moralog)
-----------------------------------------------------------------------------*/


// sPR@nkdɂcc
// http://hp.vector.co.jp/authors/VA007799/tips/tips13.htm


//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "hebope.h"
#include "CategoryTreeView.h"
#include "AAListView.h"
#include "AAHanger.h"
#include "HebopeDoc.h"
#include "ExeCommon.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCategoryTreeView

IMPLEMENT_DYNCREATE(CCategoryTreeView, CTreeView)

CCategoryTreeView::CCategoryTreeView()
: m_bUIReflect( TRUE )
{
}

CCategoryTreeView::~CCategoryTreeView()
{
}


BEGIN_MESSAGE_MAP(CCategoryTreeView, CTreeViewEx)
	//{{AFX_MSG_MAP(CCategoryTreeView)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED, OnSelchanged)
	ON_NOTIFY_REFLECT(TVN_ENDLABELEDIT, OnEndlabeledit)
	ON_NOTIFY_REFLECT(TVN_DELETEITEM, OnDeleteitem)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(IDM_TREE_ADDNODE, OnTreeAddnode)
	ON_COMMAND(IDM_TREE_DELETENODE, OnTreeDeletenode)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCategoryTreeView `

void CCategoryTreeView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: ̈ʒuɕ`p̃R[hǉĂ
}

/////////////////////////////////////////////////////////////////////////////
// CCategoryTreeView ff

#ifdef _DEBUG
void CCategoryTreeView::AssertValid() const
{
	CTreeViewEx::AssertValid();
}

void CCategoryTreeView::Dump(CDumpContext& dc) const
{
	CTreeViewEx::Dump(dc);
}
#endif //_DEBUG


/*-----------------------------------------------------------------------------
[]	yCeXV
[@\]	hLger[ɔf
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCategoryTreeView::ReflectView()
{
	CHebopeDoc*		pDoc = (CHebopeDoc*)(::GetMainFrame()->GetActiveDocument());
	if ( pDoc != NULL )
	{
		CCategoryTree*	pCategoryTree = pDoc->GetCategoryTree();

		SetUIReflect( FALSE );
		GetTreeCtrl().DeleteAllItems();

		// JeSc[̓e𔽉f
		// c[ɒǉĂ݂eXg
		HTREEITEM	RootNode = TVI_ROOT;
		CCategoryNode*	pNode = pCategoryTree->Node();
		pNode->Reflect(
			&GetTreeCtrl(),
			RootNode
		);

		SetUIReflect( TRUE );
	}
}


/*-----------------------------------------------------------------------------
[]	IڕύXnh
[@\]	m[h̑IύXɔāAXgeύXB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCategoryTreeView::OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

	// Xgr[̓eXV
	::GetMainFrame()->ReflectListView();

	*pResult = 0;
}


/*-----------------------------------------------------------------------------
[]	m[h̕ύXnh
[@\]	m[ĥ̖ύXB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCategoryTreeView::OnEndlabeledit(NMHDR* pNMHDR, LRESULT* pResult) 
{
	TV_DISPINFO* pTVDispInfo = (TV_DISPINFO*)pNMHDR;

	// f[^̃m[ĥύX
	BOOL		bModified = FALSE;
	CString		strNewNodeName(pTVDispInfo->item.pszText);
	if( !strNewNodeName.IsEmpty() )
	{
		CCategoryNode*	pCategoryNode;
		pCategoryNode = (CCategoryNode*)(GetTreeCtrl().GetItemData( pTVDispInfo->item.hItem ));
		pCategoryNode->SetNodeName( strNewNodeName );

		bModified = TRUE;
	}
	
	*pResult = bModified;
}


/*-----------------------------------------------------------------------------
[]	m[h폜nh
[@\]	m[h폜B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCategoryTreeView::OnDeleteitem(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

	// UIƘA̐ݒłΌf[^̃m[h폜
	if ( IsUIReflect() )
	{
		CCategoryNode*	pCategoryNode = (CCategoryNode*)(pNMTreeView->itemOld.lParam);
		CCategoryNode*	pParent = pCategoryNode->GetParent();
		if ( pParent != NULL )
		{
			pParent->DeleteNode( pCategoryNode );
		}
		else
		{
			// êȂm[h̍폜H
			// [głȂȂm[hǉɐe̐ݒYĂ\
//			ASSERT( FALSE );
		}
	}
	*pResult = TRUE;
}


/*-----------------------------------------------------------------------------
[]	nh
[@\]	c[Rg[AC[WXgB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CCategoryTreeView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	BOOL	bResult = CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);

	CBitmap bitmap;

	// C[WXg̏
	// SԖڂ̈̓XgێC[W̐BTԖڂ̓XggƂ̊gC[W
	m_imageList.Create(16, 16, ILC_MASK, 3, 2);

	// rbg}bvC[WC[WXgɒǉ
	// Add֐̂QԖڂ͓̈ߐFi}XNj\
	bitmap.LoadBitmap(IDB_CLOSEFOLDER);
	m_imageList.Add(&bitmap, RGB(0,255,0));
	bitmap.DeleteObject();

	bitmap.LoadBitmap(IDB_OPENFOLDER);
	m_imageList.Add(&bitmap, RGB(0,255,0));
	bitmap.DeleteObject();

	bitmap.LoadBitmap(IDB_AA);
	m_imageList.Add(&bitmap, RGB(0,255,0));
	bitmap.DeleteObject();

	// c[Rg[ɃC[WXgݒ
	GetTreeCtrl().SetImageList(&m_imageList, TVSIL_NORMAL);

	// m[hhbvălXg邱Ƃ
	SetKeepIndentLevel( FALSE );


	m_DropTarget.Register( this );

	return( bResult );
}


/*-----------------------------------------------------------------------------
[]	ACẽRs[Jnnh
[@\]	Rs[̋sfB
[ߒl]	BOOL	Rs[(TRUE:AFLSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CCategoryTreeView::OnCopyItem(
	HTREEITEM	hSrcNode,		// I :Rs[m[h [-] (-) :-
	HTREEITEM	hNewParent,		// I :Rs[em[h [-] (-) :-
	HTREEITEM	hAfter			// I :Rs[Zm[h [-] (-) :-
)
{
	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	ACẽRs[nh
[@\]	Rs[B
[ߒl]	BOOL	(TRUE:AFLSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CCategoryTreeView::OnCopiedItem(
	HTREEITEM	hNewNode,		// I :Rs[m[h [-] (-) :-
	HTREEITEM	hSrcNode,		// I :Rs[m[h [-] (-) :-
	HTREEITEM	hNewParent,		// I :Rs[em[h [-] (-) :-
	HTREEITEM	hAfter			// I :Rs[Zm[h [-] (-) :-
)
{
	CCategoryNode*	pSrcNode;
	pSrcNode = (CCategoryNode*)(GetTreeCtrl().GetItemData( hSrcNode ));

	CCategoryNode*	pParentNode;
	pParentNode = (CCategoryNode*)(GetTreeCtrl().GetItemData( hNewParent ));

	// m[hǉʒůmF
	CCategoryNode*	pAfterNode = NULL;
	if ( hAfter != TVI_LAST )
	{
		pAfterNode = (CCategoryNode*)(GetTreeCtrl().GetItemData( hAfter ));
	}

	// \[Xm[h̃Rs[em[hɒǉ
	CCategoryNode*	pNewNode = pParentNode->AddNode( *pSrcNode, pAfterNode );

	// c[m[h̃f[^ݒ
	GetTreeCtrl().SetItemData( hNewNode, (LPARAM)pNewNode );

	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	ENbNnh
[@\]	|bvAbv̕\B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCategoryTreeView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// Ym[hI
	UINT	uiWhere;
	HTREEITEM	Node = GetTreeCtrl().HitTest( point, &uiWhere );
	GetTreeCtrl().Select( Node, TVGN_CARET );

	// j[̃[h
	CMenu menu;
	VERIFY(menu.LoadMenu(IDR_TREEPOPUP));
	CMenu* pPopup = menu.GetSubMenu(0);

	// |bvAbvj[̕\
	CPoint posCursor( point );
	ClientToScreen( &posCursor );
	pPopup->TrackPopupMenu(
		TPM_LEFTALIGN | TPM_RIGHTBUTTON,
		posCursor.x, posCursor.y,
		::AfxGetMainWnd()
	);
}


/*-----------------------------------------------------------------------------
[]	m[hVKǉnh
[@\]	IĂm[hɎqm[hǉB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCategoryTreeView::OnTreeAddnode() 
{
	// c[r[őIĂm[h𓾂
	CCategoryNode*	pCategoryNode = NULL;
	HTREEITEM ParentNode = GetTreeCtrl().GetSelectedItem();
	if ( ParentNode != NULL )
	{
		pCategoryNode = (CCategoryNode*)(GetTreeCtrl().GetItemData( ParentNode ));
	}

	// VKm[h̒ǉ
	if( pCategoryNode != NULL )
	{
		// f[^Ƀm[hǉ
		CCategoryNode*	pNewNode = pCategoryNode->AddNode( (CString)"(VK)" );

		// c[r[Ƀm[hǉ
		HTREEITEM NewNode = GetTreeCtrl().InsertItem( pNewNode->GetNodeName(), 0, 1, ParentNode );
		GetTreeCtrl().SetItemData( NewNode, (LPARAM)pNewNode );

		// em[hJāAVKǉm[hI
		GetTreeCtrl().Select( NewNode, TVGN_CARET );

		// VKm[ĥ̕ҏWJn
		GetTreeCtrl().EditLabel( NewNode );
	}
}


/*-----------------------------------------------------------------------------
[]	m[h폜nh
[@\]	IĂm[h폜B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCategoryTreeView::OnTreeDeletenode() 
{
	// c[r[őIĂm[h𓾂
	CCategoryNode*	pCategoryNode = NULL;
	HTREEITEM DeleteNode = GetTreeCtrl().GetSelectedItem();
	if ( DeleteNode != NULL )
	{
		// m[h폜
		GetTreeCtrl().DeleteItem( DeleteNode );
	}
}


/*-----------------------------------------------------------------------------
[]	hbOEnternh
[@\]	\̒ʒmB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
DROPEFFECT CCategoryTreeView::OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
{
	UINT	uiFormat = ::RegisterClipboardFormat( g_strAADataFormat );
	if( pDataObject->IsDataAvailable( uiFormat ) )
	{
		// ctrlԂɂARs[ǂʒm
        return (dwKeyState & MK_CONTROL) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
    }

	return CTreeViewEx::OnDragEnter(pDataObject, dwKeyState, point);
}


/*-----------------------------------------------------------------------------
[]	hbOOvernh
[@\]	\̒ʒmBhbvm[h̃nCCgĕ`B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
DROPEFFECT CCategoryTreeView::OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
{
	UINT	uiFormat = ::RegisterClipboardFormat( g_strAADataFormat );
	if( pDataObject->IsDataAvailable( uiFormat ) )
	{
		// Ym[ho
		UINT	uiWhere;
		HTREEITEM	DropNode = GetTreeCtrl().HitTest( point, &uiWhere );

		// hbvʒũm[h`
		GetTreeCtrl().SelectDropTarget( DropNode );

		// ctrlԂɂARs[ǂʒm
		return (dwKeyState & MK_CONTROL) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
	}
	
	return CTreeViewEx::OnDragOver(pDataObject, dwKeyState, point);
}


/*-----------------------------------------------------------------------------
[]	hbvnh
[@\]	Xg̃hbvBCfNX̒ǉB
[ߒl]	Ȃ
[l]	\[Xf[^͖ăXg̑IԂɍsB
-----------------------------------------------------------------------------*/
BOOL CCategoryTreeView::OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point) 
{
	UINT	uiFormat = ::RegisterClipboardFormat( g_strAADataFormat );
	if( pDataObject->IsDataAvailable( uiFormat ) )
	{
		// Ym[ho
		UINT	uiWhere;
		HTREEITEM	DropNode = GetTreeCtrl().HitTest( point, &uiWhere );

		// m[hɑ΂AAf[^ǉ
		if( DropNode != NULL )
		{
			// Xgr[ɑIĂvfׂĂhbvꂽ̂Ƃ݂Ȃ
			CListCtrl*	pList = &(::GetMainFrame()->GetListView()->GetListCtrl());
			CCategoryNode* pDropNode = (CCategoryNode*)(GetTreeCtrl().GetItemData( DropNode  ));

			POSITION pos = pList->GetFirstSelectedItemPosition();
			while( pos != NULL )
			{
				long idxLine = pList->GetNextSelectedItem( pos );				// Xgԍ
				long idxItem = (long)(pList->GetItemData( idxLine ));			// m[hԍ
				long idxAA = ::GetMainFrame()->GetListView()->Node()->GetIndex( idxItem );	// AAԍ

				pDropNode->AddIndex( idxAA );
			}
		}

		// hbv^[Qbg̏
		GetTreeCtrl().SelectDropTarget( NULL );
		return TRUE;
	}
	
	return CTreeViewEx::OnDrop(pDataObject, dropEffect, point);
}
