/*-----------------------------------------------------------------------------
[]	CategoryNode.cpp
[Tv]	JeSm[h̎
[l]	JeSc[̃m[hB
[]	2003-03-14	NC		VK쐬(moralog)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[hEsS`
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "hebope.h"
#include "CategoryNode.h"
#include "../Common/Common.h"
#include "ExeCommon.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CCategoryNode::CCategoryNode()
	: m_pParent( NULL )
{

}


/*-----------------------------------------------------------------------------
[]	fXgN^
[@\]	CX^X̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CCategoryNode::~CCategoryNode()
{
	RemoveAllNode();
	RemoveAllIndex();
}


/*-----------------------------------------------------------------------------
[]	ʃm[h̔j
[@\]	IɊmۂʃm[h̉B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCategoryNode::RemoveAllNode()
{
	POSITION	pos = m_listpNodez.GetHeadPosition();
	while( pos != NULL )
	{
		delete ( m_listpNodez.GetNext(pos) );
	}
	m_listpNodez.RemoveAll();
}


/*-----------------------------------------------------------------------------
[]	c[r[̃m[hɔf
[@\]	c[r[֔fB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void	CCategoryNode::Reflect(
	CTreeCtrl*	pTree,
	HTREEITEM	RootNode
)
{
	// ̃JeS쐬
	HTREEITEM	OwnNode = pTree->InsertItem( GetNodeName(), 0, 1, RootNode );
	pTree->SetItemData( OwnNode, (DWORD)this );

	// ʃm[hǉ
	POSITION	pos = m_listpNodez.GetHeadPosition();
	while( pos != NULL )
	{
		m_listpNodez.GetNext(pos)->Reflect( pTree, OwnNode );
	}
}

/*-----------------------------------------------------------------------------
[]	m[ĥ̐ݒ
[@\]	m[ĥ̖ύX
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void	CCategoryNode::SetNodeName(
	CString strNodeName				// m[hV [-] (-) :-
)
{
	m_strNodeName = strNodeName;

	// hLgɕύXI
	::NotifyModified();
}

/*-----------------------------------------------------------------------------
[]	ʃm[h̒ǉ
[@\]	
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CCategoryNode* CCategoryNode::AddNode(
	CString&	strNodeName,
	BOOL		bForceCreate			// K :TRUE
)
{
	// ̂̃m[h΂Ȃ
	if ( !bForceCreate )
	{
		POSITION	pos = m_listpNodez.GetHeadPosition();
		while( pos != NULL )
		{
			CCategoryNode* pNode = m_listpNodez.GetAt( pos );
			if( pNode->GetNodeName() == strNodeName )
			{
				return( pNode );
			}
			m_listpNodez.GetNext( pos );
		}
	}

	// VKm[h쐬
	CCategoryNode* pNewNode = new CCategoryNode;
	m_listpNodez.AddTail( pNewNode );
	pNewNode->m_pParent = this;
	pNewNode->SetNodeName( strNodeName );

	// hLgɕύXI
	::NotifyModified();

	return( pNewNode );
}



/*-----------------------------------------------------------------------------
[]	ʃm[h̍폜
[@\]	
[ߒl]	BOOL	[-] (TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CCategoryNode::DeleteNode(
	CCategoryNode* pDeleteNode
)
{
	POSITION	pos = m_listpNodez.GetHeadPosition();
	while( pos != NULL )
	{
		CCategoryNode* pNode = m_listpNodez.GetAt( pos );
		if( pNode == pDeleteNode )
		{
			delete pDeleteNode;
			m_listpNodez.RemoveAt( pos );

			// hLgɕύXI
			::NotifyModified();

			return( TRUE );
		}
		m_listpNodez.GetNext( pos );
	}
	return( FALSE );
}

/*-----------------------------------------------------------------------------
[]	AACfNX̎擾
[@\]	
[ߒl]	long AÃCfNX [-] (-1:݂ȂB0`:CAAHangerCfNX)
[l]	Ȃ
-----------------------------------------------------------------------------*/
long CCategoryNode::GetIndex( long idxIndex )
{
	POSITION	pos = m_listIndexz.GetHeadPosition();
	while( pos != NULL )
	{
		if ( idxIndex == 0 )
		{
			return( m_listIndexz.GetAt(pos) );
		}
		m_listIndexz.GetNext(pos);
		idxIndex--;
	}
	return( -1 );
}



/*-----------------------------------------------------------------------------
[]	t@Co
[@\]	
[ߒl]	BOOL	 [-] (:TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CCategoryNode::Write(CArchive& ar)
{
	// m[h
	ar.WriteString( ::QuoteString( m_strNodeName ) );
	ar.WriteString( "\n" );

	// CfNX
	ar.WriteString( ::LongToString( m_listIndexz.GetCount() ) );
	ar.WriteString( "\n" );

	// CfNXQ
	POSITION	posIndex = m_listIndexz.GetHeadPosition();
	while( posIndex )
	{
		ar.WriteString( ::LongToString( m_listIndexz.GetNext( posIndex ) ) );
		ar.WriteString( "\n" );
	}

	// ʃm[h
	ar.WriteString( ::LongToString( m_listpNodez.GetCount() ) );
	ar.WriteString( "\n" );

	// ʃm[hQ
	POSITION	posNode = m_listpNodez.GetHeadPosition();
	while( posNode )
	{
		m_listpNodez.GetNext( posNode )->Write( ar );
	}

	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	t@C
[@\]	
[ߒl]	BOOL	 [-] (:TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CCategoryNode::Read(CArchive& ar)
{
	RemoveAllNode();
	RemoveAllIndex();

	CString		strLine;

	// m[h
	ar.ReadString( strLine );
	m_strNodeName = ::DeQuoteString( strLine );

	// CfNXQ
	long	nIndex;
	ar.ReadString( strLine );
	nIndex = ::StringToLong( strLine );
	while( nIndex > 0 )
	{
		ar.ReadString( strLine );
		m_listIndexz.AddTail( ::StringToLong( strLine ) );
		nIndex--;
	}

	// ʃm[hQ
	long	nNode;
	ar.ReadString( strLine );
	nNode = ::StringToLong( strLine );
	while( nNode > 0 )
	{
		CCategoryNode*	ptmp = new CCategoryNode;
		ptmp->Read( ar );
		ptmp->m_pParent = this;
		m_listpNodez.AddTail( ptmp );
		nNode--;
	}

	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	ʃm[h̕ǉ
[@\]	
[ߒl]	BOOL	 [-] (:TRUE:AFALSE:s)
[l]	CfNX񂾂Rs[Aʃm[h̓Rs[Ȃ!
-----------------------------------------------------------------------------*/
CCategoryNode* CCategoryNode::AddNode(
	CCategoryNode& Src,			// I  :m[h [-] (-) :-
	CCategoryNode* pAfter		// I  :Rs[Zm[h [-] (-) :-
)
{
	CCategoryNode* pNewNode = AddNode( Src.GetNodeName() );

	pNewNode->m_listIndexz.RemoveAll();
	pNewNode->m_listIndexz.AddTail( &Src.m_listIndexz );
/*
	POSITION pos = Src.m_listpNodez.GetHeadPosition();
	while( pos != NULL )
	{
		pNewNode->AddNode(
			*(Src.m_listpNodez.GetNext( pos )),
			NULL
		);
	}
*/
	// hLgɕύXI
	::NotifyModified();

	return( pNewNode );
}


/*-----------------------------------------------------------------------------
[]	AACfNX̍폜
[@\]	
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCategoryNode::DeleteIndex(
	long lIndex				// Xgvfԍ [0`]
)
{
	POSITION	pos = m_listIndexz.GetHeadPosition();
	while( pos != NULL )
	{
		if( lIndex == 0 )
		{
			m_listIndexz.RemoveAt(pos);

			// hLgɕύXI
			::NotifyModified();

			return;
		}
		lIndex--;
		m_listIndexz.GetNext(pos);
	}
}


// ʃm[h̎擾
CCategoryNode* CCategoryNode::GetNode(
	long idxNode
)
{
	POSITION	pos = m_listpNodez.GetHeadPosition();
	while( pos != NULL )
	{
		if ( idxNode == 0 )
		{
			return( m_listpNodez.GetAt( pos ) );
		}
		idxNode--;
		m_listpNodez.GetNext(pos);
	}
	return( NULL );
}


// AACfNX̐ݒ
BOOL CCategoryNode::SetIndex(
	long idxItem,
	long idxAA
)
{
	POSITION	pos = m_listIndexz.GetHeadPosition();
	while( pos != NULL )
	{
		if ( idxItem == 0 )
		{
			m_listIndexz.SetAt( pos, idxAA );

			// hLgɕύXI
			::NotifyModified();

			return( TRUE );
		}
		idxItem--;
		m_listIndexz.GetNext(pos);
	}
	return( FALSE );
}



// ȉ̊Kw̃CfNXSė񋓂
long	CCategoryNode::GetIndexz( CList<long, long>* plistlIndexz )
{
	// ̊Kw
	plistlIndexz->AddTail( &m_listIndexz );

	// Kw
	POSITION	pos = m_listpNodez.GetHeadPosition();
	while( pos != NULL )
	{
		m_listpNodez.GetAt( pos )->GetIndexz( plistlIndexz );
		m_listpNodez.GetNext(pos);
	}
	return ( plistlIndexz->GetCount() );
}

// CfNX̐UȂ
BOOL CCategoryNode::Renumbering( CList<long, long>& listlIndexz )
{
	// ̊Kw
	{
		POSITION	posMy = m_listIndexz.GetHeadPosition();
		while( posMy != NULL )
		{
			long	iOldIndex = m_listIndexz.GetAt( posMy );

			long	idxNewIndex = 0;
			POSITION	posTrans = listlIndexz.GetHeadPosition();
			while( posTrans != NULL )
			{
				if ( listlIndexz.GetAt( posTrans ) == iOldIndex )
				{
					m_listIndexz.SetAt( posMy, idxNewIndex );
					break;
				}
				listlIndexz.GetNext( posTrans );
				idxNewIndex++;
			}
			m_listIndexz.GetNext( posMy );
		}
	}

	// Kw
	POSITION	pos = m_listpNodez.GetHeadPosition();
	while( pos != NULL )
	{
		m_listpNodez.GetAt( pos )->Renumbering( listlIndexz );
		m_listpNodez.GetNext( pos );
	}

	// hLgɕύXI
	::NotifyModified();

	return ( TRUE );
}
