/*-----------------------------------------------------------------------------
[]	Unicoder.cpp
[Tv]	jR[hǗNX̎
[l]	Ȃ
[]	2003-02-25	NC		Rgt(moralog)
		2004-03-31 pnger	UnicodeToEntityRef()ǉ(moralog)
		2004-06-06 b0401111	(3344)ʐݒ̃jR[hŒǉ̃{^ƋI(moralog)
-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Unicoder.h"
#include "CharacterEntityReference.h"
#include "UnicodeFontDefine.h"
#include "wingdi.h"
#include <stdlib.h>
#include <ctype.h>
#include "Common.h"
#include "ExeCommon.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


// @\݂邩H
//  (3344) BGN 2004.06.07 (moralog) ֐̑ݔ@ύX
// Unicode͈͎擾֐
typedef DWORD (WINAPI *GETFONTUNICODERENGES)(
	HDC,
	LPGLYPHSET
);
HMODULE						s_hGDI32DLL( NULL );
GETFONTUNICODERENGES		s_pProcGETFONTUNICODERENGES( NULL );
//  (3344) END


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CUnicoder::CUnicoder()
: m_bEnable( TRUE )
{
//  (3344) BGN 2004.06.07 (moralog) ֐̑ݔ@ύX
	// Unicode͈͎擾֐DLL擾
	s_hGDI32DLL = ::LoadLibrary( _T("gdi32.dll") );
	if ( s_hGDI32DLL != NULL )
	{
		s_pProcGETFONTUNICODERENGES = (GETFONTUNICODERENGES)::GetProcAddress(
			s_hGDI32DLL,
			_T("GetFontUnicodeRanges")
		);
	}
//  (3344) END
}


/*-----------------------------------------------------------------------------
[]	fXgN^
[@\]	CX^X̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CUnicoder::~CUnicoder()
{
//  (3344) BGN 2004.06.07 (moralog) ֐̑ݔ@ύX
	// Unicode͈͎擾֐pDLL
	if ( s_hGDI32DLL != NULL )
	{
		::FreeLibrary( s_hGDI32DLL );
	}
//  (3344) END
}


/*-----------------------------------------------------------------------------
[]	jR[hSJisϊiPj
[@\]	UnicodeSJisɕϊB
[ߒl]	CString		ϊςݕ [SJis] (-)
[l]	KvłHTMLiSJisjɕϊB
		ϊKvȂ΂̂܂SJisR[hɓǂݑւB
-----------------------------------------------------------------------------*/
int	CUnicoder::UnicodeToSJIS(
		const wchar_t	uniSrc,
		char*			sjisDst
)
{
	int		idxDst( 0 );
	{
		char		mbstrDst[3];
		wchar_t		wSrc[2];
		wSrc[0] = uniSrc;
		wSrc[1] = 0x00;
		size_t		size = wcstombs(
			mbstrDst,
			wSrc,
			3
		);

		// ǂ255ȉ̂Ƃ wcstombs() 듮삵Ă悤ȋC
		if( uniSrc >= 0x7F )
		if( uniSrc <= 0xFF )
		{
			// ςȂ̂ɕϊĂꂿႤ̂ŁA߂
			size = (size_t)-1;
		}

		// ϊłȂ͕̂ɒ
		if ( size != (size_t)-1 )
		{
			memcpy( sjisDst+idxDst, mbstrDst, size );
			idxDst += size;
		}
		else
		{
			int		nColumn = UnicodeToEntityRef(
				uniSrc,
				sjisDst+idxDst
			);
			if ( nColumn > 0 )
			{
				idxDst += nColumn;
			}
			else
			{
				sjisDst[idxDst++] = '&';
				sjisDst[idxDst++] = '#';
				_itoa( uniSrc, sjisDst+idxDst, 10 );
				idxDst += strlen( sjisDst+idxDst );
				sjisDst[idxDst++] = ';';
			}
		}
	}

	sjisDst[idxDst] = 0x00;
	return( idxDst );
}


/*-----------------------------------------------------------------------------
[]	jR[h
[@\]	HTMLAłUNICODEԂB
[ߒl]	long oCg@[byte] (0:łȂA1`:)
[l]	10i\LA16i\LA̎QƂɑΉB
-----------------------------------------------------------------------------*/
long		CUnicoder::IsUnicode(
	const char*		pstrSrc,		// I:Ώە [-] (-) :-
	wchar_t*		pwcharUnicode	// O:Unicode [Unicode] (-) :-
)
{
	long	idxByte = 0;
	if ( m_bEnable )
	if ( pstrSrc[idxByte] == '&' )
	{
		idxByte++;

		if ( pstrSrc[idxByte] == '#' )
		{
			idxByte++;

			if ( pstrSrc[idxByte] == 'x' )
			{
				idxByte++;

				// 16i^Cv
				wchar_t	lCode = 0;
				while( TRUE )
				{
					char iByte = pstrSrc[idxByte];
					if ( iByte == ';' )
					{
						idxByte++;
						*pwcharUnicode = lCode;
						break;
					}
					else
					if( 'a'<=iByte && iByte<='f')
					{
						lCode = (USHORT)(lCode*16 + 10+iByte-'a');
						idxByte++;
					}
					else
					if( 'A'<=iByte && iByte<='F')
					{
						lCode = (USHORT)(lCode*16 + 10+iByte-'A');
						idxByte++;
					}
					else
					if( '0'<=iByte && iByte<='9')
					{
						lCode = (USHORT)(lCode*16 + iByte-'0');
						idxByte++;
					}
					else
					{
						idxByte = (USHORT)0;
						break;
					}
				}
				return( idxByte );
			}
			// 10i^Cv
			wchar_t	lCode = 0;
			while( TRUE )
			{
				char iByte = pstrSrc[idxByte];
				if ( iByte == ';' )
				{
					*pwcharUnicode = lCode;
					idxByte++;
					break;
				}
				else
				if( '0'<=iByte && iByte<='9')
				{
					lCode = (USHORT)(lCode*10 + iByte-'0');
					idxByte++;
				}
				else
				{
					idxByte = 0;
					break;
				}
			}
			return( idxByte );
		}
		// ̎Q
		int	nRef = sizeof(aEntitieRef)/sizeof(TEntitieRef);
		for( int idxRef=0 ; idxRef<nRef ; idxRef++ )
		{
			if ( memcmp(
				pstrSrc + idxByte,
				aEntitieRef[idxRef].pName,
				strlen( aEntitieRef[idxRef].pName )
			) == 0 )
			{
				if ( ';' == *(pstrSrc + idxByte + strlen( aEntitieRef[idxRef].pName )))
				{
					*pwcharUnicode = (USHORT)aEntitieRef[idxRef].uiCode; 
					idxByte += strlen( aEntitieRef[idxRef].pName ) + 1;
					return( idxByte );
				}
			}
		}
	}
	return( 0 );
}


/*-----------------------------------------------------------------------------
[]	`
[@\]	jR[h̕`B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CUnicoder::DrawCharCode(
	HDC				hdc,			//   O:o͐DC [-] (-) :-
	const RECT&		rcDst,			// I  :o͐` [pixel] (-) :-
	wchar_t			tCharCode		// I  :Unicode [-] (-) :-
)
{
	HFONT	hfon = GetFont( hdc, tCharCode );
	HFONT	hfonOld = (HFONT)::SelectObject( hdc, hfon );
	// ̕`
	::TextOutW(
		hdc,
		rcDst.left,
		rcDst.top,
		&tCharCode,
		1
	);

	::SelectObject( hdc, hfonOld );
}


/*-----------------------------------------------------------------------------
[]	gp`vZ
[@\]	jR[h`ɗv`TCY̎擾B
[ߒl]	CSize	Kv` [pixel] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
SIZE CUnicoder::ExtextCharCode(
	HDC				hdc,			//   O:o͐DC [-] (-) :-
	wchar_t			tCharCode		// I  :Unicode [-] (-) :-
)
{
	HFONT	hfonOld = (HFONT)::SelectObject( hdc, GetFont( hdc, tCharCode ) );
	SIZE	sizeExtent;
	::GetTextExtentPoint32W(
		hdc,
		&tCharCode,
		1,
		&sizeExtent
	);
	::SelectObject( hdc, hfonOld );

	return( sizeExtent );
}


/*-----------------------------------------------------------------------------
[]	tHg擾
[@\]	jR[h`ɗvtHg̎擾B
[ߒl]	CFont*	tHg [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
HFONT CUnicoder::GetFont(
	HDC			hdc,		//   O:o͐DC [-] (-) :-
	wchar_t		tCharCode	// I  :Unicode [-] (-) :-
)
{
	static	CLogFont	s_font;
	LPCTSTR	strDefaultFontName = _T("lr oSVbN");
	BYTE	iDefaultChaeSet = SHIFTJIS_CHARSET;

	for( long idxBlock=0 ; idxBlock<sizeof(atUnicodeFontDefine)/sizeof(TUnicodeFontDefine) ; idxBlock++ )
	{
		if (atUnicodeFontDefine[idxBlock].iStartCode <= (long)tCharCode )
		if (atUnicodeFontDefine[idxBlock].iEndCode >= (long)tCharCode )
		{
//			strcpy( s_font.m_strFontName, atUnicodeFontDefine[idxBlock].strFontName );
			s_font.m_strFontName = atUnicodeFontDefine[idxBlock].strFontName;
			s_font.m_nCharSet = atUnicodeFontDefine[idxBlock].iCharSet;
//			if ( s_font.m_strFontName[0] == 0x00 )
			if ( s_font.m_strFontName.IsEmpty() )
			{
			// tHĝݒ肳ĂȂ΃ftHgtHgɂ
//				strcpy( s_font.m_strFontName, strDefaultFontName );
				s_font.m_strFontName = strDefaultFontName;
				s_font.m_nCharSet = iDefaultChaeSet;
			}
			break;
		}
	}

	// `\łȂ΃ftHgtHgɂ
//	HFONT	font = s_font.GetFont( hdc );
	HFONT	font = (HFONT)*(s_font.GetFont( CDC::FromHandle( hdc ) ));
	if ( !IsDrawable( hdc, font, tCharCode ) )
	{
//		strcpy( s_font.m_strFontName, strDefaultFontName );
		s_font.m_strFontName = strDefaultFontName;
		s_font.m_nCharSet = iDefaultChaeSet;
	}

//	return( s_font.GetFont( hdc ) );
	return( *(s_font.GetFont( CDC::FromHandle( hdc ) ) ) );
}


/*-----------------------------------------------------------------------------
[]	BCX^X擾
[@\]	BCX^X̎擾B
[ߒl]	CUnicoder*	BCX^X [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
CUnicoder*	CUnicoder::GetInstance()
{
	static CUnicoder	Unicoder;
	return( &Unicoder );
}


/*-----------------------------------------------------------------------------
[]	UnicodeSJisϊij
[@\]	SJis̎擾B
[ߒl]	CString		ϊςݕ [SJis] (-)
[l]	SJis̒"?"ɊY镔UnicodeϊB
-----------------------------------------------------------------------------*/
long		CUnicoder::GetSJisString(
	const char*		pcstr,		// I  :SJis [-] (-)
	const wchar_t*	pwcstr,		// I  :Unicode [-] (-)
	char*			pDst
)
{
	long	nDstByte = GetSJisStringCore( pcstr, pwcstr, pDst );
	return( nDstByte );
}


/*-----------------------------------------------------------------------------
[]	UnicodeSJisϊ
[@\]	SJis̎擾B
[ߒl]	long	ϊςSJis [byte] (-)
[l]	SJis̒"?"ɊY镔UnicodeϊB
		ϊꂽHTMLŕ\B
-----------------------------------------------------------------------------*/
long	CUnicoder::GetSJisStringCore(
	const char*		pcstr,		// I  :SJis [-] (-)
	const wchar_t*	pwcstr,		// I  :Unicode [-] (-)
	char*			pDstBuffer	//   O:ϊςSJis [-] (-)
)
{
	// tc[UNICODEϊ܂
	// ϊ邱Ƃۂ̂ŁAKvȕϊĂ݂B

	long	nDstByte = 0;
	{
		// SJisPÂA"?"YUNICODEf[^ϊĂ݂
		long	idxUnicodeChar=0;
		while( *pcstr != 0x00 )
		{
			if( isleadbyte(*pcstr) != 0 )
			{
			// QoCg
				if( pDstBuffer != NULL )
				{
					memcpy( pDstBuffer+nDstByte, pcstr, 2 );
				}
				pcstr+=2;
				nDstByte+=2;
			}
			else
			if ( *pcstr == '?' )
			{
				// UnicodeH
				int			lenHTMLCharCode( 0 );
				if ( pDstBuffer != NULL )
				{
					lenHTMLCharCode = CUnicoder::UnicodeToSJIS(
						*(pwcstr+idxUnicodeChar),
						pDstBuffer+nDstByte
					);
				}
				else
				{
					char		strHTMLCharCode[HTMLCHARCODE_LENGTH];
					lenHTMLCharCode = CUnicoder::UnicodeToSJIS(
						*(pwcstr+idxUnicodeChar),
						strHTMLCharCode
					);
				}
				nDstByte += lenHTMLCharCode;
				pcstr++;
			}
			else
			{
				if( pDstBuffer != NULL )
				{
					*(pDstBuffer+nDstByte) = *pcstr;
				}
				nDstByte++;
				pcstr++;
			}
			idxUnicodeChar++;
		}
	}

	if( pDstBuffer != NULL )
	{
		pDstBuffer[nDstByte] = 0x00;
	}
	return( nDstByte );
}

/*-----------------------------------------------------------------------------
[]	Unicode̎QSJisϊ
[@\]	jR[h̎QƂɕϊB
[ߒl]	int		ϊςSJis [byte] (-)
[l]	ϊłȂΖ߂l0
-----------------------------------------------------------------------------*/
int		CUnicoder::UnicodeToEntityRef(
	const wchar_t	uniSrc,
	char*			sjisDst
)
{
	for( int idxItem=0 ; idxItem<sizeof(aEntitieRef)/sizeof(TEntitieRef) ; idxItem++ )
	{
		if ( aEntitieRef[idxItem].uiCode == uniSrc )
		{
			int	iLength = strlen( aEntitieRef[idxItem].pName );
			sjisDst[0] = '&';
			memcpy( sjisDst+1, aEntitieRef[idxItem].pName, iLength );
			sjisDst[ iLength+1 ] = ';';
			return( iLength+2 );
		}
	}
	return( 0 );
}

/*-----------------------------------------------------------------------------
[]	UnicodeSJisϊij
[@\]	SJis̎擾B
[ߒl]	CString		ϊςݕ [SJis] (-)
[l]	SJis̒"?"ɊY镔UnicodeϊB
-----------------------------------------------------------------------------*/
CString		CUnicoder::GetSJisString(
	const char*		pcstr,		// I  :SJis [-] (-)
	const wchar_t*	pwcstr		// I  :Unicode [-] (-)
)
{
	// ܂i[ɕKvȃoCg𓾂
	long	nDstByte = GetSJisStringCore( pcstr, pwcstr, NULL );

	// ϊςݕi[obt@p
	char*	pDstBuffer = new char[ nDstByte +1];

	// ϊ
	GetSJisStringCore( pcstr, pwcstr, pDstBuffer );
	pDstBuffer[nDstByte] = 0x00;

	// ꎞϐɃobt@eޔăobt@
	CString	strDst = pDstBuffer;
	delete [] pDstBuffer;

	return( strDst );
}


/*-----------------------------------------------------------------------------
[]	`\mF
[@\]	I𒆂̃tHgŕR[h`ł邩mFB
[ߒl]	BOOL	`s [-] (TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL	CUnicoder::IsDrawable(
	HDC			hdc,		// I  :ΏDC [-] (-) :-
	HFONT		font,		// I  :ΏۃtHg [-] (-) :-
	wchar_t		tCharCode	// I  :Unicode [-] (-) :-
)
{
	BOOL	bSupported( FALSE );

	// @\݂邩H
//  (3344) BGN 2004.06.07 (moralog) ֐̑ݔ@ύX
	GETFONTUNICODERENGES		pProc( NULL );
	pProc = s_pProcGETFONTUNICODERENGES;
/*
//  original BGN
typedef DWORD (WINAPI *GETFONTUNICODERENGES)(
		HDC,
		LPGLYPHSET
	);

	GETFONTUNICODERENGES		pProc( NULL );
	{
		static BOOL					s_bChecked( FALSE );
		static GETFONTUNICODERENGES	s_pProc( NULL );
		if ( !s_bChecked )
		{

			CString	strPathName = ::GetExePathName();
			CString	strFileName;
			strFileName.Format(
				"%s.%s",
				::FilenameFromPathName( strPathName ),
				::ExtFromPathName( strPathName )
			);
			s_pProc = (GETFONTUNICODERENGES)::GetProcAddress(
				::GetModuleHandle( strFileName ),
				_T( "GetFontUnicodeRanges" )
			);
			s_bChecked = TRUE;
		}
		pProc = s_pProc;
	}
//  original END
*/
//  (3344) END

	if ( pProc != NULL )
	{
		HFONT	fontOld = (HFONT)::SelectObject( hdc, font );

		// tHg̃T|[g𓾂
		GLYPHSET	tGlyphset;
		GLYPHSET*	pGlyphset = &tGlyphset;

		// W̃TCY𓾂
		int	sizeRangeBuffer = pProc(
			hdc,
			NULL
		);

		// Kvȑ傫̃obt@mۂăW擾
		int		size = sizeof(GLYPHSET) + sizeRangeBuffer;
		char*		pBuff = new char[size];
		memset( pBuff, 0x00, size );
		pGlyphset = (GLYPHSET*)pBuff;
		pGlyphset->cbThis = sizeof(GLYPHSET);
		pGlyphset->flAccel = 0;//GS_8BIT_INDICES;
//		pGlyphset->cGlyphsSupported;
		pGlyphset->cRanges = 0;
		pProc(
			hdc,
			pGlyphset
		);

		// v郌W{
		for( UINT idxRange=0 ; idxRange<pGlyphset->cRanges ; idxRange++ )
		{
			if ( pGlyphset->ranges[idxRange].wcLow <= tCharCode )
			if ( pGlyphset->ranges[idxRange].wcLow+pGlyphset->ranges[idxRange].cGlyphs > tCharCode )
			{
				// Wv̂ŕ`ł
				bSupported = TRUE;
				break;
			}
		}
		delete [] pBuff;

		::SelectObject( hdc, fontOld );
	}

	return( bSupported );
}


