/*-----------------------------------------------------------------------------
[]	SettingDlg.cpp
[Tv]	ݒ_CAONX̎
[l]	Ȃ
[]	2003-02-28	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Shitarabian.h"
#include "SettingDlg.h"
#include "GeneralSetting.h"
#include "SettingPath.h"
#include "ShitarabianDoc.h"
#include "ShitarabianView.h"
#include "ExeCommon.h"
#include "ShitarabianPlugInManager.h"
#include "MainFrm.h"
#include "EditDrawer.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CDialog::CDialog()̃wvQƁB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CSettingDlg::CSettingDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSettingDlg::IDD, pParent)
	, m_pGeneralSetting( NULL )
	, m_pDoc( NULL )
{
	//{{AFX_DATA_INIT(CSettingDlg)
	m_strSettingName = _T("");
	m_strExt = _T("");
	//}}AFX_DATA_INIT
}


/*-----------------------------------------------------------------------------
[]	f[^ϊ
[@\]	CDialog::DoDataExchange()̃wvQƁB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CSettingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSettingDlg)
	DDX_Control(pDX, IDC_SETTING_TAB, m_tabSheet);
	DDX_CBString(pDX, IDC_SETTING_SETTINGNAME, m_strSettingName);
	DDX_Text(pDX, IDC_SETTING_EXT, m_strExt);
	DDX_Control(pDX, IDC_SETTING_SETTINGNAME, m_comboSettingName);
	DDX_Control(pDX, IDC_SETTING_SAVE, m_btnSave);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSettingDlg, CDialog)
	//{{AFX_MSG_MAP(CSettingDlg)
	ON_BN_CLICKED(IDC_SETTING_SAVE, OnSettingSave)
	ON_CBN_EDITCHANGE(IDC_SETTING_SETTINGNAME, OnEditchangeSettingSettingname)
	ON_CBN_SELCHANGE(IDC_SETTING_SETTINGNAME, OnSelchangeSettingSettingname)
	ON_BN_CLICKED(IDC_SETTING_REFLECT, OnSettingReflect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/*-----------------------------------------------------------------------------
[]	nh
[@\]	_CAȌB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CSettingDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// ݂̐ݒꎞo
	m_pGeneralSetting->Write();
	CShitarabianPlugInManager::GetInstance()->OnSave( m_pDoc );

	// y[W̒ǉ
	m_tabSheet.InsertItem( TCIF_TEXT|TCIF_PARAM, 0, "\", 0, (LPARAM)&m_SettingViewDlg );
	m_tabSheet.InsertItem( TCIF_TEXT|TCIF_PARAM, 1, "\F", 0, (LPARAM)&m_SettingEmphasisDlg );
	m_tabSheet.InsertItem( TCIF_TEXT|TCIF_PARAM, 2, "󔒕", 0, (LPARAM)&m_SettingWhiteSpaceDlg );
	m_tabSheet.InsertItem( TCIF_TEXT|TCIF_PARAM, 3, "BOX\", 0, (LPARAM)&m_SettingBoxCharDlg );
	m_tabSheet.InsertItem( TCIF_TEXT|TCIF_PARAM, 4, "", 0, (LPARAM)&m_SettingPrintDlg );

	// eq_CAȌ
	CreatePagez();

	// V[g̃Rg[ݒ肵̂Łiݒ̗񋓂Ȃǁjǂݍ
	ReadFromGeneral();

	// Ƃ肠Py[Wڂ\
	m_SettingViewDlg.ShowWindow( SW_SHOW );
	PostMessage( WM_PAINT, 0, 0 );

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	          // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}


/*-----------------------------------------------------------------------------
[]	uݒۑv{^nh
[@\]	ݒ̕ۑB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CSettingDlg::OnSettingSave() 
{
	// Kp
	OnSettingReflect();

	if ( m_pGeneralSetting != NULL )
	{
		BOOL	bPrepare = 
		CSettingPath::GetInstance()->PrepareFolder(
			m_strSettingName
		);

		if ( bPrepare )
		{
			// ݒ̕ۑ
			m_pGeneralSetting->Write();

			// R{{bNX̏
			ReadFromGeneral();
		}
		else
		{
			::ErrorLog(
				"ݒt@C̕ۑs",
				"CSettingDlg::OnSettingSave()"
			);
		}

		// ݒtH_ɖ߂
		CSettingPath::GetInstance()->ResetGeneralFolder();
	}
}


/*-----------------------------------------------------------------------------
[]	ݒ薼̕ҏWύXnh
[@\]	R{{bNX̐ݒ薼̂̕ҏWɔ\B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CSettingDlg::OnEditchangeSettingSettingname()
{
	VisibleControl();
}


/*-----------------------------------------------------------------------------
[]	ݒύXnh
[@\]	R{{bNX̐ݒ薼̂̑IύXɔݒǂݍ݁B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CSettingDlg::OnSelchangeSettingSettingname() 
{
	int		idxCurItem = m_comboSettingName.GetCurSel();

	if ( idxCurItem != CB_ERR )
	if ( m_pGeneralSetting != NULL )
	{
		CString		str;
		m_comboSettingName.GetLBText(
			idxCurItem,
			str
		);
		// ݒtH_ύXă[h
		CSettingPath::GetInstance()->SetFolderIndex(
			idxCurItem
		);
		m_pGeneralSetting->Read();

		// vOCݒ̓ǂݍ
		CShitarabianPlugInManager::GetInstance()->OnLoad( m_pDoc );

		// _CAORg[̍Đݒ
		ReadFromGeneral();
		m_strSettingName = str;
		UpdateData( FALSE );

		// `č\z
		ReBuildView();

		// ĕ`
		m_pDoc->SetAllUpdate();
		m_pDoc->ReDraw();

		// ݒtH_ɖ߂
		CSettingPath::GetInstance()->ResetGeneralFolder();
	}

	// _CAO̍Đݒ
	DestroyPagez();
	CreatePagez();

	VisibleControl();
}


/*-----------------------------------------------------------------------------
[]	\
[@\]	{^EnaleB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CSettingDlg::VisibleControl()
{
	CString		strName;
	m_comboSettingName.GetWindowText( strName );
	m_btnSave.EnableWindow( !strName.IsEmpty() );
}


/*-----------------------------------------------------------------------------
[]	uCANCELvnh
[@\]	ۑꂽݒēxǂݍށB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CSettingDlg::OnCancel() 
{
	// oĂݒēxǂݍ
	m_pGeneralSetting->Read();
	CShitarabianPlugInManager::GetInstance()->OnLoad( m_pDoc );

	// `č\z
	ReBuildView();

	// ĕ`
	m_pDoc->SetAllUpdate();
	m_pDoc->ReDraw();

	CDialog::OnCancel();
}


/*-----------------------------------------------------------------------------
[]	ݒǂݍ
[@\]	ݒނR{{bNX֗񋓂B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CSettingDlg::ReadFromGeneral()
{
	m_strExt = m_pGeneralSetting->GetExt();

	{
	// ݒt@C̃tH_
	// R{{bNXɗ񋓂
		m_comboSettingName.ResetContent();
		int	idxFolder;
		for( idxFolder=0 ; idxFolder<CSettingPath::GetInstance()->Count() ; idxFolder++)
		{
			CString	str = CSettingPath::GetInstance()->GetFolderName(idxFolder);
			m_comboSettingName.AddString( str );
		}

		// R{{bNXɐݒ薼̂\
		m_strSettingName = m_pGeneralSetting->GetSettingName();
	}

	UpdateData( FALSE );
	VisibleControl();
}


/*-----------------------------------------------------------------------------
[]	Inh
[@\]	IB\[X̉B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CSettingDlg::DestroyWindow() 
{
	m_tabSheet.DeleteAllItems();

	DestroyPagez();
	
	return CDialog::DestroyWindow();
}


/*-----------------------------------------------------------------------------
[]	unjv{^nh
[@\]	ݒ̕ۑƔfB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CSettingDlg::OnOK() 
{
	OnSettingReflect();
	CDialog::OnOK();
}


/*-----------------------------------------------------------------------------
[]	uKpv{^nh
[@\]	ݒ̕ۑƔfB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CSettingDlg::OnSettingReflect()
{
	// _CAOOK
	m_SettingViewDlg.Confirm();
	m_SettingEmphasisDlg.Confirm();
	m_SettingWhiteSpaceDlg.Confirm();
	m_SettingBoxCharDlg.Confirm();
	m_SettingPrintDlg.Confirm();

	// _CAOݒ̔f
	{
		// Emphasis
		CGeneralSetting::GetInstance()->GetEmphasisDefine()->Copy( m_EmphasisDefine );
		CGeneralSetting::GetInstance()->GetEmphasisDefine()->MultiLineEmphasisStarterPrepare();

		// BoxChar
		CGeneralSetting::GetInstance()->GetBoxCharDefine()->Copy( *m_SettingBoxCharDlg.m_BoxCharList.GetDefine() );

		// ݒ̕ۑ
		UpdateData( TRUE );
		m_pGeneralSetting->SetExt( m_strExt );
		m_pGeneralSetting->SetSettingName( m_strSettingName );
		m_pGeneralSetting->Write();
	}

	// `č\z
	ReBuildView();

	// ĕ`
	m_pDoc->SetAllUpdate();
	m_pDoc->ReDraw();
}


/*-----------------------------------------------------------------------------
[]	y[W_CAO̔j
[@\]	eq_CAO̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CSettingDlg::DestroyPagez()
{
	m_SettingViewDlg.DestroyWindow();
	m_SettingEmphasisDlg.DestroyWindow();
	m_SettingWhiteSpaceDlg.DestroyWindow();
	m_SettingBoxCharDlg.DestroyWindow();
	m_SettingPrintDlg.DestroyWindow();
}


/*-----------------------------------------------------------------------------
[]	y[W_CAȌ
[@\]	eq_CAȌB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CSettingDlg::CreatePagez()
{
	// \ݒ
	m_SettingViewDlg.Create( IDD_SETTING_VIEW, &m_tabSheet );

	// \F
	m_EmphasisDefine.Copy( *CGeneralSetting::GetInstance()->GetEmphasisDefine() );
	m_SettingEmphasisDlg.Attach( &m_EmphasisDefine );
	m_SettingEmphasisDlg.Create( IDD_EMPHASIS, &m_tabSheet );

	// 󔒕
	m_SettingWhiteSpaceDlg.Create( IDD_BLANK, &m_tabSheet );

	// BOX\
	m_SettingBoxCharDlg.m_BoxCharList.GetDefine()->Copy( *CGeneralSetting::GetInstance()->GetBoxCharDefine() );
	m_SettingBoxCharDlg.Create( IDD_BOXCHAR, &m_tabSheet );

	// 
	m_SettingPrintDlg.Attach( CGeneralSetting::GetInstance()->GetPrintDefine() );
	m_SettingPrintDlg.Create( IDD_PRINT, &m_tabSheet );

	m_tabSheet.ReflectPagez();
}


/*-----------------------------------------------------------------------------
[]	ݒ񔽉f
[@\]	ݒViewɔfA\č\zB
[ߒl]	Ȃ
[l]	XN[ʒu𕜌B
-----------------------------------------------------------------------------*/
void CSettingDlg::ReBuildView()
{
	// ݒR{{bNXύX
	::GetMainFrame()->ResetSettingCombo();

	// \Ăŏs擾i\sʒû߁j
	long	lStartRow = m_pDoc->GetMainView()->VisibleRowStart();

	// DrawerɃtHgύXʒm
	CEditDrawer::GetInstance()->RecalcFontSize();

	// hLg\̍č\z
	m_pDoc->ReflectEmphasis();
	m_pDoc->AnalizeEmphasisLinez( 0, m_pDoc->GetLineCount()-1 );

	// \s𕜌
	{
		// XN[{bNXړ
		CPoint		ptScroll;
		ptScroll.y = CEditDrawer::GetInstance()->CaretRowToPixelZoomed( lStartRow );
		ptScroll.x = 0;

	// please! ׂĂVIewɓKpȂƂȂƎv
		m_pDoc->GetMainView()->SetDeviceScrollPosition( ptScroll );
	}
}
