// RgL
// EmphasisDefine.cpp: CEmphasisDefine NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Shitarabian.h"
#include "EmphasisDefine.h"
#include "Common.h"
#include "ExeCommon.h"
#include "SettingPath.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CEmphasisDefine::CEmphasisDefine()
:	m_bEnabled( TRUE )
,	m_aItemz()
,	m_bMultiLineEmphasisStarterPrepared( FALSE )
,	m_bMultiLineEmphasisStarterRegExpExist( FALSE )
,	m_bMultiLineEmphasisStarterNormalExist( FALSE )
{
// `ǉwb_̒萔`ύX邱
	CEmphasisItem	Item;

	// ʏ핶
	Item.SetPattern((CString)"ʏ̕");
	Item.SetForeColor( RGB(0,0,0) );
	Item.SetBackColor( RGB(255,255,255) );
	Item.SetEnableToggle( FALSE );
	m_aItemz.Add( Item );

	// I𕶎
	Item.SetPattern((CString)"I͈");
	Item.SetForeColor( RGB(255,255,255) );
	Item.SetBackColor( RGB(64,128,128) );
	Item.SetEnableToggle( FALSE );
	m_aItemz.Add( Item );

	// sԍ
	Item.SetPattern((CString)"sԍ");
	Item.SetForeColor( RGB(255,255,255) );
	Item.SetBackColor( RGB(0,0,0) );
	Item.SetEnableToggle( FALSE );
	m_aItemz.Add( Item );

	// }[Ns
	Item.SetPattern((CString)"}[Ns");
	Item.SetForeColor( RGB(255,255,255) );
	Item.SetBackColor( RGB(0,255,255) );
	Item.SetEnableToggle( FALSE );
	m_aItemz.Add( Item );

	// ҏWs
	Item.SetPattern((CString)"ҏWs");
	Item.SetForeColor( RGB(255,255,255) );
	Item.SetBackColor( RGB(128,128,128) );
	Item.SetEnableToggle( FALSE );
	m_aItemz.Add( Item );

	// [[
	Item.SetPattern((CString)"[[");
	Item.SetForeColor( RGB(255,255,255) );
	Item.SetBackColor( RGB(200,200,200) );
	Item.SetEnableToggle( FALSE );
	m_aItemz.Add( Item );

//  (3632) BGN 2003.12.28 (moralog) Lbgʒu\F`ǉ
	// Lbgʒu
	Item.SetPattern((CString)"Lbgʒu");
	Item.SetForeColor( RGB(255,255,255) );
	Item.SetBackColor( RGB(128,128,128) );
	Item.SetEnableToggle( FALSE );
	m_aItemz.Add( Item );
//  (3632) END

	// EOF
	Item.SetPattern((CString)"[EOF]");
	Item.SetForeColor( RGB(255,255,255) );
	Item.SetBackColor( RGB(128,128,128) );
	Item.SetEnableToggle( TRUE );
	m_aItemz.Add( Item );

	// s
	Item.SetPattern((CString)"s");
	Item.SetForeColor( RGB(128,128,128) );
	Item.SetBackColor( RGB(255,255,255) );
	Item.SetEnableToggle( TRUE );
	m_aItemz.Add( Item );

	// HIT
	Item.SetPattern((CString)"HIT");
	Item.SetForeColor( RGB(0,0,0) );
	Item.SetBackColor( RGB(255,255,0) );
	Item.SetEnableToggle( TRUE );
	m_aItemz.Add( Item );
}

CEmphasisDefine::~CEmphasisDefine()
{

}



BOOL	CEmphasisDefine::Write()
{
	try
	{
		CString		strFilename = CSettingPath::GetInstance()->GetFolderPath() + "emphasis.ini";
		CStdioFile	file( strFilename, CFile::modeCreate | CFile::modeWrite );

		// o[W̏
		CString		strVersion;
		strVersion.LoadString( IDS_RELEASE_VERSION );
		file.WriteString( strVersion + "\n" );

		// L
		file.WriteString( BoolToString( m_bEnabled ) + "\n" );

		int	idxChar;
		for( idxChar=0 ; idxChar<m_aItemz.GetSize() ; idxChar++ )
		{
			BOOL	bSuccess = m_aItemz[idxChar].Write( &file );
			if ( !bSuccess )
			{
				return( FALSE );
			}
		}

		return( TRUE );
	}
	catch( CFileException* e )
	{
		e->Delete();
		ErrorLog( "t@Co", "CEmphasisDefine::Write()" );
		return( FALSE );
	}
}



BOOL	CEmphasisDefine::Read()
{
	CString		strGeneralFilename = CSettingPath::GetInstance()->GetFolderPath() + "emphasis.ini";

	CFileStatus	status;
	BOOL	bExists = CFile::GetStatus( strGeneralFilename, status );
	if ( !bExists )
	{
		// t@Ĉ
		return( FALSE );
	}

	try
	{
		CStdioFile	file( strGeneralFilename, CFile::modeRead | CFile::shareDenyNone );

		BOOL	bSuccess = TRUE;

		// o[W̓ǂݍ
		CString		strVersion;
		bSuccess = file.ReadString( strVersion );
		if ( !bSuccess )
		{
			return( FALSE );
		}

		// L
		CString	strEnable;
		bSuccess = file.ReadString( strEnable );
		if ( !bSuccess )
		{
			return( FALSE );
		}
		m_bEnabled = StringToBool( strEnable );

		m_aItemz.RemoveAll();
		while( TRUE )
		{
			CEmphasisItem	Item;

			bSuccess = Item.Read( file );
			if ( !bSuccess )
			{
				break;
			}

			m_aItemz.Add( Item );
		}

//  (3632) BGN 2003.12.28 (moralog) o[WǗǉ
		// o[WǗ
		{
			long	lVersion = ::StringToVersion( strVersion );
			if ( lVersion <= 31228 )
			{
				// Lbgʒu\̒`Ȃ̂Œǉ
				CEmphasisItem	Item;
				Item.SetPattern((CString)"Lbgʒu");
				Item.SetForeColor( RGB(255,255,255) );
				Item.SetBackColor( RGB(128,128,128) );
				Item.SetEnableToggle( TRUE );
				m_aItemz.InsertAt( EMPHASIS_CARETPOSITION, Item );
			}
		}
//  (3632) END

		return( TRUE );
	}
	catch( CFileException* e )
	{
		e->Delete();
		ErrorLog( "t@C", "CEmphasisDefine::Read()" );
		return( FALSE );
	}

	return( TRUE );
}


void CEmphasisDefine::Copy( CEmphasisDefine& SrcDefine )
{
	m_bEnabled = SrcDefine.m_bEnabled;
	GetItemz().Copy( SrcDefine.GetItemz());	
}


void CEmphasisDefine::SetEnable( BOOL bEnabled )
{
	m_bEnabled = bEnabled; 
};



// s\̐K\łȂp^[݂邩
BOOL CEmphasisDefine::IsMultiLineEmphasisStarterNormalExist()
{
	if ( !m_bMultiLineEmphasisStarterPrepared )
	{
		MultiLineEmphasisStarterPrepare();
	}
	return( m_bMultiLineEmphasisStarterNormalExist );
}


// s\̐K\p^[iA݁j߂
CString& CEmphasisDefine::GetMultiLineEmphasisStarterRegExp()
{
	if ( !m_bMultiLineEmphasisStarterPrepared )
	{
		MultiLineEmphasisStarterPrepare();
	}
	return( m_strMultiLineEmphasisStarterRegExp );
}

// s\̃p^[o
void CEmphasisDefine::MultiLineEmphasisStarterPrepare()
{
	m_bMultiLineEmphasisStarterRegExpExist = FALSE;
	m_bMultiLineEmphasisStarterNormalExist = FALSE;
	m_strMultiLineEmphasisStarterRegExp.Empty();

	// \ݒ肩畡s\̂̂̂ݏ𒊏o
	int		idxEmphasis;
	CArray<CEmphasisItem, CEmphasisItem&>&	aEmphasisz = GetItemz();
	for( idxEmphasis=EMPHASIS_NEEDCOLORINGITEM ; idxEmphasis<aEmphasisz.GetSize() ; idxEmphasis++ )
	if( aEmphasisz[ idxEmphasis ].GetEnable() )					// `L
	if( !aEmphasisz[ idxEmphasis ].GetTerminator().IsEmpty() )	// I[ == s\
	{
		// K\̏ꍇAAp^[쐬Ă
		if ( aEmphasisz[ idxEmphasis ].GetFindCondition()->bRegExp )
		{
			CString	strPattern( aEmphasisz[ idxEmphasis ].GetPattern() );
			if( !strPattern.IsEmpty() )
			{
				if( !m_strMultiLineEmphasisStarterRegExp.IsEmpty() )
				{
					m_strMultiLineEmphasisStarterRegExp += "|";
				}
				CString	strTmp;
				strTmp.Format(
					"%s(%s)", m_strMultiLineEmphasisStarterRegExp,strPattern
				);
				m_strMultiLineEmphasisStarterRegExp = strTmp;

				m_bMultiLineEmphasisStarterRegExpExist = TRUE;
			}
		}
		else
		{
			// K\łȂꍇA݂ƂtÔݗĂĂ
			m_bMultiLineEmphasisStarterNormalExist = TRUE;
		}
	}

	m_bMultiLineEmphasisStarterPrepared = TRUE;
	return;
}