/*-----------------------------------------------------------------------------
[]	CommandCaret.cpp
[Tv]	LbgړR}hNX̎
[l]	Ȃ
[]	2003-02-26	NC		Rgt(moralog)
		2003-12-01	b031130 (3363)PageDownɃJ[\L[ŋI(dincom)
		2003-12-26  b031228 (3330)PageUp,Down̋(dincom)
-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Shitarabian.h"
#include "CommandCaret.h"
#include "ShitarabianDoc.h"
#include "EditDrawer.h"
#include "CommandMultiEdit.h"
#include "ShitarabianView.h"
#include "Unicoder.h"
#include "ExeCommon.h"
#include "CommandInput.h"
#include "CommandManager.h"
#include "Common.h"
#include "GeneralSetting.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//-----------------------------------------------------------------------------
// CCommandCaret 
//-----------------------------------------------------------------------------
/*
 ړ^Cv m_nType ɂāB
	E{I zL[iVK_xxxjB̏ꍇ͍W͖B
	E0x00 ̂ƂAW[Caret] m_idxRow A m_idxColumn LB

 ㉺̍sɈړƂ̂wW[Pixel]o@ɂāB
	EAJ[֐X^eBbNŕۑĂBîɖɂȂ肻ȗ\j
		uꏊviewƂO[oȂǂɂׂȁB
	EAJ[Wɋ߂ő̈ʒuIĂB
*/


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CCommandCaret::CCommandCaret()
:	m_nType( 0 )
,	m_idxRow( 0 )
,	m_idxColumn( 0 )
{

}


/*-----------------------------------------------------------------------------
[]	fXgN^
[@\]	CX^X̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CCommandCaret::~CCommandCaret()
{

}


/*-----------------------------------------------------------------------------
[]	
[@\]	VCX^X𐶐ĕB
[ߒl]	ICommand*	ꂽCX^Xւ̃|C^ [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
ICommand*	CCommandCaret::Duplicate()
{
	ICommand*	pcmdNew;

	pcmdNew = new CCommandCaret;
	pcmdNew->Copy( *this );

	return( pcmdNew );
}


/*-----------------------------------------------------------------------------
[]	Rs[
[@\]	Rs[B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void		CCommandCaret::Copy(
	ICommand&	cmdSrc			// I  :Rs[CX^X [-] (-) :-
)
{
	CCommandCaret*	pCaret;
	pCaret = dynamic_cast<CCommandCaret*>(&cmdSrc);

	if ( pCaret != NULL )
	{
		m_nType = pCaret->m_nType;			// ړ^Cv [zL[] (0x00:ڈړ)
		m_idxRow = pCaret->m_idxRow;		// ͂ꂽʒu [s] (-)
		m_idxColumn = pCaret->m_idxColumn;	// ͂ꂽʒu [] (-)
	}
	else
	{
		// قȂ^̃Rs[悤Ƃ
		ASSERT( FALSE );
	}
}


/*-----------------------------------------------------------------------------
[]	s
[@\]	LbgړR}hsB
[ߒl]	BOOL	 [-] (TURE:AFALSE:s)
[l]	SetAttribute()Ă邱ƁB
-----------------------------------------------------------------------------*/
BOOL		CCommandCaret::Execute(
	CShitarabianDoc* pDoc		// I  :ΏۃhLg [-] (-) :-
)
{
	CEditDrawer*		pDrawer = CEditDrawer::GetInstance();
	static long	lAnchorX = 0;	// ㉺ړƂ̃LbgʒuopW [Pixel] (-)
								// Lbg̈ړA̓͂ȂǂōXVA
								// ㉺ړ̂Ƃ͌ŒB
	if( pDoc == NULL )
	{
		return( FALSE );
	}

	BOOL		bAnchorUpdate = TRUE;

	long	idxRow = 0;
	long	idxColumn = 0;
	idxRow = pDoc->GetCaretRow();
	idxColumn = pDoc->GetCaretColumn();

	switch( m_nType )
	{
	case VK_LEFT:
		// 
		// }`JŃXLbvȂʒu܂ō֖߂
		for( idxColumn-- ; idxColumn>=0 ; idxColumn-- )
		{
			if ( idxColumn == pDoc->MultiColumnSkip( idxRow, idxColumn ) )
			{
				break;
			}
		}
		if ( idxColumn < 0 )
		{
			// ̍sցB
			if ( idxRow != 0 )
			{
				CString* pstrUpperLine = pDoc->GetLine( idxRow-1 );
				long	idxChar = ::ByteColumnToCaretColumn( *pstrUpperLine, pstrUpperLine->GetLength() );

				pDoc->SetCaretRow( idxRow-1 );
				pDoc->SetCaretColumn( idxChar );

				bAnchorUpdate = TRUE;
			}
			break;
		}

		pDoc->SetCaretColumn( idxColumn );
		break;

	case VK_RIGHT:
		// E
		{
			CEmphasisLine* pEmphasisLine = pDoc->GetEmphasisLine( idxRow );
			if ( idxColumn < pEmphasisLine->GetColumnCount() )
			{
				// słȂꍇA
				// }`JXLbvPJE
				idxColumn = pDoc->MultiColumnSkip( idxRow, idxColumn+1 );
				pDoc->SetCaretColumn( idxColumn );
			}
			else
			{
				// s̏ꍇA
				if ( CGeneralSetting::GetInstance()->GetFreeCursor() )
				{
				// t[J[\[ĥƂJǉ
					CCommandInput		cmdInput;
					CCommandManager*	pCmd = CCommandManager::GetInstance();

					CString		strPad = g_cstrBigBlank;
					// Jǉ
					cmdInput.SetAttribute( strPad, idxRow, idxColumn );
					cmdInput.Execute( pDoc );
					pCmd->Add( cmdInput );
				}
				else
				{
				// t[J[\łȂΉ̍s
					if ( idxRow < pDoc->GetLineCount()-1 )
					{
						pDoc->SetCaretRow( idxRow+1 );
						pDoc->SetCaretColumn( 0 );

						bAnchorUpdate = TRUE;
					}
				}
			}
		}
		break;

	case VK_UP:
		// 
		{
			long	lOldAnchorX = lAnchorX;
			if ( idxRow == 0 )
			if ( CGeneralSetting::GetInstance()->GetFreeCursor() )
			{
			// t[J[\[ĥƂsǉ
				CString		strAdd = pDoc->ReturnChar();

				// sǉ
				CCommandInput		cmdInput;
				CCommandManager*	pCmd = CCommandManager::GetInstance();
				cmdInput.SetAttribute( strAdd, 0, 0 );
				cmdInput.Execute( pDoc );
				pCmd->Add( cmdInput );

				lAnchorX = lOldAnchorX;
				idxRow++;
			}

			// ̍sցB
			if ( idxRow > 0 )
			{
				CString*	pstrUpperLine = pDoc->GetLine( idxRow-1 );
				if ( pstrUpperLine != NULL )
				{
					idxColumn = 0;
					CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( idxRow-1 );
					if ( pEmphasisLine != NULL )
					{
						if ( CGeneralSetting::GetInstance()->GetFreeCursor() )
						{
						// t[J[\[ĥƂJǉ
							pDoc->AppendColumn( idxRow-1, (lAnchorX)/pDrawer->GetZoom() );
						}

						idxColumn = pEmphasisLine->PixelToCaretColumnZoomed(
							lAnchorX
						);
					}
				}
				pDoc->SetCaretRow( idxRow-1 );
				pDoc->SetCaretColumn( idxColumn );

				bAnchorUpdate = FALSE;
			}
		}
		break;

	case VK_DOWN:
		// 
		{
			long	lOldAnchorX = lAnchorX;
			if ( CGeneralSetting::GetInstance()->GetFreeCursor() )
			{
			// t[J[\[ĥƂsǉ
				pDoc->AppendRow( idxRow+1 );
			}

			// ̍sցB
			if ( idxRow < pDoc->GetLineCount()-1 )
			{
				CString*	pstrLowerLine = pDoc->GetLine( idxRow+1 );
				if ( pstrLowerLine != NULL )
				{
					CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( idxRow+1 );
					idxColumn = 0;
					if ( pEmphasisLine != NULL )
					{
						if ( CGeneralSetting::GetInstance()->GetFreeCursor() )
						{
						// t[J[\[ĥƂJǉ
							pDoc->AppendColumn( idxRow+1, (lOldAnchorX)/pDrawer->GetZoom() );
						}

						idxColumn = pEmphasisLine->PixelToCaretColumnZoomed(
							lOldAnchorX
						);
					}
				}
				pDoc->SetCaretRow( idxRow+1 );
				pDoc->SetCaretColumn( idxColumn );

				bAnchorUpdate = FALSE;
			}
		}
		break;

	case VK_HOME:
		// s̐擪
		pDoc->SetCaretColumn( 0 );
		bAnchorUpdate = TRUE;
		break;

	case VK_END:
		// s
		{
			CString* pstrCurrentLine = pDoc->GetLine( idxRow );
			long	idxChar = ::ByteColumnToCaretColumn( *pstrCurrentLine, pstrCurrentLine->GetLength() );
			pDoc->SetCaretColumn( idxChar );
			bAnchorUpdate = TRUE;
		}
		break;

	case VK_PRIOR:
		{
			// XN[Kv
			BOOL	bScroll;
			int		iVisibleStartRow = 0;

			//  (3330) BGN 2003.12.26 (dincom) 
			// T߃XN[@\ONȂΈxʒ[ɔ΂
			if ( CGeneralSetting::GetInstance()->GetRestrainedScroll() )
			{
				// T߃XN[@\ONȂ̂ŉʒ[łȂƂ̓XN[Ȃ
				iVisibleStartRow += pDoc->GetMainView()->VisibleRowStart();
				bScroll = ( pDoc->GetCaretRow() <= iVisibleStartRow );
			}
			else
			{
				// T߃XN[@\OFFȂ̂ŏɃXN[
				bScroll = TRUE;
			}
				//  Original BGN
				//iVisibleStartRow += pDoc->GetMainView()-	>VisibleRowStart();
				//bScroll = ( pDoc->GetCaretRow() <= iVisibleStartRow );
				//  Original END
			//  (3330) END

			if ( bScroll )
			{
			// Lbgʓ[̂ƂAy[WXN[
				CCommandMultiEdit	cmdEdit;

				//  (3330) BGN 2003.12.26 (dincom) 
				int	nSkipRow = pDoc->GetMainView()->VisibleRowCount() + pDoc->GetCaretRow() - pDoc->GetMainView()->VisibleRowStart();
				for( int idxLine=0 ; idxLine<nSkipRow ; idxLine++ )
				//  Original BGN
				//for( int idxLine=0 ; idxLine<pDoc->GetMainView()->VisibleRowCount() ; idxLine++ )
				//  Original END
				//  (3330) END
				{
					CCommandCaret	cmdCaret;
					cmdCaret.SetAttribute( VK_UP, idxRow, idxColumn );
					cmdEdit.Add( cmdCaret );
				}
				cmdEdit.Execute( pDoc );
			}
			else
			{
			// ʏ[ɃLbgړ
				pDoc->SetCaretRow( iVisibleStartRow );
			}
		}
		break;

	case VK_NEXT:
		{
			// XN[Kv
			BOOL	bScroll;
			int		iVisibleLastRow = 0;

			//  (3330) BGN 2003.12.26 (dincom) 
			// T߃XN[@\ONȂΈxʒ[ɔ΂
			if ( CGeneralSetting::GetInstance()->GetRestrainedScroll() )
			{
				// T߃XN[@\ONȂ̂ŉʒ[łȂƂ̓XN[Ȃ
				iVisibleLastRow += pDoc->GetMainView()->VisibleRowStart();
				iVisibleLastRow += pDoc->GetMainView()->VisibleRowCount()-1;
				bScroll = ( pDoc->GetCaretRow() >= iVisibleLastRow );
			}
			else
			{
				// T߃XN[@\OFFȂ̂ŏɃXN[
				bScroll = TRUE;
			}
				//  Original BGN
				//iVisibleLastRow += pDoc->GetMainView()->VisibleRowStart();
				//iVisibleLastRow += pDoc->GetMainView()->VisibleRowCount()-1;
				//bScroll = ( pDoc->GetCaretRow() >= iVisibleLastRow );
				//  Original END
			//  (3330) END

			if ( bScroll )
			{
			// XN[
				CCommandMultiEdit	cmdEdit;

				//  (3330) BGN 2003.12.26 (dincom) 
				int	nSkipRow = pDoc->GetMainView()->VisibleRowCount()*2 - ( pDoc->GetCaretRow() - pDoc->GetMainView()->VisibleRowStart() );
				for( int idxLine=0 ; idxLine<nSkipRow ; idxLine++ )
				//  Original BGN
				//for( int idxLine=0 ; idxLine<pDoc->GetMainView()->VisibleRowCount() ; idxLine++ )
				//  Original END
				//  (3330) END
				{
					CCommandCaret	cmdCaret;
					cmdCaret.SetAttribute( VK_DOWN, idxRow, idxColumn );
					cmdEdit.Add( cmdCaret );
				}
				cmdEdit.Execute( pDoc );
			}
			else
			{
			// ʉ[ɃLbgړ
			//  Original BGN
			//	pDoc->SetCaretRow( iVisibleLastRow );
			//  Original END

				//  (3363) BGN 2003.12.01 (dincom) 
				iVisibleLastRow = min( iVisibleLastRow, pDoc->GetLineCount()-1 );
				pDoc->SetCaretRow( iVisibleLastRow );
				//  (3363) END
			}
		}
		break;

	default:
		// wW[Caret]
		pDoc->SetCaretRow( m_idxRow );
		pDoc->SetCaretColumn( m_idxColumn );
		break;
	}

	if( pDoc->GetCaretRow() != 0 )
	{
	// }`J̓ɃLbĝ\邽
	// Lbgʒu𒲐߂
		pDoc->SetCaretColumn( pDoc->MultiColumnSkip(
			pDoc->GetCaretRow(),
			pDoc->GetCaretColumn()
			)
		);
	}

	// AJ[i㉺ړ̈ʒu␳pWj̐ݒ
	if ( bAnchorUpdate )
	{
		lAnchorX = 0;
		CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( pDoc->GetCaretRow() );
		if ( pEmphasisLine != NULL )
		{
			lAnchorX = pEmphasisLine->CaretColumnToPixelZoomed(
				pDoc->GetCaretColumn()
			);
		}
	}

	if ( idxRow == pDoc->GetCaretRow() )
	if ( idxColumn == pDoc->GetCaretColumn() )
	{
		return( FALSE );
	}
	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	
[@\]	LbgړR}hB
[ߒl]	BOOL	 [-] (TURE:AFALSE:s)
[l]	KvȂ̂ŁAȂƂB
-----------------------------------------------------------------------------*/
BOOL		CCommandCaret::UnExecute(
	CShitarabianDoc* pDoc		// I  :ΏۃhLg [-] (-) :-
)
{
	// warning C4100:x̖
	pDoc;

	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	ݒ
[@\]	CX^X̑ݒ肷B
[ߒl]	Ȃ
[l]	Execute()OɕKsĂƁB
-----------------------------------------------------------------------------*/
void		CCommandCaret::SetAttribute(
	char		nType,			// I  :ړ^Cv [zL[] (0x00:ڈړ) :-
	long		idxRow,			// I  :͂ꂽʒu [s] (-) :-
	long		idxColumn		// I  :͂ꂽʒu [] (-) :-
)
{
	m_nType = nType;			// ړ^Cv [zL[] (0x00:ڈړ)
	m_idxRow = idxRow;			// ͂ꂽʒu [s] (-)
	m_idxColumn = idxColumn;	// ͂ꂽʒu [] (-)
}


