/*-----------------------------------------------------------------------------
[]	CharPaletteCanvasDlg.cpp
[Tv]	pbg^uy[WNX̎
[l]	Ȃ
[]	2003-04-22	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
// CN[hEsS`
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "shitarabian.h"
#include "ExeStruct.h"
#include "GeneralSetting.h"
#include "CharPaletteCanvasDlg.h"
#include "CharPaletteDlg.h"
#include "CharPalette.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CCharPaletteCanvasDlg::CCharPaletteCanvasDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCharPaletteCanvasDlg::IDD, pParent)
	, m_sizeButton( 40, 40 )
	, m_nColumn( 1 )
	, m_nRow( 1 )
	, m_eScrollBarAlign( ScrollBarAlignBottom )
	, m_idxCellSelect( 0 )
	, m_idxTab( 0 )
	, m_bEdit( FALSE )
{
	//{{AFX_DATA_INIT(CCharPaletteCanvasDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


/*-----------------------------------------------------------------------------
[]	f[^ϊ
[@\]	CDialog::DoDataExchange() ̃wvQƁB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCharPaletteCanvasDlg)
	DDX_Control(pDX, IDC_CHARPALETTEEDIT, m_editChar);
	DDX_Control(pDX, IDC_CHARPALETTE_CANVAS, m_Canvas);
	DDX_Control(pDX, IDC_CHARPALETTECANVAS_VSCROLL, m_VScroll);
	DDX_Control(pDX, IDC_CHARPALETTECANVAS_HSCROLL, m_HScroll);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCharPaletteCanvasDlg, CDialog)
	//{{AFX_MSG_MAP(CCharPaletteCanvasDlg)
	ON_WM_SIZE()
	ON_WM_DRAWITEM()
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_COMMAND(IDM_CHARPALETTE_INSERTCELL, OnCharpaletteInsertcell)
	ON_COMMAND(IDM_CHARPALETTE_EDITCELL, OnCharpaletteEditcell)
	ON_COMMAND(IDM_CHARPALETTE_DELETECELL, OnCharpaletteDeletecell)
	ON_EN_KILLFOCUS(IDC_CHARPALETTEEDIT, OnKillfocusCharpaletteedit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/*-----------------------------------------------------------------------------
[]	nh
[@\]	B
[ߒl]	CDialog::OnInitDialog()̃wvQƁB
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CCharPaletteCanvasDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// ҏWpGfBbg{bNXƂ肠B
	m_editChar.ShowWindow( SW_HIDE );
/*
	m_Canvas.SetWindowPos(
		0,10,10,
		10,10,
		SWP_NOZORDER|SWP_NOMOVE
	);
*/
	// Rg[̔zu
	RePositionControl();

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

/*-----------------------------------------------------------------------------
[]	TCYύXnh
[@\]	Rg[̍ĔzuB
[ߒl]	Ȃ
[l]	CDislog::OnSize()̃wvQƁB
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::OnSize(UINT nType, int cx, int cy) 
{
	if ( ::IsWindow( m_Canvas.m_hWnd ) )
	{
		ReflectSize( cx, cy );
	}

	CDialog::OnSize(nType, cx, cy);
}

/*-----------------------------------------------------------------------------
[]	TCYύX
[@\]	Rg[̍ĔzuB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::ReflectSize(
	int cx,		// _CAOy[W̕ [pixel] (-) :-
	int cy		// _CAOy[W̍ [pixel] (-) :-
)
{
	m_sizeButton.cx = max( 1, m_sizeButton.cx );
	m_sizeButton.cy = max( 1, m_sizeButton.cy );

	if ( ::IsWindow( m_Canvas.m_hWnd ) )
	{
		CStringArray*	pastrCharz = GetCharz();

		CRect	rcVScroll;
		CRect	rcHScroll;
		m_VScroll.GetWindowRect( &rcVScroll );
		m_HScroll.GetWindowRect( &rcHScroll );

		CRect	rcClient;
		GetClientRect( & rcClient );

		// Rg[ʒǔvZ
		CRect	rcCanvas( rcClient );
		CPoint	ptVScroll( 0, 0 );
		CPoint	ptHScroll( 0, 0 );
		switch ( m_eScrollBarAlign )
		{
		case ScrollBarAlignTop:
			rcCanvas.top = rcHScroll.Height();
			ptHScroll.x = 0;
			ptHScroll.y = 0;
			m_HScroll.ShowWindow( SW_SHOW );
			m_VScroll.ShowWindow( SW_HIDE );
			break;

		case ScrollBarAlignBottom:
			rcCanvas.bottom = rcCanvas.Height() - rcHScroll.Height();
			ptHScroll.x = 0;
			ptHScroll.y = rcCanvas.bottom;
			m_HScroll.ShowWindow( SW_SHOW );
			m_VScroll.ShowWindow( SW_HIDE );
			break;

		case ScrollBarAlignLeft:
			rcCanvas.left = rcVScroll.Width();
			ptVScroll.x = 0;
			ptVScroll.y = 0;
			m_HScroll.ShowWindow( SW_HIDE );
			m_VScroll.ShowWindow( SW_SHOW );
			break;

		case ScrollBarAlignRight:
			rcCanvas.right =  rcCanvas.Width() - rcVScroll.Width();
			ptVScroll.x = rcCanvas.right;
			ptVScroll.y = 0;
			m_HScroll.ShowWindow( SW_HIDE );
			m_VScroll.ShowWindow( SW_SHOW );
			break;

		default:
			break;
		}

		// LoX̔zu
		m_Canvas.SetWindowPos(
			NULL,
			rcCanvas.left,
			rcCanvas.top,
			rcCanvas.Width(),//rcClient.Width(),
			rcCanvas.Height(),//rcClient.Height(),
			SWP_NOZORDER
		);

		// XN[o[̔zu
		m_VScroll.SetWindowPos(
			NULL,
			ptVScroll.x,
			ptVScroll.y,
			rcVScroll.Width(),
			cy,
			SWP_NOZORDER
		);

		// XN[o[̔zu
		m_HScroll.SetWindowPos(
			NULL,
			ptHScroll.x,
			ptHScroll.y,
			cx,
			rcHScroll.Height(),
			SWP_NOZORDER
		);

		// {IɃXN[ȂӂɉĔzuB
		// XN[ӂɂ݂͂
		switch ( m_eScrollBarAlign )
		{
		case ScrollBarAlignTop:
		case ScrollBarAlignBottom:
			// XN[Ȃ̂Ŋ{Iɏcɔzu
			m_nRow = ( cy - rcHScroll.Height() ) / m_sizeButton.cy;
			m_nRow = max( m_nRow, 1 );
			m_nColumn = ( pastrCharz->GetSize() + m_nRow -1 ) / m_nRow;
			break;

		case ScrollBarAlignLeft:
		case ScrollBarAlignRight:
			// cXN[Ȃ̂Ŋ{Iɉɔzu
			m_nColumn = ( cx - rcVScroll.Width() ) / m_sizeButton.cx;
			m_nColumn = max( m_nColumn, 1 );
			m_nRow = ( pastrCharz->GetSize() + m_nColumn -1 ) / m_nColumn;
			break;

		default:
			break;
		}

		SCROLLINFO	tHInfo;
		tHInfo.cbSize = sizeof( tHInfo ); 
		tHInfo.fMask = SIF_ALL; 
		tHInfo.nMin = 0;
		tHInfo.nMax = (m_nColumn-(cx/m_sizeButton.cx)) * m_sizeButton.cx; 
		tHInfo.nPage = 1;
		tHInfo.nPos = 0;
		tHInfo.nTrackPos = 1; 
		m_HScroll.SetScrollInfo( &tHInfo );

		SCROLLINFO	tVInfo;
		tVInfo.cbSize = sizeof( tVInfo ); 
		tVInfo.fMask = SIF_ALL; 
		tVInfo.nMin = 0;
		tVInfo.nMax = (m_nRow-(cy/m_sizeButton.cy)) * m_sizeButton.cy; 
		tVInfo.nPage = 1;
		tVInfo.nPos = 0;
		tVInfo.nTrackPos = 1; 
		m_VScroll.SetScrollInfo( &tVInfo );
	}
}

/*-----------------------------------------------------------------------------
[]	`nh
[@\]	ZQ̕`揈B
[ߒl]	Ȃ
[l]	CDialog::OnDrawItem()̃wvQƁB
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
//  ([jO) BGN 2003.12.29 (moralog) warning C4100
	// warning C4100 
	nIDCtl;
	lpDrawItemStruct;
//  ([jO) END

	Redraw();
}

/*-----------------------------------------------------------------------------
[]	`揈
[@\]	ZQ̕`揈B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::Redraw()
{
	for( long idxRow=0 ; idxRow<=m_nRow ; idxRow++ )
	{
		for( long idxColumn=0 ; idxColumn<=m_nColumn ; idxColumn++ )
		{
			if ( !DrawCell( idxRow, idxColumn ) )
			{
				;//break;
			}
		}
	}
}

/*-----------------------------------------------------------------------------
[]	sJZԍ
[@\]	sƃJYZԍ擾B
[ߒl]	long		Zԍ [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
long CCharPaletteCanvasDlg::RowColumnToCellIndex(
	long	idxRow,		// I  : s [-] (-) :-
	long	idxColumn	// I  : J [-] (-) :-
)
{
	long idxChar = 0;
	switch ( m_eScrollBarAlign )
	{
	case ScrollBarAlignTop:
	case ScrollBarAlignBottom:
		// XN[̂ƂAc̍͌Œ
		idxChar = m_nRow*idxColumn+idxRow;
		break;

	case ScrollBarAlignLeft:
	case ScrollBarAlignRight:
		idxChar = idxRow*m_nColumn+idxColumn;
		break;

	default:
		break;
	}
	return( idxChar );
}

/*-----------------------------------------------------------------------------
[]	ZԍsJ
[@\]	ZԍYsƃJ擾B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::CellIndexToRowColumn(
	long	idxChar,			// I  : Zԍ [-] (-) :-
	long*	pidxRow,			//   O: s [-] (-) :-
	long*	pidxColumn			//   O: J [-] (-) :-
)
{
	switch ( m_eScrollBarAlign )
	{
	case ScrollBarAlignTop:
	case ScrollBarAlignBottom:
		// XN[̂ƂAc̍͌Œ
		*pidxColumn = idxChar/m_nRow;
		*pidxRow = idxChar - (*pidxColumn*m_nRow);
		break;

	case ScrollBarAlignLeft:
	case ScrollBarAlignRight:
		*pidxRow = idxChar/m_nColumn;
		*pidxColumn = idxChar - (*pidxRow*m_nColumn);
		break;

	default:
		ASSERT( FALSE );
		break;
	}
}

/*-----------------------------------------------------------------------------
[]	ZԍsJ
[@\]	ZԍYsƃJ擾B
[ߒl]	BOOL		TRUE
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CCharPaletteCanvasDlg::DrawCell(
	long	idxRow,		// I  : s [-] (-) :-
	long	idxColumn	// I  : J [-] (-) :-
)
{
	CStringArray*	pastrCharz = GetCharz();
	CClientDC dc( &m_Canvas );

	CRect	rcClient;
	m_Canvas.GetClientRect( &rcClient );

	// [W̐ݒ
	CRgn		rgn;
	rgn.CreateRectRgn( 0, 0, rcClient.Width(), rcClient.Height() );
	dc.SelectObject( rgn );
	CPen*	pOldPen = (CPen*)dc.SelectStockObject( BLACK_PEN );


	// XN[ʒuɑΉ}bsOɕύX
	{
		int	iXOffset = 0;
		int	iYOffset = 0;
		switch ( m_eScrollBarAlign )
		{
		case ScrollBarAlignTop:
		case ScrollBarAlignBottom:
			// XN[
			iXOffset = m_HScroll.GetScrollPos();
			break;

		case ScrollBarAlignLeft:
		case ScrollBarAlignRight:
			iYOffset = m_VScroll.GetScrollPos();
			break;

		default:
			ASSERT( FALSE );
			break;
		}
		dc.SetViewportOrg(
			-iXOffset,
			-iYOffset
		);
	}

	// Z`
	{
		COLORREF	colBack = RGB( 255, 255, 255 );
		COLORREF	colSelect = RGB( 200, 200, 255 );

		// Zo
		long idxChar = RowColumnToCellIndex( idxRow, idxColumn );
		if ( idxChar == m_idxCellSelect )
		{
			colBack = colSelect;
		}

		// ZʒǔvZ
		CRect	rcCell(
			idxColumn * m_sizeButton.cx,
			idxRow * m_sizeButton.cy,
			idxColumn * m_sizeButton.cx + m_sizeButton.cx -1,
			idxRow * m_sizeButton.cy + m_sizeButton.cy -1
		);

		// LN^̂ȂZ`
		{
			BOOL	bValid = TRUE;
			bValid &= ( idxChar < pastrCharz->GetSize() );
			bValid &= ( idxRow < m_nRow );
			bValid &= ( idxColumn < m_nColumn );
			if( !bValid )
			{
				dc.FillSolidRect(
					rcCell.left,
					rcCell.top,
					rcCell.Width()+1,
					rcCell.Height()+1,
					GetSysColor( COLOR_3DFACE )
				);
				// A
				return( FALSE );
			}
		}

		// ʏZ̕`
		{
			dc.FillSolidRect(
				rcCell.left+1,
				rcCell.top+1,
				rcCell.Width()-1,
				rcCell.Height()-1,
				colBack
			);

			// LN^̕`
			{
				CLogFont	Font;
				CFont*	pfonOld = dc.SelectObject( Font.GetFont(&dc) );
				dc.DrawText(
					pastrCharz->GetAt( idxChar ),
					rcCell,
					DT_CENTER|DT_VCENTER|DT_NOPREFIX|DT_SINGLELINE
				);
				dc.SelectObject( pfonOld );
			}

			dc.MoveTo(
				rcCell.left,
				rcCell.top
			);
			dc.LineTo(
				rcCell.left,
				rcCell.bottom
			);
			dc.LineTo(
				rcCell.right,
				rcCell.bottom
			);
			dc.LineTo(
				rcCell.right,
				rcCell.top
			);
			dc.LineTo(
				rcCell.left,
				rcCell.top
			);
		}
	}

	dc.SelectObject( pOldPen );

	dc.SetViewportOrg( 0, 0 );
	return( TRUE );
}

/*-----------------------------------------------------------------------------
[]	XN[o[zuݒ
[@\]	XN[o[̔zuύXB
[ߒl]	Ȃ
[l]	RePositionControl() ȂƔfȂB
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::SetScrollBarAlign(
	EScrollBarAlign eAlign		// I  : zu [-] (-) :-
)
{
	m_eScrollBarAlign = eAlign;
}

/*-----------------------------------------------------------------------------
[]	WZ擾
[@\]	NCAgWZʒu擾
[ߒl]	long		Zԍ [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
long CCharPaletteCanvasDlg::PointToCell(
	CPoint		ptCursor,		// I  : J[\ʒu [NCAgW] (-) :-
	long*		pRow,			//   O: s [-] (-) :-
	long*		pColumn			//   O: J [-] (-) :-
)
{
	// XN[ʒuɑΉ}bsOӎ
	int	iXOffset = 0;
	int	iYOffset = 0;
	{
		switch ( m_eScrollBarAlign )
		{
		case ScrollBarAlignTop:
		case ScrollBarAlignBottom:
			// XN[
			iXOffset = m_HScroll.GetScrollPos();
			break;

		case ScrollBarAlignLeft:
		case ScrollBarAlignRight:
			iYOffset = m_VScroll.GetScrollPos();
			break;

		default:
			ASSERT( FALSE );
			break;
		}
	}

	// ꂽZ
	m_Canvas.ScreenToClient( &ptCursor );
	*pColumn = (ptCursor.x+iXOffset) / m_sizeButton.cx;
	*pRow = (ptCursor.y+iYOffset) / m_sizeButton.cy;
	long	idxChar = RowColumnToCellIndex( *pRow, *pColumn );
	return( idxChar );
}

/*-----------------------------------------------------------------------------
[]	ZԍW擾
[@\]	ZԍɊYW𓾂B
[ߒl]	long		Zԍ [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
CRect CCharPaletteCanvasDlg::CellToRect(
	long		idxCell		// I  : Zԍ [-] (-) :-
)
{
	CRect	rc;

	// XN[ʒuɑΉ}bsOӎ
	int	iXOffset = 0;
	int	iYOffset = 0;
	{
		switch ( m_eScrollBarAlign )
		{
		case ScrollBarAlignTop:
		case ScrollBarAlignBottom:
			// XN[
			iXOffset = m_HScroll.GetScrollPos();
			rc.left = (idxCell/m_nRow);
			rc.top = idxCell-(rc.left*m_nRow);
			break;

		case ScrollBarAlignLeft:
		case ScrollBarAlignRight:
			iYOffset = m_VScroll.GetScrollPos();
			rc.top = (idxCell/m_nColumn);
			rc.left = idxCell - (rc.top*m_nColumn);
			break;

		default:
			ASSERT( FALSE );
			break;
		}
	}

	// LoXʒuɉčW𒲐
	rc.top *= m_sizeButton.cy;
	rc.left *= m_sizeButton.cx;

	CRect	rcClient;
	m_Canvas.GetWindowRect( &rcClient );
	ScreenToClient( &rcClient );
	rc.top += rcClient.top;
	rc.left += rcClient.left;

	rc.bottom = rc.top + m_sizeButton.cy;
	rc.right = rc.left + m_sizeButton.cx;
	return( rc );
}


/*-----------------------------------------------------------------------------
[]	bZ[Wnh
[@\]	L[͏B
[ߒl]	BOOL
[l]	CDialog::PreTranslateMessage()̃wvQƁB
-----------------------------------------------------------------------------*/
BOOL CCharPaletteCanvasDlg::PreTranslateMessage(MSG* pMsg) 
{
	CStringArray*	pastrCharz = GetCharz();

	// L[͂̃Cxg
	if ( m_bEdit )
	if ( GetFocus() == &m_editChar )
	{
	// ҏW[h
		switch( pMsg->message )
		{
		case WM_KEYDOWN:
			switch( pMsg->wParam )
			{
			case VK_RETURN:
				OnKillfocusCharpaletteedit();
				return( TRUE );
				break;

			case VK_ESCAPE:
				m_editChar.SetWindowText( pastrCharz->GetAt(m_idxCellSelect) );
				OnKillfocusCharpaletteedit();
				return( TRUE );
				break;

			default:
				break;
			}
			break;

		default:
			break;
		}
	}

	if ( !m_bEdit )
	if ( pMsg->message == WM_RBUTTONDOWN )
	if ( pMsg->hwnd == m_Canvas.m_hWnd )
	{
		// NbNʒȗI
		long	iNewRow;
		long	iNewColumn;
		long	idxChar;
		idxChar = PointToCell(
			pMsg->pt,
			&iNewRow,
			&iNewColumn
		);
		if ( iNewColumn < m_nColumn )
		if ( iNewRow < m_nRow )
		if ( idxChar < pastrCharz->GetSize() )
		{
			long	iOldColumn;
			long	iOldRow;
			long	idxOldChar = m_idxCellSelect;
			m_idxCellSelect = idxChar;
			CellIndexToRowColumn( idxOldChar, &iOldRow, &iOldColumn );

			// Z̕`iIԂ̔fj
			DrawCell( iOldRow, iOldColumn );
			DrawCell( iNewRow, iNewColumn );
		}

		// |bvAbvj[̕\
		{
			// j[̃[h
			CMenu menu;
			VERIFY(menu.LoadMenu(IDR_CHARPALETTE));

			// |bvAbvƂĕ\Tuj[o
			CMenu* pPopup = menu.GetSubMenu( 1 );
			ASSERT(pPopup != NULL);

			// ҏWE폜̗L
			BOOL	bExist = ( m_idxCellSelect < pastrCharz->GetSize() );
			pPopup->EnableMenuItem( IDM_CHARPALETTE_EDITCELL, MF_BYCOMMAND | bExist?MF_ENABLED:MF_GRAYED );
			pPopup->EnableMenuItem( IDM_CHARPALETTE_DELETECELL, MF_BYCOMMAND | bExist?MF_ENABLED:MF_GRAYED );

			// |bvAbvj[̕\
			CPoint	ptCursor;
			::GetCursorPos( &ptCursor );
			pPopup->TrackPopupMenu(
				TPM_LEFTALIGN | TPM_RIGHTBUTTON,
				ptCursor.x, ptCursor.y,
				this
			);
		}
		return( TRUE );
	}

	if ( !m_bEdit )
	if ( pMsg->message == WM_LBUTTONDOWN )
	if ( pMsg->hwnd == m_Canvas.m_hWnd )
	{
		long	iNewRow;
		long	iNewColumn;
		long	idxChar;
		idxChar = PointToCell(
			pMsg->pt,
			&iNewRow,
			&iNewColumn
		);

		// Z
		if ( iNewColumn < m_nColumn )
		if ( iNewRow < m_nRow )
		if ( idxChar < pastrCharz->GetSize() )
		{
			long	iOldColumn;
			long	iOldRow;
			long	idxOldChar = m_idxCellSelect;
			m_idxCellSelect = idxChar;
			CellIndexToRowColumn( idxOldChar, &iOldRow, &iOldColumn );

			// Z̕`iIԂ̔fj
			DrawCell( iOldRow, iOldColumn );
			DrawCell( iNewRow, iNewColumn );

			// CEBhE֕}
			CString		str = pastrCharz->GetAt(idxChar);
			m_pParent->ConfirmChar( str );
			return( TRUE );
		}
	}

	if ( pMsg->message == WM_KEYDOWN )
	if ( pMsg->hwnd == m_Canvas.m_hWnd )
	{
		long	iOldColumn;
		long	iOldRow;
		long	idxOldChar = m_idxCellSelect;
		CellIndexToRowColumn( idxOldChar, &iOldRow, &iOldColumn );
		long	iColumn = iOldColumn;
		long	iRow = iOldRow;

		// }gNX͂ݏoꍇ͔Β[oĂ
		switch( pMsg->wParam )
		{
		case VK_TAB:
			// ^uRg[ɃtH[JX𓖂Ă
			m_pParent->SetTabFocus();
			m_pParent->PostMessage( WM_KEYDOWN, VK_TAB, 0 );
			break;

		case VK_ESCAPE:
			{
				// CEBhE֖߂
				m_pParent->ToMainWindow();
			}
			break;

		case VK_RETURN:
		case VK_SPACE:
			{
				// CEBhE֕}
				CString		str = pastrCharz->GetAt(idxOldChar);
				m_pParent->ConfirmChar( str );
			}
			break;

		case VK_UP:
			iRow--;
			if ( iRow < 0 )
			{
				iRow = m_nRow-1;
				while( RowColumnToCellIndex( iRow, iColumn ) >= pastrCharz->GetSize() )
				{
					iRow--;
				}
			}
			break;

		case VK_DOWN:
			iRow++;
			if( RowColumnToCellIndex( iRow, iColumn ) >= pastrCharz->GetSize() )
			{
				iRow = 0;
			}
			if( iRow >= m_nRow )
			{
				iRow = 0;
			}
			break;

		case VK_LEFT:
			iColumn--;
			if ( iColumn < 0 )
			{
				iColumn = m_nColumn-1;
				while( RowColumnToCellIndex( iRow, iColumn ) >= pastrCharz->GetSize() )
				{
					iColumn--;
				}
			}
			break;

		case VK_RIGHT:
			iColumn++;
			if( RowColumnToCellIndex( iRow, iColumn ) >= pastrCharz->GetSize() )
			{
				iColumn = 0;
			}
			if( iColumn >= m_nColumn )
			{
				iColumn = 0;
			}
			break;

		default:
			break;
		}

		long	idxChar = RowColumnToCellIndex( iRow, iColumn );
		if ( idxChar < pastrCharz->GetSize() )
		{
			m_idxCellSelect = idxChar;
			DrawCell( iOldRow, iOldColumn );
			DrawCell( iRow, iColumn );
		}
		return( TRUE );
	}


	return CDialog::PreTranslateMessage(pMsg);
}


/*-----------------------------------------------------------------------------
[]	XN[o[nh
[@\]	XN[B
[ߒl]	Ȃ
[l]	CDialog::OnHScroll()̃wvQƁB
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	int	min = 0;
	int max = 0;
	int	iNowPos = 0;
	if( pScrollBar != NULL )
	{
		pScrollBar->GetScrollRange( &min, &max );
		iNowPos = pScrollBar->GetScrollPos();
	}

	if( pScrollBar ==  &m_HScroll )
	{
		switch( nSBCode )
		{
		case SB_LEFT://   [փXN[B
			pScrollBar->SetScrollPos( max );
			break;
		case SB_ENDSCROLL://   XN[IB
			break;
		case SB_LINELEFT://   փXN[B
			pScrollBar->SetScrollPos( max(min,iNowPos-m_sizeButton.cx/2) );
			break;
		case SB_PAGELEFT://   1 y[WփXN[B
			pScrollBar->SetScrollPos( max(min,iNowPos-m_sizeButton.cx) );
			break;
		case SB_LINERIGHT://   EփXN[B
			pScrollBar->SetScrollPos( min(max,iNowPos+m_sizeButton.cx/2) );
			break;
		case SB_PAGERIGHT://   1 y[WEփXN[B
			pScrollBar->SetScrollPos( min(max,iNowPos+m_sizeButton.cx) );
			break;
		case SB_RIGHT://   E[փXN[B
			pScrollBar->SetScrollPos( min );
			break;
		case SB_THUMBPOSITION://   ΈʒuփXN[B݈ʒu͈ nPos Ŏw肳܂B
		case SB_THUMBTRACK://XN[ {bNXwʒuփhbO܂B݈ʒu͈ nPos Ŏw肳܂B 
			pScrollBar->SetScrollPos( nPos );
			break;
		default:
			break;
		}
		Redraw();
	}

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

/*-----------------------------------------------------------------------------
[]	XN[o[nh
[@\]	XN[B
[ߒl]	Ȃ
[l]	CDialog::OnVScroll()̃wvQƁB
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	int	min = 0;
	int max = 0;
	int	iNowPos = 0;
	if( pScrollBar != NULL )
	{
		pScrollBar->GetScrollRange( &min, &max );
		iNowPos = pScrollBar->GetScrollPos();
	}

	if( pScrollBar ==  &m_VScroll )
	{
		switch( nSBCode )
		{
		case SB_LEFT://   [փXN[B
			pScrollBar->SetScrollPos( max );
			break;
		case SB_ENDSCROLL://   XN[IB
			break;
		case SB_LINELEFT://   փXN[B
			pScrollBar->SetScrollPos( max(min,iNowPos-m_sizeButton.cy/2) );
			break;
		case SB_PAGELEFT://   1 y[WփXN[B
			pScrollBar->SetScrollPos( max(min,iNowPos-m_sizeButton.cy) );
			break;
		case SB_LINERIGHT://   EփXN[B
			pScrollBar->SetScrollPos( min(max,iNowPos+m_sizeButton.cy/2) );
			break;
		case SB_PAGERIGHT://   1 y[WEփXN[B
			pScrollBar->SetScrollPos( min(max,iNowPos+m_sizeButton.cy) );
			break;
		case SB_RIGHT://   E[փXN[B
			pScrollBar->SetScrollPos( min );
			break;
		case SB_THUMBPOSITION://   ΈʒuփXN[B݈ʒu͈ nPos Ŏw肳܂B
		case SB_THUMBTRACK://XN[ {bNXwʒuփhbO܂B݈ʒu͈ nPos Ŏw肳܂B 
			pScrollBar->SetScrollPos( nPos );
			break;
		default:
			break;
		}
		Redraw();
	}
	
	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

/*-----------------------------------------------------------------------------
[]	{^TCYύX
[@\]	{^̃TCYύXB
[ߒl]	Ȃ
[l]	RePositionControl()ȂƔfȂB
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::SetButtonSize( CSize sizeButton )
{
	m_sizeButton = sizeButton;
}

/*-----------------------------------------------------------------------------
[]	}{^nh
[@\]	IʒuɃZ}AҏW[hɓB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::OnCharpaletteInsertcell() 
{
	CStringArray*	pastrCharz = GetCharz();
	pastrCharz->InsertAt( m_idxCellSelect, _T("") );
	RePositionControl();
	RedrawWindow();

	OnCharpaletteEditcell();
}

/*-----------------------------------------------------------------------------
[]	ҏW{^nh
[@\]	IʒũZɑ΂AҏW[hɓB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::OnCharpaletteEditcell() 
{
	CRect	rc( CellToRect( m_idxCellSelect ) );

	// GfBbg{bNXzuAeZbg
	m_editChar.SetWindowPos( &wndTop, rc.left,rc.top, rc.Width(),rc.Height(), SWP_NOREPOSITION|SWP_NOZORDER);
	CStringArray*	pastrCharz = GetCharz();
	m_editChar.SetWindowText( pastrCharz->GetAt(m_idxCellSelect) );

	// ̓[hJn
	m_editChar.ShowWindow( SW_SHOW );
	m_editChar.SetFocus();

	m_bEdit = TRUE;
}

/*-----------------------------------------------------------------------------
[]	폜{^nh
[@\]	IʒũZ폜B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::OnCharpaletteDeletecell() 
{
	CStringArray*	pastrCharz = GetCharz();
	CString		strMes;
	strMes.Format( "\"%s\" 폜܂H", pastrCharz->GetAt(m_idxCellSelect) );
	if ( MessageBox( strMes, "Z̍폜mF", MB_ICONWARNING|MB_OKCANCEL ) == IDOK )
	{
		pastrCharz->RemoveAt( m_idxCellSelect );
		RePositionControl();
		RedrawWindow();
	}
}

/*-----------------------------------------------------------------------------
[]	ҏWIiGfBbg{bNX̃tH[JXrnhj
[@\]	ҏW̏IƓo^pbgo^B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteCanvasDlg::OnKillfocusCharpaletteedit() 
{
	CString		strChar;
	m_editChar.GetWindowText( strChar );

	CStringArray*	pastrCharz = GetCharz();
	if ( m_idxCellSelect < pastrCharz->GetSize() )
	{
		// eLXgȂ
		pastrCharz->SetAt( m_idxCellSelect, strChar );

		// Z̕`
		long	iColumn;
		long	iRow;
		CellIndexToRowColumn( m_idxCellSelect, &iRow, &iColumn );
		DrawCell( iRow, iColumn );
	}

	// GfBbgRg[
	m_editChar.ShowWindow( SW_HIDE );
	m_Canvas.SetFocus();
	m_bEdit = FALSE;
}

/*-----------------------------------------------------------------------------
[]	pbgQ擾
[@\]	pbgŎgp镶Q̎擾B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CStringArray*	CCharPaletteCanvasDlg::GetCharz() 
{
	CArray<CCharPalette, CCharPalette&>* paPalettez = CGeneralSetting::GetInstance()->GetCharPaletteManager()->GetDefine()->GetItemz();
	if ( m_idxTab < paPalettez->GetSize() )
	{
		CCharPalette&	Palette = (*paPalettez)[ m_idxTab ];
		return( Palette.GetCharz() );
	}
	return( NULL );
}

/*-----------------------------------------------------------------------------
[]	Rg[Ĕzu
[@\]	`摮̕ύX󂯂ăRg[zuȂB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void	CCharPaletteCanvasDlg::RePositionControl() 
{
	// Rg[̔zu
	CRect	rcClient;
	GetClientRect( &rcClient );
	ReflectSize( rcClient.Width(), rcClient.Height() );
}
