/*-----------------------------------------------------------------------------
[]	TokenReader.h
[Tv]	BREGEXPiDLL)wb_
[l]	aqdfdwo ckk
		http://www.hi-ho.ne.jp/babaq/bregexp.html
[]	2003-01-25	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/
#ifndef _BREGEXP_H_INCLUDED
#define _BREGEXP_H_INCLUDED

#ifdef _BREGEXP_
#define BREGEXPAPI __declspec(dllexport) 
#else
#define BREGEXPAPI __declspec(dllimport) 
#endif


/*-----------------------------------------------------------------------------
[]	}b`\(BREGEXP)
[pr]	}b`Ȃǂi[Ă炵B
[l]	Ȃ
-----------------------------------------------------------------------------*/
typedef struct bregexp{
	const char *outp;		// BSubst uf[^̐擪|C^
	const char *outendp;	// BSubst uf[^̍ŏI|C^+1
//  xxxxx BGN 2003.01.25 (moralog)
// warning C4510, C4610 邽߂ const͂
	int  splitctr;			// BSplit z
//  oridinal BGN
//	const int  splitctr;	// BSplit z
//  oridinal END
//  xxxxx END
	const char **splitp;	// BSplit f[^|C^
	int	rsv1;		// U[u@RɎgp\ 
	char *parap;		// p^[f[^|C^
	char *paraendp;		// p^[f[^|C^+1
	char *transtblp;	// BTrans ϊe[u|C^
	char **startp;		// }b`f[^̐擪|C^
	char **endp;		// }b`f[^̍ŏI|C^+1
	int nparens;		// p^[̒() ̐B $1,$2, 𒲂ׂƂɎgp
} BREGEXP;


//-----------------------------------------------------------------------------
// DLL I/F֐vg^Cv
//-----------------------------------------------------------------------------
#if defined(__cplusplus)
extern "C"
{
#endif

BREGEXPAPI
int BMatch(char* str,char *target,char *targetendp,
				BREGEXP **rxp,char *msg) ;
BREGEXPAPI
int BSubst(char* str,char *target,char *targetendp,
				BREGEXP **rxp,char *msg) ;
BREGEXPAPI
int BTrans(char* str,char *target,char *targetendp,
				BREGEXP **rxp,char *msg) ;
BREGEXPAPI
int BSplit(char* str,char *target,char *targetendp,
				int limit,BREGEXP **rxp,char *msg);
BREGEXPAPI
void BRegfree(BREGEXP* rx);

BREGEXPAPI
char* BRegexpVersion(void);

#if defined(__cplusplus)
}
#endif


#undef BREGEXPAPI
#endif // _BREGEXP_H_INCLUDED
