<!DOCTYPE html>
<html lang="ja">
<head>
	<meta charset="utf-8">
	<title>{{$config.title}}</title>
</head>
<body>

<div id="container">
	<h1>{{$config.title}}</h1>

	<div id="body">
	<div>
	<div>
		<a href="{{"/plan/add"|ciurl}}">追加</a>
	</div>

	<table>
	<thead>
	<tr>
		<th>ID</th>
		<th>起案者</th>
		<th>名前</th>
		<th>状態</th>
		<th>活性度</th>
		<th>期間</th>
		<th>費用</th>
		<th>スポンサー	</th>
		<th>Action</th>
	</tr>
	</thead>
	<tbody>
	{{foreach from=$data item=row}}
	<tr>
		<td>{{$row.id}}</td>
		<td>{{$row.owner_name|escape}}</td>
		<td><a href="{{"/plan/view/{{$row.id}}"|ciurl}}">{{$row.name|escape}}</a></td>
		<td>{{$row.status|escape}}</td>
		<td>{{include file="parts/activity.tpl" activity=$row.activity}}</td>
		<td>{{$row.term}}</td>
		<td>{{$row.budget|default:"-"|escape}} / {{$row.target_budget|default:"-"|escape}}</td>
		<td>
			<div>
			{{foreach from=$row.sponsors item=sponsor}}
			{{if $sponsor.img_url && $sponsor.url}}
				<a href="{{$sponsor.url|escape}}"><img src="{{$sponsor.img_url|escape}}" alt="{{$sponsor.name|escape}}" /></a>
			{{elseif $sponsor.url}}
				<a href="{{$sponsor.url|escape}}">{{$sponsor.name|escape}}</a>
			{{elseif $sponsor.img_url}}
				<img src="{{$sponsor.img_url|escape}}" alt="{{$sponsor.name|escape}}" />
			{{else}}
				{{$sponsor.name}}
			{{/if}}
			{{/foreach}}
			</div
		</td>
		<td>
			<a href="{{"/plan/view/{{$row.id}}"|ciurl}}">詳細</a> | 
			<a href="{{"/plan/edit/{{$row.id}}"|ciurl}}">編集</a>
			{{if $user}}
			 | <a href="{{"/plan/active/{{$row.id}}"|ciurl}}">やってる</a>
			{{/if}}
		</td>
	</tr>
	{{/foreach}}
	</tbody></table>

	<div>
		<a href="{{"/plan/add"|ciurl}}">追加</a>
	</div>

	</div>

	</div>
</div>
</body>
</html>