<!DOCTYPE html>
<html lang="ja">
<head>
	<meta charset="utf-8">
	<title>{{$config.title}}</title>
	<script type="text/javascript" src="{{$config.js_url}}jquery-1.7.2.min.js"></script>
	<script type="text/javascript">
	function copyPrev(root) {
		var clone = root.prev().clone(true);
		var l = clone.find('legend');
		if (l.length>0) {
			l.html(
				l.html().substr(0,5)+(parseInt(l.html().substr(5)) + 1)
			);
		}
		clone.insertBefore(root);
	}
	</script>
</head>
<body>

<div id="container">
	<h1><a href="{{"/"|ciurl}}">{{$config.title}}</a></h1>

	<header>
		<div class="breadcrumbs">
		</div>
	</header>

	<div id="body">
		{{if $plan.id}}
		<h2>{{$plan.name|escape}}の編集</h2>
		<form method="post" action="{{"/plan/edit/"|cat:$plan.id|ciurl}}">
		{{else}}
		<h2>新しい企画の作成</h2>
		<form method="post" action="{{"/plan/add"|ciurl}}">
		{{/if}}
			<div>
			<label>id</label>
			{{$plan.id}}
			</div>

			<div>
			<label>名称</label>
			<input type="text" name="name" value="{{$plan.name|escape}}" />
			</div>

{{if $plan.id}}
			<div>
			<label>起案者</label>
			{{$plan.owner_name|escape}}
			</div>

			<div>
			<label>活性度</label>
			{{include file="parts/activity.tpl" activity=$plan.activity}}{{* <input type="button" onclick="alert('todo')" value="Active!!" />*}}
			</div>
{{/if}}

			<div>
			<label>状態</label>
			<input type="text" name="status" value="{{$plan.status|escape}}" />
			</div>

			<div>
			<label>概要</label>
			<textarea name="summary" rows="4" cols="80">{{$plan.summary|escape}}</textarea>
			</div>

			<div>
			<label>期間</label>
			<input type="text" name="term" value="{{$plan.term|escape}}" />
			</div>

			<div>
				<fieldset id="sponsor">
					<legend>関連文書</legend>
{{foreach from=$plan.docs item=doc}}
					<div>
						<label>名前</label><input type="text" name="doc_name[]" value="{{$doc.name|escape}}" />
						<label>HTML (for iFrame)</label><br />
						<textarea name="doc_html[]" cols="80" rows="4">{{$doc.html|escape}}</textarea>
						<input type="hidden" name="doc_id[]" value="{{$doc.id}}" />
					</div>
{{/foreach}}
					<div>
						<label>名前</label><input type="text" name="doc_name[]" value="" />
						<label>HTML (for iFrame)</label><br />
						<textarea name="doc_html[]" cols="80" rows="4"></textarea>
						<input type="hidden" name="doc_id[]" value="" />
					</div>
					<div id="new_doc">
						<input type="button" value="追加" onclick="copyPrev($(this).parent())" />
					</div>
				</fieldset>
			</div>

			<div>
				<fieldset id="sponsor">
					<legend>スポンサー情報</legend>
{{foreach from=$plan.sponsors item=sponsor key=k}}
					<fieldset>
						<legend>スポンサー{{$k+1}}</legend>
						<div>
							<label>名前</label><input type="text" name="sponsor_name[]" value="{{$sponsor.name|escape}}" />
							<label>支援金額</label><input type="text" name="sponsor_amount[]" value="{{$sponsor.amount|escape}}" />
						</div>
						<div>
							<label>URL</label><input type="text" name="sponsor_url[]" value="{{$sponsor.url|escape}}" />
						</div>
						<div>
							<label>バナーURL</label><input type="text" name="sponsor_img_url[]" value="{{$sponsor.img_url|escape}}" />
						</div>
						<div>
							<label>補足事項</label><br />
							<textarea name="sponsor_explain[]" rows="4" cols="80">{{$sponsor.explain|escape}}</textarea>
						</div>
						<input type="hidden" name="sponsor_id[]" value="{{$sponsor.id}}" />
					</fieldset>
{{/foreach}}
					<fieldset>
						<legend>スポンサー{{if $sponsor}}{{$k+2}}{{else}}{{$k+1}}{{/if}}</legend>
						<div>
							<label>名前</label><input type="text" name="sponsor_name[]" value="" />
							<label>支援金額</label><input type="text" name="sponsor_amount[]" value="" />
						</div>
						<div>
							<label>URL</label><input type="text" name="sponsor_url[]" value="" />
						</div>
						<div>
							<label>バナーURL</label><input type="text" name="sponsor_img_url[]" value="" />
						</div>
						<div>
							<label>補足事項</label><br />
							<textarea name="sponsor_explain[]" rows="4" cols="80"></textarea>
						</div>
						<input type="hidden" name="sponsor_id[]" value="" />
					</fieldset>
					<div id="new_sponsor">
						<input type="button" value="追加" onclick="copyPrev($(this).parent())" />
					</div>
				</fieldset>
			</div>

			<div>
			<label>目標獲得予算</label>
			<input type="text" name="target_budget" value="{{$plan.target_budget|escape}}" />
			</div>

			<div>
			<label>獲得済み予算</label>
			<input type="text" name="budget" value="{{$plan.budget|escape}}" />
			</div>

{{if $plan.id}}
			<div>
			<label>作成日</label>
			{{$plan.created}}
			</div>

			<div>
			<label>更新日</label>
			{{$plan.modified}}
			</div>
{{/if}}

			<div>
				<input type="submit" value="保存" name="do" />
			</div>
		</form>
	</div>
</div>
</body>
</html>