<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Plan extends MY_Controller {
	function index() {
		$this->load->model('Planmodel', '', TRUE);
		$data = $this->Planmodel->search_plan();
		$this->smarty->view('plan/index', array('data' => $data));
	}

	function view($id) {
		$this->load->model('Planmodel', '', TRUE);
		$data = $this->Planmodel->detail($id);
		if (empty($data))
			die('error');

		$this->smarty->view('plan/view', array('plan' => $data));
	}

	function edit($id) {
		$this->load->model('Planmodel', '', TRUE);
		$data = $this->Planmodel->detail($id);
		if (empty($data))
			die('error');

		if ($this->input->post('do')) {
			$d = $this->_getModelByInput();
			$d['plan']['id'] = $id;
			$save_ret = $this->Planmodel->saveAll($this->user, $id, $d['plan'], $d['docs'], $d['sponsors']);
			if ($save_ret === FALSE)
				die('error');	//TODO
			$this->load->helper('url');
			redirect('/plan/edit/'.$id);
		}

		$this->smarty->view('plan/edit', array('plan' => $data));
	}

	function add() {
		$this->load->model('Planmodel', '', TRUE);
		$data = $this->Planmodel->getEmpty();
		if ($this->input->post('do')) {
			$d = $this->_getModelByInput();
			$d['owner_id'] = $this->user['id'];
			$d['owner_name'] = $this->user['name'];
			$save_ret = $this->Planmodel->saveAll($this->user, NULL, $d['plan'], $d['docs'], $d['sponsors']);
			if ($save_ret === FALSE)
				die('error');	//TODO
			$this->load->helper('url');
			redirect('/plan/edit/'.$save_ret);
		}

		$this->smarty->view('plan/edit', array('plan' => $data));
	}

	function delete() {
		//TODO
	}

	function active($plan_id) {
		$this->load->model('Planmodel', '', TRUE);
		$this->Planmodel->addActivity($this->user, $plan_id);
		$this->load->helper('url');
		redirect('/');
	}

	function _getModelByInput() {
		$main = array(
			'name' => $this->input->post('name'),
			'summary' => $this->input->post('summary'),
			'term' => $this->input->post('term'),
			'budget' => $this->input->post('budget'),
			'target_budget' => $this->input->post('target_budget'),
			'status' => $this->input->post('status'),
		);

		$doc_names = $this->input->post('doc_name');
		$doc_htmls = $this->input->post('doc_html');
		$doc_ids = $this->input->post('doc_id');
		$docs = array();
		foreach ($doc_names as $k => $v) {
			if (! empty($v)) {
				$docs[] = array(
					'id' => $doc_ids[$k],
					'name' => $doc_names[$k],
					'html' => $doc_htmls[$k],
				);
			}
		}

		$sponsors = array();
		$sponsor_names = $this->input->post('sponsor_name');
		$sponsor_amounts = $this->input->post('sponsor_amount');
		$sponsor_urls = $this->input->post('sponsor_url');
		$sponsor_img_urls = $this->input->post('sponsor_img_url');
		$sponsor_explains = $this->input->post('sponsor_explain');
		$sponsor_ids = $this->input->post('sponsor_id');
		foreach ($sponsor_names as $k => $v) {
			if (! empty($v)) {
				$sponsors[] = array(
					'id' => $sponsor_ids[$k],
					'name' => $sponsor_names[$k],
					'amount' => $sponsor_amounts[$k],
					'url' => $sponsor_urls[$k],
					'img_url' => $sponsor_img_urls[$k],
					'explain' => $sponsor_explains[$k],
				);
			}
		}

		return array(
			'plan' => $main,
			'docs' => $docs,
			'sponsors' => $sponsors
		);
	}
}
