/*
 * Decompiled with CFR 0.152.
 */
package com.projity.print;

import com.projity.job.Job;
import com.projity.job.JobQueue;
import com.projity.job.JobRunnable;
import com.projity.offline_graphics.SVGRenderer;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParams;
import com.projity.pm.graphic.spreadsheet.renderer.FontManager;
import com.projity.print.ExtendedPageFormat;
import com.projity.print.ExtendedPrintService;
import com.projity.print.ExtendedPrintServiceFactory;
import com.projity.print.PDFPrintService;
import com.projity.print.PrintDocument;
import com.projity.print.PrintPreviewFrame;
import com.projity.print.ViewPrintable;
import com.projity.print.ViewPrintableParams;
import com.projity.print.ViewPrintableParamsImpl;
import com.projity.session.SessionFactory;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class GraphPageable
extends PrintDocument
implements ViewPrintableParams {
    protected SVGRenderer renderer;
    protected int documentRowCount;
    protected int documentColCount;
    protected ViewPrintable defaultPrintable;
    ExtendedPrintService extendedPrintService = ExtendedPrintServiceFactory.getExtendedPrintService();

    public GraphPageable(SVGRenderer sVGRenderer, boolean bl, boolean bl2) {
        this(sVGRenderer, false, bl, bl2);
    }

    private GraphPageable(SVGRenderer sVGRenderer, boolean bl, boolean bl2, boolean bl3) {
        super(sVGRenderer.getProject(), bl, bl2, bl3);
        FontManager.setOfflineDefaultFont(FontManager.DEFAULT_FONT);
        this.renderer = sVGRenderer;
        GraphParams graphParams = sVGRenderer.getParams();
        if (graphParams instanceof SpreadSheetParams && graphParams.isLeftPartVisible() && graphParams.isRightPartVisible()) {
            graphParams.setLeftPartVisible(this.showSpreadsheet);
            graphParams.setRightPartVisible(this.showGantt);
        } else {
            this.showSpreadsheet = graphParams.isLeftPartVisible();
            this.showGantt = graphParams.isRightPartVisible();
        }
        this.zoomX = this.scaleToSettings.getWidth();
        this.zoomY = this.scaleToSettings.isConstrainProportions() ? this.zoomX : this.scaleToSettings.getHeight();
        this.saveZoom();
        if (!this.scaleToSelected) {
            this.updateZoom(this.fitToSettings.getColumns(), this.fitToSettings.getRows());
        }
    }

    public int getNumberOfPages() {
        return this.documentRowCount * this.documentColCount;
    }

    public PageFormat getPageFormat(int n2) throws IndexOutOfBoundsException {
        return this.getPageFormat();
    }

    public Printable getPrintable(int n2) throws IndexOutOfBoundsException {
        return this.getDefaultPrintable();
    }

    public ViewPrintable getSafePrintable() {
        return new ViewPrintable(new ViewPrintableParamsImpl(this.getTransform(), this.renderer.createSafePrintCopy(), this.documentRowCount, this.documentColCount, this.getTotalZoomX(), this.getTotalZoomY()));
    }

    public ExtendedPageFormat getSafePageFormat() {
        return new ExtendedPageFormat(this.getPageFormat());
    }

    public PrintPreviewFrame getPrintPreviewFrame() {
        if (this.printPreview == null) {
            this.printPreview = new PrintPreviewFrame(this);
        }
        return this.printPreview;
    }

    public void preview() {
        this.getPrintPreviewFrame().pack();
        this.getPrintPreviewFrame().setVisible(true);
    }

    public void print() {
        if (this.printService instanceof PDFPrintService) {
            Alert.error(Messages.getString("PageSetupDialog.NotValidPrinter"));
            return;
        }
        try {
            final PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintService(this.printService);
            ViewPrintable viewPrintable = this.getSafePrintable();
            viewPrintable.setPageFormat(printerJob.validatePage(this.getSafePageFormat()));
            viewPrintable.update();
            printerJob.setPrintable(viewPrintable, viewPrintable.getPageFormat());
            ViewPrintable viewPrintable2 = this.getSafePrintable();
            ExtendedPageFormat extendedPageFormat = this.getSafePageFormat();
            printerJob.setPrintable(viewPrintable2, extendedPageFormat);
            if (printerJob.printDialog()) {
                JobQueue jobQueue = SessionFactory.getInstance().getJobQueue();
                Job job = new Job(jobQueue, "Printing", "Printing...", true, this.getPrintPreviewFrame());
                job.addRunnable(new JobRunnable("Printing", 1.0f){

                    public Object run() throws Exception {
                        try {
                            ViewPrintable viewPrintable = GraphPageable.this.getSafePrintable();
                            viewPrintable.setJr(this);
                            viewPrintable.setPrinterJob(printerJob);
                            viewPrintable.setPageFormat(printerJob.validatePage(GraphPageable.this.getSafePageFormat()));
                            viewPrintable.update();
                            printerJob.setPrintable(viewPrintable, viewPrintable.getPageFormat());
                            viewPrintable.setJr(this);
                            viewPrintable.setPrinterJob(printerJob);
                            printerJob.print();
                        }
                        catch (PrinterException printerException) {
                            Alert.error(printerException.getMessage());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        return null;
                    }
                });
                jobQueue.schedule(job);
            }
        }
        catch (PrinterException printerException) {
            Alert.error(printerException.getMessage());
        }
    }

    public int getColumnCount() {
        return this.documentColCount;
    }

    public void update() {
        GraphParams graphParams = this.renderer.getParams();
        double d2 = this.getTotalZoomX();
        double d3 = this.getTotalZoomY();
        int n2 = (int)Math.ceil((this.pageFormat.getImageableWidth() - 1.0) / d2);
        int n3 = (int)Math.ceil((this.pageFormat.getImageableHeight() - 1.0) / d3);
        graphParams.setPrintBounds(new Rectangle(0, 0, n2, n3));
        this.documentColCount = graphParams.getPrintCols();
        this.documentRowCount = graphParams.getPrintRows();
    }

    public ViewPrintable getDefaultPrintable() {
        if (this.defaultPrintable == null) {
            this.defaultPrintable = new ViewPrintable(this);
        }
        return this.defaultPrintable;
    }

    public void printWithDefault(Graphics graphics, int n2) throws PrinterException {
        this.getDefaultPrintable().print(graphics, n2);
    }

    public SVGRenderer getRenderer() {
        return this.renderer;
    }

    public int getDocumentColCount() {
        return this.documentColCount;
    }

    public int getDocumentRowCount() {
        return this.documentRowCount;
    }

    public void setDocumentRowCount(int n2) {
        this.documentRowCount = n2;
    }

    public void setDocumentColCount(int n2) {
        this.documentColCount = n2;
    }

    public void updateZoom(int n2, int n3) {
        double d2 = this.pageFormat.getImageableWidth();
        double d3 = this.pageFormat.getImageableHeight();
        SVGRenderer sVGRenderer = this.getRenderer();
        GraphParams graphParams = sVGRenderer.getParams();
        double d4 = this.extendedPrintService.getWRatio(n2, d2, graphParams);
        double d5 = this.extendedPrintService.getHRatio(n3, d3, graphParams);
        this.setTotalZoomX(d4);
        this.setTotalZoomY(d5);
    }
}

