/*
 * Decompiled with CFR 0.152.
 */
package com.projity.print;

import com.projity.print.PDFPrintService;
import com.projity.print.PageSize;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.print.PrintService;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

public class ExtendedPageFormat
extends PageFormat
implements Cloneable,
Serializable {
    static final long serialVersionUID = 785552028119291L;
    protected static final int DEFAULT_MARGINS = 10;
    public static final int BIG_PAGE = 1;
    public static final int CUSTOM = 2;
    protected MediaSizeName sizeName;
    protected PageSize size;
    protected MediaPrintableArea printableArea;
    protected int type = 0;
    private static final float VERSION = 1.1f;

    public ExtendedPageFormat() {
        this.setSizeName(ExtendedPageFormat.getDefaultMediaSizeName());
        this.printableArea = ExtendedPageFormat.getDefaultMediaPrintableArea(this.size);
        this.setOrientation(0);
        this.updatePaper();
    }

    public ExtendedPageFormat(ExtendedPageFormat extendedPageFormat) {
        extendedPageFormat.copy(this);
    }

    public static MediaSizeName getDefaultMediaSizeName() {
        return MediaSizeName.ISO_A4;
    }

    public static MediaPrintableArea getDefaultMediaPrintableArea(Size2DSyntax size2DSyntax) {
        return new MediaPrintableArea(10.0f, 10.0f, size2DSyntax.getX(1000) - 20.0f, size2DSyntax.getY(1000) - 20.0f, 1000);
    }

    public static MediaSizeName getDefaultMediaSizeName(PrintService printService) {
        if (printService instanceof PDFPrintService) {
            return ExtendedPageFormat.getDefaultMediaSizeName();
        }
        Object object = printService.getDefaultAttributeValue(Media.class);
        if (object instanceof MediaSizeName) {
            return (MediaSizeName)object;
        }
        return null;
    }

    public static MediaPrintableArea getDefaultMediaPrintableArea(PrintService printService, MediaSizeName mediaSizeName) {
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName == null ? ExtendedPageFormat.getDefaultMediaSizeName() : mediaSizeName);
        return ExtendedPageFormat.adaptMediaPrintableArea(ExtendedPageFormat.getDefaultMediaPrintableArea(mediaSize), printService, mediaSizeName);
    }

    public static MediaPrintableArea adaptMediaPrintableArea(MediaPrintableArea mediaPrintableArea, PrintService printService, MediaSizeName mediaSizeName) {
        if (mediaSizeName == null) {
            return mediaPrintableArea;
        }
        MediaPrintableArea mediaPrintableArea2 = ExtendedPageFormat.getMaxMediaPrintableArea(printService, mediaSizeName);
        boolean bl = false;
        float f2 = mediaPrintableArea.getX(1000);
        float f3 = mediaPrintableArea.getY(1000);
        float f4 = mediaPrintableArea.getWidth(1000);
        float f5 = mediaPrintableArea.getHeight(1000);
        float f6 = mediaPrintableArea.getX(1000);
        float f7 = mediaPrintableArea.getY(1000);
        float f8 = mediaPrintableArea.getWidth(1000);
        float f9 = mediaPrintableArea.getHeight(1000);
        if (f2 < 0.0f) {
            f2 = 0.0f;
            bl = true;
        }
        if (f2 > f6) {
            f2 = f6;
            bl = true;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
            bl = true;
        }
        if (f3 > f7) {
            f3 = f7;
            bl = true;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
            bl = true;
        }
        if (f4 > f8) {
            f4 = f8;
            bl = true;
        }
        if (f5 < 0.0f) {
            f5 = 0.0f;
            bl = true;
        }
        if (f5 > f9) {
            f5 = f9;
            bl = true;
        }
        if (bl) {
            return new MediaPrintableArea(f2, f3, f4, f5, 1000);
        }
        return mediaPrintableArea;
    }

    private static MediaPrintableArea getMaxMediaPrintableArea(PrintService printService, MediaSizeName mediaSizeName) {
        Serializable serializable;
        MediaPrintableArea mediaPrintableArea = null;
        if (mediaSizeName != null && !(printService instanceof PDFPrintService)) {
            serializable = new HashPrintRequestAttributeSet();
            serializable.add(mediaSizeName);
            MediaPrintableArea[] mediaPrintableAreaArray = (MediaPrintableArea[])printService.getSupportedAttributeValues(MediaPrintableArea.class, null, (AttributeSet)((Object)serializable));
            if (mediaPrintableAreaArray != null && mediaPrintableAreaArray.length == 1) {
                mediaPrintableArea = mediaPrintableAreaArray[0];
            }
        }
        if (mediaPrintableArea == null) {
            serializable = MediaSize.getMediaSizeForName(mediaSizeName);
            mediaPrintableArea = new MediaPrintableArea(0.0f, 0.0f, ((Size2DSyntax)serializable).getX(1000), ((Size2DSyntax)serializable).getY(1000), 1000);
        }
        return mediaPrintableArea;
    }

    public ExtendedPageFormat(MediaSizeName mediaSizeName, MediaPrintableArea mediaPrintableArea) {
        this.setSizeName(mediaSizeName);
        this.printableArea = mediaPrintableArea;
        this.setOrientation(0);
        this.updatePaper();
    }

    protected void updatePaper() {
        Paper paper = new Paper();
        paper.setSize(Math.round(this.size.getX(25400) * 72.0f), Math.round(this.size.getY(25400) * 72.0f));
        paper.setImageableArea(Math.floor(this.printableArea.getX(25400) * 72.0f), Math.floor(this.printableArea.getY(25400) * 72.0f), Math.ceil(this.printableArea.getWidth(25400) * 72.0f), Math.ceil(this.printableArea.getHeight(25400) * 72.0f));
        this.setPaper(paper);
    }

    public PageSize getSize() {
        return this.size;
    }

    public void setSize(PageSize pageSize, int n2) {
        this.type = n2;
        this.sizeName = null;
        this.size = pageSize;
        this.updatePaper();
    }

    public MediaSizeName getSizeName() {
        return this.sizeName;
    }

    public void setSizeName(MediaSizeName mediaSizeName) {
        this.type = 0;
        this.sizeName = mediaSizeName;
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        this.size = mediaSize == null ? null : new PageSize(mediaSize.getX(1000), mediaSize.getY(1000), 1000);
    }

    public MediaPrintableArea getPrintableArea() {
        return this.printableArea;
    }

    public void setPrintableArea(MediaPrintableArea mediaPrintableArea) {
        this.printableArea = mediaPrintableArea;
        this.updatePaper();
    }

    public double[] getMargins(boolean bl) {
        int n2 = this.getOrientation();
        double d2 = this.printableArea.getX(1000);
        double d3 = this.size.getX(1000) - this.printableArea.getWidth(1000) - this.printableArea.getX(1000);
        double d4 = this.printableArea.getY(1000);
        double d5 = this.size.getY(1000) - this.printableArea.getHeight(1000) - this.printableArea.getY(1000);
        if (!bl) {
            return new double[]{d2, d3, d4, d5};
        }
        switch (n2) {
            case 0: {
                return new double[]{d5, d4, d2, d3};
            }
            case 2: {
                return new double[]{d4, d5, d3, d2};
            }
        }
        return new double[]{d2, d3, d4, d5};
    }

    public Object clone() {
        ExtendedPageFormat extendedPageFormat = (ExtendedPageFormat)super.clone();
        this.copy(extendedPageFormat);
        return extendedPageFormat;
    }

    public void copy(ExtendedPageFormat extendedPageFormat) {
        extendedPageFormat.setOrientation(this.getOrientation());
        extendedPageFormat.type = this.type;
        extendedPageFormat.sizeName = this.sizeName;
        extendedPageFormat.size = new PageSize(this.size.getX(1000), this.size.getY(1000), 1000);
        extendedPageFormat.printableArea = new MediaPrintableArea(this.printableArea.getX(1000), this.printableArea.getY(1000), this.printableArea.getWidth(1000), this.printableArea.getHeight(1000), 1000);
        extendedPageFormat.updatePaper();
    }

    public void addAttributes(AttributeSet attributeSet) {
        OrientationRequested orientationRequested;
        attributeSet.add(this.sizeName);
        attributeSet.add(this.printableArea);
        switch (this.getOrientation()) {
            case 1: {
                orientationRequested = OrientationRequested.PORTRAIT;
                break;
            }
            case 0: {
                orientationRequested = OrientationRequested.LANDSCAPE;
                break;
            }
            case 2: {
                orientationRequested = OrientationRequested.REVERSE_LANDSCAPE;
            }
            default: {
                orientationRequested = OrientationRequested.PORTRAIT;
            }
        }
        attributeSet.add(orientationRequested);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeFloat(1.1f);
        objectOutputStream.writeObject(this.sizeName);
        objectOutputStream.writeObject(this.sizeName == null ? this.size : null);
        objectOutputStream.writeObject(this.printableArea);
        objectOutputStream.writeInt(this.getOrientation());
        objectOutputStream.writeInt(this.type);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        float f2 = objectInputStream.readFloat();
        this.sizeName = (MediaSizeName)objectInputStream.readObject();
        this.size = (PageSize)objectInputStream.readObject();
        if (this.sizeName != null) {
            this.setSizeName(this.sizeName);
        }
        this.printableArea = (MediaPrintableArea)objectInputStream.readObject();
        int n2 = objectInputStream.readInt();
        this.setOrientation(n2);
        if (f2 >= 1.1f) {
            this.type = objectInputStream.readInt();
            if (this.type == 1 && n2 == 0) {
                this.setOrientation(1);
                this.size = new PageSize(this.size.getY(1000), this.size.getX(1000), 1000);
                this.printableArea = new MediaPrintableArea(this.printableArea.getY(1000), this.printableArea.getX(1000), this.printableArea.getHeight(1000), this.printableArea.getWidth(1000), 1000);
            }
        }
        this.updatePaper();
    }

    public int getType() {
        return this.type;
    }
}

