/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.network;

import com.projity.graphic.configuration.BarStyles;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.graph.LinkRouting;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.network.NetworkParams;
import com.projity.pm.graphic.network.layout.NetworkLayout;
import com.projity.pm.graphic.network.layout.NetworkLayoutEvent;
import com.projity.pm.graphic.network.link_routing.DefaultNetworkLinkRouting;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class NetworkParamsImpl
implements NetworkParams,
Cloneable {
    protected AffineTransform transform;
    protected int zoom;
    protected BarStyles barStyles;
    protected GraphicConfiguration configuration = GraphicConfiguration.getInstance();
    protected NodeModelCache cache;
    protected LinkRouting routing = new DefaultNetworkLinkRouting();
    protected NetworkLayout networkLayout;
    protected Rectangle printBounds;

    public NetworkParamsImpl() {
        this.transform = new AffineTransform();
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int n2) {
        boolean bl;
        if (n2 == this.zoom) {
            return;
        }
        boolean bl2 = bl = n2 - this.zoom > 0;
        while (this.zoom != n2) {
            this.transform.concatenate(AffineTransform.getScaleInstance(this.barStyles.getRatioX(this.zoom, bl), this.barStyles.getRatioY(this.zoom, bl)));
            if (bl) {
                ++this.zoom;
                continue;
            }
            --this.zoom;
        }
    }

    public BarStyles getBarStyles() {
        return this.barStyles;
    }

    public NodeModelCache getCache() {
        return this.cache;
    }

    public GraphicConfiguration getConfiguration() {
        return this.configuration;
    }

    public LinkRouting getRouting() {
        return this.routing;
    }

    public void setBarStyles(BarStyles barStyles) {
        this.barStyles = barStyles;
        this.networkLayout.setBarStyles(barStyles);
    }

    public void setCache(NodeModelCache nodeModelCache) {
        this.cache = nodeModelCache;
        this.networkLayout.setCache(nodeModelCache);
    }

    public void setConfiguration(GraphicConfiguration graphicConfiguration) {
        this.configuration = graphicConfiguration;
    }

    public void setRouting(LinkRouting linkRouting) {
        this.routing = linkRouting;
    }

    public boolean useTextures() {
        return false;
    }

    public GeneralPath scale(GeneralPath generalPath) {
        if (generalPath == null) {
            return null;
        }
        GeneralPath generalPath2 = (GeneralPath)generalPath.clone();
        generalPath2.transform(this.getTransform());
        return generalPath2;
    }

    public Point2D scale(Point2D point2D) {
        AffineTransform affineTransform = this.getTransform();
        return new Point2D.Double(point2D.getX() * affineTransform.getScaleX() + affineTransform.getTranslateX(), point2D.getY() * affineTransform.getScaleY() + affineTransform.getTranslateY());
    }

    public Point2D scaleVector(Point2D point2D) {
        AffineTransform affineTransform = this.getTransform();
        return new Point2D.Double(point2D.getX() * affineTransform.getScaleX(), point2D.getY() * affineTransform.getScaleY());
    }

    public Point2D scaleVector_1(Point2D point2D) {
        AffineTransform affineTransform = this.getTransform();
        return new Point2D.Double(point2D.getX() / affineTransform.getScaleX(), point2D.getY() / affineTransform.getScaleY());
    }

    public Rectangle scale(Rectangle rectangle) {
        AffineTransform affineTransform = this.getTransform();
        if (affineTransform == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle();
        rectangle2.setFrameFromDiagonal(rectangle.getMinX() * affineTransform.getScaleX() + affineTransform.getTranslateX(), rectangle.getMinY() * affineTransform.getScaleY() + affineTransform.getTranslateY(), rectangle.getMaxX() * affineTransform.getScaleX() + affineTransform.getTranslateX(), rectangle.getMaxY() * affineTransform.getScaleY() + affineTransform.getTranslateY());
        return rectangle2;
    }

    public Rectangle getDrawingBounds() {
        Rectangle rectangle = this.networkLayout.getBounds();
        GraphicConfiguration graphicConfiguration = GraphicConfiguration.getInstance();
        return new Rectangle(rectangle.x + rectangle.width + graphicConfiguration.getPertXOffset(), rectangle.y + rectangle.height + graphicConfiguration.getPertYOffset());
    }

    public void layoutChanged(NetworkLayoutEvent networkLayoutEvent) {
    }

    public NetworkLayout getNetworkLayout() {
        return this.networkLayout;
    }

    public void setNetworkLayout(NetworkLayout networkLayout) {
        this.networkLayout = networkLayout;
    }

    public void updateLayout() {
        this.networkLayout.updateBounds();
    }

    public Rectangle getPrintBounds() {
        return this.printBounds;
    }

    public void setPrintBounds(Rectangle rectangle) {
        this.printBounds = rectangle;
    }

    public int getPrintCols() {
        return (int)Math.ceil(this.getDrawingBounds().getWidth() / this.getPrintBounds().getWidth());
    }

    public int getPrintRows() {
        return (int)Math.ceil(this.getDrawingBounds().getHeight() / this.getPrintBounds().getHeight());
    }

    public Rectangle getNetworkPrintBounds(int n2, int n3) {
        int n4 = this.getPrintCols();
        int n5 = this.getPrintRows();
        int n6 = n3 == n4 - 1 ? this.getDrawingBounds().width % this.getPrintBounds().width : this.getPrintBounds().width;
        int n7 = n2 == n5 - 1 ? this.getDrawingBounds().height % this.getPrintBounds().height : this.getPrintBounds().height;
        return new Rectangle(n3 * this.printBounds.width, n2 * this.printBounds.height, n6, n7);
    }

    public boolean isLeftPartVisible() {
        return true;
    }

    public boolean isRightPartVisible() {
        return true;
    }

    public void setLeftPartVisible(boolean bl) {
    }

    public void setRightPartVisible(boolean bl) {
    }

    public boolean isSupportLeftAndRightParts() {
        return false;
    }

    public void setSupportLeftAndRightParts(boolean bl) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public GraphParams createSafePrintCopy() {
        NetworkParamsImpl networkParamsImpl = (NetworkParamsImpl)this.clone();
        if (networkParamsImpl.printBounds != null) {
            networkParamsImpl.printBounds = (Rectangle)networkParamsImpl.printBounds.clone();
        }
        return networkParamsImpl;
    }
}

