/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.chart;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.grouping.core.NodeList;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.transform.CommonTransformFactory;
import com.projity.grouping.core.transform.ViewConfiguration;
import com.projity.pm.assignment.HasAssignmentsImpl;
import com.projity.pm.assignment.HasTimeDistributedData;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.chart.AxisPanel;
import com.projity.pm.graphic.chart.ChartHelper;
import com.projity.pm.graphic.chart.ChartInfo;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.spreadsheet.selection.event.SelectionNodeEvent;
import com.projity.pm.graphic.spreadsheet.selection.event.SelectionNodeListener;
import com.projity.pm.graphic.swing.Util;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.task.Project;
import com.projity.strings.Messages;
import com.projity.toolbar.TransformComboBox;
import com.projity.toolbar.TransformComboBoxModel;
import com.projity.util.Environment;
import com.projity.workspace.SavableToWorkspace;
import com.projity.workspace.WorkspaceSetting;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.commons.collections.Closure;

public class ChartLegend
implements SelectionNodeListener,
Serializable,
SavableToWorkspace {
    private static final long serialVersionUID = 5098599798868391983L;
    JTree tree;
    JCheckBox selectedOnTop;
    JCheckBox cumulative;
    JCheckBox histogram;
    JRadioButton cost;
    JRadioButton work;
    JScrollPane treeScrollPane = null;
    JScrollPane tracesScrollPane = null;
    boolean selecting = false;
    JList workTraces;
    JList costTraces;
    boolean simple;
    ChartInfo chartInfo;
    List selectedObjects = new ArrayList();
    List selectedResourcesFromTasks = new ArrayList();
    List selectedResourcesOnTree = new ArrayList();
    TransformComboBox filterComboBox = null;
    JList tracesList;

    public ChartLegend(ChartInfo chartInfo) {
        this.chartInfo = chartInfo;
        this.simple = chartInfo.isSimple();
    }

    void rebuildTree() {
        this.initTree();
    }

    private void initTree() {
        this.tree = new JTree(this.chartInfo.getCache());
        this.tree.setExpandsSelectedPaths(true);
        JTree jTree = this.tree;
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (ChartLegend.this.selecting) {
                    return;
                }
                TreePath[] treePathArray = ((JTree)treeSelectionEvent.getSource()).getSelectionPaths();
                ChartLegend.this.chartInfo.updateChart(ChartLegend.this.selectedObjects, ChartLegend.this.pathsToList(treePathArray));
            }
        });
        this.tree.setCellRenderer(new TreeRenderer());
        if (this.treeScrollPane == null) {
            this.treeScrollPane = new JScrollPane(this.tree);
        } else {
            this.treeScrollPane.getViewport().add(this.tree);
        }
    }

    JList getListInstance(boolean bl) {
        final JList jList = new JList(){
            private static final long serialVersionUID = 1L;

            public void updateUI() {
                if (!Environment.isNewLook()) {
                    super.updateUI();
                }
            }
        };
        if (Environment.isNewLook()) {
            jList.setUI(new BasicListUI());
        }
        jList.setSelectionMode(2);
        jList.setCellRenderer(new ListRenderer());
        this.setListFields(jList, bl);
        if (!this.simple) {
            jList.setSelectedIndex(0);
            jList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (ChartLegend.this.chartInfo.isRestoring()) {
                        return;
                    }
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        ChartLegend.this.chartInfo.setTraces(jList.getSelectedValues());
                    }
                }
            });
        }
        return jList;
    }

    public void setControlValues() {
        if (this.simple) {
            this.selectedOnTop.setSelected(this.chartInfo.isSelectedOnTop());
        } else {
            this.cumulative.setSelected(this.chartInfo.isCumulative());
            this.histogram.setSelected(this.chartInfo.isHistogram());
            this.work.setSelected(this.chartInfo.isWork());
            this.cost.setSelected(!this.chartInfo.isWork());
            Util.setSelectedValues(this.tracesList, this.chartInfo.traces);
        }
    }

    void initControls() {
        this.chartInfo.setAxisPanel(new AxisPanel(this.chartInfo));
        this.filterComboBox = new TransformComboBox(null, "ChooseFilter", 1);
        this.filterComboBox.setView(ViewConfiguration.getView("Charts"));
        this.filterComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ChartLegend.this.chartInfo.isRestoring()) {
                    return;
                }
                TransformComboBox transformComboBox = (TransformComboBox)actionEvent.getSource();
                CommonTransformFactory commonTransformFactory = (CommonTransformFactory)transformComboBox.getSelectedItem();
                ((TransformComboBoxModel)transformComboBox.getModel()).changeTransform(commonTransformFactory);
            }
        });
        this.initTree();
        Object[] objectArray = this.getFields(false);
        this.tracesList = this.workTraces = this.getListInstance(false);
        this.tracesScrollPane = new JScrollPane(this.workTraces);
        this.workTraces.setVisibleRowCount(Environment.getStandAlone() ? 3 : 4);
        if (this.simple) {
            this.chartInfo.setTraces(objectArray);
            this.tree.getSelectionModel().setSelectionMode(1);
            this.selectedOnTop = new JCheckBox(Messages.getString("Text.ShowSelectedOnTop"));
            this.selectedOnTop.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    ChartLegend.this.chartInfo.setSelectedOnTop(itemEvent.getStateChange() == 1);
                    Object[] objectArray = ChartLegend.this.getFields(false);
                    ChartLegend.this.chartInfo.setTraces(objectArray);
                    ChartLegend.this.workTraces = ChartLegend.this.getListInstance(false);
                    ChartLegend.this.tracesScrollPane.getViewport().add(ChartLegend.this.workTraces);
                    ChartLegend.this.workTraces.setVisibleRowCount(Environment.getStandAlone() ? 3 : 4);
                }
            });
            this.selectedOnTop.setSelected(this.chartInfo.isSelectedOnTop());
            return;
        }
        this.costTraces = this.getListInstance(true);
        this.cumulative = new JCheckBox(Messages.getString("Text.Cumulative"));
        this.cumulative.setSelected(this.chartInfo.isCumulative());
        this.cumulative.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ChartLegend.this.chartInfo.setCumulative(itemEvent.getStateChange() == 1);
            }
        });
        this.histogram = new JCheckBox(Messages.getString("Text.Histogram"));
        this.histogram.setSelected(this.chartInfo.isHistogram());
        this.histogram.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                ChartLegend.this.chartInfo.setHistogram(bl);
                if (bl) {
                    ChartLegend.this.workTraces.setSelectionMode(0);
                    ChartLegend.this.costTraces.setSelectionMode(0);
                } else {
                    ChartLegend.this.workTraces.setSelectionMode(2);
                    ChartLegend.this.costTraces.setSelectionMode(2);
                }
            }
        });
        this.work = new JRadioButton(Messages.getString("Text.work"));
        this.work.setSelected(this.chartInfo.isWork());
        this.cost = new JRadioButton(Messages.getString("Text.cost"));
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getSource() == ChartLegend.this.cost;
                ChartLegend.this.chartInfo.setWork(!bl);
                ChartLegend.this.tracesList = bl ? ChartLegend.this.costTraces : ChartLegend.this.workTraces;
                ChartLegend.this.tracesScrollPane.getViewport().add(ChartLegend.this.tracesList);
                if (!ChartLegend.this.chartInfo.isRestoring()) {
                    ChartLegend.this.chartInfo.setTraces(ChartLegend.this.tracesList.getSelectedValues());
                }
            }
        };
        this.cost.addItemListener(itemListener);
        this.work.addItemListener(itemListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.cost);
        buttonGroup.add(this.work);
        this.chartInfo.setTraces(new Object[]{objectArray[0]});
    }

    private List pathsToList(TreePath[] treePathArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (treePathArray != null) {
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                arrayList.add(((GraphicNode)treePathArray[i2].getLastPathComponent()).getNode().getImpl());
            }
        }
        return arrayList;
    }

    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("p:grow, 3dlu,100dlu:grow,5dlu, default, 5dlu", "p, 3dlu, p, 3dlu, p, 3dlu, " + (this.simple ? "" : "fill:") + "p:grow, 5dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.addLabel(Messages.getString("ChartLegend.ResourceFilter"), cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.filterComboBox, cellConstraints.xy(3, 1));
        defaultFormBuilder.add((Component)this.treeScrollPane, cellConstraints.xywh(1, 3, 3, 5));
        defaultFormBuilder.add((Component)this.tracesScrollPane, cellConstraints.xy(5, 7));
        if (this.simple) {
            defaultFormBuilder.add((Component)this.selectedOnTop, cellConstraints.xy(5, 1));
        } else {
            defaultFormBuilder.add((Component)this.cumulative, cellConstraints.xy(5, 1));
            defaultFormBuilder.add((Component)this.histogram, cellConstraints.xy(5, 3));
            defaultFormBuilder.add(this.workCostRadioPanel(), cellConstraints.xy(5, 5));
        }
        return defaultFormBuilder.getPanel();
    }

    public Component workCostRadioPanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.work);
        jPanel.add(this.cost);
        return jPanel;
    }

    private Object[] getFields(boolean bl) {
        if (this.simple) {
            return this.chartInfo.isSelectedOnTop() ? (Environment.getStandAlone() ? HasTimeDistributedData.histogramTypes : HasTimeDistributedData.serverHistogramTypes) : (Environment.getStandAlone() ? HasTimeDistributedData.reverseHistogramTypes : HasTimeDistributedData.serverReverseHistogramTypes);
        }
        return bl ? HasTimeDistributedData.costTypes : HasTimeDistributedData.workTypes;
    }

    private void setListFields(JList jList, boolean bl) {
        Object[] objectArray = this.getFields(bl);
        jList.setListData(objectArray);
        jList.setVisibleRowCount(objectArray.length);
        if (this.simple) {
            jList.setSelectionInterval(0, objectArray.length);
            jList.setEnabled(false);
        }
    }

    private List getListFromNodeList(List list) {
        List list2 = NodeList.nodeListToImplList(list);
        if (list2.isEmpty() || !(list2.get(0) instanceof Project)) {
            return list2;
        }
        final ArrayList arrayList = new ArrayList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((Project)iterator.next()).forTasks(new Closure(){

                public void execute(Object object) {
                    arrayList.add(object);
                }
            });
        }
        return arrayList;
    }

    public void selectionChanged(SelectionNodeEvent selectionNodeEvent) {
        if (!this.chartInfo.isVisible()) {
            return;
        }
        List list = selectionNodeEvent.getNodes();
        this.selectedObjects = this.getListFromNodeList(list);
        List list2 = this.extractResources(this.selectedObjects);
        if (list2.isEmpty()) {
            this.selectedResourcesFromTasks = HasAssignmentsImpl.extractOppositeList(this.selectedObjects, false);
        } else {
            this.selectedResourcesFromTasks = list2;
            this.selectedObjects = null;
        }
        this.setTreeSelection(this.selectedResourcesFromTasks);
        this.chartInfo.updateChart(this.selectedObjects, this.selectedResourcesOnTree);
    }

    private List extractResources(List list) {
        ArrayList arrayList = new ArrayList();
        for (Object e2 : list) {
            if (!(e2 instanceof Resource)) continue;
            arrayList.add(e2);
        }
        return arrayList;
    }

    private void setTreeSelection(List list) {
        this.selecting = true;
        this.selectedResourcesOnTree.clear();
        this.selectedResourcesOnTree.addAll(list);
        this.selectedResourcesOnTree.remove(ResourceImpl.getUnassignedInstance());
        int[] nArray = new int[this.selectedResourcesOnTree.size()];
        NodeModel nodeModel = this.chartInfo.getNodeModel();
        int n2 = Integer.MAX_VALUE;
        Object e2 = null;
        for (int i2 = 0; i2 < this.selectedResourcesOnTree.size(); ++i2) {
            int n3;
            Object e3 = this.selectedResourcesOnTree.get(i2);
            nArray[i2] = n3 = nodeModel.getHierarchy().getIndexOfNode(nodeModel.search(e3), false);
            if (n3 >= n2) continue;
            n2 = n3;
            e2 = e3;
        }
        this.tree.clearSelection();
        this.tree.setExpandsSelectedPaths(true);
        if (this.simple && e2 != null) {
            this.tree.setSelectionRow(n2);
            this.selectedResourcesOnTree.clear();
            this.selectedResourcesOnTree.add(e2);
        } else {
            this.tree.setSelectionRows(nArray);
        }
        this.tree.setExpandsSelectedPaths(true);
        this.tree.repaint();
        this.selecting = false;
    }

    public WorkspaceSetting createWorkspace(int n2) {
        Workspace workspace = new Workspace();
        workspace.treeViewPosition = this.treeScrollPane.getViewport().getViewPosition();
        workspace.tracesViewPosition = this.tracesScrollPane.getViewport().getViewPosition();
        return workspace;
    }

    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n2) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.treeScrollPane.getViewport().setViewPosition(workspace.treeViewPosition);
        this.tracesScrollPane.getViewport().setViewPosition(workspace.tracesViewPosition);
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = -8581691622116505516L;
        Point treeViewPosition;
        Point tracesViewPosition;

        public Point getTracesViewPosition() {
            return this.tracesViewPosition;
        }

        public void setTracesViewPosition(Point point) {
            this.tracesViewPosition = point;
        }

        public Point getTreeViewPosition() {
            return this.treeViewPosition;
        }

        public void setTreeViewPosition(Point point) {
            this.treeViewPosition = point;
        }
    }

    class ListRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public ListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            this.setText(object.toString());
            if (bl) {
                Color color = ChartHelper.getColorForField(object);
                this.setBackground(color);
                if (color.getRed() + color.getGreen() + color.getBlue() < 450) {
                    this.setForeground(Color.white);
                } else {
                    this.setForeground(jList.getForeground());
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (bl) {
                this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            } else {
                this.setBorder(BorderFactory.createLineBorder(jList.getBackground(), 1));
            }
            return this;
        }
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private Icon activeIcon = IconManager.getIcon("greenCircle");

        TreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n2, bl4);
            if (ChartLegend.this.selectedResourcesFromTasks.contains(((GraphicNode)object).getNode().getImpl())) {
                this.setIcon(this.activeIcon);
            }
            return component;
        }
    }
}

