/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.costing;

import com.projity.configuration.CalculationPreference;
import com.projity.datatype.ImageLink;
import com.projity.pm.calendar.HasCalendar;
import com.projity.pm.costing.EarnedValueValues;
import com.projity.pm.snapshot.BaselineScheduleFields;
import com.projity.pm.snapshot.Snapshottable;
import com.projity.pm.time.HasStartAndEnd;
import com.projity.strings.Messages;
import com.projity.util.DateTime;

public class EarnedValueCalculator {
    private static final long defaultStart = 0L;
    private static final long defaultEnd = DateTime.getMaxDate().getTime();
    private static EarnedValueCalculator instance = null;
    private static final String NO_BASELINE = "There is no Earned Value data";

    private double getDivideByZeroValue() {
        return CalculationPreference.getActive().getEarnedValueDivideByZeroValue();
    }

    public double acwp(EarnedValueValues earnedValueValues) {
        return earnedValueValues.acwp(0L, defaultEnd);
    }

    public double bac(EarnedValueValues earnedValueValues) {
        return earnedValueValues.bac(0L, defaultEnd);
    }

    public double bcwp(EarnedValueValues earnedValueValues) {
        return earnedValueValues.acwp(0L, defaultEnd);
    }

    public double bcws(EarnedValueValues earnedValueValues) {
        return earnedValueValues.bcws(0L, defaultEnd);
    }

    public static EarnedValueCalculator getInstance() {
        if (instance == null) {
            instance = new EarnedValueCalculator();
        }
        return instance;
    }

    private EarnedValueCalculator() {
    }

    public double cv(EarnedValueValues earnedValueValues, long l2, long l3) {
        return earnedValueValues.bcwp(l2, l3) - earnedValueValues.acwp(l2, l3);
    }

    public double cv(EarnedValueValues earnedValueValues) {
        return this.cv(earnedValueValues, 0L, defaultEnd);
    }

    public double sv(EarnedValueValues earnedValueValues, long l2, long l3) {
        return earnedValueValues.bcwp(l2, l3) - earnedValueValues.bcws(l2, l3);
    }

    public double sv(EarnedValueValues earnedValueValues) {
        return this.sv(earnedValueValues, 0L, defaultEnd);
    }

    public double eac(EarnedValueValues earnedValueValues, long l2, long l3) {
        double d2;
        double d3 = earnedValueValues.bcwp(l2, l3);
        if (d3 == 0.0) {
            if (this.getDivideByZeroValue() == 0.0) {
                return 0.0;
            }
            d3 = earnedValueValues.cost(l2, l3);
        }
        if ((d2 = earnedValueValues.acwp(l2, l3)) == 0.0 && this.getDivideByZeroValue() != 0.0) {
            return earnedValueValues.cost(l2, l3);
        }
        return d2 + d2 * (earnedValueValues.bac(l2, l3) - d3) / d3;
    }

    public double eac(EarnedValueValues earnedValueValues) {
        return this.eac(earnedValueValues, 0L, defaultEnd);
    }

    public double vac(EarnedValueValues earnedValueValues, long l2, long l3) {
        return earnedValueValues.bac(l2, l3) - this.eac(earnedValueValues, l2, l3);
    }

    public double vac(EarnedValueValues earnedValueValues) {
        return this.vac(earnedValueValues, 0L, defaultEnd);
    }

    public double cpi(EarnedValueValues earnedValueValues, long l2, long l3) {
        double d2 = earnedValueValues.acwp(l2, l3);
        if (d2 == 0.0) {
            return this.getDivideByZeroValue();
        }
        return earnedValueValues.bcwp(l2, l3) / d2;
    }

    public double cpi(EarnedValueValues earnedValueValues) {
        return this.cpi(earnedValueValues, 0L, defaultEnd);
    }

    public double spi(EarnedValueValues earnedValueValues, long l2, long l3) {
        double d2 = earnedValueValues.bcws(l2, l3);
        if (d2 == 0.0) {
            return this.getDivideByZeroValue();
        }
        return earnedValueValues.bcwp(l2, l3) / d2;
    }

    public double spi(EarnedValueValues earnedValueValues) {
        return this.spi(earnedValueValues, 0L, defaultEnd);
    }

    public double csi(EarnedValueValues earnedValueValues, long l2, long l3) {
        return this.spi(earnedValueValues, l2, l3) * this.cpi(earnedValueValues, l2, l3);
    }

    public double csi(EarnedValueValues earnedValueValues) {
        return this.spi(earnedValueValues) * this.cpi(earnedValueValues);
    }

    public double cvPercent(EarnedValueValues earnedValueValues, long l2, long l3) {
        double d2 = earnedValueValues.bcwp(l2, l3);
        if (d2 == 0.0) {
            return this.getDivideByZeroValue();
        }
        return (d2 - earnedValueValues.acwp(l2, l3)) / d2;
    }

    public double cvPercent(EarnedValueValues earnedValueValues) {
        return this.cvPercent(earnedValueValues, 0L, defaultEnd);
    }

    public double svPercent(EarnedValueValues earnedValueValues, long l2, long l3) {
        double d2 = earnedValueValues.bcws(l2, l3);
        if (d2 == 0.0) {
            return this.getDivideByZeroValue();
        }
        return (earnedValueValues.bcwp(l2, l3) - d2) / d2;
    }

    public double svPercent(EarnedValueValues earnedValueValues) {
        return this.svPercent(earnedValueValues, 0L, defaultEnd);
    }

    public double tcpi(EarnedValueValues earnedValueValues, long l2, long l3) {
        double d2;
        double d3 = earnedValueValues.bac(l2, l3);
        if (d3 == (d2 = earnedValueValues.acwp(l2, l3))) {
            return this.getDivideByZeroValue();
        }
        return (d3 - earnedValueValues.bcwp(l2, l3)) / (d3 - d2);
    }

    public double tcpi(EarnedValueValues earnedValueValues) {
        return this.tcpi(earnedValueValues, 0L, defaultEnd);
    }

    public double bcwr(EarnedValueValues earnedValueValues, long l2, long l3) {
        return earnedValueValues.bac(l2, l3) - earnedValueValues.bcwp(l2, l3);
    }

    public double bcwr(EarnedValueValues earnedValueValues) {
        return this.bcwr(earnedValueValues, 0L, defaultEnd);
    }

    public long getStartOffset(EarnedValueValues earnedValueValues) {
        int n2 = Snapshottable.BASELINE;
        if (!(earnedValueValues instanceof HasStartAndEnd)) {
            return 0L;
        }
        if (!(earnedValueValues instanceof BaselineScheduleFields)) {
            return 0L;
        }
        if (!(earnedValueValues instanceof HasCalendar)) {
            return 0L;
        }
        long l2 = ((BaselineScheduleFields)((Object)earnedValueValues)).getBaselineStart(n2);
        if (l2 == 0L) {
            return 0L;
        }
        long l3 = ((HasStartAndEnd)((Object)earnedValueValues)).getStart();
        return ((HasCalendar)((Object)earnedValueValues)).getEffectiveWorkCalendar().compare(l3, l2, false);
    }

    public long getFinishOffset(EarnedValueValues earnedValueValues) {
        int n2 = Snapshottable.BASELINE;
        if (!(earnedValueValues instanceof HasStartAndEnd)) {
            return 0L;
        }
        if (!(earnedValueValues instanceof BaselineScheduleFields)) {
            return 0L;
        }
        if (!(earnedValueValues instanceof HasCalendar)) {
            return 0L;
        }
        long l2 = ((BaselineScheduleFields)((Object)earnedValueValues)).getBaselineFinish(n2);
        if (l2 == 0L) {
            return 0L;
        }
        long l3 = ((HasStartAndEnd)((Object)earnedValueValues)).getEnd();
        return ((HasCalendar)((Object)earnedValueValues)).getEffectiveWorkCalendar().compare(l3, l2, false);
    }

    public ImageLink getScheduleStatusIndicator(double d2) {
        return ImageLink.trafficLight(d2 == 0.0 ? NO_BASELINE : Messages.getString("EarnedValueCalculator.SPI") + "=" + d2, d2, 1.0, 0.9);
    }

    public ImageLink getBudgetStatusIndicator(double d2) {
        return ImageLink.trafficLight(d2 == 0.0 ? NO_BASELINE : Messages.getString("EarnedValueCalculator.CPI") + "=" + d2, d2, 1.0, 0.9);
    }

    public ImageLink getStatusIndicator(double d2) {
        return ImageLink.trafficLight(d2 == 0.0 ? NO_BASELINE : Messages.getString("EarnedValueCalculator.CSI") + "=" + d2, d2, 1.0, 0.81);
    }
}

