/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.calendar;

import com.projity.configuration.Settings;
import com.projity.pm.calendar.WorkRange;
import com.projity.pm.calendar.WorkRangeException;
import com.projity.strings.Messages;
import com.projity.util.DateTime;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class WorkingHours
implements Cloneable,
Serializable {
    static final long serialVersionUID = 83888849333431L;
    private static long MS_PER_MINUTE = 60000L;
    long duration = 0L;
    WorkRange[] workRange = new WorkRange[Settings.CALENDAR_INTERVALS];
    private static GregorianCalendar helper = DateTime.calendarInstance();
    private static WorkingHours defaultWorkingHours = null;
    private static WorkingHours nonStopWorkingHours = null;

    public Object clone() {
        WorkingHours workingHours = new WorkingHours();
        for (int i2 = 0; i2 < this.workRange.length; ++i2) {
            workingHours.workRange[i2] = this.workRange[i2] == null ? null : (WorkRange)this.workRange[i2].clone();
        }
        workingHours.duration = this.duration;
        return workingHours;
    }

    WorkingHours intersectWith(WorkingHours workingHours) {
        int n2 = 0;
        int n3 = 0;
        ArrayList<WorkRange> arrayList = new ArrayList<WorkRange>();
        while (n2 != this.workRange.length && n3 != workingHours.workRange.length) {
            long l2;
            WorkRange workRange = this.workRange[n2];
            WorkRange workRange2 = workingHours.workRange[n3];
            if (workRange == null || workRange2 == null) break;
            long l3 = Math.max(workRange.getStart(), workRange2.getStart());
            if (workRange.getEnd() < workRange2.getEnd()) {
                l2 = workRange.getEnd();
                ++n2;
            } else {
                l2 = workRange2.getEnd();
                ++n3;
            }
            if (l2 <= l3) continue;
            try {
                arrayList.add(new WorkRange(l3, l2));
            }
            catch (WorkRangeException workRangeException) {
                workRangeException.printStackTrace();
            }
        }
        WorkingHours workingHours2 = new WorkingHours();
        workingHours2.workRange = new WorkRange[arrayList.size()];
        arrayList.toArray(workingHours2.workRange);
        workingHours2.initialize();
        return workingHours2;
    }

    private static synchronized long getHoursAndMinutes(Date date) {
        helper.setTime(date);
        long l2 = 60L * (long)(24 + helper.get(11)) + (long)helper.get(12) - (long)date.getTimezoneOffset();
        return 60000L * (l2 %= 1440L);
    }

    public static synchronized long hourTime(int n2) {
        helper.setTimeInMillis(0L);
        helper.set(11, n2);
        return helper.getTimeInMillis();
    }

    public boolean setInterval(int n2, Date date, Date date2) {
        if (date == null || date2 == null) {
            return false;
        }
        try {
            this.setInterval(n2, WorkingHours.getHoursAndMinutes(date), WorkingHours.getHoursAndMinutes(date2));
            return true;
        }
        catch (WorkRangeException workRangeException) {
            workRangeException.printStackTrace();
            return false;
        }
    }

    public void setInterval(int n2, long l2, long l3) throws WorkRangeException {
        if (l2 == -1L || l3 == -1L) {
            this.workRange[n2] = null;
        } else {
            GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
            gregorianCalendar.setTimeInMillis(l3);
            if (gregorianCalendar.get(11) == 0 && gregorianCalendar.get(12) == 0) {
                gregorianCalendar.add(11, 24);
                l3 = gregorianCalendar.getTimeInMillis();
            }
            this.workRange[n2] = new WorkRange(l2, l3);
        }
        this.initialize();
    }

    public WorkRange getInterval(int n2) {
        return this.workRange[n2];
    }

    public List getIntervals() {
        return Arrays.asList(this.workRange);
    }

    public WorkingHours() {
        for (int i2 = 0; i2 < this.workRange.length; ++i2) {
            this.workRange[i2] = null;
        }
    }

    void validate() throws WorkRangeException {
        int n2;
        boolean bl = false;
        for (n2 = 0; n2 < this.workRange.length - 1; ++n2) {
            if (this.workRange[n2] == null) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            throw new WorkRangeException(Messages.getString("WorkRangeException.RangeIncomplete"));
        }
        for (n2 = 0; n2 < this.workRange.length - 1; ++n2) {
            for (int i2 = n2 + 1; i2 < this.workRange.length; ++i2) {
                if (this.workRange[n2] == null || this.workRange[n2].isBefore(this.workRange[i2])) continue;
                throw new WorkRangeException(Messages.getString("WorkRangeException.RangesMustBeOrdered"));
            }
        }
        this.initialize();
    }

    public long getDuration() {
        return this.duration;
    }

    void initialize() {
        this.duration = 0L;
        for (int i2 = 0; i2 < this.workRange.length; ++i2) {
            if (this.workRange[i2] == null) continue;
            this.duration += this.workRange[i2].calcWorkingHours();
        }
    }

    public void setNonWorking() {
        this.duration = 0L;
    }

    public long calcTimeAtRemainingWork(long l2) {
        long l3 = 0L;
        for (int i2 = this.workRange.length - 1; i2 >= 0; --i2) {
            if (this.workRange[i2] == null || (l3 += this.workRange[i2].calcWorkingHours()) < l2) continue;
            return this.workRange[i2].getStart() + (l3 - l2);
        }
        return -1L;
    }

    public long calcTimeAtWork(long l2) {
        long l3 = 0L;
        for (int i2 = 0; i2 < this.workRange.length; ++i2) {
            if (this.workRange[i2] == null || (l3 += this.workRange[i2].calcWorkingHours()) < l2) continue;
            return this.workRange[i2].getEnd() - (l3 - l2);
        }
        return -1L;
    }

    public long calcWorkTimeAfter(long l2) {
        long l3 = 0L;
        for (int i2 = 0; i2 < this.workRange.length; ++i2) {
            if (this.workRange[i2] == null || this.workRange[i2].getEnd() <= l2) continue;
            l3 += this.workRange[i2].getEnd() - Math.max(l2, this.workRange[i2].getStart());
        }
        return l3;
    }

    public long calcWorkTimeBefore(long l2) {
        return this.duration - this.calcWorkTimeAfter(l2);
    }

    public long calcWorkTime(long l2, boolean bl) {
        return bl ? this.calcWorkTimeAfter(l2) : this.calcWorkTimeBefore(l2);
    }

    public String toString() {
        String string = "WorkingHours\n";
        for (int i2 = 0; i2 < this.workRange.length; ++i2) {
            if (this.workRange[i2] == null) continue;
            if (string.length() != 0) {
                string = string + "\n";
            }
            string = string + "Range " + i2 + " - " + this.workRange[i2];
        }
        return string;
    }

    public static WorkingHours getDefault() {
        if (defaultWorkingHours == null) {
            defaultWorkingHours = new WorkingHours();
            try {
                GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
                gregorianCalendar.setTimeInMillis(0L);
                gregorianCalendar.set(11, 8);
                long l2 = gregorianCalendar.getTimeInMillis();
                gregorianCalendar.set(11, 12);
                long l3 = gregorianCalendar.getTimeInMillis();
                defaultWorkingHours.setInterval(0, l2, l3);
                gregorianCalendar.set(11, 13);
                l2 = gregorianCalendar.getTimeInMillis();
                gregorianCalendar.set(11, 17);
                l3 = gregorianCalendar.getTimeInMillis();
                defaultWorkingHours.setInterval(1, l2, l3);
            }
            catch (WorkRangeException workRangeException) {
                workRangeException.printStackTrace();
            }
        }
        return defaultWorkingHours;
    }

    public static WorkingHours getNonStop() {
        if (nonStopWorkingHours == null) {
            nonStopWorkingHours = new WorkingHours();
            try {
                GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
                gregorianCalendar.setTimeInMillis(0L);
                gregorianCalendar.set(11, 0);
                long l2 = gregorianCalendar.getTimeInMillis();
                nonStopWorkingHours.setInterval(0, l2, l2);
            }
            catch (WorkRangeException workRangeException) {
                workRangeException.printStackTrace();
            }
        }
        return nonStopWorkingHours;
    }

    public boolean equals(Object object) {
        if (!(object instanceof WorkingHours)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        WorkingHours workingHours = (WorkingHours)object;
        for (int i2 = 0; i2 < this.workRange.length; ++i2) {
            if (!(this.workRange[i2] != null ? !this.workRange[i2].equals(workingHours.workRange[i2]) : workingHours.workRange[i2] != null)) continue;
            return false;
        }
        return true;
    }

    public boolean hasHours() {
        this.duration = 0L;
        for (int i2 = 0; i2 < this.workRange.length; ++i2) {
            if (this.workRange[i2] == null) continue;
            return true;
        }
        return false;
    }
}

