/*
 * Decompiled with CFR 0.152.
 */
package com.projity.graphic.configuration.shape;

import com.projity.util.ArrayUtils;
import java.awt.geom.GeneralPath;
import java.util.HashMap;

public class PredefinedShape {
    private String name;
    private double[][] points = null;
    private double[][][] pointGrid = null;
    private static final double[][] rectPoints = new double[][]{{1.0, 0.5}, {0.0, 0.5}, {0.0, -0.5}, {1.0, -0.5}};
    public static final PredefinedShape FULL_HEIGHT = new PredefinedShape("FULL_HEIGHT", rectPoints);
    public static final PredefinedShape HALF_HEIGHT_TOP = new PredefinedShape("HALF_HEIGHT_TOP", rectPoints, 1.0, 0.5, 0.0, -0.25);
    public static final PredefinedShape HALF_HEIGHT_BOTTOM = new PredefinedShape("HALF_HEIGHT_BOTTOM", rectPoints, 1.0, 0.5, 0.0, 0.25);
    public static final PredefinedShape HALF_HEIGHT_CENTER = new PredefinedShape("HALF_HEIGHT_CENTER", rectPoints, 1.0, 0.5, 0.0, 0.0);
    public static final PredefinedShape QUARTER_HEIGHT_CENTER = new PredefinedShape("QUARTER_HEIGHT_CENTER", rectPoints, 1.0, 0.25, 0.0, 0.0);
    public static final PredefinedShape SQUARE = new PredefinedShape("SQUARE", new double[][]{{0.5, 0.5}, {-0.5, 0.5}, {-0.5, -0.5}, {0.5, -0.5}});
    public static final PredefinedShape DIAMOND = new PredefinedShape("DIAMOND", new double[][]{{0.0, -0.5}, {-0.5, 0.0}, {0.0, 0.5}, {0.5, 0.0}});
    public static final PredefinedShape PENTAGON_UP = new PredefinedShape("PENTAGON_UP", new double[][]{{0.0, -0.5}, {-0.5, 0.0}, {-0.5, 0.5}, {0.5, 0.5}, {0.5, 0.0}});
    public static final PredefinedShape PENTAGON_DOWN = new PredefinedShape("PENTAGON_DOWN", new double[][]{{0.0, 0.5}, {-0.5, 0.0}, {-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.0}});
    public static final PredefinedShape TRIANGLE_UP = new PredefinedShape("TRIANGLE_UP", new double[][]{{-0.5, 0.5}, {0.0, -0.5}, {0.5, 0.5}});
    public static final PredefinedShape TRIANGLE_DOWN = new PredefinedShape("TRIANGLE_DOWN", new double[][]{{-0.5, -0.5}, {0.0, 0.5}, {0.5, -0.5}});
    public static final PredefinedShape TRIANGLE_RIGHT = new PredefinedShape("TRIANGLE_RIGHT", new double[][]{{-0.5, -0.5}, {-0.5, 0.5}, {0.5, 0.0}});
    public static final PredefinedShape TRIANGLE_LEFT = new PredefinedShape("TRIANGLE_LEFT", new double[][]{{0.5, -0.5}, {0.5, 0.5}, {-0.5, 0.0}});
    public static final PredefinedShape ARROW_UP = new PredefinedShape("ARROW_UP", new double[][]{{-0.2, 0.5}, {-0.2, 0.0}, {-0.5, 0.0}, {0.0, -0.5}, {0.5, 0.0}, {0.2, 0.0}, {0.2, 0.5}});
    public static final PredefinedShape ARROW_DOWN = new PredefinedShape("ARROW_DOWN", new double[][]{{-0.2, -0.5}, {-0.2, 0.0}, {-0.5, 0.0}, {0.0, 0.5}, {0.5, 0.0}, {0.2, 0.0}, {0.2, -0.5}});
    public static final PredefinedShape LINK_ARROW1 = new PredefinedShape("LINK_ARROW1", new double[][]{{0.0, 0.0}, {1.0, 1.0}, {0.7, 0.0}, {1.0, -1.0}, {0.0, 0.0}});
    public static final PredefinedShape HEXAGON = new PredefinedShape("HEXAGON", new double[][][]{new double[][]{{1.0, -0.25, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}}, new double[][]{{0.0, 0.25, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.25, 0.0, 0.0}, {0.0, -0.5, 0.0, 0.0}}, new double[][]{{1.0, -0.25, 0.0, 0.0}, {0.0, -0.5, 0.0, 0.0}}, new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}});
    public static final PredefinedShape PARALLELOGRAM = new PredefinedShape("PARALLELOGRAM", new double[][][]{new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, -0.5, 0.0, 0.0}}, new double[][]{{0.0, 0.25, 0.0, 0.0}, {0.0, -0.5, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}}, new double[][]{{1.0, -0.25, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}}});
    public static final PredefinedShape[] MIDDLE_LIST = new PredefinedShape[]{FULL_HEIGHT, HALF_HEIGHT_TOP, HALF_HEIGHT_BOTTOM, HALF_HEIGHT_CENTER, QUARTER_HEIGHT_CENTER};
    public static final PredefinedShape[] END_LIST = new PredefinedShape[]{SQUARE, DIAMOND, PENTAGON_UP, PENTAGON_DOWN, TRIANGLE_UP, TRIANGLE_DOWN, TRIANGLE_RIGHT, TRIANGLE_LEFT, ARROW_UP, ARROW_DOWN, LINK_ARROW1};
    public static final PredefinedShape[] NETWORK_LIST = new PredefinedShape[]{FULL_HEIGHT, HEXAGON, PARALLELOGRAM};
    private static HashMap predefinedShapeMap = null;

    public GeneralPath toGeneralPath(double d2, double d3, double d4, double d5) {
        GeneralPath generalPath;
        if (this.points != null) {
            generalPath = new GeneralPath(0, this.points.length);
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                int n2 = PredefinedShape.r(d2 * this.points[i2][0] + d4);
                int n3 = PredefinedShape.r(d3 * this.points[i2][1] + d5);
                if (i2 == 0) {
                    generalPath.moveTo(n2, n3);
                    continue;
                }
                generalPath.lineTo(n2, n3);
            }
        } else {
            generalPath = new GeneralPath(0, this.pointGrid.length);
            for (int i3 = 0; i3 < this.pointGrid.length; ++i3) {
                int n4 = PredefinedShape.r(d2 * this.pointGrid[i3][0][0] + d3 * this.pointGrid[i3][0][1] + d4 * this.pointGrid[i3][0][2] + d5 * this.pointGrid[i3][0][3] + d4);
                int n5 = PredefinedShape.r(d2 * this.pointGrid[i3][1][0] + d3 * this.pointGrid[i3][1][1] + d4 * this.pointGrid[i3][1][2] + d5 * this.pointGrid[i3][1][3] + d5);
                if (i3 == 0) {
                    generalPath.moveTo(n4, n5);
                    continue;
                }
                generalPath.lineTo(n4, n5);
            }
        }
        generalPath.closePath();
        return generalPath;
    }

    protected PredefinedShape(String string, double[][] dArray, double d2, double d3, double d4, double d5) {
        this.name = string;
        this.points = ArrayUtils.clone(dArray);
        this.scale(d2, d3);
        this.translate(d4, d5);
    }

    protected PredefinedShape(String string, double[][] dArray) {
        this(string, dArray, 1.0, 1.0, 0.0, 0.0);
    }

    protected PredefinedShape(String string, double[][][] dArray) {
        this.name = string;
        this.pointGrid = ArrayUtils.clone(dArray);
    }

    private void scale(double d2, double d3) {
        for (int i2 = 0; i2 < this.points.length; ++i2) {
            double[] dArray = this.points[i2];
            dArray[0] = dArray[0] * d2;
            double[] dArray2 = this.points[i2];
            dArray2[1] = dArray2[1] * d3;
        }
    }

    private void translate(double d2, double d3) {
        for (int i2 = 0; i2 < this.points.length; ++i2) {
            double[] dArray = this.points[i2];
            dArray[0] = dArray[0] + d2;
            double[] dArray2 = this.points[i2];
            dArray2[1] = dArray2[1] + d3;
        }
    }

    private static int r(double d2) {
        return (int)Math.round(d2);
    }

    private static void add(PredefinedShape predefinedShape) {
        predefinedShapeMap.put(predefinedShape.name, predefinedShape);
    }

    private static void initialize() {
        PredefinedShape.add(FULL_HEIGHT);
        PredefinedShape.add(HALF_HEIGHT_TOP);
        PredefinedShape.add(HALF_HEIGHT_BOTTOM);
        PredefinedShape.add(HALF_HEIGHT_CENTER);
        PredefinedShape.add(QUARTER_HEIGHT_CENTER);
        PredefinedShape.add(SQUARE);
        PredefinedShape.add(DIAMOND);
        PredefinedShape.add(PENTAGON_UP);
        PredefinedShape.add(PENTAGON_DOWN);
        PredefinedShape.add(TRIANGLE_UP);
        PredefinedShape.add(TRIANGLE_DOWN);
        PredefinedShape.add(TRIANGLE_RIGHT);
        PredefinedShape.add(TRIANGLE_LEFT);
        PredefinedShape.add(ARROW_UP);
        PredefinedShape.add(ARROW_DOWN);
        PredefinedShape.add(HEXAGON);
        PredefinedShape.add(PARALLELOGRAM);
        PredefinedShape.add(LINK_ARROW1);
    }

    private static HashMap getPredefinedShapeMap() {
        if (predefinedShapeMap == null) {
            predefinedShapeMap = new HashMap();
            PredefinedShape.initialize();
        }
        return predefinedShapeMap;
    }

    public static PredefinedShape find(String string) {
        PredefinedShape predefinedShape = (PredefinedShape)PredefinedShape.getPredefinedShapeMap().get(string);
        return predefinedShape;
    }
}

