/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

public final class TimescaleUnits {
    public static final int NONE_VALUE = -1;
    public static final int MINUTES_VALUE = 0;
    public static final int HOURS_VALUE = 1;
    public static final int DAYS_VALUE = 2;
    public static final int WEEKS_VALUE = 3;
    public static final int THIRDS_OF_MONTHS_VALUE = 4;
    public static final int MONTHS_VALUE = 5;
    public static final int QUARTERS_VALUE = 6;
    public static final int HALF_YEARS_VALUE = 7;
    public static final int YEARS_VALUE = 8;
    public static final TimescaleUnits NONE = new TimescaleUnits(-1);
    public static final TimescaleUnits MINUTES = new TimescaleUnits(0);
    public static final TimescaleUnits HOURS = new TimescaleUnits(1);
    public static final TimescaleUnits DAYS = new TimescaleUnits(2);
    public static final TimescaleUnits WEEKS = new TimescaleUnits(3);
    public static final TimescaleUnits THIRDS_OF_MONTHS = new TimescaleUnits(4);
    public static final TimescaleUnits MONTHS = new TimescaleUnits(5);
    public static final TimescaleUnits QUARTERS = new TimescaleUnits(6);
    public static final TimescaleUnits HALF_YEARS = new TimescaleUnits(7);
    public static final TimescaleUnits YEARS = new TimescaleUnits(8);
    private static final TimescaleUnits[] UNITS_ARRAY = new TimescaleUnits[]{MINUTES, HOURS, DAYS, WEEKS, THIRDS_OF_MONTHS, MONTHS, QUARTERS, HALF_YEARS, YEARS};
    private static final String[] UNITS_NAMES = new String[]{"Minutes", "Hours", "Days", "Weeks", "Thirds of Months", "Months", "Quarters", "Half Years", "Years"};
    private int m_value;

    private TimescaleUnits(int value) {
        this.m_value = value;
    }

    public static TimescaleUnits getInstance(int value) {
        TimescaleUnits result = value < 0 || value >= UNITS_ARRAY.length ? NONE : UNITS_ARRAY[value];
        return result;
    }

    public String getName() {
        String result = this.m_value == -1 ? "None" : UNITS_NAMES[this.m_value];
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

