/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.grammar;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.BinaryExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.SequenceExp;
import java.io.ObjectStreamField;
import java.io.Serializable;

public class ExpressionPool
implements Serializable {
    private final ClosedHash expTable = new ClosedHash();
    static /* synthetic */ Class class$com$sun$msv$grammar$ChoiceExp;
    static /* synthetic */ Class class$com$sun$msv$grammar$SequenceExp;
    static /* synthetic */ Class class$com$sun$msv$grammar$ExpressionPool;

    public final Expression createAttribute(NameClass nameClass) {
        return this.unify(new AttributeExp(nameClass, Expression.anyString));
    }

    public final Expression createAttribute(NameClass nameClass, Expression content) {
        if (content == Expression.nullSet) {
            return content;
        }
        return this.unify(new AttributeExp(nameClass, content));
    }

    public final Expression createAnyString() {
        return Expression.anyString;
    }

    public final Expression createChoice(Expression left, Expression right) {
        if (left == Expression.nullSet) {
            return right;
        }
        if (right == Expression.nullSet) {
            return left;
        }
        if (left == Expression.epsilon && right.isEpsilonReducible()) {
            return right;
        }
        if (right == Expression.epsilon && left.isEpsilonReducible()) {
            return left;
        }
        if (right instanceof ChoiceExp) {
            ChoiceExp c = (ChoiceExp)right;
            return this.createChoice(this.createChoice(left, c.exp1), c.exp2);
        }
        Expression next = left;
        while (true) {
            if (next == right) {
                return left;
            }
            if (!(next instanceof ChoiceExp)) break;
            ChoiceExp cp = (ChoiceExp)next;
            if (cp.exp2 == right) {
                return left;
            }
            next = cp.exp1;
        }
        Expression o = this.expTable.getBinExp(left, right, class$com$sun$msv$grammar$ChoiceExp == null ? (class$com$sun$msv$grammar$ChoiceExp = ExpressionPool.class$("com.sun.msv.grammar.ChoiceExp")) : class$com$sun$msv$grammar$ChoiceExp);
        if (o == null) {
            return this.unify(new ChoiceExp(left, right));
        }
        return o;
    }

    public final Expression createOneOrMore(Expression child) {
        if (child == Expression.epsilon || child == Expression.anyString || child == Expression.nullSet || child instanceof OneOrMoreExp) {
            return child;
        }
        return this.unify(new OneOrMoreExp(child));
    }

    public final Expression createZeroOrMore(Expression child) {
        return this.createOptional(this.createOneOrMore(child));
    }

    public final Expression createOptional(Expression child) {
        return this.createChoice(child, Expression.epsilon);
    }

    public final Expression createMixed(Expression body) {
        if (body == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (body == Expression.epsilon) {
            return Expression.anyString;
        }
        return this.unify(new MixedExp(body));
    }

    public final Expression createSequence(Expression left, Expression right) {
        if (left == Expression.nullSet || right == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (left == Expression.epsilon) {
            return right;
        }
        if (right == Expression.epsilon) {
            return left;
        }
        if (right instanceof SequenceExp) {
            SequenceExp s = (SequenceExp)right;
            return this.createSequence(this.createSequence(left, s.exp1), s.exp2);
        }
        Expression o = this.expTable.getBinExp(left, right, class$com$sun$msv$grammar$SequenceExp == null ? (class$com$sun$msv$grammar$SequenceExp = ExpressionPool.class$("com.sun.msv.grammar.SequenceExp")) : class$com$sun$msv$grammar$SequenceExp);
        if (o == null) {
            return this.unify(new SequenceExp(left, right));
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Expression unify(Expression exp) {
        Expression o = this.expTable.get(exp);
        if (o == null) {
            ClosedHash closedHash = this.expTable;
            synchronized (closedHash) {
                o = this.expTable.get(exp);
                if (o == null) {
                    this.expTable.put(exp);
                    return exp;
                }
            }
        }
        return o;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class ClosedHash
    implements Serializable {
        private Expression[] table = new Expression[191];
        private int count;
        private int threshold = 57;
        private ClosedHash parent;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("count", Integer.TYPE), new ObjectStreamField("streamVersion", Byte.TYPE), new ObjectStreamField("parent", class$com$sun$msv$grammar$ExpressionPool == null ? (class$com$sun$msv$grammar$ExpressionPool = ExpressionPool.class$("com.sun.msv.grammar.ExpressionPool")) : class$com$sun$msv$grammar$ExpressionPool)};

        public ClosedHash() {
            this(null);
        }

        public ClosedHash(ClosedHash parent) {
            this.parent = parent;
        }

        public Expression getBinExp(Expression left, Expression right, Class type) {
            int hash = left.hashCode() + right.hashCode() ^ type.hashCode();
            return this.getBinExp(hash, left, right, type);
        }

        private Expression getBinExp(int hash, Expression left, Expression right, Class type) {
            Expression e;
            if (this.parent != null && (e = this.parent.getBinExp(hash, left, right, type)) != null) {
                return e;
            }
            Expression[] tab = this.table;
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Expression e2;
            while ((e2 = tab[index]) != null) {
                if (e2.hashCode() == hash && e2.getClass() == type) {
                    BinaryExp be = (BinaryExp)e2;
                    if (be.exp1 == left && be.exp2 == right) {
                        return be;
                    }
                }
                index = (index + 1) % tab.length;
            }
            return null;
        }

        public Expression get(Expression key) {
            Expression e;
            if (this.parent != null && (e = this.parent.get(key)) != null) {
                return e;
            }
            Expression[] tab = this.table;
            int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
            Expression e2;
            while ((e2 = tab[index]) != null) {
                if (e2.equals(key)) {
                    return e2;
                }
                index = (index + 1) % tab.length;
            }
            return null;
        }

        private void rehash() {
            int oldCapacity = this.table.length;
            Expression[] oldMap = this.table;
            int newCapacity = oldCapacity * 2 + 1;
            Expression[] newMap = new Expression[newCapacity];
            int i = oldCapacity;
            while (i-- > 0) {
                if (oldMap[i] == null) continue;
                int index = (oldMap[i].hashCode() & Integer.MAX_VALUE) % newMap.length;
                while (newMap[index] != null) {
                    index = (index + 1) % newMap.length;
                }
                newMap[index] = oldMap[i];
            }
            this.threshold = (int)((float)newCapacity * 0.3f);
            this.table = newMap;
        }

        public void put(Expression newExp) {
            if (this.count >= this.threshold) {
                this.rehash();
            }
            Expression[] tab = this.table;
            int index = (newExp.hashCode() & Integer.MAX_VALUE) % tab.length;
            while (tab[index] != null) {
                index = (index + 1) % tab.length;
            }
            tab[index] = newExp;
            ++this.count;
        }
    }
}

