/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data.mspdi;

import com.projity.contrib.util.Log;
import com.projity.contrib.util.LogFactory;
import com.projity.pm.assignment.Assignment;
import com.projity.server.data.mspdi.TimephasedService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.mspdi.MSPDIReader;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.ProjectType;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;

public class ModifiedMSPDIReader
extends MSPDIReader {
    static Log log = LogFactory.getLog(ModifiedMSPDIReader.class);
    protected com.projity.pm.task.Project projityProject;
    protected Map projityTaskMap = new HashMap();
    protected Map projityAssignmentMap = new HashMap();
    protected Map projitySnapshotIdMap = new HashMap();
    protected Map timephasedMap = new HashMap();
    private static Resource UNASSIGNED = null;
    ArrayList<Object[]> preds = new ArrayList();

    public ProjectFile read(InputStream inputStream) throws MPXJException {
        ProjectFile projectFile = this.readSax(inputStream);
        this.processPreds();
        return projectFile;
    }

    private Resource unassignedResource() {
        if (UNASSIGNED == null) {
            UNASSIGNED = this.m_projectFile.addResource();
            UNASSIGNED.setUniqueID(-65535);
        }
        return UNASSIGNED;
    }

    protected void readResources(Project project, HashMap hashMap) {
        super.readResources(project, hashMap);
        this.unassignedResource();
    }

    public ResourceAssignment readAssignment(ProjectType.AssignmentsType.AssignmentType assignmentType) {
        ResourceAssignment resourceAssignment = super.readAssignment(assignmentType);
        if (resourceAssignment != null) {
            this.putTimephasedList(resourceAssignment, assignmentType.getTimephasedData());
        }
        return resourceAssignment;
    }

    public void setProjityProject(com.projity.pm.task.Project project) {
        this.projityProject = project;
    }

    public void putProjityTaskMap(Object object, Object object2) {
        this.projityTaskMap.put(object, object2);
    }

    public void putProjityAssignmentMap(Object object, Object object2) {
        this.projityAssignmentMap.put(object, object2);
    }

    public void putProjitySnapshotIdMap(Object object, Object object2) {
        this.projitySnapshotIdMap.put(object, object2);
    }

    public void putTimephasedList(Object object, Object object2) {
        if (object == null || object2 == null) {
            return;
        }
        this.timephasedMap.put(object, object2);
    }

    public List getTimephasedList(Object object) {
        return (List)this.timephasedMap.get(object);
    }

    public Resource getResourceByUniqueID(int n) {
        Resource resource = n == -65535 ? this.unassignedResource() : this.m_projectFile.getResourceByUniqueID(n);
        return resource;
    }

    public static void readAssignmentBaselinesAndTimephased(Assignment assignment, List list) {
        Iterator iterator = list.iterator();
        TimephasedService timephasedService = TimephasedService.getInstance();
        while (iterator.hasNext()) {
            timephasedService.readTimephased(assignment, (TimephasedDataType)iterator.next());
        }
        assignment.makeFlatIfPossible();
    }

    protected void readPredecessors(ProjectType.TasksType.TaskType taskType) {
        Task task;
        Integer n = taskType.getUID();
        if (n != null && (task = this.m_projectFile.getTaskByUniqueID(n)) != null) {
            List list = taskType.getPredecessorLink();
            for (Object e : list) {
            }
        }
    }

    protected void readPredecessorAsUID(Task task, ProjectType.TasksType.TaskType.PredecessorLinkType predecessorLinkType) {
        this.preds.add(new Object[]{task, predecessorLinkType});
    }

    private void processPreds() {
        for (Object[] objectArray : this.preds) {
            super.readPredecessorAsUID((Task)objectArray[0], (ProjectType.TasksType.TaskType.PredecessorLinkType)objectArray[1]);
        }
    }
}

